// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model



/**
 * Provides information about the values of pending modifications to a replication
 * instance. This data type is an object of the
 * <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_ReplicationInstance.html">
 * ReplicationInstance
 * user-defined
 * data type.
 */
class ReplicationPendingModifiedValues private constructor(builder: Builder) {
    /**
     * The amount of storage (in gigabytes) that is allocated for the replication
     * instance.
     */
    val allocatedStorage: kotlin.Int? = builder.allocatedStorage
    /**
     * The engine version number of the replication instance.
     */
    val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * Specifies whether the replication instance is a Multi-AZ deployment. You can't set the
     * AvailabilityZone parameter if the Multi-AZ parameter is set to
     * true.
     */
    val multiAz: kotlin.Boolean? = builder.multiAz
    /**
     * The compute and memory capacity of the replication instance as defined for the specified
     * replication instance class.
     * For more information on the settings and capacities for the available replication instance classes, see
     * <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth">
     * Selecting the right DMS replication instance for your migration.
     */
    val replicationInstanceClass: kotlin.String? = builder.replicationInstanceClass

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationPendingModifiedValues = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReplicationPendingModifiedValues(")
        append("allocatedStorage=$allocatedStorage,")
        append("engineVersion=$engineVersion,")
        append("multiAz=$multiAz,")
        append("replicationInstanceClass=$replicationInstanceClass)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedStorage ?: 0
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (multiAz?.hashCode() ?: 0)
        result = 31 * result + (replicationInstanceClass?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ReplicationPendingModifiedValues

        if (allocatedStorage != other.allocatedStorage) return false
        if (engineVersion != other.engineVersion) return false
        if (multiAz != other.multiAz) return false
        if (replicationInstanceClass != other.replicationInstanceClass) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationPendingModifiedValues = Builder(this).apply(block).build()

    class Builder {
        /**
         * The amount of storage (in gigabytes) that is allocated for the replication
         * instance.
         */
        var allocatedStorage: kotlin.Int? = null
        /**
         * The engine version number of the replication instance.
         */
        var engineVersion: kotlin.String? = null
        /**
         * Specifies whether the replication instance is a Multi-AZ deployment. You can't set the
         * AvailabilityZone parameter if the Multi-AZ parameter is set to
         * true.
         */
        var multiAz: kotlin.Boolean? = null
        /**
         * The compute and memory capacity of the replication instance as defined for the specified
         * replication instance class.
         * For more information on the settings and capacities for the available replication instance classes, see
         * <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth">
         * Selecting the right DMS replication instance for your migration.
         */
        var replicationInstanceClass: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationPendingModifiedValues) : this() {
            this.allocatedStorage = x.allocatedStorage
            this.engineVersion = x.engineVersion
            this.multiAz = x.multiAz
            this.replicationInstanceClass = x.replicationInstanceClass
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationPendingModifiedValues = ReplicationPendingModifiedValues(this)
    }
}
