// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model



/**
 * Provides information that defines a Microsoft SQL Server endpoint.
 */
class MicrosoftSqlServerSettings private constructor(builder: Builder) {
    /**
     * The maximum size of the packets (in bytes) used to transfer
     * data using BCP.
     */
    val bcpPacketSize: kotlin.Int? = builder.bcpPacketSize
    /**
     * Specifies a file group for the DMS internal tables. When the replication task
     * starts, all the internal DMS control tables (awsdms_ apply_exception, awsdms_apply,
     * awsdms_changes) are created for the specified file group.
     */
    val controlTablesFileGroup: kotlin.String? = builder.controlTablesFileGroup
    /**
     * Database name for the endpoint.
     */
    val databaseName: kotlin.String? = builder.databaseName
    /**
     * Endpoint connection password.
     */
    val password: kotlin.String? = builder.password
    /**
     * Endpoint TCP port.
     */
    val port: kotlin.Int? = builder.port
    /**
     * Cleans and recreates table metadata information on the replication instance when
     * a mismatch occurs. An example is a situation where running an alter DDL statement on
     * a table might result in different information about the table cached in the replication
     * instance.
     */
    val querySingleAlwaysOnNode: kotlin.Boolean? = builder.querySingleAlwaysOnNode
    /**
     * When this attribute is set to Y, DMS only reads changes
     * from transaction log backups and doesn't read from the
     * active transaction log file during ongoing replication. Setting
     * this parameter to Y enables you to control active transaction
     * log file growth during full load and ongoing replication
     * tasks. However, it can add some source latency to ongoing
     * replication.
     */
    val readBackupOnly: kotlin.Boolean? = builder.readBackupOnly
    /**
     * Use this attribute to minimize the need to access the
     * backup log and enable DMS to prevent truncation using one of the
     * following two methods.
     * Start transactions in the database: This is the default
     * method. When this method is used, DMS prevents
     * TLOG truncation by mimicking a transaction in the database.
     * As long as such a transaction is open, changes that appear
     * after the transaction started aren't truncated. If you need
     * Microsoft Replication to be enabled in your database, then
     * you must choose this method.
     * Exclusively use sp_repldone within a single task: When
     * this method is used, DMS reads the changes and then
     * uses sp_repldone to mark the TLOG transactions as ready
     * for truncation. Although this method doesn't involve any
     * transactional activities, it can only be used when Microsoft
     * Replication isn't running. Also, when using this method, only
     * one DMS task can access the database at any given
     * time. Therefore, if you need to run parallel DMS tasks
     * against the same database, use the default method.
     */
    val safeguardPolicy: aws.sdk.kotlin.services.databasemigrationservice.model.SafeguardPolicy? = builder.safeguardPolicy
    /**
     * The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
     * trusted entity and grants the required permissions to access the value in
     * SecretsManagerSecret. The role must allow the iam:PassRole action.
     * SecretsManagerSecret has the value of the Amazon Web Services Secrets Manager
     * secret that allows access to the SQL Server endpoint.
     * You can specify one of two sets of values for these permissions. You can specify the
     * values for this setting and SecretsManagerSecretId. Or you can specify
     * clear-text values for UserName, Password,
     * ServerName, and Port. You can't specify both. For more
     * information on creating this SecretsManagerSecret and the
     * SecretsManagerAccessRoleArn and SecretsManagerSecretId
     * required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
     * resources in the Database Migration Service User
     * Guide.
     */
    val secretsManagerAccessRoleArn: kotlin.String? = builder.secretsManagerAccessRoleArn
    /**
     * The full ARN, partial ARN, or friendly name of the SecretsManagerSecret that contains the SQL Server endpoint connection details.
     */
    val secretsManagerSecretId: kotlin.String? = builder.secretsManagerSecretId
    /**
     * Fully qualified domain name of the endpoint.
     */
    val serverName: kotlin.String? = builder.serverName
    /**
     * Use this to attribute to transfer data for full-load operations
     * using BCP. When the target table contains an identity
     * column that does not exist in the source table, you must
     * disable the use BCP for loading table option.
     */
    val useBcpFullLoad: kotlin.Boolean? = builder.useBcpFullLoad
    /**
     * When this attribute is set to Y, DMS processes third-party
     * transaction log backups if they are created in native format.
     */
    val useThirdPartyBackupDevice: kotlin.Boolean? = builder.useThirdPartyBackupDevice
    /**
     * Endpoint connection user name.
     */
    val username: kotlin.String? = builder.username

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.MicrosoftSqlServerSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MicrosoftSqlServerSettings(")
        append("bcpPacketSize=$bcpPacketSize,")
        append("controlTablesFileGroup=$controlTablesFileGroup,")
        append("databaseName=$databaseName,")
        append("password=*** Sensitive Data Redacted ***,")
        append("port=$port,")
        append("querySingleAlwaysOnNode=$querySingleAlwaysOnNode,")
        append("readBackupOnly=$readBackupOnly,")
        append("safeguardPolicy=$safeguardPolicy,")
        append("secretsManagerAccessRoleArn=$secretsManagerAccessRoleArn,")
        append("secretsManagerSecretId=$secretsManagerSecretId,")
        append("serverName=$serverName,")
        append("useBcpFullLoad=$useBcpFullLoad,")
        append("useThirdPartyBackupDevice=$useThirdPartyBackupDevice,")
        append("username=$username)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bcpPacketSize ?: 0
        result = 31 * result + (controlTablesFileGroup?.hashCode() ?: 0)
        result = 31 * result + (databaseName?.hashCode() ?: 0)
        result = 31 * result + (password?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (querySingleAlwaysOnNode?.hashCode() ?: 0)
        result = 31 * result + (readBackupOnly?.hashCode() ?: 0)
        result = 31 * result + (safeguardPolicy?.hashCode() ?: 0)
        result = 31 * result + (secretsManagerAccessRoleArn?.hashCode() ?: 0)
        result = 31 * result + (secretsManagerSecretId?.hashCode() ?: 0)
        result = 31 * result + (serverName?.hashCode() ?: 0)
        result = 31 * result + (useBcpFullLoad?.hashCode() ?: 0)
        result = 31 * result + (useThirdPartyBackupDevice?.hashCode() ?: 0)
        result = 31 * result + (username?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as MicrosoftSqlServerSettings

        if (bcpPacketSize != other.bcpPacketSize) return false
        if (controlTablesFileGroup != other.controlTablesFileGroup) return false
        if (databaseName != other.databaseName) return false
        if (password != other.password) return false
        if (port != other.port) return false
        if (querySingleAlwaysOnNode != other.querySingleAlwaysOnNode) return false
        if (readBackupOnly != other.readBackupOnly) return false
        if (safeguardPolicy != other.safeguardPolicy) return false
        if (secretsManagerAccessRoleArn != other.secretsManagerAccessRoleArn) return false
        if (secretsManagerSecretId != other.secretsManagerSecretId) return false
        if (serverName != other.serverName) return false
        if (useBcpFullLoad != other.useBcpFullLoad) return false
        if (useThirdPartyBackupDevice != other.useThirdPartyBackupDevice) return false
        if (username != other.username) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.MicrosoftSqlServerSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * The maximum size of the packets (in bytes) used to transfer
         * data using BCP.
         */
        var bcpPacketSize: kotlin.Int? = null
        /**
         * Specifies a file group for the DMS internal tables. When the replication task
         * starts, all the internal DMS control tables (awsdms_ apply_exception, awsdms_apply,
         * awsdms_changes) are created for the specified file group.
         */
        var controlTablesFileGroup: kotlin.String? = null
        /**
         * Database name for the endpoint.
         */
        var databaseName: kotlin.String? = null
        /**
         * Endpoint connection password.
         */
        var password: kotlin.String? = null
        /**
         * Endpoint TCP port.
         */
        var port: kotlin.Int? = null
        /**
         * Cleans and recreates table metadata information on the replication instance when
         * a mismatch occurs. An example is a situation where running an alter DDL statement on
         * a table might result in different information about the table cached in the replication
         * instance.
         */
        var querySingleAlwaysOnNode: kotlin.Boolean? = null
        /**
         * When this attribute is set to Y, DMS only reads changes
         * from transaction log backups and doesn't read from the
         * active transaction log file during ongoing replication. Setting
         * this parameter to Y enables you to control active transaction
         * log file growth during full load and ongoing replication
         * tasks. However, it can add some source latency to ongoing
         * replication.
         */
        var readBackupOnly: kotlin.Boolean? = null
        /**
         * Use this attribute to minimize the need to access the
         * backup log and enable DMS to prevent truncation using one of the
         * following two methods.
         * Start transactions in the database: This is the default
         * method. When this method is used, DMS prevents
         * TLOG truncation by mimicking a transaction in the database.
         * As long as such a transaction is open, changes that appear
         * after the transaction started aren't truncated. If you need
         * Microsoft Replication to be enabled in your database, then
         * you must choose this method.
         * Exclusively use sp_repldone within a single task: When
         * this method is used, DMS reads the changes and then
         * uses sp_repldone to mark the TLOG transactions as ready
         * for truncation. Although this method doesn't involve any
         * transactional activities, it can only be used when Microsoft
         * Replication isn't running. Also, when using this method, only
         * one DMS task can access the database at any given
         * time. Therefore, if you need to run parallel DMS tasks
         * against the same database, use the default method.
         */
        var safeguardPolicy: aws.sdk.kotlin.services.databasemigrationservice.model.SafeguardPolicy? = null
        /**
         * The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
         * trusted entity and grants the required permissions to access the value in
         * SecretsManagerSecret. The role must allow the iam:PassRole action.
         * SecretsManagerSecret has the value of the Amazon Web Services Secrets Manager
         * secret that allows access to the SQL Server endpoint.
         * You can specify one of two sets of values for these permissions. You can specify the
         * values for this setting and SecretsManagerSecretId. Or you can specify
         * clear-text values for UserName, Password,
         * ServerName, and Port. You can't specify both. For more
         * information on creating this SecretsManagerSecret and the
         * SecretsManagerAccessRoleArn and SecretsManagerSecretId
         * required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
         * resources in the Database Migration Service User
         * Guide.
         */
        var secretsManagerAccessRoleArn: kotlin.String? = null
        /**
         * The full ARN, partial ARN, or friendly name of the SecretsManagerSecret that contains the SQL Server endpoint connection details.
         */
        var secretsManagerSecretId: kotlin.String? = null
        /**
         * Fully qualified domain name of the endpoint.
         */
        var serverName: kotlin.String? = null
        /**
         * Use this to attribute to transfer data for full-load operations
         * using BCP. When the target table contains an identity
         * column that does not exist in the source table, you must
         * disable the use BCP for loading table option.
         */
        var useBcpFullLoad: kotlin.Boolean? = null
        /**
         * When this attribute is set to Y, DMS processes third-party
         * transaction log backups if they are created in native format.
         */
        var useThirdPartyBackupDevice: kotlin.Boolean? = null
        /**
         * Endpoint connection user name.
         */
        var username: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.MicrosoftSqlServerSettings) : this() {
            this.bcpPacketSize = x.bcpPacketSize
            this.controlTablesFileGroup = x.controlTablesFileGroup
            this.databaseName = x.databaseName
            this.password = x.password
            this.port = x.port
            this.querySingleAlwaysOnNode = x.querySingleAlwaysOnNode
            this.readBackupOnly = x.readBackupOnly
            this.safeguardPolicy = x.safeguardPolicy
            this.secretsManagerAccessRoleArn = x.secretsManagerAccessRoleArn
            this.secretsManagerSecretId = x.secretsManagerSecretId
            this.serverName = x.serverName
            this.useBcpFullLoad = x.useBcpFullLoad
            this.useThirdPartyBackupDevice = x.useThirdPartyBackupDevice
            this.username = x.username
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.MicrosoftSqlServerSettings = MicrosoftSqlServerSettings(this)
    }
}
