// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model



/**
 * Lists categories of events subscribed to, and generated by, the applicable DMS
 * resource type. This data type appears in response to the
 * <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_EventCategoryGroup.html">
 * DescribeEventCategories
 * action.
 */
class EventCategoryGroup private constructor(builder: Builder) {
    /**
     * A list of event categories from a source type that you've chosen.
     */
    val eventCategories: List<String>? = builder.eventCategories
    /**
     * The type of DMS resource that generates events.
     * Valid values: replication-instance | replication-server | security-group |
     * replication-task
     */
    val sourceType: kotlin.String? = builder.sourceType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.EventCategoryGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EventCategoryGroup(")
        append("eventCategories=$eventCategories,")
        append("sourceType=$sourceType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = eventCategories?.hashCode() ?: 0
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as EventCategoryGroup

        if (eventCategories != other.eventCategories) return false
        if (sourceType != other.sourceType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.EventCategoryGroup = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of event categories from a source type that you've chosen.
         */
        var eventCategories: List<String>? = null
        /**
         * The type of DMS resource that generates events.
         * Valid values: replication-instance | replication-server | security-group |
         * replication-task
         */
        var sourceType: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.EventCategoryGroup) : this() {
            this.eventCategories = x.eventCategories
            this.sourceType = x.sourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.EventCategoryGroup = EventCategoryGroup(this)
    }
}
