// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model



/**
 * Describes an endpoint of a database instance in response to operations such as the
 * following:
 * CreateEndpoint
 * DescribeEndpoint
 * ModifyEndpoint
 */
class Endpoint private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) used for SSL connection to the endpoint.
     */
    val certificateArn: kotlin.String? = builder.certificateArn
    /**
     * The name of the database at the endpoint.
     */
    val databaseName: kotlin.String? = builder.databaseName
    /**
     * The settings in JSON format for the DMS transfer type of source endpoint.
     * Possible settings include the following:
     * ServiceAccessRoleArn -  - The Amazon Resource Name (ARN) used by the service access IAM role.
     * The role must allow the iam:PassRole action.
     * BucketName - The name of the S3 bucket to use.
     * Shorthand syntax for these settings is as follows:
     * ServiceAccessRoleArn=string,BucketName=string,
     * JSON syntax for these settings is as follows: { "ServiceAccessRoleArn":
     * "string", "BucketName": "string"}
     */
    val dmsTransferSettings: aws.sdk.kotlin.services.databasemigrationservice.model.DmsTransferSettings? = builder.dmsTransferSettings
    /**
     * Provides information that defines a DocumentDB endpoint.
     */
    val docDbSettings: aws.sdk.kotlin.services.databasemigrationservice.model.DocDbSettings? = builder.docDbSettings
    /**
     * The settings for the DynamoDB target endpoint. For more information, see the
     * DynamoDBSettings structure.
     */
    val dynamoDbSettings: aws.sdk.kotlin.services.databasemigrationservice.model.DynamoDbSettings? = builder.dynamoDbSettings
    /**
     * The settings for the Elasticsearch source endpoint. For more information, see the
     * ElasticsearchSettings structure.
     */
    val elasticsearchSettings: aws.sdk.kotlin.services.databasemigrationservice.model.ElasticsearchSettings? = builder.elasticsearchSettings
    /**
     * The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
     */
    val endpointArn: kotlin.String? = builder.endpointArn
    /**
     * The database endpoint identifier. Identifiers must begin with a letter and must contain
     * only ASCII letters, digits, and hyphens. They can't end with a hyphen or contain two
     * consecutive hyphens.
     */
    val endpointIdentifier: kotlin.String? = builder.endpointIdentifier
    /**
     * The type of endpoint.  Valid values are source and target.
     */
    val endpointType: aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationEndpointTypeValue? = builder.endpointType
    /**
     * The expanded name for the engine name. For example, if the EngineName
     * parameter is "aurora," this value would be "Amazon Aurora MySQL."
     */
    val engineDisplayName: kotlin.String? = builder.engineDisplayName
    /**
     * The database engine name. Valid values, depending on the EndpointType, include
     * "mysql", "oracle", "postgres",
     * "mariadb", "aurora", "aurora-postgresql",
     * "redshift", "s3", "db2", "azuredb",
     * "sybase", "dynamodb", "mongodb",
     * "kinesis", "kafka", "elasticsearch",
     * "documentdb", "sqlserver", and "neptune".
     */
    val engineName: kotlin.String? = builder.engineName
    /**
     * Value returned by a call to CreateEndpoint that can be used for cross-account
     * validation. Use it on a subsequent call to CreateEndpoint to create the endpoint with a
     * cross-account.
     */
    val externalId: kotlin.String? = builder.externalId
    /**
     * The external table definition.
     */
    val externalTableDefinition: kotlin.String? = builder.externalTableDefinition
    /**
     * Additional connection attributes used to connect to the endpoint.
     */
    val extraConnectionAttributes: kotlin.String? = builder.extraConnectionAttributes
    /**
     * The settings for the IBM Db2 LUW source endpoint. For more information, see the
     * IBMDb2Settings structure.
     */
    val ibmDb2Settings: aws.sdk.kotlin.services.databasemigrationservice.model.IbmDb2Settings? = builder.ibmDb2Settings
    /**
     * The settings for the Apache Kafka target endpoint. For more information, see the
     * KafkaSettings structure.
     */
    val kafkaSettings: aws.sdk.kotlin.services.databasemigrationservice.model.KafkaSettings? = builder.kafkaSettings
    /**
     * The settings for the Amazon Kinesis target endpoint. For more information, see the
     * KinesisSettings structure.
     */
    val kinesisSettings: aws.sdk.kotlin.services.databasemigrationservice.model.KinesisSettings? = builder.kinesisSettings
    /**
     * An KMS key identifier that is used to encrypt the connection parameters for the endpoint.
     * If you don't specify a value for the KmsKeyId parameter, then
     * DMS uses your default encryption key.
     * KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a
     * different default encryption key for each Amazon Web Services Region.
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The settings for the Microsoft SQL Server source and target endpoint. For more
     * information, see the MicrosoftSQLServerSettings structure.
     */
    val microsoftSqlServerSettings: aws.sdk.kotlin.services.databasemigrationservice.model.MicrosoftSqlServerSettings? = builder.microsoftSqlServerSettings
    /**
     * The settings for the MongoDB source endpoint. For more information, see the
     * MongoDbSettings structure.
     */
    val mongoDbSettings: aws.sdk.kotlin.services.databasemigrationservice.model.MongoDbSettings? = builder.mongoDbSettings
    /**
     * The settings for the MySQL source and target endpoint. For more information, see the
     * MySQLSettings structure.
     */
    val mySqlSettings: aws.sdk.kotlin.services.databasemigrationservice.model.MySqlSettings? = builder.mySqlSettings
    /**
     * The settings for the Amazon Neptune target endpoint. For more information, see the
     * NeptuneSettings structure.
     */
    val neptuneSettings: aws.sdk.kotlin.services.databasemigrationservice.model.NeptuneSettings? = builder.neptuneSettings
    /**
     * The settings for the Oracle source and target endpoint. For more information, see the
     * OracleSettings structure.
     */
    val oracleSettings: aws.sdk.kotlin.services.databasemigrationservice.model.OracleSettings? = builder.oracleSettings
    /**
     * The port value used to access the endpoint.
     */
    val port: kotlin.Int? = builder.port
    /**
     * The settings for the PostgreSQL source and target endpoint. For more information, see
     * the PostgreSQLSettings structure.
     */
    val postgreSqlSettings: aws.sdk.kotlin.services.databasemigrationservice.model.PostgreSqlSettings? = builder.postgreSqlSettings
    /**
     * The settings for the Redis target endpoint. For more information, see the
     * RedisSettings structure.
     */
    val redisSettings: aws.sdk.kotlin.services.databasemigrationservice.model.RedisSettings? = builder.redisSettings
    /**
     * Settings for the Amazon Redshift endpoint.
     */
    val redshiftSettings: aws.sdk.kotlin.services.databasemigrationservice.model.RedshiftSettings? = builder.redshiftSettings
    /**
     * The settings for the S3 target endpoint. For more information, see the
     * S3Settings structure.
     */
    val s3Settings: aws.sdk.kotlin.services.databasemigrationservice.model.S3Settings? = builder.s3Settings
    /**
     * The name of the server at the endpoint.
     */
    val serverName: kotlin.String? = builder.serverName
    /**
     * The Amazon Resource Name (ARN) used by the service to access the IAM role.
     * The role must allow the iam:PassRole action.
     */
    val serviceAccessRoleArn: kotlin.String? = builder.serviceAccessRoleArn
    /**
     * The SSL mode used to connect to the endpoint. The default value is none.
     */
    val sslMode: aws.sdk.kotlin.services.databasemigrationservice.model.DmsSslModeValue? = builder.sslMode
    /**
     * The status of the endpoint.
     */
    val status: kotlin.String? = builder.status
    /**
     * The settings for the SAP ASE source and target endpoint. For more information, see the
     * SybaseSettings structure.
     */
    val sybaseSettings: aws.sdk.kotlin.services.databasemigrationservice.model.SybaseSettings? = builder.sybaseSettings
    /**
     * The user name used to connect to the endpoint.
     */
    val username: kotlin.String? = builder.username

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.Endpoint = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Endpoint(")
        append("certificateArn=$certificateArn,")
        append("databaseName=$databaseName,")
        append("dmsTransferSettings=$dmsTransferSettings,")
        append("docDbSettings=$docDbSettings,")
        append("dynamoDbSettings=$dynamoDbSettings,")
        append("elasticsearchSettings=$elasticsearchSettings,")
        append("endpointArn=$endpointArn,")
        append("endpointIdentifier=$endpointIdentifier,")
        append("endpointType=$endpointType,")
        append("engineDisplayName=$engineDisplayName,")
        append("engineName=$engineName,")
        append("externalId=$externalId,")
        append("externalTableDefinition=$externalTableDefinition,")
        append("extraConnectionAttributes=$extraConnectionAttributes,")
        append("ibmDb2Settings=$ibmDb2Settings,")
        append("kafkaSettings=$kafkaSettings,")
        append("kinesisSettings=$kinesisSettings,")
        append("kmsKeyId=$kmsKeyId,")
        append("microsoftSqlServerSettings=$microsoftSqlServerSettings,")
        append("mongoDbSettings=$mongoDbSettings,")
        append("mySqlSettings=$mySqlSettings,")
        append("neptuneSettings=$neptuneSettings,")
        append("oracleSettings=$oracleSettings,")
        append("port=$port,")
        append("postgreSqlSettings=$postgreSqlSettings,")
        append("redisSettings=$redisSettings,")
        append("redshiftSettings=$redshiftSettings,")
        append("s3Settings=$s3Settings,")
        append("serverName=$serverName,")
        append("serviceAccessRoleArn=$serviceAccessRoleArn,")
        append("sslMode=$sslMode,")
        append("status=$status,")
        append("sybaseSettings=$sybaseSettings,")
        append("username=$username)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateArn?.hashCode() ?: 0
        result = 31 * result + (databaseName?.hashCode() ?: 0)
        result = 31 * result + (dmsTransferSettings?.hashCode() ?: 0)
        result = 31 * result + (docDbSettings?.hashCode() ?: 0)
        result = 31 * result + (dynamoDbSettings?.hashCode() ?: 0)
        result = 31 * result + (elasticsearchSettings?.hashCode() ?: 0)
        result = 31 * result + (endpointArn?.hashCode() ?: 0)
        result = 31 * result + (endpointIdentifier?.hashCode() ?: 0)
        result = 31 * result + (endpointType?.hashCode() ?: 0)
        result = 31 * result + (engineDisplayName?.hashCode() ?: 0)
        result = 31 * result + (engineName?.hashCode() ?: 0)
        result = 31 * result + (externalId?.hashCode() ?: 0)
        result = 31 * result + (externalTableDefinition?.hashCode() ?: 0)
        result = 31 * result + (extraConnectionAttributes?.hashCode() ?: 0)
        result = 31 * result + (ibmDb2Settings?.hashCode() ?: 0)
        result = 31 * result + (kafkaSettings?.hashCode() ?: 0)
        result = 31 * result + (kinesisSettings?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (microsoftSqlServerSettings?.hashCode() ?: 0)
        result = 31 * result + (mongoDbSettings?.hashCode() ?: 0)
        result = 31 * result + (mySqlSettings?.hashCode() ?: 0)
        result = 31 * result + (neptuneSettings?.hashCode() ?: 0)
        result = 31 * result + (oracleSettings?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (postgreSqlSettings?.hashCode() ?: 0)
        result = 31 * result + (redisSettings?.hashCode() ?: 0)
        result = 31 * result + (redshiftSettings?.hashCode() ?: 0)
        result = 31 * result + (s3Settings?.hashCode() ?: 0)
        result = 31 * result + (serverName?.hashCode() ?: 0)
        result = 31 * result + (serviceAccessRoleArn?.hashCode() ?: 0)
        result = 31 * result + (sslMode?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (sybaseSettings?.hashCode() ?: 0)
        result = 31 * result + (username?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Endpoint

        if (certificateArn != other.certificateArn) return false
        if (databaseName != other.databaseName) return false
        if (dmsTransferSettings != other.dmsTransferSettings) return false
        if (docDbSettings != other.docDbSettings) return false
        if (dynamoDbSettings != other.dynamoDbSettings) return false
        if (elasticsearchSettings != other.elasticsearchSettings) return false
        if (endpointArn != other.endpointArn) return false
        if (endpointIdentifier != other.endpointIdentifier) return false
        if (endpointType != other.endpointType) return false
        if (engineDisplayName != other.engineDisplayName) return false
        if (engineName != other.engineName) return false
        if (externalId != other.externalId) return false
        if (externalTableDefinition != other.externalTableDefinition) return false
        if (extraConnectionAttributes != other.extraConnectionAttributes) return false
        if (ibmDb2Settings != other.ibmDb2Settings) return false
        if (kafkaSettings != other.kafkaSettings) return false
        if (kinesisSettings != other.kinesisSettings) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (microsoftSqlServerSettings != other.microsoftSqlServerSettings) return false
        if (mongoDbSettings != other.mongoDbSettings) return false
        if (mySqlSettings != other.mySqlSettings) return false
        if (neptuneSettings != other.neptuneSettings) return false
        if (oracleSettings != other.oracleSettings) return false
        if (port != other.port) return false
        if (postgreSqlSettings != other.postgreSqlSettings) return false
        if (redisSettings != other.redisSettings) return false
        if (redshiftSettings != other.redshiftSettings) return false
        if (s3Settings != other.s3Settings) return false
        if (serverName != other.serverName) return false
        if (serviceAccessRoleArn != other.serviceAccessRoleArn) return false
        if (sslMode != other.sslMode) return false
        if (status != other.status) return false
        if (sybaseSettings != other.sybaseSettings) return false
        if (username != other.username) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.Endpoint = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) used for SSL connection to the endpoint.
         */
        var certificateArn: kotlin.String? = null
        /**
         * The name of the database at the endpoint.
         */
        var databaseName: kotlin.String? = null
        /**
         * The settings in JSON format for the DMS transfer type of source endpoint.
         * Possible settings include the following:
         * ServiceAccessRoleArn -  - The Amazon Resource Name (ARN) used by the service access IAM role.
         * The role must allow the iam:PassRole action.
         * BucketName - The name of the S3 bucket to use.
         * Shorthand syntax for these settings is as follows:
         * ServiceAccessRoleArn=string,BucketName=string,
         * JSON syntax for these settings is as follows: { "ServiceAccessRoleArn":
         * "string", "BucketName": "string"}
         */
        var dmsTransferSettings: aws.sdk.kotlin.services.databasemigrationservice.model.DmsTransferSettings? = null
        /**
         * Provides information that defines a DocumentDB endpoint.
         */
        var docDbSettings: aws.sdk.kotlin.services.databasemigrationservice.model.DocDbSettings? = null
        /**
         * The settings for the DynamoDB target endpoint. For more information, see the
         * DynamoDBSettings structure.
         */
        var dynamoDbSettings: aws.sdk.kotlin.services.databasemigrationservice.model.DynamoDbSettings? = null
        /**
         * The settings for the Elasticsearch source endpoint. For more information, see the
         * ElasticsearchSettings structure.
         */
        var elasticsearchSettings: aws.sdk.kotlin.services.databasemigrationservice.model.ElasticsearchSettings? = null
        /**
         * The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
         */
        var endpointArn: kotlin.String? = null
        /**
         * The database endpoint identifier. Identifiers must begin with a letter and must contain
         * only ASCII letters, digits, and hyphens. They can't end with a hyphen or contain two
         * consecutive hyphens.
         */
        var endpointIdentifier: kotlin.String? = null
        /**
         * The type of endpoint.  Valid values are source and target.
         */
        var endpointType: aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationEndpointTypeValue? = null
        /**
         * The expanded name for the engine name. For example, if the EngineName
         * parameter is "aurora," this value would be "Amazon Aurora MySQL."
         */
        var engineDisplayName: kotlin.String? = null
        /**
         * The database engine name. Valid values, depending on the EndpointType, include
         * "mysql", "oracle", "postgres",
         * "mariadb", "aurora", "aurora-postgresql",
         * "redshift", "s3", "db2", "azuredb",
         * "sybase", "dynamodb", "mongodb",
         * "kinesis", "kafka", "elasticsearch",
         * "documentdb", "sqlserver", and "neptune".
         */
        var engineName: kotlin.String? = null
        /**
         * Value returned by a call to CreateEndpoint that can be used for cross-account
         * validation. Use it on a subsequent call to CreateEndpoint to create the endpoint with a
         * cross-account.
         */
        var externalId: kotlin.String? = null
        /**
         * The external table definition.
         */
        var externalTableDefinition: kotlin.String? = null
        /**
         * Additional connection attributes used to connect to the endpoint.
         */
        var extraConnectionAttributes: kotlin.String? = null
        /**
         * The settings for the IBM Db2 LUW source endpoint. For more information, see the
         * IBMDb2Settings structure.
         */
        var ibmDb2Settings: aws.sdk.kotlin.services.databasemigrationservice.model.IbmDb2Settings? = null
        /**
         * The settings for the Apache Kafka target endpoint. For more information, see the
         * KafkaSettings structure.
         */
        var kafkaSettings: aws.sdk.kotlin.services.databasemigrationservice.model.KafkaSettings? = null
        /**
         * The settings for the Amazon Kinesis target endpoint. For more information, see the
         * KinesisSettings structure.
         */
        var kinesisSettings: aws.sdk.kotlin.services.databasemigrationservice.model.KinesisSettings? = null
        /**
         * An KMS key identifier that is used to encrypt the connection parameters for the endpoint.
         * If you don't specify a value for the KmsKeyId parameter, then
         * DMS uses your default encryption key.
         * KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a
         * different default encryption key for each Amazon Web Services Region.
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * The settings for the Microsoft SQL Server source and target endpoint. For more
         * information, see the MicrosoftSQLServerSettings structure.
         */
        var microsoftSqlServerSettings: aws.sdk.kotlin.services.databasemigrationservice.model.MicrosoftSqlServerSettings? = null
        /**
         * The settings for the MongoDB source endpoint. For more information, see the
         * MongoDbSettings structure.
         */
        var mongoDbSettings: aws.sdk.kotlin.services.databasemigrationservice.model.MongoDbSettings? = null
        /**
         * The settings for the MySQL source and target endpoint. For more information, see the
         * MySQLSettings structure.
         */
        var mySqlSettings: aws.sdk.kotlin.services.databasemigrationservice.model.MySqlSettings? = null
        /**
         * The settings for the Amazon Neptune target endpoint. For more information, see the
         * NeptuneSettings structure.
         */
        var neptuneSettings: aws.sdk.kotlin.services.databasemigrationservice.model.NeptuneSettings? = null
        /**
         * The settings for the Oracle source and target endpoint. For more information, see the
         * OracleSettings structure.
         */
        var oracleSettings: aws.sdk.kotlin.services.databasemigrationservice.model.OracleSettings? = null
        /**
         * The port value used to access the endpoint.
         */
        var port: kotlin.Int? = null
        /**
         * The settings for the PostgreSQL source and target endpoint. For more information, see
         * the PostgreSQLSettings structure.
         */
        var postgreSqlSettings: aws.sdk.kotlin.services.databasemigrationservice.model.PostgreSqlSettings? = null
        /**
         * The settings for the Redis target endpoint. For more information, see the
         * RedisSettings structure.
         */
        var redisSettings: aws.sdk.kotlin.services.databasemigrationservice.model.RedisSettings? = null
        /**
         * Settings for the Amazon Redshift endpoint.
         */
        var redshiftSettings: aws.sdk.kotlin.services.databasemigrationservice.model.RedshiftSettings? = null
        /**
         * The settings for the S3 target endpoint. For more information, see the
         * S3Settings structure.
         */
        var s3Settings: aws.sdk.kotlin.services.databasemigrationservice.model.S3Settings? = null
        /**
         * The name of the server at the endpoint.
         */
        var serverName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) used by the service to access the IAM role.
         * The role must allow the iam:PassRole action.
         */
        var serviceAccessRoleArn: kotlin.String? = null
        /**
         * The SSL mode used to connect to the endpoint. The default value is none.
         */
        var sslMode: aws.sdk.kotlin.services.databasemigrationservice.model.DmsSslModeValue? = null
        /**
         * The status of the endpoint.
         */
        var status: kotlin.String? = null
        /**
         * The settings for the SAP ASE source and target endpoint. For more information, see the
         * SybaseSettings structure.
         */
        var sybaseSettings: aws.sdk.kotlin.services.databasemigrationservice.model.SybaseSettings? = null
        /**
         * The user name used to connect to the endpoint.
         */
        var username: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.Endpoint) : this() {
            this.certificateArn = x.certificateArn
            this.databaseName = x.databaseName
            this.dmsTransferSettings = x.dmsTransferSettings
            this.docDbSettings = x.docDbSettings
            this.dynamoDbSettings = x.dynamoDbSettings
            this.elasticsearchSettings = x.elasticsearchSettings
            this.endpointArn = x.endpointArn
            this.endpointIdentifier = x.endpointIdentifier
            this.endpointType = x.endpointType
            this.engineDisplayName = x.engineDisplayName
            this.engineName = x.engineName
            this.externalId = x.externalId
            this.externalTableDefinition = x.externalTableDefinition
            this.extraConnectionAttributes = x.extraConnectionAttributes
            this.ibmDb2Settings = x.ibmDb2Settings
            this.kafkaSettings = x.kafkaSettings
            this.kinesisSettings = x.kinesisSettings
            this.kmsKeyId = x.kmsKeyId
            this.microsoftSqlServerSettings = x.microsoftSqlServerSettings
            this.mongoDbSettings = x.mongoDbSettings
            this.mySqlSettings = x.mySqlSettings
            this.neptuneSettings = x.neptuneSettings
            this.oracleSettings = x.oracleSettings
            this.port = x.port
            this.postgreSqlSettings = x.postgreSqlSettings
            this.redisSettings = x.redisSettings
            this.redshiftSettings = x.redshiftSettings
            this.s3Settings = x.s3Settings
            this.serverName = x.serverName
            this.serviceAccessRoleArn = x.serviceAccessRoleArn
            this.sslMode = x.sslMode
            this.status = x.status
            this.sybaseSettings = x.sybaseSettings
            this.username = x.username
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.Endpoint = Endpoint(this)

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.DmsTransferSettings] inside the given [block]
         */
        fun dmsTransferSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.DmsTransferSettings.Builder.() -> kotlin.Unit) {
            this.dmsTransferSettings = aws.sdk.kotlin.services.databasemigrationservice.model.DmsTransferSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.DocDbSettings] inside the given [block]
         */
        fun docDbSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.DocDbSettings.Builder.() -> kotlin.Unit) {
            this.docDbSettings = aws.sdk.kotlin.services.databasemigrationservice.model.DocDbSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.DynamoDbSettings] inside the given [block]
         */
        fun dynamoDbSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.DynamoDbSettings.Builder.() -> kotlin.Unit) {
            this.dynamoDbSettings = aws.sdk.kotlin.services.databasemigrationservice.model.DynamoDbSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.ElasticsearchSettings] inside the given [block]
         */
        fun elasticsearchSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.ElasticsearchSettings.Builder.() -> kotlin.Unit) {
            this.elasticsearchSettings = aws.sdk.kotlin.services.databasemigrationservice.model.ElasticsearchSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.IbmDb2Settings] inside the given [block]
         */
        fun ibmDb2Settings(block: aws.sdk.kotlin.services.databasemigrationservice.model.IbmDb2Settings.Builder.() -> kotlin.Unit) {
            this.ibmDb2Settings = aws.sdk.kotlin.services.databasemigrationservice.model.IbmDb2Settings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.KafkaSettings] inside the given [block]
         */
        fun kafkaSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.KafkaSettings.Builder.() -> kotlin.Unit) {
            this.kafkaSettings = aws.sdk.kotlin.services.databasemigrationservice.model.KafkaSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.KinesisSettings] inside the given [block]
         */
        fun kinesisSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.KinesisSettings.Builder.() -> kotlin.Unit) {
            this.kinesisSettings = aws.sdk.kotlin.services.databasemigrationservice.model.KinesisSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.MicrosoftSqlServerSettings] inside the given [block]
         */
        fun microsoftSqlServerSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.MicrosoftSqlServerSettings.Builder.() -> kotlin.Unit) {
            this.microsoftSqlServerSettings = aws.sdk.kotlin.services.databasemigrationservice.model.MicrosoftSqlServerSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.MongoDbSettings] inside the given [block]
         */
        fun mongoDbSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.MongoDbSettings.Builder.() -> kotlin.Unit) {
            this.mongoDbSettings = aws.sdk.kotlin.services.databasemigrationservice.model.MongoDbSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.MySqlSettings] inside the given [block]
         */
        fun mySqlSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.MySqlSettings.Builder.() -> kotlin.Unit) {
            this.mySqlSettings = aws.sdk.kotlin.services.databasemigrationservice.model.MySqlSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.NeptuneSettings] inside the given [block]
         */
        fun neptuneSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.NeptuneSettings.Builder.() -> kotlin.Unit) {
            this.neptuneSettings = aws.sdk.kotlin.services.databasemigrationservice.model.NeptuneSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.OracleSettings] inside the given [block]
         */
        fun oracleSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.OracleSettings.Builder.() -> kotlin.Unit) {
            this.oracleSettings = aws.sdk.kotlin.services.databasemigrationservice.model.OracleSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.PostgreSqlSettings] inside the given [block]
         */
        fun postgreSqlSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.PostgreSqlSettings.Builder.() -> kotlin.Unit) {
            this.postgreSqlSettings = aws.sdk.kotlin.services.databasemigrationservice.model.PostgreSqlSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.RedisSettings] inside the given [block]
         */
        fun redisSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.RedisSettings.Builder.() -> kotlin.Unit) {
            this.redisSettings = aws.sdk.kotlin.services.databasemigrationservice.model.RedisSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.RedshiftSettings] inside the given [block]
         */
        fun redshiftSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.RedshiftSettings.Builder.() -> kotlin.Unit) {
            this.redshiftSettings = aws.sdk.kotlin.services.databasemigrationservice.model.RedshiftSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.S3Settings] inside the given [block]
         */
        fun s3Settings(block: aws.sdk.kotlin.services.databasemigrationservice.model.S3Settings.Builder.() -> kotlin.Unit) {
            this.s3Settings = aws.sdk.kotlin.services.databasemigrationservice.model.S3Settings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.SybaseSettings] inside the given [block]
         */
        fun sybaseSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.SybaseSettings.Builder.() -> kotlin.Unit) {
            this.sybaseSettings = aws.sdk.kotlin.services.databasemigrationservice.model.SybaseSettings.invoke(block)
        }
    }
}
