// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice

import aws.sdk.kotlin.runtime.auth.signing.AwsSigV4SigningMiddleware
import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.databasemigrationservice.model.*
import aws.sdk.kotlin.services.databasemigrationservice.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.middleware.Retry
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "Database Migration Service"
const val ServiceApiVersion: String = "2016-01-01"
const val SdkVersion: String = "0.9.4-beta"

internal class DefaultDatabaseMigrationClient(override val config: DatabaseMigrationClient.Config) : DatabaseMigrationClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Adds metadata tags to an DMS resource, including replication instance, endpoint,
     * security group, and migration task. These tags can also be used with cost allocation
     * reporting to track cost associated with DMS resources, or used in a Condition statement in
     * an IAM policy for DMS. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html">
     * Tag
     * data type description.
     */
    override suspend fun addTagsToResource(input: AddTagsToResourceRequest): AddTagsToResourceResponse {
        val op = SdkHttpOperation.build<AddTagsToResourceRequest, AddTagsToResourceResponse> {
            serializer = AddTagsToResourceOperationSerializer()
            deserializer = AddTagsToResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddTagsToResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Applies a pending maintenance action to a resource (for example, to a replication instance).
     */
    override suspend fun applyPendingMaintenanceAction(input: ApplyPendingMaintenanceActionRequest): ApplyPendingMaintenanceActionResponse {
        val op = SdkHttpOperation.build<ApplyPendingMaintenanceActionRequest, ApplyPendingMaintenanceActionResponse> {
            serializer = ApplyPendingMaintenanceActionOperationSerializer()
            deserializer = ApplyPendingMaintenanceActionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ApplyPendingMaintenanceAction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Cancels a single premigration assessment run.
     * This operation prevents any individual assessments from running if they haven't started
     * running. It also attempts to cancel any individual assessments that are currently
     * running.
     */
    override suspend fun cancelReplicationTaskAssessmentRun(input: CancelReplicationTaskAssessmentRunRequest): CancelReplicationTaskAssessmentRunResponse {
        val op = SdkHttpOperation.build<CancelReplicationTaskAssessmentRunRequest, CancelReplicationTaskAssessmentRunResponse> {
            serializer = CancelReplicationTaskAssessmentRunOperationSerializer()
            deserializer = CancelReplicationTaskAssessmentRunOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelReplicationTaskAssessmentRun"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Creates an endpoint using the provided settings.
     * For a MySQL source or target endpoint, don't explicitly specify the database using
     * the DatabaseName request parameter on the CreateEndpoint API call.
     * Specifying DatabaseName when you create a MySQL endpoint replicates all the
     * task tables to this single database. For MySQL endpoints, you specify the database only when
     * you specify the schema in the table-mapping rules of the DMS task.
     */
    override suspend fun createEndpoint(input: CreateEndpointRequest): CreateEndpointResponse {
        val op = SdkHttpOperation.build<CreateEndpointRequest, CreateEndpointResponse> {
            serializer = CreateEndpointOperationSerializer()
            deserializer = CreateEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateEndpoint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Creates an DMS event notification subscription.
     * You can specify the type of source (SourceType) you want to be notified of,
     * provide a list of DMS source IDs (SourceIds) that triggers the events, and
     * provide a list of event categories (EventCategories) for events you want to be
     * notified of. If you specify both the SourceType and SourceIds,
     * such as SourceType = replication-instance and SourceIdentifier =
     * my-replinstance, you will be notified of all the replication instance events for
     * the specified source. If you specify a SourceType but don't specify a
     * SourceIdentifier, you receive notice of the events for that source type for
     * all your DMS sources. If you don't specify either SourceType nor
     * SourceIdentifier, you will be notified of events generated from all DMS
     * sources belonging to your customer account.
     * For more information about DMS events, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications in the Database Migration Service User
     * Guide.
     */
    override suspend fun createEventSubscription(input: CreateEventSubscriptionRequest): CreateEventSubscriptionResponse {
        val op = SdkHttpOperation.build<CreateEventSubscriptionRequest, CreateEventSubscriptionResponse> {
            serializer = CreateEventSubscriptionOperationSerializer()
            deserializer = CreateEventSubscriptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateEventSubscription"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Creates the replication instance using the specified parameters.
     * DMS requires that your account have certain roles with appropriate permissions
     * before you can create a replication instance. For information on the required roles, see
     * <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.APIRole">Creating the IAM Roles to Use With the CLI and DMS API. For
     * information on the required permissions, see
     * <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.IAMPermissions">IAM Permissions Needed to Use DMS.
     */
    override suspend fun createReplicationInstance(input: CreateReplicationInstanceRequest): CreateReplicationInstanceResponse {
        val op = SdkHttpOperation.build<CreateReplicationInstanceRequest, CreateReplicationInstanceResponse> {
            serializer = CreateReplicationInstanceOperationSerializer()
            deserializer = CreateReplicationInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateReplicationInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Creates a replication subnet group given a list of the subnet IDs in a VPC.
     * The VPC needs to have at least one subnet in at least two availability zones in the Amazon Web Services Region, otherwise the
     * service will throw a ReplicationSubnetGroupDoesNotCoverEnoughAZs exception.
     */
    override suspend fun createReplicationSubnetGroup(input: CreateReplicationSubnetGroupRequest): CreateReplicationSubnetGroupResponse {
        val op = SdkHttpOperation.build<CreateReplicationSubnetGroupRequest, CreateReplicationSubnetGroupResponse> {
            serializer = CreateReplicationSubnetGroupOperationSerializer()
            deserializer = CreateReplicationSubnetGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateReplicationSubnetGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Creates a replication task using the specified parameters.
     */
    override suspend fun createReplicationTask(input: CreateReplicationTaskRequest): CreateReplicationTaskResponse {
        val op = SdkHttpOperation.build<CreateReplicationTaskRequest, CreateReplicationTaskResponse> {
            serializer = CreateReplicationTaskOperationSerializer()
            deserializer = CreateReplicationTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateReplicationTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified certificate.
     */
    override suspend fun deleteCertificate(input: DeleteCertificateRequest): DeleteCertificateResponse {
        val op = SdkHttpOperation.build<DeleteCertificateRequest, DeleteCertificateResponse> {
            serializer = DeleteCertificateOperationSerializer()
            deserializer = DeleteCertificateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCertificate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the connection between a replication instance and an endpoint.
     */
    override suspend fun deleteConnection(input: DeleteConnectionRequest): DeleteConnectionResponse {
        val op = SdkHttpOperation.build<DeleteConnectionRequest, DeleteConnectionResponse> {
            serializer = DeleteConnectionOperationSerializer()
            deserializer = DeleteConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteConnection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified endpoint.
     * All tasks associated with the endpoint must be deleted before you can delete the
     * endpoint.
     */
    override suspend fun deleteEndpoint(input: DeleteEndpointRequest): DeleteEndpointResponse {
        val op = SdkHttpOperation.build<DeleteEndpointRequest, DeleteEndpointResponse> {
            serializer = DeleteEndpointOperationSerializer()
            deserializer = DeleteEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteEndpoint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an DMS event subscription.
     */
    override suspend fun deleteEventSubscription(input: DeleteEventSubscriptionRequest): DeleteEventSubscriptionResponse {
        val op = SdkHttpOperation.build<DeleteEventSubscriptionRequest, DeleteEventSubscriptionResponse> {
            serializer = DeleteEventSubscriptionOperationSerializer()
            deserializer = DeleteEventSubscriptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteEventSubscription"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified replication instance.
     * You must delete any migration tasks that are associated with the replication instance
     * before you can delete it.
     */
    override suspend fun deleteReplicationInstance(input: DeleteReplicationInstanceRequest): DeleteReplicationInstanceResponse {
        val op = SdkHttpOperation.build<DeleteReplicationInstanceRequest, DeleteReplicationInstanceResponse> {
            serializer = DeleteReplicationInstanceOperationSerializer()
            deserializer = DeleteReplicationInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteReplicationInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a subnet group.
     */
    override suspend fun deleteReplicationSubnetGroup(input: DeleteReplicationSubnetGroupRequest): DeleteReplicationSubnetGroupResponse {
        val op = SdkHttpOperation.build<DeleteReplicationSubnetGroupRequest, DeleteReplicationSubnetGroupResponse> {
            serializer = DeleteReplicationSubnetGroupOperationSerializer()
            deserializer = DeleteReplicationSubnetGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteReplicationSubnetGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified replication task.
     */
    override suspend fun deleteReplicationTask(input: DeleteReplicationTaskRequest): DeleteReplicationTaskResponse {
        val op = SdkHttpOperation.build<DeleteReplicationTaskRequest, DeleteReplicationTaskResponse> {
            serializer = DeleteReplicationTaskOperationSerializer()
            deserializer = DeleteReplicationTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteReplicationTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the record of a single premigration assessment run.
     * This operation removes all metadata that DMS maintains about this assessment run.
     * However, the operation leaves untouched all information about this assessment run that is
     * stored in your Amazon S3 bucket.
     */
    override suspend fun deleteReplicationTaskAssessmentRun(input: DeleteReplicationTaskAssessmentRunRequest): DeleteReplicationTaskAssessmentRunResponse {
        val op = SdkHttpOperation.build<DeleteReplicationTaskAssessmentRunRequest, DeleteReplicationTaskAssessmentRunResponse> {
            serializer = DeleteReplicationTaskAssessmentRunOperationSerializer()
            deserializer = DeleteReplicationTaskAssessmentRunOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteReplicationTaskAssessmentRun"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Lists all of the DMS attributes for a customer account. These attributes include DMS
     * quotas for the account and a unique account identifier in a particular DMS region. DMS
     * quotas include a list of resource quotas supported by the account, such as the number of
     * replication instances allowed. The description for each resource quota, includes the quota
     * name, current usage toward that quota, and the quota's maximum value. DMS uses the unique
     * account identifier to name each artifact used by DMS in the given region.
     * This command does not take any parameters.
     */
    override suspend fun describeAccountAttributes(input: DescribeAccountAttributesRequest): DescribeAccountAttributesResponse {
        val op = SdkHttpOperation.build<DescribeAccountAttributesRequest, DescribeAccountAttributesResponse> {
            serializer = DescribeAccountAttributesOperationSerializer()
            deserializer = DescribeAccountAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAccountAttributes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Provides a list of individual assessments that you can specify for a new premigration
     * assessment run, given one or more parameters.
     * If you specify an existing migration task, this operation provides the default individual
     * assessments you can specify for that task. Otherwise, the specified parameters model elements
     * of a possible migration task on which to base a premigration assessment run.
     * To use these migration task modeling parameters, you must specify an existing replication instance,
     * a source database engine, a target database engine, and a migration type. This combination of
     * parameters potentially limits the default individual assessments available for an assessment run
     * created for a corresponding migration task.
     * If you specify no parameters, this operation provides a list of all possible individual assessments
     * that you can specify for an assessment run. If you specify any one of the task modeling parameters, you must
     * specify all of them or the operation cannot provide a list of individual assessments.
     * The only parameter that you can specify alone is for an existing migration task. The specified task
     * definition then determines the default list of individual assessments that you can specify in an
     * assessment run for the task.
     */
    override suspend fun describeApplicableIndividualAssessments(input: DescribeApplicableIndividualAssessmentsRequest): DescribeApplicableIndividualAssessmentsResponse {
        val op = SdkHttpOperation.build<DescribeApplicableIndividualAssessmentsRequest, DescribeApplicableIndividualAssessmentsResponse> {
            serializer = DescribeApplicableIndividualAssessmentsOperationSerializer()
            deserializer = DescribeApplicableIndividualAssessmentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeApplicableIndividualAssessments"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Provides a description of the certificate.
     */
    override suspend fun describeCertificates(input: DescribeCertificatesRequest): DescribeCertificatesResponse {
        val op = SdkHttpOperation.build<DescribeCertificatesRequest, DescribeCertificatesResponse> {
            serializer = DescribeCertificatesOperationSerializer()
            deserializer = DescribeCertificatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCertificates"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Describes the status of the connections that have been made between the replication
     * instance and an endpoint. Connections are created when you test an endpoint.
     */
    override suspend fun describeConnections(input: DescribeConnectionsRequest): DescribeConnectionsResponse {
        val op = SdkHttpOperation.build<DescribeConnectionsRequest, DescribeConnectionsResponse> {
            serializer = DescribeConnectionsOperationSerializer()
            deserializer = DescribeConnectionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeConnections"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the possible endpoint settings available
     * when you create an endpoint for a specific database engine.
     */
    override suspend fun describeEndpointSettings(input: DescribeEndpointSettingsRequest): DescribeEndpointSettingsResponse {
        val op = SdkHttpOperation.build<DescribeEndpointSettingsRequest, DescribeEndpointSettingsResponse> {
            serializer = DescribeEndpointSettingsOperationSerializer()
            deserializer = DescribeEndpointSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEndpointSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the type of endpoints available.
     */
    override suspend fun describeEndpointTypes(input: DescribeEndpointTypesRequest): DescribeEndpointTypesResponse {
        val op = SdkHttpOperation.build<DescribeEndpointTypesRequest, DescribeEndpointTypesResponse> {
            serializer = DescribeEndpointTypesOperationSerializer()
            deserializer = DescribeEndpointTypesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEndpointTypes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the endpoints for your account in the current region.
     */
    override suspend fun describeEndpoints(input: DescribeEndpointsRequest): DescribeEndpointsResponse {
        val op = SdkHttpOperation.build<DescribeEndpointsRequest, DescribeEndpointsResponse> {
            serializer = DescribeEndpointsOperationSerializer()
            deserializer = DescribeEndpointsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEndpoints"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Lists categories for all event source types, or, if specified, for a specified source
     * type. You can see a list of the event categories and source types in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events
     * and Notifications in the Database Migration Service User
     * Guide.
     */
    override suspend fun describeEventCategories(input: DescribeEventCategoriesRequest): DescribeEventCategoriesResponse {
        val op = SdkHttpOperation.build<DescribeEventCategoriesRequest, DescribeEventCategoriesResponse> {
            serializer = DescribeEventCategoriesOperationSerializer()
            deserializer = DescribeEventCategoriesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEventCategories"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the event subscriptions for a customer account. The description of a
     * subscription includes SubscriptionName, SNSTopicARN,
     * CustomerID, SourceType, SourceID,
     * CreationTime, and Status.
     * If you specify SubscriptionName, this action lists the description for that
     * subscription.
     */
    override suspend fun describeEventSubscriptions(input: DescribeEventSubscriptionsRequest): DescribeEventSubscriptionsResponse {
        val op = SdkHttpOperation.build<DescribeEventSubscriptionsRequest, DescribeEventSubscriptionsResponse> {
            serializer = DescribeEventSubscriptionsOperationSerializer()
            deserializer = DescribeEventSubscriptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEventSubscriptions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Lists events for a given source identifier and source type. You can also specify a
     * start and end time. For more information on DMS events, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications in the Database Migration Service User
     * Guide.
     */
    override suspend fun describeEvents(input: DescribeEventsRequest): DescribeEventsResponse {
        val op = SdkHttpOperation.build<DescribeEventsRequest, DescribeEventsResponse> {
            serializer = DescribeEventsOperationSerializer()
            deserializer = DescribeEventsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEvents"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the replication instance types that can be created in the
     * specified region.
     */
    override suspend fun describeOrderableReplicationInstances(input: DescribeOrderableReplicationInstancesRequest): DescribeOrderableReplicationInstancesResponse {
        val op = SdkHttpOperation.build<DescribeOrderableReplicationInstancesRequest, DescribeOrderableReplicationInstancesResponse> {
            serializer = DescribeOrderableReplicationInstancesOperationSerializer()
            deserializer = DescribeOrderableReplicationInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeOrderableReplicationInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * For internal use only
     */
    override suspend fun describePendingMaintenanceActions(input: DescribePendingMaintenanceActionsRequest): DescribePendingMaintenanceActionsResponse {
        val op = SdkHttpOperation.build<DescribePendingMaintenanceActionsRequest, DescribePendingMaintenanceActionsResponse> {
            serializer = DescribePendingMaintenanceActionsOperationSerializer()
            deserializer = DescribePendingMaintenanceActionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribePendingMaintenanceActions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Returns the status of the RefreshSchemas operation.
     */
    override suspend fun describeRefreshSchemasStatus(input: DescribeRefreshSchemasStatusRequest): DescribeRefreshSchemasStatusResponse {
        val op = SdkHttpOperation.build<DescribeRefreshSchemasStatusRequest, DescribeRefreshSchemasStatusResponse> {
            serializer = DescribeRefreshSchemasStatusOperationSerializer()
            deserializer = DescribeRefreshSchemasStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeRefreshSchemasStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the task logs for the specified task.
     */
    override suspend fun describeReplicationInstanceTaskLogs(input: DescribeReplicationInstanceTaskLogsRequest): DescribeReplicationInstanceTaskLogsResponse {
        val op = SdkHttpOperation.build<DescribeReplicationInstanceTaskLogsRequest, DescribeReplicationInstanceTaskLogsResponse> {
            serializer = DescribeReplicationInstanceTaskLogsOperationSerializer()
            deserializer = DescribeReplicationInstanceTaskLogsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeReplicationInstanceTaskLogs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about replication instances for your account in the current
     * region.
     */
    override suspend fun describeReplicationInstances(input: DescribeReplicationInstancesRequest): DescribeReplicationInstancesResponse {
        val op = SdkHttpOperation.build<DescribeReplicationInstancesRequest, DescribeReplicationInstancesResponse> {
            serializer = DescribeReplicationInstancesOperationSerializer()
            deserializer = DescribeReplicationInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeReplicationInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the replication subnet groups.
     */
    override suspend fun describeReplicationSubnetGroups(input: DescribeReplicationSubnetGroupsRequest): DescribeReplicationSubnetGroupsResponse {
        val op = SdkHttpOperation.build<DescribeReplicationSubnetGroupsRequest, DescribeReplicationSubnetGroupsResponse> {
            serializer = DescribeReplicationSubnetGroupsOperationSerializer()
            deserializer = DescribeReplicationSubnetGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeReplicationSubnetGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Returns the task assessment results from the Amazon S3 bucket that DMS creates in your
     * Amazon Web Services account.  This action always returns the
     * latest results.
     * For more information about DMS task assessments, see
     * <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html">Creating a task assessment report
     * in the <a href="https://docs.aws.amazon.com/https:/docs.aws.amazon.com/dms/latest/userguide/Welcome.html">
     * Database Migration Service User Guide.
     */
    override suspend fun describeReplicationTaskAssessmentResults(input: DescribeReplicationTaskAssessmentResultsRequest): DescribeReplicationTaskAssessmentResultsResponse {
        val op = SdkHttpOperation.build<DescribeReplicationTaskAssessmentResultsRequest, DescribeReplicationTaskAssessmentResultsResponse> {
            serializer = DescribeReplicationTaskAssessmentResultsOperationSerializer()
            deserializer = DescribeReplicationTaskAssessmentResultsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeReplicationTaskAssessmentResults"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Returns a paginated list of premigration assessment runs based on filter
     * settings.
     * These filter settings can specify a combination of premigration assessment runs,
     * migration tasks, replication instances, and assessment run status values.
     * This operation doesn't return information about individual assessments. For this
     * information, see the DescribeReplicationTaskIndividualAssessments
     * operation.
     */
    override suspend fun describeReplicationTaskAssessmentRuns(input: DescribeReplicationTaskAssessmentRunsRequest): DescribeReplicationTaskAssessmentRunsResponse {
        val op = SdkHttpOperation.build<DescribeReplicationTaskAssessmentRunsRequest, DescribeReplicationTaskAssessmentRunsResponse> {
            serializer = DescribeReplicationTaskAssessmentRunsOperationSerializer()
            deserializer = DescribeReplicationTaskAssessmentRunsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeReplicationTaskAssessmentRuns"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Returns a paginated list of individual assessments based on filter settings.
     * These filter settings can specify a combination of premigration assessment runs,
     * migration tasks, and assessment status values.
     */
    override suspend fun describeReplicationTaskIndividualAssessments(input: DescribeReplicationTaskIndividualAssessmentsRequest): DescribeReplicationTaskIndividualAssessmentsResponse {
        val op = SdkHttpOperation.build<DescribeReplicationTaskIndividualAssessmentsRequest, DescribeReplicationTaskIndividualAssessmentsResponse> {
            serializer = DescribeReplicationTaskIndividualAssessmentsOperationSerializer()
            deserializer = DescribeReplicationTaskIndividualAssessmentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeReplicationTaskIndividualAssessments"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about replication tasks for your account in the current
     * region.
     */
    override suspend fun describeReplicationTasks(input: DescribeReplicationTasksRequest): DescribeReplicationTasksResponse {
        val op = SdkHttpOperation.build<DescribeReplicationTasksRequest, DescribeReplicationTasksResponse> {
            serializer = DescribeReplicationTasksOperationSerializer()
            deserializer = DescribeReplicationTasksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeReplicationTasks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the schema for the specified endpoint.
     */
    override suspend fun describeSchemas(input: DescribeSchemasRequest): DescribeSchemasResponse {
        val op = SdkHttpOperation.build<DescribeSchemasRequest, DescribeSchemasResponse> {
            serializer = DescribeSchemasOperationSerializer()
            deserializer = DescribeSchemasOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSchemas"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Returns table statistics on the database migration task, including table name, rows
     * inserted, rows updated, and rows deleted.
     * Note that the "last updated" column the DMS console only indicates the time that DMS
     * last updated the table statistics record for a table. It does not indicate the time of the
     * last update to the table.
     */
    override suspend fun describeTableStatistics(input: DescribeTableStatisticsRequest): DescribeTableStatisticsResponse {
        val op = SdkHttpOperation.build<DescribeTableStatisticsRequest, DescribeTableStatisticsResponse> {
            serializer = DescribeTableStatisticsOperationSerializer()
            deserializer = DescribeTableStatisticsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTableStatistics"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Uploads the specified certificate.
     */
    override suspend fun importCertificate(input: ImportCertificateRequest): ImportCertificateResponse {
        val op = SdkHttpOperation.build<ImportCertificateRequest, ImportCertificateResponse> {
            serializer = ImportCertificateOperationSerializer()
            deserializer = ImportCertificateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ImportCertificate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Lists all metadata tags attached to an DMS resource, including
     * replication instance, endpoint, security group, and migration task.
     * For more information, see <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html">
     * Tag
     * data type description.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the specified endpoint.
     * For a MySQL source or target endpoint, don't explicitly specify the database using
     * the DatabaseName request parameter on the ModifyEndpoint API call.
     * Specifying DatabaseName when you modify a MySQL endpoint replicates all the
     * task tables to this single database. For MySQL endpoints, you specify the database only when
     * you specify the schema in the table-mapping rules of the DMS task.
     */
    override suspend fun modifyEndpoint(input: ModifyEndpointRequest): ModifyEndpointResponse {
        val op = SdkHttpOperation.build<ModifyEndpointRequest, ModifyEndpointResponse> {
            serializer = ModifyEndpointOperationSerializer()
            deserializer = ModifyEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyEndpoint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Modifies an existing DMS event notification subscription.
     */
    override suspend fun modifyEventSubscription(input: ModifyEventSubscriptionRequest): ModifyEventSubscriptionResponse {
        val op = SdkHttpOperation.build<ModifyEventSubscriptionRequest, ModifyEventSubscriptionResponse> {
            serializer = ModifyEventSubscriptionOperationSerializer()
            deserializer = ModifyEventSubscriptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyEventSubscription"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the replication instance to apply new settings. You can change one or more
     * parameters by specifying these parameters and the new values in the request.
     * Some settings are applied during the maintenance window.
     */
    override suspend fun modifyReplicationInstance(input: ModifyReplicationInstanceRequest): ModifyReplicationInstanceResponse {
        val op = SdkHttpOperation.build<ModifyReplicationInstanceRequest, ModifyReplicationInstanceResponse> {
            serializer = ModifyReplicationInstanceOperationSerializer()
            deserializer = ModifyReplicationInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyReplicationInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the settings for the specified replication subnet group.
     */
    override suspend fun modifyReplicationSubnetGroup(input: ModifyReplicationSubnetGroupRequest): ModifyReplicationSubnetGroupResponse {
        val op = SdkHttpOperation.build<ModifyReplicationSubnetGroupRequest, ModifyReplicationSubnetGroupResponse> {
            serializer = ModifyReplicationSubnetGroupOperationSerializer()
            deserializer = ModifyReplicationSubnetGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyReplicationSubnetGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the specified replication task.
     * You can't modify the task endpoints. The task must be stopped before you can modify it.
     * For more information about DMS tasks, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html">Working with Migration Tasks in the
     * Database Migration Service User Guide.
     */
    override suspend fun modifyReplicationTask(input: ModifyReplicationTaskRequest): ModifyReplicationTaskResponse {
        val op = SdkHttpOperation.build<ModifyReplicationTaskRequest, ModifyReplicationTaskResponse> {
            serializer = ModifyReplicationTaskOperationSerializer()
            deserializer = ModifyReplicationTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyReplicationTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Moves a replication task from its current replication instance to a different target
     * replication instance using the specified parameters. The target replication instance must
     * be created with the same or later DMS version as the current replication
     * instance.
     */
    override suspend fun moveReplicationTask(input: MoveReplicationTaskRequest): MoveReplicationTaskResponse {
        val op = SdkHttpOperation.build<MoveReplicationTaskRequest, MoveReplicationTaskResponse> {
            serializer = MoveReplicationTaskOperationSerializer()
            deserializer = MoveReplicationTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "MoveReplicationTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Reboots a replication instance. Rebooting results in a momentary outage, until the
     * replication instance becomes available again.
     */
    override suspend fun rebootReplicationInstance(input: RebootReplicationInstanceRequest): RebootReplicationInstanceResponse {
        val op = SdkHttpOperation.build<RebootReplicationInstanceRequest, RebootReplicationInstanceResponse> {
            serializer = RebootReplicationInstanceOperationSerializer()
            deserializer = RebootReplicationInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RebootReplicationInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Populates the schema for the specified endpoint. This is an asynchronous operation and
     * can take several minutes. You can check the status of this operation by calling the
     * DescribeRefreshSchemasStatus operation.
     */
    override suspend fun refreshSchemas(input: RefreshSchemasRequest): RefreshSchemasResponse {
        val op = SdkHttpOperation.build<RefreshSchemasRequest, RefreshSchemasResponse> {
            serializer = RefreshSchemasOperationSerializer()
            deserializer = RefreshSchemasOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RefreshSchemas"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Reloads the target database table with the source data.
     * You can only use this operation with a task in the RUNNING state, otherwise the service
     * will throw an InvalidResourceStateFault exception.
     */
    override suspend fun reloadTables(input: ReloadTablesRequest): ReloadTablesResponse {
        val op = SdkHttpOperation.build<ReloadTablesRequest, ReloadTablesResponse> {
            serializer = ReloadTablesOperationSerializer()
            deserializer = ReloadTablesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ReloadTables"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Removes metadata tags from an DMS resource, including replication instance,
     * endpoint, security group, and migration task. For more information, see
     * <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html">
     * Tag
     * data type description.
     */
    override suspend fun removeTagsFromResource(input: RemoveTagsFromResourceRequest): RemoveTagsFromResourceResponse {
        val op = SdkHttpOperation.build<RemoveTagsFromResourceRequest, RemoveTagsFromResourceResponse> {
            serializer = RemoveTagsFromResourceOperationSerializer()
            deserializer = RemoveTagsFromResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RemoveTagsFromResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Starts the replication task.
     * For more information about DMS tasks, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html">Working with Migration Tasks  in the
     * Database Migration Service User Guide.
     */
    override suspend fun startReplicationTask(input: StartReplicationTaskRequest): StartReplicationTaskResponse {
        val op = SdkHttpOperation.build<StartReplicationTaskRequest, StartReplicationTaskResponse> {
            serializer = StartReplicationTaskOperationSerializer()
            deserializer = StartReplicationTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartReplicationTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Starts the replication task assessment for unsupported data types in the source
     * database.
     */
    override suspend fun startReplicationTaskAssessment(input: StartReplicationTaskAssessmentRequest): StartReplicationTaskAssessmentResponse {
        val op = SdkHttpOperation.build<StartReplicationTaskAssessmentRequest, StartReplicationTaskAssessmentResponse> {
            serializer = StartReplicationTaskAssessmentOperationSerializer()
            deserializer = StartReplicationTaskAssessmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartReplicationTaskAssessment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Starts a new premigration assessment run for one or more individual assessments
     * of a migration task.
     * The assessments that you can specify depend on the source and target database engine and
     * the migration type defined for the given task. To run this operation, your migration task
     * must already be created. After you run this operation, you can review the status of each
     * individual assessment. You can also run the migration task manually after the assessment
     * run and its individual assessments complete.
     */
    override suspend fun startReplicationTaskAssessmentRun(input: StartReplicationTaskAssessmentRunRequest): StartReplicationTaskAssessmentRunResponse {
        val op = SdkHttpOperation.build<StartReplicationTaskAssessmentRunRequest, StartReplicationTaskAssessmentRunResponse> {
            serializer = StartReplicationTaskAssessmentRunOperationSerializer()
            deserializer = StartReplicationTaskAssessmentRunOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartReplicationTaskAssessmentRun"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Stops the replication task.
     */
    override suspend fun stopReplicationTask(input: StopReplicationTaskRequest): StopReplicationTaskResponse {
        val op = SdkHttpOperation.build<StopReplicationTaskRequest, StopReplicationTaskResponse> {
            serializer = StopReplicationTaskOperationSerializer()
            deserializer = StopReplicationTaskOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopReplicationTask"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    /**
     * Tests the connection between the replication instance and the endpoint.
     */
    override suspend fun testConnection(input: TestConnectionRequest): TestConnectionResponse {
        val op = SdkHttpOperation.build<TestConnectionRequest, TestConnectionResponse> {
            serializer = TestConnectionOperationSerializer()
            deserializer = TestConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TestConnection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint) {
            serviceId = ServiceId
            resolver = config.endpointResolver
        }
        op.install(Retry) {
            strategy = config.retryStrategy
            policy = AwsDefaultRetryPolicy
        }
        op.install(AwsJsonProtocol) {
            serviceShapeName = "AmazonDMSv20160101"
            version = "1.1"
        }
        op.install(UserAgent) {
            staticMetadata = awsUserAgentMetadata
        }
        op.install(AwsSigV4SigningMiddleware) {
            this.credentialsProvider = config.credentialsProvider
            this.signingService = "dms"
        }
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
    }
}
