// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.services.databasemigrationservice.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.databasemigrationservice.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * <fullname>Database Migration Service</fullname>
 * Database Migration Service (DMS) can migrate your data to and from the most
 * widely used commercial and open-source databases such as Oracle, PostgreSQL, Microsoft SQL
 * Server, Amazon Redshift, MariaDB, Amazon Aurora, MySQL, and SAP Adaptive Server Enterprise
 * (ASE). The service supports homogeneous migrations such as Oracle to Oracle, as well as
 * heterogeneous migrations between different database platforms, such as Oracle to MySQL or
 * SQL Server to PostgreSQL.
 * For more information about DMS, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/Welcome.html">What Is Database Migration Service?
 * in the Database Migration Service User Guide.
 */
interface DatabaseMigrationClient : SdkClient {

    override val serviceName: String
        get() = "Database Migration Service"
    /**
     * DatabaseMigrationClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.Builder.() -> Unit = {}): DatabaseMigrationClient {
            val config = Config.Builder().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
            }.apply(block).build()
            return DefaultDatabaseMigrationClient(config)
        }

        operator fun invoke(config: Config): DatabaseMigrationClient = DefaultDatabaseMigrationClient(config)

        /**
         * Construct a [DatabaseMigrationClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): DatabaseMigrationClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return DatabaseMigrationClient(sharedConfig)
        }
    }

    class Config private constructor(builder: Builder): AwsClientConfig, HttpClientConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Adds metadata tags to an DMS resource, including replication instance, endpoint,
     * security group, and migration task. These tags can also be used with cost allocation
     * reporting to track cost associated with DMS resources, or used in a Condition statement in
     * an IAM policy for DMS. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html">
     * Tag
     * data type description.
     */
    suspend fun addTagsToResource(input: AddTagsToResourceRequest): AddTagsToResourceResponse

    /**
     * Adds metadata tags to an DMS resource, including replication instance, endpoint,
     * security group, and migration task. These tags can also be used with cost allocation
     * reporting to track cost associated with DMS resources, or used in a Condition statement in
     * an IAM policy for DMS. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html">
     * Tag
     * data type description.
     */
    suspend fun addTagsToResource(block: AddTagsToResourceRequest.Builder.() -> Unit) = addTagsToResource(AddTagsToResourceRequest.Builder().apply(block).build())

    /**
     * Applies a pending maintenance action to a resource (for example, to a replication instance).
     */
    suspend fun applyPendingMaintenanceAction(input: ApplyPendingMaintenanceActionRequest): ApplyPendingMaintenanceActionResponse

    /**
     * Applies a pending maintenance action to a resource (for example, to a replication instance).
     */
    suspend fun applyPendingMaintenanceAction(block: ApplyPendingMaintenanceActionRequest.Builder.() -> Unit) = applyPendingMaintenanceAction(ApplyPendingMaintenanceActionRequest.Builder().apply(block).build())

    /**
     * Cancels a single premigration assessment run.
     * This operation prevents any individual assessments from running if they haven't started
     * running. It also attempts to cancel any individual assessments that are currently
     * running.
     */
    suspend fun cancelReplicationTaskAssessmentRun(input: CancelReplicationTaskAssessmentRunRequest): CancelReplicationTaskAssessmentRunResponse

    /**
     * Cancels a single premigration assessment run.
     * This operation prevents any individual assessments from running if they haven't started
     * running. It also attempts to cancel any individual assessments that are currently
     * running.
     */
    suspend fun cancelReplicationTaskAssessmentRun(block: CancelReplicationTaskAssessmentRunRequest.Builder.() -> Unit) = cancelReplicationTaskAssessmentRun(CancelReplicationTaskAssessmentRunRequest.Builder().apply(block).build())

    /**
     * Creates an endpoint using the provided settings.
     * For a MySQL source or target endpoint, don't explicitly specify the database using
     * the DatabaseName request parameter on the CreateEndpoint API call.
     * Specifying DatabaseName when you create a MySQL endpoint replicates all the
     * task tables to this single database. For MySQL endpoints, you specify the database only when
     * you specify the schema in the table-mapping rules of the DMS task.
     */
    suspend fun createEndpoint(input: CreateEndpointRequest): CreateEndpointResponse

    /**
     * Creates an endpoint using the provided settings.
     * For a MySQL source or target endpoint, don't explicitly specify the database using
     * the DatabaseName request parameter on the CreateEndpoint API call.
     * Specifying DatabaseName when you create a MySQL endpoint replicates all the
     * task tables to this single database. For MySQL endpoints, you specify the database only when
     * you specify the schema in the table-mapping rules of the DMS task.
     */
    suspend fun createEndpoint(block: CreateEndpointRequest.Builder.() -> Unit) = createEndpoint(CreateEndpointRequest.Builder().apply(block).build())

    /**
     * Creates an DMS event notification subscription.
     * You can specify the type of source (SourceType) you want to be notified of,
     * provide a list of DMS source IDs (SourceIds) that triggers the events, and
     * provide a list of event categories (EventCategories) for events you want to be
     * notified of. If you specify both the SourceType and SourceIds,
     * such as SourceType = replication-instance and SourceIdentifier =
     * my-replinstance, you will be notified of all the replication instance events for
     * the specified source. If you specify a SourceType but don't specify a
     * SourceIdentifier, you receive notice of the events for that source type for
     * all your DMS sources. If you don't specify either SourceType nor
     * SourceIdentifier, you will be notified of events generated from all DMS
     * sources belonging to your customer account.
     * For more information about DMS events, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications in the Database Migration Service User
     * Guide.
     */
    suspend fun createEventSubscription(input: CreateEventSubscriptionRequest): CreateEventSubscriptionResponse

    /**
     * Creates an DMS event notification subscription.
     * You can specify the type of source (SourceType) you want to be notified of,
     * provide a list of DMS source IDs (SourceIds) that triggers the events, and
     * provide a list of event categories (EventCategories) for events you want to be
     * notified of. If you specify both the SourceType and SourceIds,
     * such as SourceType = replication-instance and SourceIdentifier =
     * my-replinstance, you will be notified of all the replication instance events for
     * the specified source. If you specify a SourceType but don't specify a
     * SourceIdentifier, you receive notice of the events for that source type for
     * all your DMS sources. If you don't specify either SourceType nor
     * SourceIdentifier, you will be notified of events generated from all DMS
     * sources belonging to your customer account.
     * For more information about DMS events, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications in the Database Migration Service User
     * Guide.
     */
    suspend fun createEventSubscription(block: CreateEventSubscriptionRequest.Builder.() -> Unit) = createEventSubscription(CreateEventSubscriptionRequest.Builder().apply(block).build())

    /**
     * Creates the replication instance using the specified parameters.
     * DMS requires that your account have certain roles with appropriate permissions
     * before you can create a replication instance. For information on the required roles, see
     * <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.APIRole">Creating the IAM Roles to Use With the CLI and DMS API. For
     * information on the required permissions, see
     * <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.IAMPermissions">IAM Permissions Needed to Use DMS.
     */
    suspend fun createReplicationInstance(input: CreateReplicationInstanceRequest): CreateReplicationInstanceResponse

    /**
     * Creates the replication instance using the specified parameters.
     * DMS requires that your account have certain roles with appropriate permissions
     * before you can create a replication instance. For information on the required roles, see
     * <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.APIRole">Creating the IAM Roles to Use With the CLI and DMS API. For
     * information on the required permissions, see
     * <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.IAMPermissions">IAM Permissions Needed to Use DMS.
     */
    suspend fun createReplicationInstance(block: CreateReplicationInstanceRequest.Builder.() -> Unit) = createReplicationInstance(CreateReplicationInstanceRequest.Builder().apply(block).build())

    /**
     * Creates a replication subnet group given a list of the subnet IDs in a VPC.
     * The VPC needs to have at least one subnet in at least two availability zones in the Amazon Web Services Region, otherwise the
     * service will throw a ReplicationSubnetGroupDoesNotCoverEnoughAZs exception.
     */
    suspend fun createReplicationSubnetGroup(input: CreateReplicationSubnetGroupRequest): CreateReplicationSubnetGroupResponse

    /**
     * Creates a replication subnet group given a list of the subnet IDs in a VPC.
     * The VPC needs to have at least one subnet in at least two availability zones in the Amazon Web Services Region, otherwise the
     * service will throw a ReplicationSubnetGroupDoesNotCoverEnoughAZs exception.
     */
    suspend fun createReplicationSubnetGroup(block: CreateReplicationSubnetGroupRequest.Builder.() -> Unit) = createReplicationSubnetGroup(CreateReplicationSubnetGroupRequest.Builder().apply(block).build())

    /**
     * Creates a replication task using the specified parameters.
     */
    suspend fun createReplicationTask(input: CreateReplicationTaskRequest): CreateReplicationTaskResponse

    /**
     * Creates a replication task using the specified parameters.
     */
    suspend fun createReplicationTask(block: CreateReplicationTaskRequest.Builder.() -> Unit) = createReplicationTask(CreateReplicationTaskRequest.Builder().apply(block).build())

    /**
     * Deletes the specified certificate.
     */
    suspend fun deleteCertificate(input: DeleteCertificateRequest): DeleteCertificateResponse

    /**
     * Deletes the specified certificate.
     */
    suspend fun deleteCertificate(block: DeleteCertificateRequest.Builder.() -> Unit) = deleteCertificate(DeleteCertificateRequest.Builder().apply(block).build())

    /**
     * Deletes the connection between a replication instance and an endpoint.
     */
    suspend fun deleteConnection(input: DeleteConnectionRequest): DeleteConnectionResponse

    /**
     * Deletes the connection between a replication instance and an endpoint.
     */
    suspend fun deleteConnection(block: DeleteConnectionRequest.Builder.() -> Unit) = deleteConnection(DeleteConnectionRequest.Builder().apply(block).build())

    /**
     * Deletes the specified endpoint.
     * All tasks associated with the endpoint must be deleted before you can delete the
     * endpoint.
     */
    suspend fun deleteEndpoint(input: DeleteEndpointRequest): DeleteEndpointResponse

    /**
     * Deletes the specified endpoint.
     * All tasks associated with the endpoint must be deleted before you can delete the
     * endpoint.
     */
    suspend fun deleteEndpoint(block: DeleteEndpointRequest.Builder.() -> Unit) = deleteEndpoint(DeleteEndpointRequest.Builder().apply(block).build())

    /**
     * Deletes an DMS event subscription.
     */
    suspend fun deleteEventSubscription(input: DeleteEventSubscriptionRequest): DeleteEventSubscriptionResponse

    /**
     * Deletes an DMS event subscription.
     */
    suspend fun deleteEventSubscription(block: DeleteEventSubscriptionRequest.Builder.() -> Unit) = deleteEventSubscription(DeleteEventSubscriptionRequest.Builder().apply(block).build())

    /**
     * Deletes the specified replication instance.
     * You must delete any migration tasks that are associated with the replication instance
     * before you can delete it.
     */
    suspend fun deleteReplicationInstance(input: DeleteReplicationInstanceRequest): DeleteReplicationInstanceResponse

    /**
     * Deletes the specified replication instance.
     * You must delete any migration tasks that are associated with the replication instance
     * before you can delete it.
     */
    suspend fun deleteReplicationInstance(block: DeleteReplicationInstanceRequest.Builder.() -> Unit) = deleteReplicationInstance(DeleteReplicationInstanceRequest.Builder().apply(block).build())

    /**
     * Deletes a subnet group.
     */
    suspend fun deleteReplicationSubnetGroup(input: DeleteReplicationSubnetGroupRequest): DeleteReplicationSubnetGroupResponse

    /**
     * Deletes a subnet group.
     */
    suspend fun deleteReplicationSubnetGroup(block: DeleteReplicationSubnetGroupRequest.Builder.() -> Unit) = deleteReplicationSubnetGroup(DeleteReplicationSubnetGroupRequest.Builder().apply(block).build())

    /**
     * Deletes the specified replication task.
     */
    suspend fun deleteReplicationTask(input: DeleteReplicationTaskRequest): DeleteReplicationTaskResponse

    /**
     * Deletes the specified replication task.
     */
    suspend fun deleteReplicationTask(block: DeleteReplicationTaskRequest.Builder.() -> Unit) = deleteReplicationTask(DeleteReplicationTaskRequest.Builder().apply(block).build())

    /**
     * Deletes the record of a single premigration assessment run.
     * This operation removes all metadata that DMS maintains about this assessment run.
     * However, the operation leaves untouched all information about this assessment run that is
     * stored in your Amazon S3 bucket.
     */
    suspend fun deleteReplicationTaskAssessmentRun(input: DeleteReplicationTaskAssessmentRunRequest): DeleteReplicationTaskAssessmentRunResponse

    /**
     * Deletes the record of a single premigration assessment run.
     * This operation removes all metadata that DMS maintains about this assessment run.
     * However, the operation leaves untouched all information about this assessment run that is
     * stored in your Amazon S3 bucket.
     */
    suspend fun deleteReplicationTaskAssessmentRun(block: DeleteReplicationTaskAssessmentRunRequest.Builder.() -> Unit) = deleteReplicationTaskAssessmentRun(DeleteReplicationTaskAssessmentRunRequest.Builder().apply(block).build())

    /**
     * Lists all of the DMS attributes for a customer account. These attributes include DMS
     * quotas for the account and a unique account identifier in a particular DMS region. DMS
     * quotas include a list of resource quotas supported by the account, such as the number of
     * replication instances allowed. The description for each resource quota, includes the quota
     * name, current usage toward that quota, and the quota's maximum value. DMS uses the unique
     * account identifier to name each artifact used by DMS in the given region.
     * This command does not take any parameters.
     */
    suspend fun describeAccountAttributes(input: DescribeAccountAttributesRequest): DescribeAccountAttributesResponse

    /**
     * Lists all of the DMS attributes for a customer account. These attributes include DMS
     * quotas for the account and a unique account identifier in a particular DMS region. DMS
     * quotas include a list of resource quotas supported by the account, such as the number of
     * replication instances allowed. The description for each resource quota, includes the quota
     * name, current usage toward that quota, and the quota's maximum value. DMS uses the unique
     * account identifier to name each artifact used by DMS in the given region.
     * This command does not take any parameters.
     */
    suspend fun describeAccountAttributes(block: DescribeAccountAttributesRequest.Builder.() -> Unit) = describeAccountAttributes(DescribeAccountAttributesRequest.Builder().apply(block).build())

    /**
     * Provides a list of individual assessments that you can specify for a new premigration
     * assessment run, given one or more parameters.
     * If you specify an existing migration task, this operation provides the default individual
     * assessments you can specify for that task. Otherwise, the specified parameters model elements
     * of a possible migration task on which to base a premigration assessment run.
     * To use these migration task modeling parameters, you must specify an existing replication instance,
     * a source database engine, a target database engine, and a migration type. This combination of
     * parameters potentially limits the default individual assessments available for an assessment run
     * created for a corresponding migration task.
     * If you specify no parameters, this operation provides a list of all possible individual assessments
     * that you can specify for an assessment run. If you specify any one of the task modeling parameters, you must
     * specify all of them or the operation cannot provide a list of individual assessments.
     * The only parameter that you can specify alone is for an existing migration task. The specified task
     * definition then determines the default list of individual assessments that you can specify in an
     * assessment run for the task.
     */
    suspend fun describeApplicableIndividualAssessments(input: DescribeApplicableIndividualAssessmentsRequest): DescribeApplicableIndividualAssessmentsResponse

    /**
     * Provides a list of individual assessments that you can specify for a new premigration
     * assessment run, given one or more parameters.
     * If you specify an existing migration task, this operation provides the default individual
     * assessments you can specify for that task. Otherwise, the specified parameters model elements
     * of a possible migration task on which to base a premigration assessment run.
     * To use these migration task modeling parameters, you must specify an existing replication instance,
     * a source database engine, a target database engine, and a migration type. This combination of
     * parameters potentially limits the default individual assessments available for an assessment run
     * created for a corresponding migration task.
     * If you specify no parameters, this operation provides a list of all possible individual assessments
     * that you can specify for an assessment run. If you specify any one of the task modeling parameters, you must
     * specify all of them or the operation cannot provide a list of individual assessments.
     * The only parameter that you can specify alone is for an existing migration task. The specified task
     * definition then determines the default list of individual assessments that you can specify in an
     * assessment run for the task.
     */
    suspend fun describeApplicableIndividualAssessments(block: DescribeApplicableIndividualAssessmentsRequest.Builder.() -> Unit) = describeApplicableIndividualAssessments(DescribeApplicableIndividualAssessmentsRequest.Builder().apply(block).build())

    /**
     * Provides a description of the certificate.
     */
    suspend fun describeCertificates(input: DescribeCertificatesRequest): DescribeCertificatesResponse

    /**
     * Provides a description of the certificate.
     */
    suspend fun describeCertificates(block: DescribeCertificatesRequest.Builder.() -> Unit) = describeCertificates(DescribeCertificatesRequest.Builder().apply(block).build())

    /**
     * Describes the status of the connections that have been made between the replication
     * instance and an endpoint. Connections are created when you test an endpoint.
     */
    suspend fun describeConnections(input: DescribeConnectionsRequest): DescribeConnectionsResponse

    /**
     * Describes the status of the connections that have been made between the replication
     * instance and an endpoint. Connections are created when you test an endpoint.
     */
    suspend fun describeConnections(block: DescribeConnectionsRequest.Builder.() -> Unit) = describeConnections(DescribeConnectionsRequest.Builder().apply(block).build())

    /**
     * Returns information about the possible endpoint settings available
     * when you create an endpoint for a specific database engine.
     */
    suspend fun describeEndpointSettings(input: DescribeEndpointSettingsRequest): DescribeEndpointSettingsResponse

    /**
     * Returns information about the possible endpoint settings available
     * when you create an endpoint for a specific database engine.
     */
    suspend fun describeEndpointSettings(block: DescribeEndpointSettingsRequest.Builder.() -> Unit) = describeEndpointSettings(DescribeEndpointSettingsRequest.Builder().apply(block).build())

    /**
     * Returns information about the type of endpoints available.
     */
    suspend fun describeEndpointTypes(input: DescribeEndpointTypesRequest): DescribeEndpointTypesResponse

    /**
     * Returns information about the type of endpoints available.
     */
    suspend fun describeEndpointTypes(block: DescribeEndpointTypesRequest.Builder.() -> Unit) = describeEndpointTypes(DescribeEndpointTypesRequest.Builder().apply(block).build())

    /**
     * Returns information about the endpoints for your account in the current region.
     */
    suspend fun describeEndpoints(input: DescribeEndpointsRequest): DescribeEndpointsResponse

    /**
     * Returns information about the endpoints for your account in the current region.
     */
    suspend fun describeEndpoints(block: DescribeEndpointsRequest.Builder.() -> Unit) = describeEndpoints(DescribeEndpointsRequest.Builder().apply(block).build())

    /**
     * Lists categories for all event source types, or, if specified, for a specified source
     * type. You can see a list of the event categories and source types in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events
     * and Notifications in the Database Migration Service User
     * Guide.
     */
    suspend fun describeEventCategories(input: DescribeEventCategoriesRequest): DescribeEventCategoriesResponse

    /**
     * Lists categories for all event source types, or, if specified, for a specified source
     * type. You can see a list of the event categories and source types in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events
     * and Notifications in the Database Migration Service User
     * Guide.
     */
    suspend fun describeEventCategories(block: DescribeEventCategoriesRequest.Builder.() -> Unit) = describeEventCategories(DescribeEventCategoriesRequest.Builder().apply(block).build())

    /**
     * Lists all the event subscriptions for a customer account. The description of a
     * subscription includes SubscriptionName, SNSTopicARN,
     * CustomerID, SourceType, SourceID,
     * CreationTime, and Status.
     * If you specify SubscriptionName, this action lists the description for that
     * subscription.
     */
    suspend fun describeEventSubscriptions(input: DescribeEventSubscriptionsRequest): DescribeEventSubscriptionsResponse

    /**
     * Lists all the event subscriptions for a customer account. The description of a
     * subscription includes SubscriptionName, SNSTopicARN,
     * CustomerID, SourceType, SourceID,
     * CreationTime, and Status.
     * If you specify SubscriptionName, this action lists the description for that
     * subscription.
     */
    suspend fun describeEventSubscriptions(block: DescribeEventSubscriptionsRequest.Builder.() -> Unit) = describeEventSubscriptions(DescribeEventSubscriptionsRequest.Builder().apply(block).build())

    /**
     * Lists events for a given source identifier and source type. You can also specify a
     * start and end time. For more information on DMS events, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications in the Database Migration Service User
     * Guide.
     */
    suspend fun describeEvents(input: DescribeEventsRequest): DescribeEventsResponse

    /**
     * Lists events for a given source identifier and source type. You can also specify a
     * start and end time. For more information on DMS events, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications in the Database Migration Service User
     * Guide.
     */
    suspend fun describeEvents(block: DescribeEventsRequest.Builder.() -> Unit) = describeEvents(DescribeEventsRequest.Builder().apply(block).build())

    /**
     * Returns information about the replication instance types that can be created in the
     * specified region.
     */
    suspend fun describeOrderableReplicationInstances(input: DescribeOrderableReplicationInstancesRequest): DescribeOrderableReplicationInstancesResponse

    /**
     * Returns information about the replication instance types that can be created in the
     * specified region.
     */
    suspend fun describeOrderableReplicationInstances(block: DescribeOrderableReplicationInstancesRequest.Builder.() -> Unit) = describeOrderableReplicationInstances(DescribeOrderableReplicationInstancesRequest.Builder().apply(block).build())

    /**
     * For internal use only
     */
    suspend fun describePendingMaintenanceActions(input: DescribePendingMaintenanceActionsRequest): DescribePendingMaintenanceActionsResponse

    /**
     * For internal use only
     */
    suspend fun describePendingMaintenanceActions(block: DescribePendingMaintenanceActionsRequest.Builder.() -> Unit) = describePendingMaintenanceActions(DescribePendingMaintenanceActionsRequest.Builder().apply(block).build())

    /**
     * Returns the status of the RefreshSchemas operation.
     */
    suspend fun describeRefreshSchemasStatus(input: DescribeRefreshSchemasStatusRequest): DescribeRefreshSchemasStatusResponse

    /**
     * Returns the status of the RefreshSchemas operation.
     */
    suspend fun describeRefreshSchemasStatus(block: DescribeRefreshSchemasStatusRequest.Builder.() -> Unit) = describeRefreshSchemasStatus(DescribeRefreshSchemasStatusRequest.Builder().apply(block).build())

    /**
     * Returns information about the task logs for the specified task.
     */
    suspend fun describeReplicationInstanceTaskLogs(input: DescribeReplicationInstanceTaskLogsRequest): DescribeReplicationInstanceTaskLogsResponse

    /**
     * Returns information about the task logs for the specified task.
     */
    suspend fun describeReplicationInstanceTaskLogs(block: DescribeReplicationInstanceTaskLogsRequest.Builder.() -> Unit) = describeReplicationInstanceTaskLogs(DescribeReplicationInstanceTaskLogsRequest.Builder().apply(block).build())

    /**
     * Returns information about replication instances for your account in the current
     * region.
     */
    suspend fun describeReplicationInstances(input: DescribeReplicationInstancesRequest): DescribeReplicationInstancesResponse

    /**
     * Returns information about replication instances for your account in the current
     * region.
     */
    suspend fun describeReplicationInstances(block: DescribeReplicationInstancesRequest.Builder.() -> Unit) = describeReplicationInstances(DescribeReplicationInstancesRequest.Builder().apply(block).build())

    /**
     * Returns information about the replication subnet groups.
     */
    suspend fun describeReplicationSubnetGroups(input: DescribeReplicationSubnetGroupsRequest): DescribeReplicationSubnetGroupsResponse

    /**
     * Returns information about the replication subnet groups.
     */
    suspend fun describeReplicationSubnetGroups(block: DescribeReplicationSubnetGroupsRequest.Builder.() -> Unit) = describeReplicationSubnetGroups(DescribeReplicationSubnetGroupsRequest.Builder().apply(block).build())

    /**
     * Returns the task assessment results from the Amazon S3 bucket that DMS creates in your
     * Amazon Web Services account.  This action always returns the
     * latest results.
     * For more information about DMS task assessments, see
     * <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html">Creating a task assessment report
     * in the <a href="https://docs.aws.amazon.com/https:/docs.aws.amazon.com/dms/latest/userguide/Welcome.html">
     * Database Migration Service User Guide.
     */
    suspend fun describeReplicationTaskAssessmentResults(input: DescribeReplicationTaskAssessmentResultsRequest): DescribeReplicationTaskAssessmentResultsResponse

    /**
     * Returns the task assessment results from the Amazon S3 bucket that DMS creates in your
     * Amazon Web Services account.  This action always returns the
     * latest results.
     * For more information about DMS task assessments, see
     * <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html">Creating a task assessment report
     * in the <a href="https://docs.aws.amazon.com/https:/docs.aws.amazon.com/dms/latest/userguide/Welcome.html">
     * Database Migration Service User Guide.
     */
    suspend fun describeReplicationTaskAssessmentResults(block: DescribeReplicationTaskAssessmentResultsRequest.Builder.() -> Unit) = describeReplicationTaskAssessmentResults(DescribeReplicationTaskAssessmentResultsRequest.Builder().apply(block).build())

    /**
     * Returns a paginated list of premigration assessment runs based on filter
     * settings.
     * These filter settings can specify a combination of premigration assessment runs,
     * migration tasks, replication instances, and assessment run status values.
     * This operation doesn't return information about individual assessments. For this
     * information, see the DescribeReplicationTaskIndividualAssessments
     * operation.
     */
    suspend fun describeReplicationTaskAssessmentRuns(input: DescribeReplicationTaskAssessmentRunsRequest): DescribeReplicationTaskAssessmentRunsResponse

    /**
     * Returns a paginated list of premigration assessment runs based on filter
     * settings.
     * These filter settings can specify a combination of premigration assessment runs,
     * migration tasks, replication instances, and assessment run status values.
     * This operation doesn't return information about individual assessments. For this
     * information, see the DescribeReplicationTaskIndividualAssessments
     * operation.
     */
    suspend fun describeReplicationTaskAssessmentRuns(block: DescribeReplicationTaskAssessmentRunsRequest.Builder.() -> Unit) = describeReplicationTaskAssessmentRuns(DescribeReplicationTaskAssessmentRunsRequest.Builder().apply(block).build())

    /**
     * Returns a paginated list of individual assessments based on filter settings.
     * These filter settings can specify a combination of premigration assessment runs,
     * migration tasks, and assessment status values.
     */
    suspend fun describeReplicationTaskIndividualAssessments(input: DescribeReplicationTaskIndividualAssessmentsRequest): DescribeReplicationTaskIndividualAssessmentsResponse

    /**
     * Returns a paginated list of individual assessments based on filter settings.
     * These filter settings can specify a combination of premigration assessment runs,
     * migration tasks, and assessment status values.
     */
    suspend fun describeReplicationTaskIndividualAssessments(block: DescribeReplicationTaskIndividualAssessmentsRequest.Builder.() -> Unit) = describeReplicationTaskIndividualAssessments(DescribeReplicationTaskIndividualAssessmentsRequest.Builder().apply(block).build())

    /**
     * Returns information about replication tasks for your account in the current
     * region.
     */
    suspend fun describeReplicationTasks(input: DescribeReplicationTasksRequest): DescribeReplicationTasksResponse

    /**
     * Returns information about replication tasks for your account in the current
     * region.
     */
    suspend fun describeReplicationTasks(block: DescribeReplicationTasksRequest.Builder.() -> Unit) = describeReplicationTasks(DescribeReplicationTasksRequest.Builder().apply(block).build())

    /**
     * Returns information about the schema for the specified endpoint.
     */
    suspend fun describeSchemas(input: DescribeSchemasRequest): DescribeSchemasResponse

    /**
     * Returns information about the schema for the specified endpoint.
     */
    suspend fun describeSchemas(block: DescribeSchemasRequest.Builder.() -> Unit) = describeSchemas(DescribeSchemasRequest.Builder().apply(block).build())

    /**
     * Returns table statistics on the database migration task, including table name, rows
     * inserted, rows updated, and rows deleted.
     * Note that the "last updated" column the DMS console only indicates the time that DMS
     * last updated the table statistics record for a table. It does not indicate the time of the
     * last update to the table.
     */
    suspend fun describeTableStatistics(input: DescribeTableStatisticsRequest): DescribeTableStatisticsResponse

    /**
     * Returns table statistics on the database migration task, including table name, rows
     * inserted, rows updated, and rows deleted.
     * Note that the "last updated" column the DMS console only indicates the time that DMS
     * last updated the table statistics record for a table. It does not indicate the time of the
     * last update to the table.
     */
    suspend fun describeTableStatistics(block: DescribeTableStatisticsRequest.Builder.() -> Unit) = describeTableStatistics(DescribeTableStatisticsRequest.Builder().apply(block).build())

    /**
     * Uploads the specified certificate.
     */
    suspend fun importCertificate(input: ImportCertificateRequest): ImportCertificateResponse

    /**
     * Uploads the specified certificate.
     */
    suspend fun importCertificate(block: ImportCertificateRequest.Builder.() -> Unit) = importCertificate(ImportCertificateRequest.Builder().apply(block).build())

    /**
     * Lists all metadata tags attached to an DMS resource, including
     * replication instance, endpoint, security group, and migration task.
     * For more information, see <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html">
     * Tag
     * data type description.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists all metadata tags attached to an DMS resource, including
     * replication instance, endpoint, security group, and migration task.
     * For more information, see <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html">
     * Tag
     * data type description.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Modifies the specified endpoint.
     * For a MySQL source or target endpoint, don't explicitly specify the database using
     * the DatabaseName request parameter on the ModifyEndpoint API call.
     * Specifying DatabaseName when you modify a MySQL endpoint replicates all the
     * task tables to this single database. For MySQL endpoints, you specify the database only when
     * you specify the schema in the table-mapping rules of the DMS task.
     */
    suspend fun modifyEndpoint(input: ModifyEndpointRequest): ModifyEndpointResponse

    /**
     * Modifies the specified endpoint.
     * For a MySQL source or target endpoint, don't explicitly specify the database using
     * the DatabaseName request parameter on the ModifyEndpoint API call.
     * Specifying DatabaseName when you modify a MySQL endpoint replicates all the
     * task tables to this single database. For MySQL endpoints, you specify the database only when
     * you specify the schema in the table-mapping rules of the DMS task.
     */
    suspend fun modifyEndpoint(block: ModifyEndpointRequest.Builder.() -> Unit) = modifyEndpoint(ModifyEndpointRequest.Builder().apply(block).build())

    /**
     * Modifies an existing DMS event notification subscription.
     */
    suspend fun modifyEventSubscription(input: ModifyEventSubscriptionRequest): ModifyEventSubscriptionResponse

    /**
     * Modifies an existing DMS event notification subscription.
     */
    suspend fun modifyEventSubscription(block: ModifyEventSubscriptionRequest.Builder.() -> Unit) = modifyEventSubscription(ModifyEventSubscriptionRequest.Builder().apply(block).build())

    /**
     * Modifies the replication instance to apply new settings. You can change one or more
     * parameters by specifying these parameters and the new values in the request.
     * Some settings are applied during the maintenance window.
     */
    suspend fun modifyReplicationInstance(input: ModifyReplicationInstanceRequest): ModifyReplicationInstanceResponse

    /**
     * Modifies the replication instance to apply new settings. You can change one or more
     * parameters by specifying these parameters and the new values in the request.
     * Some settings are applied during the maintenance window.
     */
    suspend fun modifyReplicationInstance(block: ModifyReplicationInstanceRequest.Builder.() -> Unit) = modifyReplicationInstance(ModifyReplicationInstanceRequest.Builder().apply(block).build())

    /**
     * Modifies the settings for the specified replication subnet group.
     */
    suspend fun modifyReplicationSubnetGroup(input: ModifyReplicationSubnetGroupRequest): ModifyReplicationSubnetGroupResponse

    /**
     * Modifies the settings for the specified replication subnet group.
     */
    suspend fun modifyReplicationSubnetGroup(block: ModifyReplicationSubnetGroupRequest.Builder.() -> Unit) = modifyReplicationSubnetGroup(ModifyReplicationSubnetGroupRequest.Builder().apply(block).build())

    /**
     * Modifies the specified replication task.
     * You can't modify the task endpoints. The task must be stopped before you can modify it.
     * For more information about DMS tasks, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html">Working with Migration Tasks in the
     * Database Migration Service User Guide.
     */
    suspend fun modifyReplicationTask(input: ModifyReplicationTaskRequest): ModifyReplicationTaskResponse

    /**
     * Modifies the specified replication task.
     * You can't modify the task endpoints. The task must be stopped before you can modify it.
     * For more information about DMS tasks, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html">Working with Migration Tasks in the
     * Database Migration Service User Guide.
     */
    suspend fun modifyReplicationTask(block: ModifyReplicationTaskRequest.Builder.() -> Unit) = modifyReplicationTask(ModifyReplicationTaskRequest.Builder().apply(block).build())

    /**
     * Moves a replication task from its current replication instance to a different target
     * replication instance using the specified parameters. The target replication instance must
     * be created with the same or later DMS version as the current replication
     * instance.
     */
    suspend fun moveReplicationTask(input: MoveReplicationTaskRequest): MoveReplicationTaskResponse

    /**
     * Moves a replication task from its current replication instance to a different target
     * replication instance using the specified parameters. The target replication instance must
     * be created with the same or later DMS version as the current replication
     * instance.
     */
    suspend fun moveReplicationTask(block: MoveReplicationTaskRequest.Builder.() -> Unit) = moveReplicationTask(MoveReplicationTaskRequest.Builder().apply(block).build())

    /**
     * Reboots a replication instance. Rebooting results in a momentary outage, until the
     * replication instance becomes available again.
     */
    suspend fun rebootReplicationInstance(input: RebootReplicationInstanceRequest): RebootReplicationInstanceResponse

    /**
     * Reboots a replication instance. Rebooting results in a momentary outage, until the
     * replication instance becomes available again.
     */
    suspend fun rebootReplicationInstance(block: RebootReplicationInstanceRequest.Builder.() -> Unit) = rebootReplicationInstance(RebootReplicationInstanceRequest.Builder().apply(block).build())

    /**
     * Populates the schema for the specified endpoint. This is an asynchronous operation and
     * can take several minutes. You can check the status of this operation by calling the
     * DescribeRefreshSchemasStatus operation.
     */
    suspend fun refreshSchemas(input: RefreshSchemasRequest): RefreshSchemasResponse

    /**
     * Populates the schema for the specified endpoint. This is an asynchronous operation and
     * can take several minutes. You can check the status of this operation by calling the
     * DescribeRefreshSchemasStatus operation.
     */
    suspend fun refreshSchemas(block: RefreshSchemasRequest.Builder.() -> Unit) = refreshSchemas(RefreshSchemasRequest.Builder().apply(block).build())

    /**
     * Reloads the target database table with the source data.
     * You can only use this operation with a task in the RUNNING state, otherwise the service
     * will throw an InvalidResourceStateFault exception.
     */
    suspend fun reloadTables(input: ReloadTablesRequest): ReloadTablesResponse

    /**
     * Reloads the target database table with the source data.
     * You can only use this operation with a task in the RUNNING state, otherwise the service
     * will throw an InvalidResourceStateFault exception.
     */
    suspend fun reloadTables(block: ReloadTablesRequest.Builder.() -> Unit) = reloadTables(ReloadTablesRequest.Builder().apply(block).build())

    /**
     * Removes metadata tags from an DMS resource, including replication instance,
     * endpoint, security group, and migration task. For more information, see
     * <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html">
     * Tag
     * data type description.
     */
    suspend fun removeTagsFromResource(input: RemoveTagsFromResourceRequest): RemoveTagsFromResourceResponse

    /**
     * Removes metadata tags from an DMS resource, including replication instance,
     * endpoint, security group, and migration task. For more information, see
     * <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html">
     * Tag
     * data type description.
     */
    suspend fun removeTagsFromResource(block: RemoveTagsFromResourceRequest.Builder.() -> Unit) = removeTagsFromResource(RemoveTagsFromResourceRequest.Builder().apply(block).build())

    /**
     * Starts the replication task.
     * For more information about DMS tasks, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html">Working with Migration Tasks  in the
     * Database Migration Service User Guide.
     */
    suspend fun startReplicationTask(input: StartReplicationTaskRequest): StartReplicationTaskResponse

    /**
     * Starts the replication task.
     * For more information about DMS tasks, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html">Working with Migration Tasks  in the
     * Database Migration Service User Guide.
     */
    suspend fun startReplicationTask(block: StartReplicationTaskRequest.Builder.() -> Unit) = startReplicationTask(StartReplicationTaskRequest.Builder().apply(block).build())

    /**
     * Starts the replication task assessment for unsupported data types in the source
     * database.
     */
    suspend fun startReplicationTaskAssessment(input: StartReplicationTaskAssessmentRequest): StartReplicationTaskAssessmentResponse

    /**
     * Starts the replication task assessment for unsupported data types in the source
     * database.
     */
    suspend fun startReplicationTaskAssessment(block: StartReplicationTaskAssessmentRequest.Builder.() -> Unit) = startReplicationTaskAssessment(StartReplicationTaskAssessmentRequest.Builder().apply(block).build())

    /**
     * Starts a new premigration assessment run for one or more individual assessments
     * of a migration task.
     * The assessments that you can specify depend on the source and target database engine and
     * the migration type defined for the given task. To run this operation, your migration task
     * must already be created. After you run this operation, you can review the status of each
     * individual assessment. You can also run the migration task manually after the assessment
     * run and its individual assessments complete.
     */
    suspend fun startReplicationTaskAssessmentRun(input: StartReplicationTaskAssessmentRunRequest): StartReplicationTaskAssessmentRunResponse

    /**
     * Starts a new premigration assessment run for one or more individual assessments
     * of a migration task.
     * The assessments that you can specify depend on the source and target database engine and
     * the migration type defined for the given task. To run this operation, your migration task
     * must already be created. After you run this operation, you can review the status of each
     * individual assessment. You can also run the migration task manually after the assessment
     * run and its individual assessments complete.
     */
    suspend fun startReplicationTaskAssessmentRun(block: StartReplicationTaskAssessmentRunRequest.Builder.() -> Unit) = startReplicationTaskAssessmentRun(StartReplicationTaskAssessmentRunRequest.Builder().apply(block).build())

    /**
     * Stops the replication task.
     */
    suspend fun stopReplicationTask(input: StopReplicationTaskRequest): StopReplicationTaskResponse

    /**
     * Stops the replication task.
     */
    suspend fun stopReplicationTask(block: StopReplicationTaskRequest.Builder.() -> Unit) = stopReplicationTask(StopReplicationTaskRequest.Builder().apply(block).build())

    /**
     * Tests the connection between the replication instance and the endpoint.
     */
    suspend fun testConnection(input: TestConnectionRequest): TestConnectionResponse

    /**
     * Tests the connection between the replication instance and the endpoint.
     */
    suspend fun testConnection(block: TestConnectionRequest.Builder.() -> Unit) = testConnection(TestConnectionRequest.Builder().apply(block).build())
}
