// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.transform

import aws.sdk.kotlin.services.databasemigrationservice.model.DatabaseMigrationException
import aws.sdk.kotlin.services.databasemigrationservice.model.UpdateSubscriptionsToEventBridgeResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateSubscriptionsToEventBridgeOperationDeserializer: HttpDeserialize<UpdateSubscriptionsToEventBridgeResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateSubscriptionsToEventBridgeResponse {
        if (!response.status.isSuccess()) {
            throwUpdateSubscriptionsToEventBridgeError(context, response)
        }
        val builder = UpdateSubscriptionsToEventBridgeResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateSubscriptionsToEventBridgeOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateSubscriptionsToEventBridgeError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DatabaseMigrationException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedFault" -> AccessDeniedFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidResourceStateFault" -> InvalidResourceStateFaultDeserializer().deserialize(context, wrappedResponse)
        else -> DatabaseMigrationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateSubscriptionsToEventBridgeOperationBody(builder: UpdateSubscriptionsToEventBridgeResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val RESULT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Result"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(RESULT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                RESULT_DESCRIPTOR.index -> builder.result = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
