// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.transform

import aws.sdk.kotlin.services.databasemigrationservice.model.DatabaseMigrationException
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeOrderableReplicationInstancesResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.OrderableReplicationInstance
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeOrderableReplicationInstancesOperationDeserializer: HttpDeserialize<DescribeOrderableReplicationInstancesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeOrderableReplicationInstancesResponse {
        if (!response.status.isSuccess()) {
            throwDescribeOrderableReplicationInstancesError(context, response)
        }
        val builder = DescribeOrderableReplicationInstancesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeOrderableReplicationInstancesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeOrderableReplicationInstancesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DatabaseMigrationException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> DatabaseMigrationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeOrderableReplicationInstancesOperationBody(builder: DescribeOrderableReplicationInstancesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val MARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Marker"))
    val ORDERABLEREPLICATIONINSTANCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("OrderableReplicationInstances"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MARKER_DESCRIPTOR)
        field(ORDERABLEREPLICATIONINSTANCES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MARKER_DESCRIPTOR.index -> builder.marker = deserializeString()
                ORDERABLEREPLICATIONINSTANCES_DESCRIPTOR.index -> builder.orderableReplicationInstances =
                    deserializer.deserializeList(ORDERABLEREPLICATIONINSTANCES_DESCRIPTOR) {
                        val col0 = mutableListOf<OrderableReplicationInstance>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeOrderableReplicationInstanceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
