// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.transform

import aws.sdk.kotlin.services.databasemigrationservice.model.DatabaseMigrationException
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeEventCategoriesResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.EventCategoryGroup
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeEventCategoriesOperationDeserializer: HttpDeserialize<DescribeEventCategoriesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeEventCategoriesResponse {
        if (!response.status.isSuccess()) {
            throwDescribeEventCategoriesError(context, response)
        }
        val builder = DescribeEventCategoriesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeEventCategoriesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeEventCategoriesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DatabaseMigrationException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> DatabaseMigrationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeEventCategoriesOperationBody(builder: DescribeEventCategoriesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val EVENTCATEGORYGROUPLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("EventCategoryGroupList"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EVENTCATEGORYGROUPLIST_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                EVENTCATEGORYGROUPLIST_DESCRIPTOR.index -> builder.eventCategoryGroupList =
                    deserializer.deserializeList(EVENTCATEGORYGROUPLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<EventCategoryGroup>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeEventCategoryGroupDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
