// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.transform

import aws.sdk.kotlin.services.databasemigrationservice.model.DatabaseMigrationException
import aws.sdk.kotlin.services.databasemigrationservice.model.DeleteReplicationInstanceResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationInstance
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteReplicationInstanceOperationDeserializer: HttpDeserialize<DeleteReplicationInstanceResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteReplicationInstanceResponse {
        if (!response.status.isSuccess()) {
            throwDeleteReplicationInstanceError(context, response)
        }
        val builder = DeleteReplicationInstanceResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteReplicationInstanceOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDeleteReplicationInstanceError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DatabaseMigrationException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidResourceStateFault" -> InvalidResourceStateFaultDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundFault" -> ResourceNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        else -> DatabaseMigrationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteReplicationInstanceOperationBody(builder: DeleteReplicationInstanceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val REPLICATIONINSTANCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ReplicationInstance"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(REPLICATIONINSTANCE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                REPLICATIONINSTANCE_DESCRIPTOR.index -> builder.replicationInstance = deserializeReplicationInstanceDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
