// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.transform

import aws.sdk.kotlin.services.databasemigrationservice.model.AddTagsToResourceResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DatabaseMigrationException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class AddTagsToResourceOperationDeserializer: HttpDeserialize<AddTagsToResourceResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): AddTagsToResourceResponse {
        if (!response.status.isSuccess()) {
            throwAddTagsToResourceError(context, response)
        }
        val builder = AddTagsToResourceResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwAddTagsToResourceError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DatabaseMigrationException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundFault" -> ResourceNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        else -> DatabaseMigrationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
