// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 *
 */
public class StartReplicationTaskRequest private constructor(builder: Builder) {
    /**
     * Indicates when you want a change data capture (CDC) operation to start. Use either CdcStartPosition or CdcStartTime to specify when you want a CDC operation to start. Specifying both values results in an error.
     *
     *  The value can be in date, checkpoint, or LSN/SCN format.
     *
     * Date Example: --cdc-start-position “2018-03-08T12:12:12”
     *
     * Checkpoint Example: --cdc-start-position "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"
     *
     * LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”
     *
     * When you use this task setting with a source PostgreSQL database, a logical replication slot should already be created and associated with the source endpoint. You can verify this by setting the `slotName` extra connection attribute to the name of this logical replication slot. For more information, see [Extra Connection Attributes When Using PostgreSQL as a Source for DMS](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib).
     */
    public val cdcStartPosition: kotlin.String? = builder.cdcStartPosition
    /**
     * Indicates the start time for a change data capture (CDC) operation. Use either CdcStartTime or CdcStartPosition to specify when you want a CDC operation to start. Specifying both values results in an error.
     *
     * Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”
     */
    public val cdcStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.cdcStartTime
    /**
     * Indicates when you want a change data capture (CDC) operation to stop. The value can be either server time or commit time.
     *
     * Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”
     *
     * Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12“
     */
    public val cdcStopPosition: kotlin.String? = builder.cdcStopPosition
    /**
     * The Amazon Resource Name (ARN) of the replication task to be started.
     */
    public val replicationTaskArn: kotlin.String? = builder.replicationTaskArn
    /**
     * The type of replication task to start.
     *
     * When the migration type is `full-load` or `full-load-and-cdc`, the only valid value for the first run of the task is `start-replication`. This option will start the migration.
     *
     * You can also use ReloadTables to reload specific tables that failed during migration instead of restarting the task.
     *
     * The `resume-processing` option isn't applicable for a full-load task, because you can't resume partially loaded tables during the full load phase.
     *
     * For a `full-load-and-cdc` task, DMS migrates table data, and then applies data changes that occur on the source. To load all the tables again, and start capturing source changes, use `reload-target`. Otherwise use `resume-processing`, to replicate the changes from the last stop position.
     */
    public val startReplicationTaskType: aws.sdk.kotlin.services.databasemigrationservice.model.StartReplicationTaskTypeValue? = builder.startReplicationTaskType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.StartReplicationTaskRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartReplicationTaskRequest(")
        append("cdcStartPosition=$cdcStartPosition,")
        append("cdcStartTime=$cdcStartTime,")
        append("cdcStopPosition=$cdcStopPosition,")
        append("replicationTaskArn=$replicationTaskArn,")
        append("startReplicationTaskType=$startReplicationTaskType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cdcStartPosition?.hashCode() ?: 0
        result = 31 * result + (cdcStartTime?.hashCode() ?: 0)
        result = 31 * result + (cdcStopPosition?.hashCode() ?: 0)
        result = 31 * result + (replicationTaskArn?.hashCode() ?: 0)
        result = 31 * result + (startReplicationTaskType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartReplicationTaskRequest

        if (cdcStartPosition != other.cdcStartPosition) return false
        if (cdcStartTime != other.cdcStartTime) return false
        if (cdcStopPosition != other.cdcStopPosition) return false
        if (replicationTaskArn != other.replicationTaskArn) return false
        if (startReplicationTaskType != other.startReplicationTaskType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.StartReplicationTaskRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates when you want a change data capture (CDC) operation to start. Use either CdcStartPosition or CdcStartTime to specify when you want a CDC operation to start. Specifying both values results in an error.
         *
         *  The value can be in date, checkpoint, or LSN/SCN format.
         *
         * Date Example: --cdc-start-position “2018-03-08T12:12:12”
         *
         * Checkpoint Example: --cdc-start-position "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"
         *
         * LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”
         *
         * When you use this task setting with a source PostgreSQL database, a logical replication slot should already be created and associated with the source endpoint. You can verify this by setting the `slotName` extra connection attribute to the name of this logical replication slot. For more information, see [Extra Connection Attributes When Using PostgreSQL as a Source for DMS](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib).
         */
        public var cdcStartPosition: kotlin.String? = null
        /**
         * Indicates the start time for a change data capture (CDC) operation. Use either CdcStartTime or CdcStartPosition to specify when you want a CDC operation to start. Specifying both values results in an error.
         *
         * Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”
         */
        public var cdcStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Indicates when you want a change data capture (CDC) operation to stop. The value can be either server time or commit time.
         *
         * Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”
         *
         * Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12“
         */
        public var cdcStopPosition: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the replication task to be started.
         */
        public var replicationTaskArn: kotlin.String? = null
        /**
         * The type of replication task to start.
         *
         * When the migration type is `full-load` or `full-load-and-cdc`, the only valid value for the first run of the task is `start-replication`. This option will start the migration.
         *
         * You can also use ReloadTables to reload specific tables that failed during migration instead of restarting the task.
         *
         * The `resume-processing` option isn't applicable for a full-load task, because you can't resume partially loaded tables during the full load phase.
         *
         * For a `full-load-and-cdc` task, DMS migrates table data, and then applies data changes that occur on the source. To load all the tables again, and start capturing source changes, use `reload-target`. Otherwise use `resume-processing`, to replicate the changes from the last stop position.
         */
        public var startReplicationTaskType: aws.sdk.kotlin.services.databasemigrationservice.model.StartReplicationTaskTypeValue? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.StartReplicationTaskRequest) : this() {
            this.cdcStartPosition = x.cdcStartPosition
            this.cdcStartTime = x.cdcStartTime
            this.cdcStopPosition = x.cdcStopPosition
            this.replicationTaskArn = x.replicationTaskArn
            this.startReplicationTaskType = x.startReplicationTaskType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.StartReplicationTaskRequest = StartReplicationTaskRequest(this)
    }
}
