// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model



/**
 * Provides information that defines an Amazon Redshift endpoint.
 */
public class RedshiftSettings private constructor(builder: Builder) {
    /**
     * A value that indicates to allow any date format, including invalid formats such as 00/00/00 00:00:00, to be loaded without generating an error. You can choose `true` or `false` (the default).
     *
     * This parameter applies only to TIMESTAMP and DATE columns. Always use ACCEPTANYDATE with the DATEFORMAT parameter. If the date format for the data doesn't match the DATEFORMAT specification, Amazon Redshift inserts a NULL value into that field.
     */
    public val acceptAnyDate: kotlin.Boolean? = builder.acceptAnyDate
    /**
     * Code to run after connecting. This parameter should contain the code itself, not the name of a file containing the code.
     */
    public val afterConnectScript: kotlin.String? = builder.afterConnectScript
    /**
     * An S3 folder where the comma-separated-value (.csv) files are stored before being uploaded to the target Redshift cluster.
     *
     * For full load mode, DMS converts source records into .csv files and loads them to the *BucketFolder/TableID* path. DMS uses the Redshift `COPY` command to upload the .csv files to the target table. The files are deleted once the `COPY` operation has finished. For more information, see [COPY](https://docs.aws.amazon.com/redshift/latest/dg/r_COPY.html) in the *Amazon Redshift Database Developer Guide*.
     *
     * For change-data-capture (CDC) mode, DMS creates a *NetChanges* table, and loads the .csv files to this *BucketFolder/NetChangesTableID* path.
     */
    public val bucketFolder: kotlin.String? = builder.bucketFolder
    /**
     * The name of the intermediate S3 bucket used to store .csv files before uploading data to Redshift.
     */
    public val bucketName: kotlin.String? = builder.bucketName
    /**
     * If Amazon Redshift is configured to support case sensitive schema names, set `CaseSensitiveNames` to `true`. The default is `false`.
     */
    public val caseSensitiveNames: kotlin.Boolean? = builder.caseSensitiveNames
    /**
     * If you set `CompUpdate` to `true` Amazon Redshift applies automatic compression if the table is empty. This applies even if the table columns already have encodings other than `RAW`. If you set `CompUpdate` to `false`, automatic compression is disabled and existing column encodings aren't changed. The default is `true`.
     */
    public val compUpdate: kotlin.Boolean? = builder.compUpdate
    /**
     * A value that sets the amount of time to wait (in milliseconds) before timing out, beginning from when you initially establish a connection.
     */
    public val connectionTimeout: kotlin.Int? = builder.connectionTimeout
    /**
     * The name of the Amazon Redshift data warehouse (service) that you are working with.
     */
    public val databaseName: kotlin.String? = builder.databaseName
    /**
     * The date format that you are using. Valid values are `auto` (case-sensitive), your date format string enclosed in quotes, or NULL. If this parameter is left unset (NULL), it defaults to a format of 'YYYY-MM-DD'. Using `auto` recognizes most strings, even some that aren't supported when you use a date format string.
     *
     * If your date and time values use formats different from each other, set this to `auto`.
     */
    public val dateFormat: kotlin.String? = builder.dateFormat
    /**
     * A value that specifies whether DMS should migrate empty CHAR and VARCHAR fields as NULL. A value of `true` sets empty CHAR and VARCHAR fields to null. The default is `false`.
     */
    public val emptyAsNull: kotlin.Boolean? = builder.emptyAsNull
    /**
     * The type of server-side encryption that you want to use for your data. This encryption type is part of the endpoint settings or the extra connections attributes for Amazon S3. You can choose either `SSE_S3` (the default) or `SSE_KMS`.
     *
     * For the `ModifyEndpoint` operation, you can change the existing value of the `EncryptionMode` parameter from `SSE_KMS` to `SSE_S3`. But you can’t change the existing value from `SSE_S3` to `SSE_KMS`.
     *
     * To use `SSE_S3`, create an Identity and Access Management (IAM) role with a policy that allows `"arn:aws:s3:::*"` to use the following actions: `"s3:PutObject", "s3:ListBucket"`
     */
    public val encryptionMode: aws.sdk.kotlin.services.databasemigrationservice.model.EncryptionModeValue? = builder.encryptionMode
    /**
     * This setting is only valid for a full-load migration task. Set `ExplicitIds` to `true` to have tables with `IDENTITY` columns override their auto-generated values with explicit values loaded from the source data files used to populate the tables. The default is `false`.
     */
    public val explicitIds: kotlin.Boolean? = builder.explicitIds
    /**
     * The number of threads used to upload a single file. This parameter accepts a value from 1 through 64. It defaults to 10.
     *
     * The number of parallel streams used to upload a single .csv file to an S3 bucket using S3 Multipart Upload. For more information, see [Multipart upload overview](https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html).
     *
     * `FileTransferUploadStreams` accepts a value from 1 through 64. It defaults to 10.
     */
    public val fileTransferUploadStreams: kotlin.Int? = builder.fileTransferUploadStreams
    /**
     * The amount of time to wait (in milliseconds) before timing out of operations performed by DMS on a Redshift cluster, such as Redshift COPY, INSERT, DELETE, and UPDATE.
     */
    public val loadTimeout: kotlin.Int? = builder.loadTimeout
    /**
     * When true, lets Redshift migrate the boolean type as boolean. By default, Redshift migrates booleans as `varchar(1)`.
     */
    public val mapBooleanAsBoolean: kotlin.Boolean? = builder.mapBooleanAsBoolean
    /**
     * The maximum size (in KB) of any .csv file used to load data on an S3 bucket and transfer data to Amazon Redshift. It defaults to 1048576KB (1 GB).
     */
    public val maxFileSize: kotlin.Int? = builder.maxFileSize
    /**
     * The password for the user named in the `username` property.
     */
    public val password: kotlin.String? = builder.password
    /**
     * The port number for Amazon Redshift. The default value is 5439.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * A value that specifies to remove surrounding quotation marks from strings in the incoming data. All characters within the quotation marks, including delimiters, are retained. Choose `true` to remove quotation marks. The default is `false`.
     */
    public val removeQuotes: kotlin.Boolean? = builder.removeQuotes
    /**
     * A value that specifies to replaces the invalid characters specified in `ReplaceInvalidChars`, substituting the specified characters instead. The default is `"?"`.
     */
    public val replaceChars: kotlin.String? = builder.replaceChars
    /**
     * A list of characters that you want to replace. Use with `ReplaceChars`.
     */
    public val replaceInvalidChars: kotlin.String? = builder.replaceInvalidChars
    /**
     * The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the trusted entity and grants the required permissions to access the value in `SecretsManagerSecret`. The role must allow the `iam:PassRole` action. `SecretsManagerSecret` has the value of the Amazon Web Services Secrets Manager secret that allows access to the Amazon Redshift endpoint.
     *
     * You can specify one of two sets of values for these permissions. You can specify the values for this setting and `SecretsManagerSecretId`. Or you can specify clear-text values for `UserName`, `Password`, `ServerName`, and `Port`. You can't specify both. For more information on creating this `SecretsManagerSecret` and the `SecretsManagerAccessRoleArn` and `SecretsManagerSecretId` required to access it, see [Using secrets to access Database Migration Service resources](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager) in the *Database Migration Service User Guide*.
     */
    public val secretsManagerAccessRoleArn: kotlin.String? = builder.secretsManagerAccessRoleArn
    /**
     * The full ARN, partial ARN, or friendly name of the `SecretsManagerSecret` that contains the Amazon Redshift endpoint connection details.
     */
    public val secretsManagerSecretId: kotlin.String? = builder.secretsManagerSecretId
    /**
     * The name of the Amazon Redshift cluster you are using.
     */
    public val serverName: kotlin.String? = builder.serverName
    /**
     * The KMS key ID. If you are using `SSE_KMS` for the `EncryptionMode`, provide this key ID. The key that you use needs an attached policy that enables IAM user permissions and allows use of the key.
     */
    public val serverSideEncryptionKmsKeyId: kotlin.String? = builder.serverSideEncryptionKmsKeyId
    /**
     * The Amazon Resource Name (ARN) of the IAM role that has access to the Amazon Redshift service. The role must allow the `iam:PassRole` action.
     */
    public val serviceAccessRoleArn: kotlin.String? = builder.serviceAccessRoleArn
    /**
     * The time format that you want to use. Valid values are `auto` (case-sensitive), `'timeformat_string'`, `'epochsecs'`, or `'epochmillisecs'`. It defaults to 10. Using `auto` recognizes most strings, even some that aren't supported when you use a time format string.
     *
     * If your date and time values use formats different from each other, set this parameter to `auto`.
     */
    public val timeFormat: kotlin.String? = builder.timeFormat
    /**
     * A value that specifies to remove the trailing white space characters from a VARCHAR string. This parameter applies only to columns with a VARCHAR data type. Choose `true` to remove unneeded white space. The default is `false`.
     */
    public val trimBlanks: kotlin.Boolean? = builder.trimBlanks
    /**
     * A value that specifies to truncate data in columns to the appropriate number of characters, so that the data fits in the column. This parameter applies only to columns with a VARCHAR or CHAR data type, and rows with a size of 4 MB or less. Choose `true` to truncate data. The default is `false`.
     */
    public val truncateColumns: kotlin.Boolean? = builder.truncateColumns
    /**
     * An Amazon Redshift user name for a registered user.
     */
    public val username: kotlin.String? = builder.username
    /**
     * The size (in KB) of the in-memory file write buffer used when generating .csv files on the local disk at the DMS replication instance. The default value is 1000 (buffer size is 1000KB).
     */
    public val writeBufferSize: kotlin.Int? = builder.writeBufferSize

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.RedshiftSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RedshiftSettings(")
        append("acceptAnyDate=$acceptAnyDate,")
        append("afterConnectScript=$afterConnectScript,")
        append("bucketFolder=$bucketFolder,")
        append("bucketName=$bucketName,")
        append("caseSensitiveNames=$caseSensitiveNames,")
        append("compUpdate=$compUpdate,")
        append("connectionTimeout=$connectionTimeout,")
        append("databaseName=$databaseName,")
        append("dateFormat=$dateFormat,")
        append("emptyAsNull=$emptyAsNull,")
        append("encryptionMode=$encryptionMode,")
        append("explicitIds=$explicitIds,")
        append("fileTransferUploadStreams=$fileTransferUploadStreams,")
        append("loadTimeout=$loadTimeout,")
        append("mapBooleanAsBoolean=$mapBooleanAsBoolean,")
        append("maxFileSize=$maxFileSize,")
        append("password=*** Sensitive Data Redacted ***,")
        append("port=$port,")
        append("removeQuotes=$removeQuotes,")
        append("replaceChars=$replaceChars,")
        append("replaceInvalidChars=$replaceInvalidChars,")
        append("secretsManagerAccessRoleArn=$secretsManagerAccessRoleArn,")
        append("secretsManagerSecretId=$secretsManagerSecretId,")
        append("serverName=$serverName,")
        append("serverSideEncryptionKmsKeyId=$serverSideEncryptionKmsKeyId,")
        append("serviceAccessRoleArn=$serviceAccessRoleArn,")
        append("timeFormat=$timeFormat,")
        append("trimBlanks=$trimBlanks,")
        append("truncateColumns=$truncateColumns,")
        append("username=$username,")
        append("writeBufferSize=$writeBufferSize")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceptAnyDate?.hashCode() ?: 0
        result = 31 * result + (afterConnectScript?.hashCode() ?: 0)
        result = 31 * result + (bucketFolder?.hashCode() ?: 0)
        result = 31 * result + (bucketName?.hashCode() ?: 0)
        result = 31 * result + (caseSensitiveNames?.hashCode() ?: 0)
        result = 31 * result + (compUpdate?.hashCode() ?: 0)
        result = 31 * result + (connectionTimeout ?: 0)
        result = 31 * result + (databaseName?.hashCode() ?: 0)
        result = 31 * result + (dateFormat?.hashCode() ?: 0)
        result = 31 * result + (emptyAsNull?.hashCode() ?: 0)
        result = 31 * result + (encryptionMode?.hashCode() ?: 0)
        result = 31 * result + (explicitIds?.hashCode() ?: 0)
        result = 31 * result + (fileTransferUploadStreams ?: 0)
        result = 31 * result + (loadTimeout ?: 0)
        result = 31 * result + (mapBooleanAsBoolean?.hashCode() ?: 0)
        result = 31 * result + (maxFileSize ?: 0)
        result = 31 * result + (password?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (removeQuotes?.hashCode() ?: 0)
        result = 31 * result + (replaceChars?.hashCode() ?: 0)
        result = 31 * result + (replaceInvalidChars?.hashCode() ?: 0)
        result = 31 * result + (secretsManagerAccessRoleArn?.hashCode() ?: 0)
        result = 31 * result + (secretsManagerSecretId?.hashCode() ?: 0)
        result = 31 * result + (serverName?.hashCode() ?: 0)
        result = 31 * result + (serverSideEncryptionKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (serviceAccessRoleArn?.hashCode() ?: 0)
        result = 31 * result + (timeFormat?.hashCode() ?: 0)
        result = 31 * result + (trimBlanks?.hashCode() ?: 0)
        result = 31 * result + (truncateColumns?.hashCode() ?: 0)
        result = 31 * result + (username?.hashCode() ?: 0)
        result = 31 * result + (writeBufferSize ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RedshiftSettings

        if (acceptAnyDate != other.acceptAnyDate) return false
        if (afterConnectScript != other.afterConnectScript) return false
        if (bucketFolder != other.bucketFolder) return false
        if (bucketName != other.bucketName) return false
        if (caseSensitiveNames != other.caseSensitiveNames) return false
        if (compUpdate != other.compUpdate) return false
        if (connectionTimeout != other.connectionTimeout) return false
        if (databaseName != other.databaseName) return false
        if (dateFormat != other.dateFormat) return false
        if (emptyAsNull != other.emptyAsNull) return false
        if (encryptionMode != other.encryptionMode) return false
        if (explicitIds != other.explicitIds) return false
        if (fileTransferUploadStreams != other.fileTransferUploadStreams) return false
        if (loadTimeout != other.loadTimeout) return false
        if (mapBooleanAsBoolean != other.mapBooleanAsBoolean) return false
        if (maxFileSize != other.maxFileSize) return false
        if (password != other.password) return false
        if (port != other.port) return false
        if (removeQuotes != other.removeQuotes) return false
        if (replaceChars != other.replaceChars) return false
        if (replaceInvalidChars != other.replaceInvalidChars) return false
        if (secretsManagerAccessRoleArn != other.secretsManagerAccessRoleArn) return false
        if (secretsManagerSecretId != other.secretsManagerSecretId) return false
        if (serverName != other.serverName) return false
        if (serverSideEncryptionKmsKeyId != other.serverSideEncryptionKmsKeyId) return false
        if (serviceAccessRoleArn != other.serviceAccessRoleArn) return false
        if (timeFormat != other.timeFormat) return false
        if (trimBlanks != other.trimBlanks) return false
        if (truncateColumns != other.truncateColumns) return false
        if (username != other.username) return false
        if (writeBufferSize != other.writeBufferSize) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.RedshiftSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A value that indicates to allow any date format, including invalid formats such as 00/00/00 00:00:00, to be loaded without generating an error. You can choose `true` or `false` (the default).
         *
         * This parameter applies only to TIMESTAMP and DATE columns. Always use ACCEPTANYDATE with the DATEFORMAT parameter. If the date format for the data doesn't match the DATEFORMAT specification, Amazon Redshift inserts a NULL value into that field.
         */
        public var acceptAnyDate: kotlin.Boolean? = null
        /**
         * Code to run after connecting. This parameter should contain the code itself, not the name of a file containing the code.
         */
        public var afterConnectScript: kotlin.String? = null
        /**
         * An S3 folder where the comma-separated-value (.csv) files are stored before being uploaded to the target Redshift cluster.
         *
         * For full load mode, DMS converts source records into .csv files and loads them to the *BucketFolder/TableID* path. DMS uses the Redshift `COPY` command to upload the .csv files to the target table. The files are deleted once the `COPY` operation has finished. For more information, see [COPY](https://docs.aws.amazon.com/redshift/latest/dg/r_COPY.html) in the *Amazon Redshift Database Developer Guide*.
         *
         * For change-data-capture (CDC) mode, DMS creates a *NetChanges* table, and loads the .csv files to this *BucketFolder/NetChangesTableID* path.
         */
        public var bucketFolder: kotlin.String? = null
        /**
         * The name of the intermediate S3 bucket used to store .csv files before uploading data to Redshift.
         */
        public var bucketName: kotlin.String? = null
        /**
         * If Amazon Redshift is configured to support case sensitive schema names, set `CaseSensitiveNames` to `true`. The default is `false`.
         */
        public var caseSensitiveNames: kotlin.Boolean? = null
        /**
         * If you set `CompUpdate` to `true` Amazon Redshift applies automatic compression if the table is empty. This applies even if the table columns already have encodings other than `RAW`. If you set `CompUpdate` to `false`, automatic compression is disabled and existing column encodings aren't changed. The default is `true`.
         */
        public var compUpdate: kotlin.Boolean? = null
        /**
         * A value that sets the amount of time to wait (in milliseconds) before timing out, beginning from when you initially establish a connection.
         */
        public var connectionTimeout: kotlin.Int? = null
        /**
         * The name of the Amazon Redshift data warehouse (service) that you are working with.
         */
        public var databaseName: kotlin.String? = null
        /**
         * The date format that you are using. Valid values are `auto` (case-sensitive), your date format string enclosed in quotes, or NULL. If this parameter is left unset (NULL), it defaults to a format of 'YYYY-MM-DD'. Using `auto` recognizes most strings, even some that aren't supported when you use a date format string.
         *
         * If your date and time values use formats different from each other, set this to `auto`.
         */
        public var dateFormat: kotlin.String? = null
        /**
         * A value that specifies whether DMS should migrate empty CHAR and VARCHAR fields as NULL. A value of `true` sets empty CHAR and VARCHAR fields to null. The default is `false`.
         */
        public var emptyAsNull: kotlin.Boolean? = null
        /**
         * The type of server-side encryption that you want to use for your data. This encryption type is part of the endpoint settings or the extra connections attributes for Amazon S3. You can choose either `SSE_S3` (the default) or `SSE_KMS`.
         *
         * For the `ModifyEndpoint` operation, you can change the existing value of the `EncryptionMode` parameter from `SSE_KMS` to `SSE_S3`. But you can’t change the existing value from `SSE_S3` to `SSE_KMS`.
         *
         * To use `SSE_S3`, create an Identity and Access Management (IAM) role with a policy that allows `"arn:aws:s3:::*"` to use the following actions: `"s3:PutObject", "s3:ListBucket"`
         */
        public var encryptionMode: aws.sdk.kotlin.services.databasemigrationservice.model.EncryptionModeValue? = null
        /**
         * This setting is only valid for a full-load migration task. Set `ExplicitIds` to `true` to have tables with `IDENTITY` columns override their auto-generated values with explicit values loaded from the source data files used to populate the tables. The default is `false`.
         */
        public var explicitIds: kotlin.Boolean? = null
        /**
         * The number of threads used to upload a single file. This parameter accepts a value from 1 through 64. It defaults to 10.
         *
         * The number of parallel streams used to upload a single .csv file to an S3 bucket using S3 Multipart Upload. For more information, see [Multipart upload overview](https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html).
         *
         * `FileTransferUploadStreams` accepts a value from 1 through 64. It defaults to 10.
         */
        public var fileTransferUploadStreams: kotlin.Int? = null
        /**
         * The amount of time to wait (in milliseconds) before timing out of operations performed by DMS on a Redshift cluster, such as Redshift COPY, INSERT, DELETE, and UPDATE.
         */
        public var loadTimeout: kotlin.Int? = null
        /**
         * When true, lets Redshift migrate the boolean type as boolean. By default, Redshift migrates booleans as `varchar(1)`.
         */
        public var mapBooleanAsBoolean: kotlin.Boolean? = null
        /**
         * The maximum size (in KB) of any .csv file used to load data on an S3 bucket and transfer data to Amazon Redshift. It defaults to 1048576KB (1 GB).
         */
        public var maxFileSize: kotlin.Int? = null
        /**
         * The password for the user named in the `username` property.
         */
        public var password: kotlin.String? = null
        /**
         * The port number for Amazon Redshift. The default value is 5439.
         */
        public var port: kotlin.Int? = null
        /**
         * A value that specifies to remove surrounding quotation marks from strings in the incoming data. All characters within the quotation marks, including delimiters, are retained. Choose `true` to remove quotation marks. The default is `false`.
         */
        public var removeQuotes: kotlin.Boolean? = null
        /**
         * A value that specifies to replaces the invalid characters specified in `ReplaceInvalidChars`, substituting the specified characters instead. The default is `"?"`.
         */
        public var replaceChars: kotlin.String? = null
        /**
         * A list of characters that you want to replace. Use with `ReplaceChars`.
         */
        public var replaceInvalidChars: kotlin.String? = null
        /**
         * The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the trusted entity and grants the required permissions to access the value in `SecretsManagerSecret`. The role must allow the `iam:PassRole` action. `SecretsManagerSecret` has the value of the Amazon Web Services Secrets Manager secret that allows access to the Amazon Redshift endpoint.
         *
         * You can specify one of two sets of values for these permissions. You can specify the values for this setting and `SecretsManagerSecretId`. Or you can specify clear-text values for `UserName`, `Password`, `ServerName`, and `Port`. You can't specify both. For more information on creating this `SecretsManagerSecret` and the `SecretsManagerAccessRoleArn` and `SecretsManagerSecretId` required to access it, see [Using secrets to access Database Migration Service resources](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager) in the *Database Migration Service User Guide*.
         */
        public var secretsManagerAccessRoleArn: kotlin.String? = null
        /**
         * The full ARN, partial ARN, or friendly name of the `SecretsManagerSecret` that contains the Amazon Redshift endpoint connection details.
         */
        public var secretsManagerSecretId: kotlin.String? = null
        /**
         * The name of the Amazon Redshift cluster you are using.
         */
        public var serverName: kotlin.String? = null
        /**
         * The KMS key ID. If you are using `SSE_KMS` for the `EncryptionMode`, provide this key ID. The key that you use needs an attached policy that enables IAM user permissions and allows use of the key.
         */
        public var serverSideEncryptionKmsKeyId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role that has access to the Amazon Redshift service. The role must allow the `iam:PassRole` action.
         */
        public var serviceAccessRoleArn: kotlin.String? = null
        /**
         * The time format that you want to use. Valid values are `auto` (case-sensitive), `'timeformat_string'`, `'epochsecs'`, or `'epochmillisecs'`. It defaults to 10. Using `auto` recognizes most strings, even some that aren't supported when you use a time format string.
         *
         * If your date and time values use formats different from each other, set this parameter to `auto`.
         */
        public var timeFormat: kotlin.String? = null
        /**
         * A value that specifies to remove the trailing white space characters from a VARCHAR string. This parameter applies only to columns with a VARCHAR data type. Choose `true` to remove unneeded white space. The default is `false`.
         */
        public var trimBlanks: kotlin.Boolean? = null
        /**
         * A value that specifies to truncate data in columns to the appropriate number of characters, so that the data fits in the column. This parameter applies only to columns with a VARCHAR or CHAR data type, and rows with a size of 4 MB or less. Choose `true` to truncate data. The default is `false`.
         */
        public var truncateColumns: kotlin.Boolean? = null
        /**
         * An Amazon Redshift user name for a registered user.
         */
        public var username: kotlin.String? = null
        /**
         * The size (in KB) of the in-memory file write buffer used when generating .csv files on the local disk at the DMS replication instance. The default value is 1000 (buffer size is 1000KB).
         */
        public var writeBufferSize: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.RedshiftSettings) : this() {
            this.acceptAnyDate = x.acceptAnyDate
            this.afterConnectScript = x.afterConnectScript
            this.bucketFolder = x.bucketFolder
            this.bucketName = x.bucketName
            this.caseSensitiveNames = x.caseSensitiveNames
            this.compUpdate = x.compUpdate
            this.connectionTimeout = x.connectionTimeout
            this.databaseName = x.databaseName
            this.dateFormat = x.dateFormat
            this.emptyAsNull = x.emptyAsNull
            this.encryptionMode = x.encryptionMode
            this.explicitIds = x.explicitIds
            this.fileTransferUploadStreams = x.fileTransferUploadStreams
            this.loadTimeout = x.loadTimeout
            this.mapBooleanAsBoolean = x.mapBooleanAsBoolean
            this.maxFileSize = x.maxFileSize
            this.password = x.password
            this.port = x.port
            this.removeQuotes = x.removeQuotes
            this.replaceChars = x.replaceChars
            this.replaceInvalidChars = x.replaceInvalidChars
            this.secretsManagerAccessRoleArn = x.secretsManagerAccessRoleArn
            this.secretsManagerSecretId = x.secretsManagerSecretId
            this.serverName = x.serverName
            this.serverSideEncryptionKmsKeyId = x.serverSideEncryptionKmsKeyId
            this.serviceAccessRoleArn = x.serviceAccessRoleArn
            this.timeFormat = x.timeFormat
            this.trimBlanks = x.trimBlanks
            this.truncateColumns = x.truncateColumns
            this.username = x.username
            this.writeBufferSize = x.writeBufferSize
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.RedshiftSettings = RedshiftSettings(this)
    }
}
