// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model



/**
 * Provides information that defines a MongoDB endpoint.
 */
public class MongoDbSettings private constructor(builder: Builder) {
    /**
     * The authentication mechanism you use to access the MongoDB source endpoint.
     *
     * For the default value, in MongoDB version 2.x, `"default"` is `"mongodb_cr"`. For MongoDB version 3.x or later, `"default"` is `"scram_sha_1"`. This setting isn't used when `AuthType` is set to `"no"`.
     */
    public val authMechanism: aws.sdk.kotlin.services.databasemigrationservice.model.AuthMechanismValue? = builder.authMechanism
    /**
     * The MongoDB database name. This setting isn't used when `AuthType` is set to `"no"`.
     *
     * The default is `"admin"`.
     */
    public val authSource: kotlin.String? = builder.authSource
    /**
     * The authentication type you use to access the MongoDB source endpoint.
     *
     * When when set to `"no"`, user name and password parameters are not used and can be empty.
     */
    public val authType: aws.sdk.kotlin.services.databasemigrationservice.model.AuthTypeValue? = builder.authType
    /**
     * The database name on the MongoDB source endpoint.
     */
    public val databaseName: kotlin.String? = builder.databaseName
    /**
     * Indicates the number of documents to preview to determine the document organization. Use this setting when `NestingLevel` is set to `"one"`.
     *
     * Must be a positive value greater than `0`. Default value is `1000`.
     */
    public val docsToInvestigate: kotlin.String? = builder.docsToInvestigate
    /**
     * Specifies the document ID. Use this setting when `NestingLevel` is set to `"none"`.
     *
     * Default value is `"false"`.
     */
    public val extractDocId: kotlin.String? = builder.extractDocId
    /**
     * The KMS key identifier that is used to encrypt the content on the replication instance. If you don't specify a value for the `KmsKeyId` parameter, then DMS uses your default encryption key. KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a different default encryption key for each Amazon Web Services Region.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Specifies either document or table mode.
     *
     * Default value is `"none"`. Specify `"none"` to use document mode. Specify `"one"` to use table mode.
     */
    public val nestingLevel: aws.sdk.kotlin.services.databasemigrationservice.model.NestingLevelValue? = builder.nestingLevel
    /**
     * The password for the user account you use to access the MongoDB source endpoint.
     */
    public val password: kotlin.String? = builder.password
    /**
     * The port value for the MongoDB source endpoint.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the trusted entity and grants the required permissions to access the value in `SecretsManagerSecret`. The role must allow the `iam:PassRole` action. `SecretsManagerSecret` has the value of the Amazon Web Services Secrets Manager secret that allows access to the MongoDB endpoint.
     *
     * You can specify one of two sets of values for these permissions. You can specify the values for this setting and `SecretsManagerSecretId`. Or you can specify clear-text values for `UserName`, `Password`, `ServerName`, and `Port`. You can't specify both. For more information on creating this `SecretsManagerSecret` and the `SecretsManagerAccessRoleArn` and `SecretsManagerSecretId` required to access it, see [Using secrets to access Database Migration Service resources](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager) in the *Database Migration Service User Guide*.
     */
    public val secretsManagerAccessRoleArn: kotlin.String? = builder.secretsManagerAccessRoleArn
    /**
     * The full ARN, partial ARN, or friendly name of the `SecretsManagerSecret` that contains the MongoDB endpoint connection details.
     */
    public val secretsManagerSecretId: kotlin.String? = builder.secretsManagerSecretId
    /**
     * The name of the server on the MongoDB source endpoint.
     */
    public val serverName: kotlin.String? = builder.serverName
    /**
     * The user name you use to access the MongoDB source endpoint.
     */
    public val username: kotlin.String? = builder.username

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.MongoDbSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MongoDbSettings(")
        append("authMechanism=$authMechanism,")
        append("authSource=$authSource,")
        append("authType=$authType,")
        append("databaseName=$databaseName,")
        append("docsToInvestigate=$docsToInvestigate,")
        append("extractDocId=$extractDocId,")
        append("kmsKeyId=$kmsKeyId,")
        append("nestingLevel=$nestingLevel,")
        append("password=*** Sensitive Data Redacted ***,")
        append("port=$port,")
        append("secretsManagerAccessRoleArn=$secretsManagerAccessRoleArn,")
        append("secretsManagerSecretId=$secretsManagerSecretId,")
        append("serverName=$serverName,")
        append("username=$username")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authMechanism?.hashCode() ?: 0
        result = 31 * result + (authSource?.hashCode() ?: 0)
        result = 31 * result + (authType?.hashCode() ?: 0)
        result = 31 * result + (databaseName?.hashCode() ?: 0)
        result = 31 * result + (docsToInvestigate?.hashCode() ?: 0)
        result = 31 * result + (extractDocId?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (nestingLevel?.hashCode() ?: 0)
        result = 31 * result + (password?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (secretsManagerAccessRoleArn?.hashCode() ?: 0)
        result = 31 * result + (secretsManagerSecretId?.hashCode() ?: 0)
        result = 31 * result + (serverName?.hashCode() ?: 0)
        result = 31 * result + (username?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MongoDbSettings

        if (authMechanism != other.authMechanism) return false
        if (authSource != other.authSource) return false
        if (authType != other.authType) return false
        if (databaseName != other.databaseName) return false
        if (docsToInvestigate != other.docsToInvestigate) return false
        if (extractDocId != other.extractDocId) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (nestingLevel != other.nestingLevel) return false
        if (password != other.password) return false
        if (port != other.port) return false
        if (secretsManagerAccessRoleArn != other.secretsManagerAccessRoleArn) return false
        if (secretsManagerSecretId != other.secretsManagerSecretId) return false
        if (serverName != other.serverName) return false
        if (username != other.username) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.MongoDbSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The authentication mechanism you use to access the MongoDB source endpoint.
         *
         * For the default value, in MongoDB version 2.x, `"default"` is `"mongodb_cr"`. For MongoDB version 3.x or later, `"default"` is `"scram_sha_1"`. This setting isn't used when `AuthType` is set to `"no"`.
         */
        public var authMechanism: aws.sdk.kotlin.services.databasemigrationservice.model.AuthMechanismValue? = null
        /**
         * The MongoDB database name. This setting isn't used when `AuthType` is set to `"no"`.
         *
         * The default is `"admin"`.
         */
        public var authSource: kotlin.String? = null
        /**
         * The authentication type you use to access the MongoDB source endpoint.
         *
         * When when set to `"no"`, user name and password parameters are not used and can be empty.
         */
        public var authType: aws.sdk.kotlin.services.databasemigrationservice.model.AuthTypeValue? = null
        /**
         * The database name on the MongoDB source endpoint.
         */
        public var databaseName: kotlin.String? = null
        /**
         * Indicates the number of documents to preview to determine the document organization. Use this setting when `NestingLevel` is set to `"one"`.
         *
         * Must be a positive value greater than `0`. Default value is `1000`.
         */
        public var docsToInvestigate: kotlin.String? = null
        /**
         * Specifies the document ID. Use this setting when `NestingLevel` is set to `"none"`.
         *
         * Default value is `"false"`.
         */
        public var extractDocId: kotlin.String? = null
        /**
         * The KMS key identifier that is used to encrypt the content on the replication instance. If you don't specify a value for the `KmsKeyId` parameter, then DMS uses your default encryption key. KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a different default encryption key for each Amazon Web Services Region.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Specifies either document or table mode.
         *
         * Default value is `"none"`. Specify `"none"` to use document mode. Specify `"one"` to use table mode.
         */
        public var nestingLevel: aws.sdk.kotlin.services.databasemigrationservice.model.NestingLevelValue? = null
        /**
         * The password for the user account you use to access the MongoDB source endpoint.
         */
        public var password: kotlin.String? = null
        /**
         * The port value for the MongoDB source endpoint.
         */
        public var port: kotlin.Int? = null
        /**
         * The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the trusted entity and grants the required permissions to access the value in `SecretsManagerSecret`. The role must allow the `iam:PassRole` action. `SecretsManagerSecret` has the value of the Amazon Web Services Secrets Manager secret that allows access to the MongoDB endpoint.
         *
         * You can specify one of two sets of values for these permissions. You can specify the values for this setting and `SecretsManagerSecretId`. Or you can specify clear-text values for `UserName`, `Password`, `ServerName`, and `Port`. You can't specify both. For more information on creating this `SecretsManagerSecret` and the `SecretsManagerAccessRoleArn` and `SecretsManagerSecretId` required to access it, see [Using secrets to access Database Migration Service resources](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager) in the *Database Migration Service User Guide*.
         */
        public var secretsManagerAccessRoleArn: kotlin.String? = null
        /**
         * The full ARN, partial ARN, or friendly name of the `SecretsManagerSecret` that contains the MongoDB endpoint connection details.
         */
        public var secretsManagerSecretId: kotlin.String? = null
        /**
         * The name of the server on the MongoDB source endpoint.
         */
        public var serverName: kotlin.String? = null
        /**
         * The user name you use to access the MongoDB source endpoint.
         */
        public var username: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.MongoDbSettings) : this() {
            this.authMechanism = x.authMechanism
            this.authSource = x.authSource
            this.authType = x.authType
            this.databaseName = x.databaseName
            this.docsToInvestigate = x.docsToInvestigate
            this.extractDocId = x.extractDocId
            this.kmsKeyId = x.kmsKeyId
            this.nestingLevel = x.nestingLevel
            this.password = x.password
            this.port = x.port
            this.secretsManagerAccessRoleArn = x.secretsManagerAccessRoleArn
            this.secretsManagerSecretId = x.secretsManagerSecretId
            this.serverName = x.serverName
            this.username = x.username
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.MongoDbSettings = MongoDbSettings(this)
    }
}
