// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model



/**
 * Describes an event notification subscription created by the `CreateEventSubscription` operation.
 */
public class EventSubscription private constructor(builder: Builder) {
    /**
     * The DMS event notification subscription Id.
     */
    public val custSubscriptionId: kotlin.String? = builder.custSubscriptionId
    /**
     * The Amazon Web Services customer account associated with the DMS event notification subscription.
     */
    public val customerAwsId: kotlin.String? = builder.customerAwsId
    /**
     * Boolean value that indicates if the event subscription is enabled.
     */
    public val enabled: kotlin.Boolean = builder.enabled
    /**
     * A lists of event categories.
     */
    public val eventCategoriesList: List<String>? = builder.eventCategoriesList
    /**
     * The topic ARN of the DMS event notification subscription.
     */
    public val snsTopicArn: kotlin.String? = builder.snsTopicArn
    /**
     * A list of source Ids for the event subscription.
     */
    public val sourceIdsList: List<String>? = builder.sourceIdsList
    /**
     * The type of DMS resource that generates events.
     *
     * Valid values: replication-instance | replication-server | security-group | replication-task
     */
    public val sourceType: kotlin.String? = builder.sourceType
    /**
     * The status of the DMS event notification subscription.
     *
     * Constraints:
     *
     * Can be one of the following: creating | modifying | deleting | active | no-permission | topic-not-exist
     *
     * The status "no-permission" indicates that DMS no longer has permission to post to the SNS topic. The status "topic-not-exist" indicates that the topic was deleted after the subscription was created.
     */
    public val status: kotlin.String? = builder.status
    /**
     * The time the DMS event notification subscription was created.
     */
    public val subscriptionCreationTime: kotlin.String? = builder.subscriptionCreationTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.EventSubscription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EventSubscription(")
        append("custSubscriptionId=$custSubscriptionId,")
        append("customerAwsId=$customerAwsId,")
        append("enabled=$enabled,")
        append("eventCategoriesList=$eventCategoriesList,")
        append("snsTopicArn=$snsTopicArn,")
        append("sourceIdsList=$sourceIdsList,")
        append("sourceType=$sourceType,")
        append("status=$status,")
        append("subscriptionCreationTime=$subscriptionCreationTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = custSubscriptionId?.hashCode() ?: 0
        result = 31 * result + (customerAwsId?.hashCode() ?: 0)
        result = 31 * result + (enabled.hashCode())
        result = 31 * result + (eventCategoriesList?.hashCode() ?: 0)
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        result = 31 * result + (sourceIdsList?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (subscriptionCreationTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EventSubscription

        if (custSubscriptionId != other.custSubscriptionId) return false
        if (customerAwsId != other.customerAwsId) return false
        if (enabled != other.enabled) return false
        if (eventCategoriesList != other.eventCategoriesList) return false
        if (snsTopicArn != other.snsTopicArn) return false
        if (sourceIdsList != other.sourceIdsList) return false
        if (sourceType != other.sourceType) return false
        if (status != other.status) return false
        if (subscriptionCreationTime != other.subscriptionCreationTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.EventSubscription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The DMS event notification subscription Id.
         */
        public var custSubscriptionId: kotlin.String? = null
        /**
         * The Amazon Web Services customer account associated with the DMS event notification subscription.
         */
        public var customerAwsId: kotlin.String? = null
        /**
         * Boolean value that indicates if the event subscription is enabled.
         */
        public var enabled: kotlin.Boolean = false
        /**
         * A lists of event categories.
         */
        public var eventCategoriesList: List<String>? = null
        /**
         * The topic ARN of the DMS event notification subscription.
         */
        public var snsTopicArn: kotlin.String? = null
        /**
         * A list of source Ids for the event subscription.
         */
        public var sourceIdsList: List<String>? = null
        /**
         * The type of DMS resource that generates events.
         *
         * Valid values: replication-instance | replication-server | security-group | replication-task
         */
        public var sourceType: kotlin.String? = null
        /**
         * The status of the DMS event notification subscription.
         *
         * Constraints:
         *
         * Can be one of the following: creating | modifying | deleting | active | no-permission | topic-not-exist
         *
         * The status "no-permission" indicates that DMS no longer has permission to post to the SNS topic. The status "topic-not-exist" indicates that the topic was deleted after the subscription was created.
         */
        public var status: kotlin.String? = null
        /**
         * The time the DMS event notification subscription was created.
         */
        public var subscriptionCreationTime: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.EventSubscription) : this() {
            this.custSubscriptionId = x.custSubscriptionId
            this.customerAwsId = x.customerAwsId
            this.enabled = x.enabled
            this.eventCategoriesList = x.eventCategoriesList
            this.snsTopicArn = x.snsTopicArn
            this.sourceIdsList = x.sourceIdsList
            this.sourceType = x.sourceType
            this.status = x.status
            this.subscriptionCreationTime = x.subscriptionCreationTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.EventSubscription = EventSubscription(this)
    }
}
