// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model



/**
 * Describes an endpoint of a database instance in response to operations such as the following:
 * + `CreateEndpoint`
 * + `DescribeEndpoint`
 * + `ModifyEndpoint`
 */
public class Endpoint private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) used for SSL connection to the endpoint.
     */
    public val certificateArn: kotlin.String? = builder.certificateArn
    /**
     * The name of the database at the endpoint.
     */
    public val databaseName: kotlin.String? = builder.databaseName
    /**
     * The settings for the DMS Transfer type source. For more information, see the DmsTransferSettings structure.
     */
    public val dmsTransferSettings: aws.sdk.kotlin.services.databasemigrationservice.model.DmsTransferSettings? = builder.dmsTransferSettings
    /**
     * Provides information that defines a DocumentDB endpoint.
     */
    public val docDbSettings: aws.sdk.kotlin.services.databasemigrationservice.model.DocDbSettings? = builder.docDbSettings
    /**
     * The settings for the DynamoDB target endpoint. For more information, see the `DynamoDBSettings` structure.
     */
    public val dynamoDbSettings: aws.sdk.kotlin.services.databasemigrationservice.model.DynamoDbSettings? = builder.dynamoDbSettings
    /**
     * The settings for the OpenSearch source endpoint. For more information, see the `ElasticsearchSettings` structure.
     */
    public val elasticsearchSettings: aws.sdk.kotlin.services.databasemigrationservice.model.ElasticsearchSettings? = builder.elasticsearchSettings
    /**
     * The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
     */
    public val endpointArn: kotlin.String? = builder.endpointArn
    /**
     * The database endpoint identifier. Identifiers must begin with a letter and must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen or contain two consecutive hyphens.
     */
    public val endpointIdentifier: kotlin.String? = builder.endpointIdentifier
    /**
     * The type of endpoint. Valid values are `source` and `target`.
     */
    public val endpointType: aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationEndpointTypeValue? = builder.endpointType
    /**
     * The expanded name for the engine name. For example, if the `EngineName` parameter is "aurora", this value would be "Amazon Aurora MySQL".
     */
    public val engineDisplayName: kotlin.String? = builder.engineDisplayName
    /**
     * The database engine name. Valid values, depending on the EndpointType, include `"mysql"`, `"oracle"`, `"postgres"`, `"mariadb"`, `"aurora"`, `"aurora-postgresql"`, `"redshift"`, `"s3"`, `"db2"`, `"db2-zos"`, `"azuredb"`, `"sybase"`, `"dynamodb"`, `"mongodb"`, `"kinesis"`, `"kafka"`, `"elasticsearch"`, `"documentdb"`, `"sqlserver"`, `"neptune"`, and `"babelfish"`.
     */
    public val engineName: kotlin.String? = builder.engineName
    /**
     * Value returned by a call to CreateEndpoint that can be used for cross-account validation. Use it on a subsequent call to CreateEndpoint to create the endpoint with a cross-account.
     */
    public val externalId: kotlin.String? = builder.externalId
    /**
     * The external table definition.
     */
    public val externalTableDefinition: kotlin.String? = builder.externalTableDefinition
    /**
     * Additional connection attributes used to connect to the endpoint.
     */
    public val extraConnectionAttributes: kotlin.String? = builder.extraConnectionAttributes
    /**
     * Settings in JSON format for the source GCP MySQL endpoint.
     */
    public val gcpMySqlSettings: aws.sdk.kotlin.services.databasemigrationservice.model.GcpMySqlSettings? = builder.gcpMySqlSettings
    /**
     * The settings for the IBM Db2 LUW source endpoint. For more information, see the `IBMDb2Settings` structure.
     */
    public val ibmDb2Settings: aws.sdk.kotlin.services.databasemigrationservice.model.IbmDb2Settings? = builder.ibmDb2Settings
    /**
     * The settings for the Apache Kafka target endpoint. For more information, see the `KafkaSettings` structure.
     */
    public val kafkaSettings: aws.sdk.kotlin.services.databasemigrationservice.model.KafkaSettings? = builder.kafkaSettings
    /**
     * The settings for the Amazon Kinesis target endpoint. For more information, see the `KinesisSettings` structure.
     */
    public val kinesisSettings: aws.sdk.kotlin.services.databasemigrationservice.model.KinesisSettings? = builder.kinesisSettings
    /**
     * An KMS key identifier that is used to encrypt the connection parameters for the endpoint.
     *
     * If you don't specify a value for the `KmsKeyId` parameter, then DMS uses your default encryption key.
     *
     * KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a different default encryption key for each Amazon Web Services Region.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The settings for the Microsoft SQL Server source and target endpoint. For more information, see the `MicrosoftSQLServerSettings` structure.
     */
    public val microsoftSqlServerSettings: aws.sdk.kotlin.services.databasemigrationservice.model.MicrosoftSqlServerSettings? = builder.microsoftSqlServerSettings
    /**
     * The settings for the MongoDB source endpoint. For more information, see the `MongoDbSettings` structure.
     */
    public val mongoDbSettings: aws.sdk.kotlin.services.databasemigrationservice.model.MongoDbSettings? = builder.mongoDbSettings
    /**
     * The settings for the MySQL source and target endpoint. For more information, see the `MySQLSettings` structure.
     */
    public val mySqlSettings: aws.sdk.kotlin.services.databasemigrationservice.model.MySqlSettings? = builder.mySqlSettings
    /**
     * The settings for the Amazon Neptune target endpoint. For more information, see the `NeptuneSettings` structure.
     */
    public val neptuneSettings: aws.sdk.kotlin.services.databasemigrationservice.model.NeptuneSettings? = builder.neptuneSettings
    /**
     * The settings for the Oracle source and target endpoint. For more information, see the `OracleSettings` structure.
     */
    public val oracleSettings: aws.sdk.kotlin.services.databasemigrationservice.model.OracleSettings? = builder.oracleSettings
    /**
     * The port value used to access the endpoint.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The settings for the PostgreSQL source and target endpoint. For more information, see the `PostgreSQLSettings` structure.
     */
    public val postgreSqlSettings: aws.sdk.kotlin.services.databasemigrationservice.model.PostgreSqlSettings? = builder.postgreSqlSettings
    /**
     * The settings for the Redis target endpoint. For more information, see the `RedisSettings` structure.
     */
    public val redisSettings: aws.sdk.kotlin.services.databasemigrationservice.model.RedisSettings? = builder.redisSettings
    /**
     * Settings for the Amazon Redshift endpoint.
     */
    public val redshiftSettings: aws.sdk.kotlin.services.databasemigrationservice.model.RedshiftSettings? = builder.redshiftSettings
    /**
     * The settings for the S3 target endpoint. For more information, see the `S3Settings` structure.
     */
    public val s3Settings: aws.sdk.kotlin.services.databasemigrationservice.model.S3Settings? = builder.s3Settings
    /**
     * The name of the server at the endpoint.
     */
    public val serverName: kotlin.String? = builder.serverName
    /**
     * The Amazon Resource Name (ARN) used by the service to access the IAM role. The role must allow the `iam:PassRole` action.
     */
    public val serviceAccessRoleArn: kotlin.String? = builder.serviceAccessRoleArn
    /**
     * The SSL mode used to connect to the endpoint. The default value is `none`.
     */
    public val sslMode: aws.sdk.kotlin.services.databasemigrationservice.model.DmsSslModeValue? = builder.sslMode
    /**
     * The status of the endpoint.
     */
    public val status: kotlin.String? = builder.status
    /**
     * The settings for the SAP ASE source and target endpoint. For more information, see the `SybaseSettings` structure.
     */
    public val sybaseSettings: aws.sdk.kotlin.services.databasemigrationservice.model.SybaseSettings? = builder.sybaseSettings
    /**
     * The user name used to connect to the endpoint.
     */
    public val username: kotlin.String? = builder.username

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.Endpoint = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Endpoint(")
        append("certificateArn=$certificateArn,")
        append("databaseName=$databaseName,")
        append("dmsTransferSettings=$dmsTransferSettings,")
        append("docDbSettings=$docDbSettings,")
        append("dynamoDbSettings=$dynamoDbSettings,")
        append("elasticsearchSettings=$elasticsearchSettings,")
        append("endpointArn=$endpointArn,")
        append("endpointIdentifier=$endpointIdentifier,")
        append("endpointType=$endpointType,")
        append("engineDisplayName=$engineDisplayName,")
        append("engineName=$engineName,")
        append("externalId=$externalId,")
        append("externalTableDefinition=$externalTableDefinition,")
        append("extraConnectionAttributes=$extraConnectionAttributes,")
        append("gcpMySqlSettings=$gcpMySqlSettings,")
        append("ibmDb2Settings=$ibmDb2Settings,")
        append("kafkaSettings=$kafkaSettings,")
        append("kinesisSettings=$kinesisSettings,")
        append("kmsKeyId=$kmsKeyId,")
        append("microsoftSqlServerSettings=$microsoftSqlServerSettings,")
        append("mongoDbSettings=$mongoDbSettings,")
        append("mySqlSettings=$mySqlSettings,")
        append("neptuneSettings=$neptuneSettings,")
        append("oracleSettings=$oracleSettings,")
        append("port=$port,")
        append("postgreSqlSettings=$postgreSqlSettings,")
        append("redisSettings=$redisSettings,")
        append("redshiftSettings=$redshiftSettings,")
        append("s3Settings=$s3Settings,")
        append("serverName=$serverName,")
        append("serviceAccessRoleArn=$serviceAccessRoleArn,")
        append("sslMode=$sslMode,")
        append("status=$status,")
        append("sybaseSettings=$sybaseSettings,")
        append("username=$username")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateArn?.hashCode() ?: 0
        result = 31 * result + (databaseName?.hashCode() ?: 0)
        result = 31 * result + (dmsTransferSettings?.hashCode() ?: 0)
        result = 31 * result + (docDbSettings?.hashCode() ?: 0)
        result = 31 * result + (dynamoDbSettings?.hashCode() ?: 0)
        result = 31 * result + (elasticsearchSettings?.hashCode() ?: 0)
        result = 31 * result + (endpointArn?.hashCode() ?: 0)
        result = 31 * result + (endpointIdentifier?.hashCode() ?: 0)
        result = 31 * result + (endpointType?.hashCode() ?: 0)
        result = 31 * result + (engineDisplayName?.hashCode() ?: 0)
        result = 31 * result + (engineName?.hashCode() ?: 0)
        result = 31 * result + (externalId?.hashCode() ?: 0)
        result = 31 * result + (externalTableDefinition?.hashCode() ?: 0)
        result = 31 * result + (extraConnectionAttributes?.hashCode() ?: 0)
        result = 31 * result + (gcpMySqlSettings?.hashCode() ?: 0)
        result = 31 * result + (ibmDb2Settings?.hashCode() ?: 0)
        result = 31 * result + (kafkaSettings?.hashCode() ?: 0)
        result = 31 * result + (kinesisSettings?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (microsoftSqlServerSettings?.hashCode() ?: 0)
        result = 31 * result + (mongoDbSettings?.hashCode() ?: 0)
        result = 31 * result + (mySqlSettings?.hashCode() ?: 0)
        result = 31 * result + (neptuneSettings?.hashCode() ?: 0)
        result = 31 * result + (oracleSettings?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (postgreSqlSettings?.hashCode() ?: 0)
        result = 31 * result + (redisSettings?.hashCode() ?: 0)
        result = 31 * result + (redshiftSettings?.hashCode() ?: 0)
        result = 31 * result + (s3Settings?.hashCode() ?: 0)
        result = 31 * result + (serverName?.hashCode() ?: 0)
        result = 31 * result + (serviceAccessRoleArn?.hashCode() ?: 0)
        result = 31 * result + (sslMode?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (sybaseSettings?.hashCode() ?: 0)
        result = 31 * result + (username?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Endpoint

        if (certificateArn != other.certificateArn) return false
        if (databaseName != other.databaseName) return false
        if (dmsTransferSettings != other.dmsTransferSettings) return false
        if (docDbSettings != other.docDbSettings) return false
        if (dynamoDbSettings != other.dynamoDbSettings) return false
        if (elasticsearchSettings != other.elasticsearchSettings) return false
        if (endpointArn != other.endpointArn) return false
        if (endpointIdentifier != other.endpointIdentifier) return false
        if (endpointType != other.endpointType) return false
        if (engineDisplayName != other.engineDisplayName) return false
        if (engineName != other.engineName) return false
        if (externalId != other.externalId) return false
        if (externalTableDefinition != other.externalTableDefinition) return false
        if (extraConnectionAttributes != other.extraConnectionAttributes) return false
        if (gcpMySqlSettings != other.gcpMySqlSettings) return false
        if (ibmDb2Settings != other.ibmDb2Settings) return false
        if (kafkaSettings != other.kafkaSettings) return false
        if (kinesisSettings != other.kinesisSettings) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (microsoftSqlServerSettings != other.microsoftSqlServerSettings) return false
        if (mongoDbSettings != other.mongoDbSettings) return false
        if (mySqlSettings != other.mySqlSettings) return false
        if (neptuneSettings != other.neptuneSettings) return false
        if (oracleSettings != other.oracleSettings) return false
        if (port != other.port) return false
        if (postgreSqlSettings != other.postgreSqlSettings) return false
        if (redisSettings != other.redisSettings) return false
        if (redshiftSettings != other.redshiftSettings) return false
        if (s3Settings != other.s3Settings) return false
        if (serverName != other.serverName) return false
        if (serviceAccessRoleArn != other.serviceAccessRoleArn) return false
        if (sslMode != other.sslMode) return false
        if (status != other.status) return false
        if (sybaseSettings != other.sybaseSettings) return false
        if (username != other.username) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.Endpoint = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) used for SSL connection to the endpoint.
         */
        public var certificateArn: kotlin.String? = null
        /**
         * The name of the database at the endpoint.
         */
        public var databaseName: kotlin.String? = null
        /**
         * The settings for the DMS Transfer type source. For more information, see the DmsTransferSettings structure.
         */
        public var dmsTransferSettings: aws.sdk.kotlin.services.databasemigrationservice.model.DmsTransferSettings? = null
        /**
         * Provides information that defines a DocumentDB endpoint.
         */
        public var docDbSettings: aws.sdk.kotlin.services.databasemigrationservice.model.DocDbSettings? = null
        /**
         * The settings for the DynamoDB target endpoint. For more information, see the `DynamoDBSettings` structure.
         */
        public var dynamoDbSettings: aws.sdk.kotlin.services.databasemigrationservice.model.DynamoDbSettings? = null
        /**
         * The settings for the OpenSearch source endpoint. For more information, see the `ElasticsearchSettings` structure.
         */
        public var elasticsearchSettings: aws.sdk.kotlin.services.databasemigrationservice.model.ElasticsearchSettings? = null
        /**
         * The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
         */
        public var endpointArn: kotlin.String? = null
        /**
         * The database endpoint identifier. Identifiers must begin with a letter and must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen or contain two consecutive hyphens.
         */
        public var endpointIdentifier: kotlin.String? = null
        /**
         * The type of endpoint. Valid values are `source` and `target`.
         */
        public var endpointType: aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationEndpointTypeValue? = null
        /**
         * The expanded name for the engine name. For example, if the `EngineName` parameter is "aurora", this value would be "Amazon Aurora MySQL".
         */
        public var engineDisplayName: kotlin.String? = null
        /**
         * The database engine name. Valid values, depending on the EndpointType, include `"mysql"`, `"oracle"`, `"postgres"`, `"mariadb"`, `"aurora"`, `"aurora-postgresql"`, `"redshift"`, `"s3"`, `"db2"`, `"db2-zos"`, `"azuredb"`, `"sybase"`, `"dynamodb"`, `"mongodb"`, `"kinesis"`, `"kafka"`, `"elasticsearch"`, `"documentdb"`, `"sqlserver"`, `"neptune"`, and `"babelfish"`.
         */
        public var engineName: kotlin.String? = null
        /**
         * Value returned by a call to CreateEndpoint that can be used for cross-account validation. Use it on a subsequent call to CreateEndpoint to create the endpoint with a cross-account.
         */
        public var externalId: kotlin.String? = null
        /**
         * The external table definition.
         */
        public var externalTableDefinition: kotlin.String? = null
        /**
         * Additional connection attributes used to connect to the endpoint.
         */
        public var extraConnectionAttributes: kotlin.String? = null
        /**
         * Settings in JSON format for the source GCP MySQL endpoint.
         */
        public var gcpMySqlSettings: aws.sdk.kotlin.services.databasemigrationservice.model.GcpMySqlSettings? = null
        /**
         * The settings for the IBM Db2 LUW source endpoint. For more information, see the `IBMDb2Settings` structure.
         */
        public var ibmDb2Settings: aws.sdk.kotlin.services.databasemigrationservice.model.IbmDb2Settings? = null
        /**
         * The settings for the Apache Kafka target endpoint. For more information, see the `KafkaSettings` structure.
         */
        public var kafkaSettings: aws.sdk.kotlin.services.databasemigrationservice.model.KafkaSettings? = null
        /**
         * The settings for the Amazon Kinesis target endpoint. For more information, see the `KinesisSettings` structure.
         */
        public var kinesisSettings: aws.sdk.kotlin.services.databasemigrationservice.model.KinesisSettings? = null
        /**
         * An KMS key identifier that is used to encrypt the connection parameters for the endpoint.
         *
         * If you don't specify a value for the `KmsKeyId` parameter, then DMS uses your default encryption key.
         *
         * KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a different default encryption key for each Amazon Web Services Region.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The settings for the Microsoft SQL Server source and target endpoint. For more information, see the `MicrosoftSQLServerSettings` structure.
         */
        public var microsoftSqlServerSettings: aws.sdk.kotlin.services.databasemigrationservice.model.MicrosoftSqlServerSettings? = null
        /**
         * The settings for the MongoDB source endpoint. For more information, see the `MongoDbSettings` structure.
         */
        public var mongoDbSettings: aws.sdk.kotlin.services.databasemigrationservice.model.MongoDbSettings? = null
        /**
         * The settings for the MySQL source and target endpoint. For more information, see the `MySQLSettings` structure.
         */
        public var mySqlSettings: aws.sdk.kotlin.services.databasemigrationservice.model.MySqlSettings? = null
        /**
         * The settings for the Amazon Neptune target endpoint. For more information, see the `NeptuneSettings` structure.
         */
        public var neptuneSettings: aws.sdk.kotlin.services.databasemigrationservice.model.NeptuneSettings? = null
        /**
         * The settings for the Oracle source and target endpoint. For more information, see the `OracleSettings` structure.
         */
        public var oracleSettings: aws.sdk.kotlin.services.databasemigrationservice.model.OracleSettings? = null
        /**
         * The port value used to access the endpoint.
         */
        public var port: kotlin.Int? = null
        /**
         * The settings for the PostgreSQL source and target endpoint. For more information, see the `PostgreSQLSettings` structure.
         */
        public var postgreSqlSettings: aws.sdk.kotlin.services.databasemigrationservice.model.PostgreSqlSettings? = null
        /**
         * The settings for the Redis target endpoint. For more information, see the `RedisSettings` structure.
         */
        public var redisSettings: aws.sdk.kotlin.services.databasemigrationservice.model.RedisSettings? = null
        /**
         * Settings for the Amazon Redshift endpoint.
         */
        public var redshiftSettings: aws.sdk.kotlin.services.databasemigrationservice.model.RedshiftSettings? = null
        /**
         * The settings for the S3 target endpoint. For more information, see the `S3Settings` structure.
         */
        public var s3Settings: aws.sdk.kotlin.services.databasemigrationservice.model.S3Settings? = null
        /**
         * The name of the server at the endpoint.
         */
        public var serverName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) used by the service to access the IAM role. The role must allow the `iam:PassRole` action.
         */
        public var serviceAccessRoleArn: kotlin.String? = null
        /**
         * The SSL mode used to connect to the endpoint. The default value is `none`.
         */
        public var sslMode: aws.sdk.kotlin.services.databasemigrationservice.model.DmsSslModeValue? = null
        /**
         * The status of the endpoint.
         */
        public var status: kotlin.String? = null
        /**
         * The settings for the SAP ASE source and target endpoint. For more information, see the `SybaseSettings` structure.
         */
        public var sybaseSettings: aws.sdk.kotlin.services.databasemigrationservice.model.SybaseSettings? = null
        /**
         * The user name used to connect to the endpoint.
         */
        public var username: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.Endpoint) : this() {
            this.certificateArn = x.certificateArn
            this.databaseName = x.databaseName
            this.dmsTransferSettings = x.dmsTransferSettings
            this.docDbSettings = x.docDbSettings
            this.dynamoDbSettings = x.dynamoDbSettings
            this.elasticsearchSettings = x.elasticsearchSettings
            this.endpointArn = x.endpointArn
            this.endpointIdentifier = x.endpointIdentifier
            this.endpointType = x.endpointType
            this.engineDisplayName = x.engineDisplayName
            this.engineName = x.engineName
            this.externalId = x.externalId
            this.externalTableDefinition = x.externalTableDefinition
            this.extraConnectionAttributes = x.extraConnectionAttributes
            this.gcpMySqlSettings = x.gcpMySqlSettings
            this.ibmDb2Settings = x.ibmDb2Settings
            this.kafkaSettings = x.kafkaSettings
            this.kinesisSettings = x.kinesisSettings
            this.kmsKeyId = x.kmsKeyId
            this.microsoftSqlServerSettings = x.microsoftSqlServerSettings
            this.mongoDbSettings = x.mongoDbSettings
            this.mySqlSettings = x.mySqlSettings
            this.neptuneSettings = x.neptuneSettings
            this.oracleSettings = x.oracleSettings
            this.port = x.port
            this.postgreSqlSettings = x.postgreSqlSettings
            this.redisSettings = x.redisSettings
            this.redshiftSettings = x.redshiftSettings
            this.s3Settings = x.s3Settings
            this.serverName = x.serverName
            this.serviceAccessRoleArn = x.serviceAccessRoleArn
            this.sslMode = x.sslMode
            this.status = x.status
            this.sybaseSettings = x.sybaseSettings
            this.username = x.username
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.Endpoint = Endpoint(this)

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.DmsTransferSettings] inside the given [block]
         */
        public fun dmsTransferSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.DmsTransferSettings.Builder.() -> kotlin.Unit) {
            this.dmsTransferSettings = aws.sdk.kotlin.services.databasemigrationservice.model.DmsTransferSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.DocDbSettings] inside the given [block]
         */
        public fun docDbSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.DocDbSettings.Builder.() -> kotlin.Unit) {
            this.docDbSettings = aws.sdk.kotlin.services.databasemigrationservice.model.DocDbSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.DynamoDbSettings] inside the given [block]
         */
        public fun dynamoDbSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.DynamoDbSettings.Builder.() -> kotlin.Unit) {
            this.dynamoDbSettings = aws.sdk.kotlin.services.databasemigrationservice.model.DynamoDbSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.ElasticsearchSettings] inside the given [block]
         */
        public fun elasticsearchSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.ElasticsearchSettings.Builder.() -> kotlin.Unit) {
            this.elasticsearchSettings = aws.sdk.kotlin.services.databasemigrationservice.model.ElasticsearchSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.GcpMySqlSettings] inside the given [block]
         */
        public fun gcpMySqlSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.GcpMySqlSettings.Builder.() -> kotlin.Unit) {
            this.gcpMySqlSettings = aws.sdk.kotlin.services.databasemigrationservice.model.GcpMySqlSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.IbmDb2Settings] inside the given [block]
         */
        public fun ibmDb2Settings(block: aws.sdk.kotlin.services.databasemigrationservice.model.IbmDb2Settings.Builder.() -> kotlin.Unit) {
            this.ibmDb2Settings = aws.sdk.kotlin.services.databasemigrationservice.model.IbmDb2Settings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.KafkaSettings] inside the given [block]
         */
        public fun kafkaSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.KafkaSettings.Builder.() -> kotlin.Unit) {
            this.kafkaSettings = aws.sdk.kotlin.services.databasemigrationservice.model.KafkaSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.KinesisSettings] inside the given [block]
         */
        public fun kinesisSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.KinesisSettings.Builder.() -> kotlin.Unit) {
            this.kinesisSettings = aws.sdk.kotlin.services.databasemigrationservice.model.KinesisSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.MicrosoftSqlServerSettings] inside the given [block]
         */
        public fun microsoftSqlServerSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.MicrosoftSqlServerSettings.Builder.() -> kotlin.Unit) {
            this.microsoftSqlServerSettings = aws.sdk.kotlin.services.databasemigrationservice.model.MicrosoftSqlServerSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.MongoDbSettings] inside the given [block]
         */
        public fun mongoDbSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.MongoDbSettings.Builder.() -> kotlin.Unit) {
            this.mongoDbSettings = aws.sdk.kotlin.services.databasemigrationservice.model.MongoDbSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.MySqlSettings] inside the given [block]
         */
        public fun mySqlSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.MySqlSettings.Builder.() -> kotlin.Unit) {
            this.mySqlSettings = aws.sdk.kotlin.services.databasemigrationservice.model.MySqlSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.NeptuneSettings] inside the given [block]
         */
        public fun neptuneSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.NeptuneSettings.Builder.() -> kotlin.Unit) {
            this.neptuneSettings = aws.sdk.kotlin.services.databasemigrationservice.model.NeptuneSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.OracleSettings] inside the given [block]
         */
        public fun oracleSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.OracleSettings.Builder.() -> kotlin.Unit) {
            this.oracleSettings = aws.sdk.kotlin.services.databasemigrationservice.model.OracleSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.PostgreSqlSettings] inside the given [block]
         */
        public fun postgreSqlSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.PostgreSqlSettings.Builder.() -> kotlin.Unit) {
            this.postgreSqlSettings = aws.sdk.kotlin.services.databasemigrationservice.model.PostgreSqlSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.RedisSettings] inside the given [block]
         */
        public fun redisSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.RedisSettings.Builder.() -> kotlin.Unit) {
            this.redisSettings = aws.sdk.kotlin.services.databasemigrationservice.model.RedisSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.RedshiftSettings] inside the given [block]
         */
        public fun redshiftSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.RedshiftSettings.Builder.() -> kotlin.Unit) {
            this.redshiftSettings = aws.sdk.kotlin.services.databasemigrationservice.model.RedshiftSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.S3Settings] inside the given [block]
         */
        public fun s3Settings(block: aws.sdk.kotlin.services.databasemigrationservice.model.S3Settings.Builder.() -> kotlin.Unit) {
            this.s3Settings = aws.sdk.kotlin.services.databasemigrationservice.model.S3Settings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.SybaseSettings] inside the given [block]
         */
        public fun sybaseSettings(block: aws.sdk.kotlin.services.databasemigrationservice.model.SybaseSettings.Builder.() -> kotlin.Unit) {
            this.sybaseSettings = aws.sdk.kotlin.services.databasemigrationservice.model.SybaseSettings.invoke(block)
        }
    }
}
