// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 *
 */
public class CreateReplicationTaskRequest private constructor(builder: Builder) {
    /**
     * Indicates when you want a change data capture (CDC) operation to start. Use either CdcStartPosition or CdcStartTime to specify when you want a CDC operation to start. Specifying both values results in an error.
     *
     *  The value can be in date, checkpoint, or LSN/SCN format.
     *
     * Date Example: --cdc-start-position “2018-03-08T12:12:12”
     *
     * Checkpoint Example: --cdc-start-position "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"
     *
     * LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”
     *
     * When you use this task setting with a source PostgreSQL database, a logical replication slot should already be created and associated with the source endpoint. You can verify this by setting the `slotName` extra connection attribute to the name of this logical replication slot. For more information, see [Extra Connection Attributes When Using PostgreSQL as a Source for DMS](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib).
     */
    public val cdcStartPosition: kotlin.String? = builder.cdcStartPosition
    /**
     * Indicates the start time for a change data capture (CDC) operation. Use either CdcStartTime or CdcStartPosition to specify when you want a CDC operation to start. Specifying both values results in an error.
     *
     * Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”
     */
    public val cdcStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.cdcStartTime
    /**
     * Indicates when you want a change data capture (CDC) operation to stop. The value can be either server time or commit time.
     *
     * Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”
     *
     * Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12“
     */
    public val cdcStopPosition: kotlin.String? = builder.cdcStopPosition
    /**
     * The migration type. Valid values: `full-load` | `cdc` | `full-load-and-cdc`
     */
    public val migrationType: aws.sdk.kotlin.services.databasemigrationservice.model.MigrationTypeValue? = builder.migrationType
    /**
     * The Amazon Resource Name (ARN) of a replication instance.
     */
    public val replicationInstanceArn: kotlin.String? = builder.replicationInstanceArn
    /**
     * An identifier for the replication task.
     *
     * Constraints:
     * + Must contain 1-255 alphanumeric characters or hyphens.
     * + First character must be a letter.
     * + Cannot end with a hyphen or contain two consecutive hyphens.
     */
    public val replicationTaskIdentifier: kotlin.String? = builder.replicationTaskIdentifier
    /**
     * Overall settings for the task, in JSON format. For more information, see [Specifying Task Settings for Database Migration Service Tasks](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.html) in the *Database Migration Service User Guide.*
     */
    public val replicationTaskSettings: kotlin.String? = builder.replicationTaskSettings
    /**
     * A friendly name for the resource identifier at the end of the `EndpointArn` response parameter that is returned in the created `Endpoint` object. The value for this parameter can have up to 31 characters. It can contain only ASCII letters, digits, and hyphen ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens, and can only begin with a letter, such as `Example-App-ARN1`. For example, this value might result in the `EndpointArn` value `arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1`. If you don't specify a `ResourceIdentifier` value, DMS generates a default identifier value for the end of `EndpointArn`.
     */
    public val resourceIdentifier: kotlin.String? = builder.resourceIdentifier
    /**
     * An Amazon Resource Name (ARN) that uniquely identifies the source endpoint.
     */
    public val sourceEndpointArn: kotlin.String? = builder.sourceEndpointArn
    /**
     * The table mappings for the task, in JSON format. For more information, see [Using Table Mapping to Specify Task Settings](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html) in the *Database Migration Service User Guide.*
     */
    public val tableMappings: kotlin.String? = builder.tableMappings
    /**
     * One or more tags to be assigned to the replication task.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * An Amazon Resource Name (ARN) that uniquely identifies the target endpoint.
     */
    public val targetEndpointArn: kotlin.String? = builder.targetEndpointArn
    /**
     * Supplemental information that the task requires to migrate the data for certain source and target endpoints. For more information, see [Specifying Supplemental Data for Task Settings](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html) in the *Database Migration Service User Guide.*
     */
    public val taskData: kotlin.String? = builder.taskData

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.CreateReplicationTaskRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateReplicationTaskRequest(")
        append("cdcStartPosition=$cdcStartPosition,")
        append("cdcStartTime=$cdcStartTime,")
        append("cdcStopPosition=$cdcStopPosition,")
        append("migrationType=$migrationType,")
        append("replicationInstanceArn=$replicationInstanceArn,")
        append("replicationTaskIdentifier=$replicationTaskIdentifier,")
        append("replicationTaskSettings=$replicationTaskSettings,")
        append("resourceIdentifier=$resourceIdentifier,")
        append("sourceEndpointArn=$sourceEndpointArn,")
        append("tableMappings=$tableMappings,")
        append("tags=$tags,")
        append("targetEndpointArn=$targetEndpointArn,")
        append("taskData=$taskData")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cdcStartPosition?.hashCode() ?: 0
        result = 31 * result + (cdcStartTime?.hashCode() ?: 0)
        result = 31 * result + (cdcStopPosition?.hashCode() ?: 0)
        result = 31 * result + (migrationType?.hashCode() ?: 0)
        result = 31 * result + (replicationInstanceArn?.hashCode() ?: 0)
        result = 31 * result + (replicationTaskIdentifier?.hashCode() ?: 0)
        result = 31 * result + (replicationTaskSettings?.hashCode() ?: 0)
        result = 31 * result + (resourceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (sourceEndpointArn?.hashCode() ?: 0)
        result = 31 * result + (tableMappings?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetEndpointArn?.hashCode() ?: 0)
        result = 31 * result + (taskData?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateReplicationTaskRequest

        if (cdcStartPosition != other.cdcStartPosition) return false
        if (cdcStartTime != other.cdcStartTime) return false
        if (cdcStopPosition != other.cdcStopPosition) return false
        if (migrationType != other.migrationType) return false
        if (replicationInstanceArn != other.replicationInstanceArn) return false
        if (replicationTaskIdentifier != other.replicationTaskIdentifier) return false
        if (replicationTaskSettings != other.replicationTaskSettings) return false
        if (resourceIdentifier != other.resourceIdentifier) return false
        if (sourceEndpointArn != other.sourceEndpointArn) return false
        if (tableMappings != other.tableMappings) return false
        if (tags != other.tags) return false
        if (targetEndpointArn != other.targetEndpointArn) return false
        if (taskData != other.taskData) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.CreateReplicationTaskRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates when you want a change data capture (CDC) operation to start. Use either CdcStartPosition or CdcStartTime to specify when you want a CDC operation to start. Specifying both values results in an error.
         *
         *  The value can be in date, checkpoint, or LSN/SCN format.
         *
         * Date Example: --cdc-start-position “2018-03-08T12:12:12”
         *
         * Checkpoint Example: --cdc-start-position "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"
         *
         * LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”
         *
         * When you use this task setting with a source PostgreSQL database, a logical replication slot should already be created and associated with the source endpoint. You can verify this by setting the `slotName` extra connection attribute to the name of this logical replication slot. For more information, see [Extra Connection Attributes When Using PostgreSQL as a Source for DMS](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib).
         */
        public var cdcStartPosition: kotlin.String? = null
        /**
         * Indicates the start time for a change data capture (CDC) operation. Use either CdcStartTime or CdcStartPosition to specify when you want a CDC operation to start. Specifying both values results in an error.
         *
         * Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”
         */
        public var cdcStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Indicates when you want a change data capture (CDC) operation to stop. The value can be either server time or commit time.
         *
         * Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”
         *
         * Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12“
         */
        public var cdcStopPosition: kotlin.String? = null
        /**
         * The migration type. Valid values: `full-load` | `cdc` | `full-load-and-cdc`
         */
        public var migrationType: aws.sdk.kotlin.services.databasemigrationservice.model.MigrationTypeValue? = null
        /**
         * The Amazon Resource Name (ARN) of a replication instance.
         */
        public var replicationInstanceArn: kotlin.String? = null
        /**
         * An identifier for the replication task.
         *
         * Constraints:
         * + Must contain 1-255 alphanumeric characters or hyphens.
         * + First character must be a letter.
         * + Cannot end with a hyphen or contain two consecutive hyphens.
         */
        public var replicationTaskIdentifier: kotlin.String? = null
        /**
         * Overall settings for the task, in JSON format. For more information, see [Specifying Task Settings for Database Migration Service Tasks](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.html) in the *Database Migration Service User Guide.*
         */
        public var replicationTaskSettings: kotlin.String? = null
        /**
         * A friendly name for the resource identifier at the end of the `EndpointArn` response parameter that is returned in the created `Endpoint` object. The value for this parameter can have up to 31 characters. It can contain only ASCII letters, digits, and hyphen ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens, and can only begin with a letter, such as `Example-App-ARN1`. For example, this value might result in the `EndpointArn` value `arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1`. If you don't specify a `ResourceIdentifier` value, DMS generates a default identifier value for the end of `EndpointArn`.
         */
        public var resourceIdentifier: kotlin.String? = null
        /**
         * An Amazon Resource Name (ARN) that uniquely identifies the source endpoint.
         */
        public var sourceEndpointArn: kotlin.String? = null
        /**
         * The table mappings for the task, in JSON format. For more information, see [Using Table Mapping to Specify Task Settings](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html) in the *Database Migration Service User Guide.*
         */
        public var tableMappings: kotlin.String? = null
        /**
         * One or more tags to be assigned to the replication task.
         */
        public var tags: List<Tag>? = null
        /**
         * An Amazon Resource Name (ARN) that uniquely identifies the target endpoint.
         */
        public var targetEndpointArn: kotlin.String? = null
        /**
         * Supplemental information that the task requires to migrate the data for certain source and target endpoints. For more information, see [Specifying Supplemental Data for Task Settings](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html) in the *Database Migration Service User Guide.*
         */
        public var taskData: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.CreateReplicationTaskRequest) : this() {
            this.cdcStartPosition = x.cdcStartPosition
            this.cdcStartTime = x.cdcStartTime
            this.cdcStopPosition = x.cdcStopPosition
            this.migrationType = x.migrationType
            this.replicationInstanceArn = x.replicationInstanceArn
            this.replicationTaskIdentifier = x.replicationTaskIdentifier
            this.replicationTaskSettings = x.replicationTaskSettings
            this.resourceIdentifier = x.resourceIdentifier
            this.sourceEndpointArn = x.sourceEndpointArn
            this.tableMappings = x.tableMappings
            this.tags = x.tags
            this.targetEndpointArn = x.targetEndpointArn
            this.taskData = x.taskData
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.CreateReplicationTaskRequest = CreateReplicationTaskRequest(this)
    }
}
