// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.databasemigrationservice.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.databasemigrationservice.endpoints.EndpointParameters
import aws.sdk.kotlin.services.databasemigrationservice.endpoints.EndpointProvider
import aws.sdk.kotlin.services.databasemigrationservice.model.AddTagsToResourceRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.AddTagsToResourceResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.ApplyPendingMaintenanceActionRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.ApplyPendingMaintenanceActionResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.BatchStartRecommendationsRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.BatchStartRecommendationsResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.CancelReplicationTaskAssessmentRunRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.CancelReplicationTaskAssessmentRunResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.CreateEndpointRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.CreateEndpointResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.CreateEventSubscriptionRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.CreateEventSubscriptionResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.CreateFleetAdvisorCollectorRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.CreateFleetAdvisorCollectorResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.CreateReplicationInstanceRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.CreateReplicationInstanceResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.CreateReplicationSubnetGroupRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.CreateReplicationSubnetGroupResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.CreateReplicationTaskRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.CreateReplicationTaskResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DeleteCertificateRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DeleteCertificateResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DeleteConnectionRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DeleteConnectionResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DeleteEndpointRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DeleteEndpointResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DeleteEventSubscriptionRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DeleteEventSubscriptionResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DeleteFleetAdvisorCollectorRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DeleteFleetAdvisorCollectorResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DeleteFleetAdvisorDatabasesRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DeleteFleetAdvisorDatabasesResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DeleteReplicationInstanceRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DeleteReplicationInstanceResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DeleteReplicationSubnetGroupRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DeleteReplicationSubnetGroupResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DeleteReplicationTaskAssessmentRunRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DeleteReplicationTaskAssessmentRunResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DeleteReplicationTaskRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DeleteReplicationTaskResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeAccountAttributesRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeAccountAttributesResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeApplicableIndividualAssessmentsRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeApplicableIndividualAssessmentsResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeCertificatesRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeCertificatesResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeConnectionsRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeConnectionsResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeEndpointSettingsRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeEndpointSettingsResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeEndpointTypesRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeEndpointTypesResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeEndpointsRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeEndpointsResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeEventCategoriesRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeEventCategoriesResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeEventSubscriptionsRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeEventSubscriptionsResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeEventsRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeEventsResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeFleetAdvisorCollectorsRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeFleetAdvisorCollectorsResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeFleetAdvisorDatabasesRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeFleetAdvisorDatabasesResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeFleetAdvisorLsaAnalysisRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeFleetAdvisorLsaAnalysisResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeFleetAdvisorSchemaObjectSummaryRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeFleetAdvisorSchemaObjectSummaryResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeFleetAdvisorSchemasRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeFleetAdvisorSchemasResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeOrderableReplicationInstancesRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeOrderableReplicationInstancesResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribePendingMaintenanceActionsRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribePendingMaintenanceActionsResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeRecommendationLimitationsRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeRecommendationLimitationsResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeRecommendationsRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeRecommendationsResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeRefreshSchemasStatusRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeRefreshSchemasStatusResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeReplicationInstanceTaskLogsRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeReplicationInstanceTaskLogsResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeReplicationInstancesRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeReplicationInstancesResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeReplicationSubnetGroupsRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeReplicationSubnetGroupsResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeReplicationTaskAssessmentResultsRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeReplicationTaskAssessmentResultsResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeReplicationTaskAssessmentRunsRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeReplicationTaskAssessmentRunsResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeReplicationTaskIndividualAssessmentsRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeReplicationTaskIndividualAssessmentsResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeReplicationTasksRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeReplicationTasksResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeSchemasRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeSchemasResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeTableStatisticsRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeTableStatisticsResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.ImportCertificateRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.ImportCertificateResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.ModifyEndpointRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.ModifyEndpointResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.ModifyEventSubscriptionRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.ModifyEventSubscriptionResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.ModifyReplicationInstanceRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.ModifyReplicationInstanceResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.ModifyReplicationSubnetGroupRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.ModifyReplicationSubnetGroupResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.ModifyReplicationTaskRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.ModifyReplicationTaskResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.MoveReplicationTaskRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.MoveReplicationTaskResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.RebootReplicationInstanceRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.RebootReplicationInstanceResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.RefreshSchemasRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.RefreshSchemasResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.ReloadTablesRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.ReloadTablesResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.RemoveTagsFromResourceRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.RemoveTagsFromResourceResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.RunFleetAdvisorLsaAnalysisRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.RunFleetAdvisorLsaAnalysisResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.StartRecommendationsRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.StartRecommendationsResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.StartReplicationTaskAssessmentRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.StartReplicationTaskAssessmentResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.StartReplicationTaskAssessmentRunRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.StartReplicationTaskAssessmentRunResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.StartReplicationTaskRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.StartReplicationTaskResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.StopReplicationTaskRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.StopReplicationTaskResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.TestConnectionRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.TestConnectionResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.UpdateSubscriptionsToEventBridgeRequest
import aws.sdk.kotlin.services.databasemigrationservice.model.UpdateSubscriptionsToEventBridgeResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig
import kotlin.collections.List
import kotlin.jvm.JvmStatic

/**
 * # Database Migration Service
 * Database Migration Service (DMS) can migrate your data to and from the most widely used commercial and open-source databases such as Oracle, PostgreSQL, Microsoft SQL Server, Amazon Redshift, MariaDB, Amazon Aurora, MySQL, and SAP Adaptive Server Enterprise (ASE). The service supports homogeneous migrations such as Oracle to Oracle, as well as heterogeneous migrations between different database platforms, such as Oracle to MySQL or SQL Server to PostgreSQL.
 *
 * For more information about DMS, see [What Is Database Migration Service?](https://docs.aws.amazon.com/dms/latest/userguide/Welcome.html) in the *Database Migration Service User Guide.*
 */
public interface DatabaseMigrationClient : SdkClient {
    /**
     * DatabaseMigrationClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, DatabaseMigrationClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, DatabaseMigrationClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): DatabaseMigrationClient = DefaultDatabaseMigrationClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TracingClientConfig {
        override val clientName: String = builder.clientName
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, clientName)
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            tracer = this@Config.tracer
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TracingClientConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Database Migration Service"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [HttpAuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: EndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            override var tracer: Tracer? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Adds metadata tags to an DMS resource, including replication instance, endpoint, subnet group, and migration task. These tags can also be used with cost allocation reporting to track cost associated with DMS resources, or used in a Condition statement in an IAM policy for DMS. For more information, see `Tag`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html) data type description.
     */
    public suspend fun addTagsToResource(input: AddTagsToResourceRequest): AddTagsToResourceResponse

    /**
     * Applies a pending maintenance action to a resource (for example, to a replication instance).
     */
    public suspend fun applyPendingMaintenanceAction(input: ApplyPendingMaintenanceActionRequest): ApplyPendingMaintenanceActionResponse

    /**
     * Starts the analysis of up to 20 source databases to recommend target engines for each source database. This is a batch version of [StartRecommendations](https://docs.aws.amazon.com/dms/latest/APIReference/API_StartRecommendations.html).
     *
     * The result of analysis of each source database is reported individually in the response. Because the batch request can result in a combination of successful and unsuccessful actions, you should check for batch errors even when the call returns an HTTP status code of `200`.
     */
    public suspend fun batchStartRecommendations(input: BatchStartRecommendationsRequest = BatchStartRecommendationsRequest {}): BatchStartRecommendationsResponse

    /**
     * Cancels a single premigration assessment run.
     *
     * This operation prevents any individual assessments from running if they haven't started running. It also attempts to cancel any individual assessments that are currently running.
     */
    public suspend fun cancelReplicationTaskAssessmentRun(input: CancelReplicationTaskAssessmentRunRequest): CancelReplicationTaskAssessmentRunResponse

    /**
     * Creates an endpoint using the provided settings.
     *
     * For a MySQL source or target endpoint, don't explicitly specify the database using the `DatabaseName` request parameter on the `CreateEndpoint` API call. Specifying `DatabaseName` when you create a MySQL endpoint replicates all the task tables to this single database. For MySQL endpoints, you specify the database only when you specify the schema in the table-mapping rules of the DMS task.
     */
    public suspend fun createEndpoint(input: CreateEndpointRequest): CreateEndpointResponse

    /**
     * Creates an DMS event notification subscription.
     *
     * You can specify the type of source (`SourceType`) you want to be notified of, provide a list of DMS source IDs (`SourceIds`) that triggers the events, and provide a list of event categories (`EventCategories`) for events you want to be notified of. If you specify both the `SourceType` and `SourceIds`, such as `SourceType = replication-instance` and `SourceIdentifier = my-replinstance`, you will be notified of all the replication instance events for the specified source. If you specify a `SourceType` but don't specify a `SourceIdentifier`, you receive notice of the events for that source type for all your DMS sources. If you don't specify either `SourceType` nor `SourceIdentifier`, you will be notified of events generated from all DMS sources belonging to your customer account.
     *
     * For more information about DMS events, see [Working with Events and Notifications](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html) in the *Database Migration Service User Guide.*
     */
    public suspend fun createEventSubscription(input: CreateEventSubscriptionRequest): CreateEventSubscriptionResponse

    /**
     * Creates a Fleet Advisor collector using the specified parameters.
     */
    public suspend fun createFleetAdvisorCollector(input: CreateFleetAdvisorCollectorRequest): CreateFleetAdvisorCollectorResponse

    /**
     * Creates the replication instance using the specified parameters.
     *
     * DMS requires that your account have certain roles with appropriate permissions before you can create a replication instance. For information on the required roles, see [Creating the IAM Roles to Use With the CLI and DMS API](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.APIRole). For information on the required permissions, see [IAM Permissions Needed to Use DMS](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.IAMPermissions).
     */
    public suspend fun createReplicationInstance(input: CreateReplicationInstanceRequest): CreateReplicationInstanceResponse

    /**
     * Creates a replication subnet group given a list of the subnet IDs in a VPC.
     *
     * The VPC needs to have at least one subnet in at least two availability zones in the Amazon Web Services Region, otherwise the service will throw a `ReplicationSubnetGroupDoesNotCoverEnoughAZs` exception.
     */
    public suspend fun createReplicationSubnetGroup(input: CreateReplicationSubnetGroupRequest): CreateReplicationSubnetGroupResponse

    /**
     * Creates a replication task using the specified parameters.
     */
    public suspend fun createReplicationTask(input: CreateReplicationTaskRequest): CreateReplicationTaskResponse

    /**
     * Deletes the specified certificate.
     */
    public suspend fun deleteCertificate(input: DeleteCertificateRequest): DeleteCertificateResponse

    /**
     * Deletes the connection between a replication instance and an endpoint.
     */
    public suspend fun deleteConnection(input: DeleteConnectionRequest): DeleteConnectionResponse

    /**
     * Deletes the specified endpoint.
     *
     * All tasks associated with the endpoint must be deleted before you can delete the endpoint.
     */
    public suspend fun deleteEndpoint(input: DeleteEndpointRequest): DeleteEndpointResponse

    /**
     * Deletes an DMS event subscription.
     */
    public suspend fun deleteEventSubscription(input: DeleteEventSubscriptionRequest): DeleteEventSubscriptionResponse

    /**
     * Deletes the specified Fleet Advisor collector.
     */
    public suspend fun deleteFleetAdvisorCollector(input: DeleteFleetAdvisorCollectorRequest): DeleteFleetAdvisorCollectorResponse

    /**
     * Deletes the specified Fleet Advisor collector databases.
     */
    public suspend fun deleteFleetAdvisorDatabases(input: DeleteFleetAdvisorDatabasesRequest): DeleteFleetAdvisorDatabasesResponse

    /**
     * Deletes the specified replication instance.
     *
     * You must delete any migration tasks that are associated with the replication instance before you can delete it.
     */
    public suspend fun deleteReplicationInstance(input: DeleteReplicationInstanceRequest): DeleteReplicationInstanceResponse

    /**
     * Deletes a subnet group.
     */
    public suspend fun deleteReplicationSubnetGroup(input: DeleteReplicationSubnetGroupRequest): DeleteReplicationSubnetGroupResponse

    /**
     * Deletes the specified replication task.
     */
    public suspend fun deleteReplicationTask(input: DeleteReplicationTaskRequest): DeleteReplicationTaskResponse

    /**
     * Deletes the record of a single premigration assessment run.
     *
     * This operation removes all metadata that DMS maintains about this assessment run. However, the operation leaves untouched all information about this assessment run that is stored in your Amazon S3 bucket.
     */
    public suspend fun deleteReplicationTaskAssessmentRun(input: DeleteReplicationTaskAssessmentRunRequest): DeleteReplicationTaskAssessmentRunResponse

    /**
     * Lists all of the DMS attributes for a customer account. These attributes include DMS quotas for the account and a unique account identifier in a particular DMS region. DMS quotas include a list of resource quotas supported by the account, such as the number of replication instances allowed. The description for each resource quota, includes the quota name, current usage toward that quota, and the quota's maximum value. DMS uses the unique account identifier to name each artifact used by DMS in the given region.
     *
     * This command does not take any parameters.
     */
    public suspend fun describeAccountAttributes(input: DescribeAccountAttributesRequest = DescribeAccountAttributesRequest {}): DescribeAccountAttributesResponse

    /**
     * Provides a list of individual assessments that you can specify for a new premigration assessment run, given one or more parameters.
     *
     * If you specify an existing migration task, this operation provides the default individual assessments you can specify for that task. Otherwise, the specified parameters model elements of a possible migration task on which to base a premigration assessment run.
     *
     * To use these migration task modeling parameters, you must specify an existing replication instance, a source database engine, a target database engine, and a migration type. This combination of parameters potentially limits the default individual assessments available for an assessment run created for a corresponding migration task.
     *
     * If you specify no parameters, this operation provides a list of all possible individual assessments that you can specify for an assessment run. If you specify any one of the task modeling parameters, you must specify all of them or the operation cannot provide a list of individual assessments. The only parameter that you can specify alone is for an existing migration task. The specified task definition then determines the default list of individual assessments that you can specify in an assessment run for the task.
     */
    public suspend fun describeApplicableIndividualAssessments(input: DescribeApplicableIndividualAssessmentsRequest = DescribeApplicableIndividualAssessmentsRequest {}): DescribeApplicableIndividualAssessmentsResponse

    /**
     * Provides a description of the certificate.
     */
    public suspend fun describeCertificates(input: DescribeCertificatesRequest = DescribeCertificatesRequest {}): DescribeCertificatesResponse

    /**
     * Describes the status of the connections that have been made between the replication instance and an endpoint. Connections are created when you test an endpoint.
     */
    public suspend fun describeConnections(input: DescribeConnectionsRequest = DescribeConnectionsRequest {}): DescribeConnectionsResponse

    /**
     * Returns information about the possible endpoint settings available when you create an endpoint for a specific database engine.
     */
    public suspend fun describeEndpointSettings(input: DescribeEndpointSettingsRequest): DescribeEndpointSettingsResponse

    /**
     * Returns information about the type of endpoints available.
     */
    public suspend fun describeEndpointTypes(input: DescribeEndpointTypesRequest = DescribeEndpointTypesRequest {}): DescribeEndpointTypesResponse

    /**
     * Returns information about the endpoints for your account in the current region.
     */
    public suspend fun describeEndpoints(input: DescribeEndpointsRequest = DescribeEndpointsRequest {}): DescribeEndpointsResponse

    /**
     * Lists categories for all event source types, or, if specified, for a specified source type. You can see a list of the event categories and source types in [Working with Events and Notifications](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html) in the *Database Migration Service User Guide.*
     */
    public suspend fun describeEventCategories(input: DescribeEventCategoriesRequest = DescribeEventCategoriesRequest {}): DescribeEventCategoriesResponse

    /**
     * Lists all the event subscriptions for a customer account. The description of a subscription includes `SubscriptionName`, `SNSTopicARN`, `CustomerID`, `SourceType`, `SourceID`, `CreationTime`, and `Status`.
     *
     * If you specify `SubscriptionName`, this action lists the description for that subscription.
     */
    public suspend fun describeEventSubscriptions(input: DescribeEventSubscriptionsRequest = DescribeEventSubscriptionsRequest {}): DescribeEventSubscriptionsResponse

    /**
     * Lists events for a given source identifier and source type. You can also specify a start and end time. For more information on DMS events, see [Working with Events and Notifications](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html) in the *Database Migration Service User Guide.*
     */
    public suspend fun describeEvents(input: DescribeEventsRequest = DescribeEventsRequest {}): DescribeEventsResponse

    /**
     * Returns a list of the Fleet Advisor collectors in your account.
     */
    public suspend fun describeFleetAdvisorCollectors(input: DescribeFleetAdvisorCollectorsRequest = DescribeFleetAdvisorCollectorsRequest {}): DescribeFleetAdvisorCollectorsResponse

    /**
     * Returns a list of Fleet Advisor databases in your account.
     */
    public suspend fun describeFleetAdvisorDatabases(input: DescribeFleetAdvisorDatabasesRequest = DescribeFleetAdvisorDatabasesRequest {}): DescribeFleetAdvisorDatabasesResponse

    /**
     * Provides descriptions of large-scale assessment (LSA) analyses produced by your Fleet Advisor collectors.
     */
    public suspend fun describeFleetAdvisorLsaAnalysis(input: DescribeFleetAdvisorLsaAnalysisRequest = DescribeFleetAdvisorLsaAnalysisRequest {}): DescribeFleetAdvisorLsaAnalysisResponse

    /**
     * Provides descriptions of the schemas discovered by your Fleet Advisor collectors.
     */
    public suspend fun describeFleetAdvisorSchemaObjectSummary(input: DescribeFleetAdvisorSchemaObjectSummaryRequest = DescribeFleetAdvisorSchemaObjectSummaryRequest {}): DescribeFleetAdvisorSchemaObjectSummaryResponse

    /**
     * Returns a list of schemas detected by Fleet Advisor Collectors in your account.
     */
    public suspend fun describeFleetAdvisorSchemas(input: DescribeFleetAdvisorSchemasRequest = DescribeFleetAdvisorSchemasRequest {}): DescribeFleetAdvisorSchemasResponse

    /**
     * Returns information about the replication instance types that can be created in the specified region.
     */
    public suspend fun describeOrderableReplicationInstances(input: DescribeOrderableReplicationInstancesRequest = DescribeOrderableReplicationInstancesRequest {}): DescribeOrderableReplicationInstancesResponse

    /**
     * For internal use only
     */
    public suspend fun describePendingMaintenanceActions(input: DescribePendingMaintenanceActionsRequest = DescribePendingMaintenanceActionsRequest {}): DescribePendingMaintenanceActionsResponse

    /**
     * Returns a paginated list of limitations for recommendations of target Amazon Web Services engines.
     */
    public suspend fun describeRecommendationLimitations(input: DescribeRecommendationLimitationsRequest = DescribeRecommendationLimitationsRequest {}): DescribeRecommendationLimitationsResponse

    /**
     * Returns a paginated list of target engine recommendations for your source databases.
     */
    public suspend fun describeRecommendations(input: DescribeRecommendationsRequest = DescribeRecommendationsRequest {}): DescribeRecommendationsResponse

    /**
     * Returns the status of the RefreshSchemas operation.
     */
    public suspend fun describeRefreshSchemasStatus(input: DescribeRefreshSchemasStatusRequest): DescribeRefreshSchemasStatusResponse

    /**
     * Returns information about the task logs for the specified task.
     */
    public suspend fun describeReplicationInstanceTaskLogs(input: DescribeReplicationInstanceTaskLogsRequest): DescribeReplicationInstanceTaskLogsResponse

    /**
     * Returns information about replication instances for your account in the current region.
     */
    public suspend fun describeReplicationInstances(input: DescribeReplicationInstancesRequest = DescribeReplicationInstancesRequest {}): DescribeReplicationInstancesResponse

    /**
     * Returns information about the replication subnet groups.
     */
    public suspend fun describeReplicationSubnetGroups(input: DescribeReplicationSubnetGroupsRequest = DescribeReplicationSubnetGroupsRequest {}): DescribeReplicationSubnetGroupsResponse

    /**
     * Returns the task assessment results from the Amazon S3 bucket that DMS creates in your Amazon Web Services account. This action always returns the latest results.
     *
     * For more information about DMS task assessments, see [Creating a task assessment report](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html) in the *Database Migration Service User Guide*.
     */
    public suspend fun describeReplicationTaskAssessmentResults(input: DescribeReplicationTaskAssessmentResultsRequest = DescribeReplicationTaskAssessmentResultsRequest {}): DescribeReplicationTaskAssessmentResultsResponse

    /**
     * Returns a paginated list of premigration assessment runs based on filter settings.
     *
     * These filter settings can specify a combination of premigration assessment runs, migration tasks, replication instances, and assessment run status values.
     *
     * This operation doesn't return information about individual assessments. For this information, see the `DescribeReplicationTaskIndividualAssessments` operation.
     */
    public suspend fun describeReplicationTaskAssessmentRuns(input: DescribeReplicationTaskAssessmentRunsRequest = DescribeReplicationTaskAssessmentRunsRequest {}): DescribeReplicationTaskAssessmentRunsResponse

    /**
     * Returns a paginated list of individual assessments based on filter settings.
     *
     * These filter settings can specify a combination of premigration assessment runs, migration tasks, and assessment status values.
     */
    public suspend fun describeReplicationTaskIndividualAssessments(input: DescribeReplicationTaskIndividualAssessmentsRequest = DescribeReplicationTaskIndividualAssessmentsRequest {}): DescribeReplicationTaskIndividualAssessmentsResponse

    /**
     * Returns information about replication tasks for your account in the current region.
     */
    public suspend fun describeReplicationTasks(input: DescribeReplicationTasksRequest = DescribeReplicationTasksRequest {}): DescribeReplicationTasksResponse

    /**
     * Returns information about the schema for the specified endpoint.
     */
    public suspend fun describeSchemas(input: DescribeSchemasRequest): DescribeSchemasResponse

    /**
     * Returns table statistics on the database migration task, including table name, rows inserted, rows updated, and rows deleted.
     *
     * Note that the "last updated" column the DMS console only indicates the time that DMS last updated the table statistics record for a table. It does not indicate the time of the last update to the table.
     */
    public suspend fun describeTableStatistics(input: DescribeTableStatisticsRequest): DescribeTableStatisticsResponse

    /**
     * Uploads the specified certificate.
     */
    public suspend fun importCertificate(input: ImportCertificateRequest): ImportCertificateResponse

    /**
     * Lists all metadata tags attached to an DMS resource, including replication instance, endpoint, subnet group, and migration task. For more information, see `Tag`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html) data type description.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest = ListTagsForResourceRequest {}): ListTagsForResourceResponse

    /**
     * Modifies the specified endpoint.
     *
     * For a MySQL source or target endpoint, don't explicitly specify the database using the `DatabaseName` request parameter on the `ModifyEndpoint` API call. Specifying `DatabaseName` when you modify a MySQL endpoint replicates all the task tables to this single database. For MySQL endpoints, you specify the database only when you specify the schema in the table-mapping rules of the DMS task.
     */
    public suspend fun modifyEndpoint(input: ModifyEndpointRequest): ModifyEndpointResponse

    /**
     * Modifies an existing DMS event notification subscription.
     */
    public suspend fun modifyEventSubscription(input: ModifyEventSubscriptionRequest): ModifyEventSubscriptionResponse

    /**
     * Modifies the replication instance to apply new settings. You can change one or more parameters by specifying these parameters and the new values in the request.
     *
     * Some settings are applied during the maintenance window.
     */
    public suspend fun modifyReplicationInstance(input: ModifyReplicationInstanceRequest): ModifyReplicationInstanceResponse

    /**
     * Modifies the settings for the specified replication subnet group.
     */
    public suspend fun modifyReplicationSubnetGroup(input: ModifyReplicationSubnetGroupRequest): ModifyReplicationSubnetGroupResponse

    /**
     * Modifies the specified replication task.
     *
     * You can't modify the task endpoints. The task must be stopped before you can modify it.
     *
     * For more information about DMS tasks, see [Working with Migration Tasks](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html) in the *Database Migration Service User Guide*.
     */
    public suspend fun modifyReplicationTask(input: ModifyReplicationTaskRequest): ModifyReplicationTaskResponse

    /**
     * Moves a replication task from its current replication instance to a different target replication instance using the specified parameters. The target replication instance must be created with the same or later DMS version as the current replication instance.
     */
    public suspend fun moveReplicationTask(input: MoveReplicationTaskRequest): MoveReplicationTaskResponse

    /**
     * Reboots a replication instance. Rebooting results in a momentary outage, until the replication instance becomes available again.
     */
    public suspend fun rebootReplicationInstance(input: RebootReplicationInstanceRequest): RebootReplicationInstanceResponse

    /**
     * Populates the schema for the specified endpoint. This is an asynchronous operation and can take several minutes. You can check the status of this operation by calling the DescribeRefreshSchemasStatus operation.
     */
    public suspend fun refreshSchemas(input: RefreshSchemasRequest): RefreshSchemasResponse

    /**
     * Reloads the target database table with the source data.
     *
     * You can only use this operation with a task in the `RUNNING` state, otherwise the service will throw an `InvalidResourceStateFault` exception.
     */
    public suspend fun reloadTables(input: ReloadTablesRequest): ReloadTablesResponse

    /**
     * Removes metadata tags from an DMS resource, including replication instance, endpoint, subnet group, and migration task. For more information, see `Tag`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html) data type description.
     */
    public suspend fun removeTagsFromResource(input: RemoveTagsFromResourceRequest): RemoveTagsFromResourceResponse

    /**
     * Runs large-scale assessment (LSA) analysis on every Fleet Advisor collector in your account.
     */
    public suspend fun runFleetAdvisorLsaAnalysis(input: RunFleetAdvisorLsaAnalysisRequest = RunFleetAdvisorLsaAnalysisRequest {}): RunFleetAdvisorLsaAnalysisResponse

    /**
     * Starts the analysis of your source database to provide recommendations of target engines.
     *
     * You can create recommendations for multiple source databases using [BatchStartRecommendations](https://docs.aws.amazon.com/dms/latest/APIReference/API_BatchStartRecommendations.html).
     */
    public suspend fun startRecommendations(input: StartRecommendationsRequest): StartRecommendationsResponse

    /**
     * Starts the replication task.
     *
     * For more information about DMS tasks, see [Working with Migration Tasks ](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html) in the *Database Migration Service User Guide.*
     */
    public suspend fun startReplicationTask(input: StartReplicationTaskRequest): StartReplicationTaskResponse

    /**
     * Starts the replication task assessment for unsupported data types in the source database.
     *
     * You can only use this operation for a task if the following conditions are true:
     * + The task must be in the `stopped` state.
     * + The task must have successful connections to the source and target.
     *
     * If either of these conditions are not met, an `InvalidResourceStateFault` error will result.
     *
     * For information about DMS task assessments, see [Creating a task assessment report](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html) in the *Database Migration Service User Guide*.
     */
    public suspend fun startReplicationTaskAssessment(input: StartReplicationTaskAssessmentRequest): StartReplicationTaskAssessmentResponse

    /**
     * Starts a new premigration assessment run for one or more individual assessments of a migration task.
     *
     * The assessments that you can specify depend on the source and target database engine and the migration type defined for the given task. To run this operation, your migration task must already be created. After you run this operation, you can review the status of each individual assessment. You can also run the migration task manually after the assessment run and its individual assessments complete.
     */
    public suspend fun startReplicationTaskAssessmentRun(input: StartReplicationTaskAssessmentRunRequest): StartReplicationTaskAssessmentRunResponse

    /**
     * Stops the replication task.
     */
    public suspend fun stopReplicationTask(input: StopReplicationTaskRequest): StopReplicationTaskResponse

    /**
     * Tests the connection between the replication instance and the endpoint.
     */
    public suspend fun testConnection(input: TestConnectionRequest): TestConnectionResponse

    /**
     * Migrates 10 active and enabled Amazon SNS subscriptions at a time and converts them to corresponding Amazon EventBridge rules. By default, this operation migrates subscriptions only when all your replication instance versions are 3.4.6 or higher. If any replication instances are from versions earlier than 3.4.6, the operation raises an error and tells you to upgrade these instances to version 3.4.6 or higher. To enable migration regardless of version, set the `Force` option to true. However, if you don't upgrade instances earlier than version 3.4.6, some types of events might not be available when you use Amazon EventBridge.
     *
     * To call this operation, make sure that you have certain permissions added to your user account. For more information, see [Migrating event subscriptions to Amazon EventBridge](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html#CHAP_Events-migrate-to-eventbridge) in the *Amazon Web Services Database Migration Service User Guide*.
     */
    public suspend fun updateSubscriptionsToEventBridge(input: UpdateSubscriptionsToEventBridgeRequest = UpdateSubscriptionsToEventBridgeRequest {}): UpdateSubscriptionsToEventBridgeResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun DatabaseMigrationClient.withConfig(block: DatabaseMigrationClient.Config.Builder.() -> Unit): DatabaseMigrationClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultDatabaseMigrationClient(newConfig)
}

/**
 * Adds metadata tags to an DMS resource, including replication instance, endpoint, subnet group, and migration task. These tags can also be used with cost allocation reporting to track cost associated with DMS resources, or used in a Condition statement in an IAM policy for DMS. For more information, see `Tag`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html) data type description.
 */
public suspend inline fun DatabaseMigrationClient.addTagsToResource(crossinline block: AddTagsToResourceRequest.Builder.() -> Unit): AddTagsToResourceResponse = addTagsToResource(AddTagsToResourceRequest.Builder().apply(block).build())

/**
 * Applies a pending maintenance action to a resource (for example, to a replication instance).
 */
public suspend inline fun DatabaseMigrationClient.applyPendingMaintenanceAction(crossinline block: ApplyPendingMaintenanceActionRequest.Builder.() -> Unit): ApplyPendingMaintenanceActionResponse = applyPendingMaintenanceAction(ApplyPendingMaintenanceActionRequest.Builder().apply(block).build())

/**
 * Starts the analysis of up to 20 source databases to recommend target engines for each source database. This is a batch version of [StartRecommendations](https://docs.aws.amazon.com/dms/latest/APIReference/API_StartRecommendations.html).
 *
 * The result of analysis of each source database is reported individually in the response. Because the batch request can result in a combination of successful and unsuccessful actions, you should check for batch errors even when the call returns an HTTP status code of `200`.
 */
public suspend inline fun DatabaseMigrationClient.batchStartRecommendations(crossinline block: BatchStartRecommendationsRequest.Builder.() -> Unit): BatchStartRecommendationsResponse = batchStartRecommendations(BatchStartRecommendationsRequest.Builder().apply(block).build())

/**
 * Cancels a single premigration assessment run.
 *
 * This operation prevents any individual assessments from running if they haven't started running. It also attempts to cancel any individual assessments that are currently running.
 */
public suspend inline fun DatabaseMigrationClient.cancelReplicationTaskAssessmentRun(crossinline block: CancelReplicationTaskAssessmentRunRequest.Builder.() -> Unit): CancelReplicationTaskAssessmentRunResponse = cancelReplicationTaskAssessmentRun(CancelReplicationTaskAssessmentRunRequest.Builder().apply(block).build())

/**
 * Creates an endpoint using the provided settings.
 *
 * For a MySQL source or target endpoint, don't explicitly specify the database using the `DatabaseName` request parameter on the `CreateEndpoint` API call. Specifying `DatabaseName` when you create a MySQL endpoint replicates all the task tables to this single database. For MySQL endpoints, you specify the database only when you specify the schema in the table-mapping rules of the DMS task.
 */
public suspend inline fun DatabaseMigrationClient.createEndpoint(crossinline block: CreateEndpointRequest.Builder.() -> Unit): CreateEndpointResponse = createEndpoint(CreateEndpointRequest.Builder().apply(block).build())

/**
 * Creates an DMS event notification subscription.
 *
 * You can specify the type of source (`SourceType`) you want to be notified of, provide a list of DMS source IDs (`SourceIds`) that triggers the events, and provide a list of event categories (`EventCategories`) for events you want to be notified of. If you specify both the `SourceType` and `SourceIds`, such as `SourceType = replication-instance` and `SourceIdentifier = my-replinstance`, you will be notified of all the replication instance events for the specified source. If you specify a `SourceType` but don't specify a `SourceIdentifier`, you receive notice of the events for that source type for all your DMS sources. If you don't specify either `SourceType` nor `SourceIdentifier`, you will be notified of events generated from all DMS sources belonging to your customer account.
 *
 * For more information about DMS events, see [Working with Events and Notifications](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html) in the *Database Migration Service User Guide.*
 */
public suspend inline fun DatabaseMigrationClient.createEventSubscription(crossinline block: CreateEventSubscriptionRequest.Builder.() -> Unit): CreateEventSubscriptionResponse = createEventSubscription(CreateEventSubscriptionRequest.Builder().apply(block).build())

/**
 * Creates a Fleet Advisor collector using the specified parameters.
 */
public suspend inline fun DatabaseMigrationClient.createFleetAdvisorCollector(crossinline block: CreateFleetAdvisorCollectorRequest.Builder.() -> Unit): CreateFleetAdvisorCollectorResponse = createFleetAdvisorCollector(CreateFleetAdvisorCollectorRequest.Builder().apply(block).build())

/**
 * Creates the replication instance using the specified parameters.
 *
 * DMS requires that your account have certain roles with appropriate permissions before you can create a replication instance. For information on the required roles, see [Creating the IAM Roles to Use With the CLI and DMS API](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.APIRole). For information on the required permissions, see [IAM Permissions Needed to Use DMS](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.IAMPermissions).
 */
public suspend inline fun DatabaseMigrationClient.createReplicationInstance(crossinline block: CreateReplicationInstanceRequest.Builder.() -> Unit): CreateReplicationInstanceResponse = createReplicationInstance(CreateReplicationInstanceRequest.Builder().apply(block).build())

/**
 * Creates a replication subnet group given a list of the subnet IDs in a VPC.
 *
 * The VPC needs to have at least one subnet in at least two availability zones in the Amazon Web Services Region, otherwise the service will throw a `ReplicationSubnetGroupDoesNotCoverEnoughAZs` exception.
 */
public suspend inline fun DatabaseMigrationClient.createReplicationSubnetGroup(crossinline block: CreateReplicationSubnetGroupRequest.Builder.() -> Unit): CreateReplicationSubnetGroupResponse = createReplicationSubnetGroup(CreateReplicationSubnetGroupRequest.Builder().apply(block).build())

/**
 * Creates a replication task using the specified parameters.
 */
public suspend inline fun DatabaseMigrationClient.createReplicationTask(crossinline block: CreateReplicationTaskRequest.Builder.() -> Unit): CreateReplicationTaskResponse = createReplicationTask(CreateReplicationTaskRequest.Builder().apply(block).build())

/**
 * Deletes the specified certificate.
 */
public suspend inline fun DatabaseMigrationClient.deleteCertificate(crossinline block: DeleteCertificateRequest.Builder.() -> Unit): DeleteCertificateResponse = deleteCertificate(DeleteCertificateRequest.Builder().apply(block).build())

/**
 * Deletes the connection between a replication instance and an endpoint.
 */
public suspend inline fun DatabaseMigrationClient.deleteConnection(crossinline block: DeleteConnectionRequest.Builder.() -> Unit): DeleteConnectionResponse = deleteConnection(DeleteConnectionRequest.Builder().apply(block).build())

/**
 * Deletes the specified endpoint.
 *
 * All tasks associated with the endpoint must be deleted before you can delete the endpoint.
 */
public suspend inline fun DatabaseMigrationClient.deleteEndpoint(crossinline block: DeleteEndpointRequest.Builder.() -> Unit): DeleteEndpointResponse = deleteEndpoint(DeleteEndpointRequest.Builder().apply(block).build())

/**
 * Deletes an DMS event subscription.
 */
public suspend inline fun DatabaseMigrationClient.deleteEventSubscription(crossinline block: DeleteEventSubscriptionRequest.Builder.() -> Unit): DeleteEventSubscriptionResponse = deleteEventSubscription(DeleteEventSubscriptionRequest.Builder().apply(block).build())

/**
 * Deletes the specified Fleet Advisor collector.
 */
public suspend inline fun DatabaseMigrationClient.deleteFleetAdvisorCollector(crossinline block: DeleteFleetAdvisorCollectorRequest.Builder.() -> Unit): DeleteFleetAdvisorCollectorResponse = deleteFleetAdvisorCollector(DeleteFleetAdvisorCollectorRequest.Builder().apply(block).build())

/**
 * Deletes the specified Fleet Advisor collector databases.
 */
public suspend inline fun DatabaseMigrationClient.deleteFleetAdvisorDatabases(crossinline block: DeleteFleetAdvisorDatabasesRequest.Builder.() -> Unit): DeleteFleetAdvisorDatabasesResponse = deleteFleetAdvisorDatabases(DeleteFleetAdvisorDatabasesRequest.Builder().apply(block).build())

/**
 * Deletes the specified replication instance.
 *
 * You must delete any migration tasks that are associated with the replication instance before you can delete it.
 */
public suspend inline fun DatabaseMigrationClient.deleteReplicationInstance(crossinline block: DeleteReplicationInstanceRequest.Builder.() -> Unit): DeleteReplicationInstanceResponse = deleteReplicationInstance(DeleteReplicationInstanceRequest.Builder().apply(block).build())

/**
 * Deletes a subnet group.
 */
public suspend inline fun DatabaseMigrationClient.deleteReplicationSubnetGroup(crossinline block: DeleteReplicationSubnetGroupRequest.Builder.() -> Unit): DeleteReplicationSubnetGroupResponse = deleteReplicationSubnetGroup(DeleteReplicationSubnetGroupRequest.Builder().apply(block).build())

/**
 * Deletes the specified replication task.
 */
public suspend inline fun DatabaseMigrationClient.deleteReplicationTask(crossinline block: DeleteReplicationTaskRequest.Builder.() -> Unit): DeleteReplicationTaskResponse = deleteReplicationTask(DeleteReplicationTaskRequest.Builder().apply(block).build())

/**
 * Deletes the record of a single premigration assessment run.
 *
 * This operation removes all metadata that DMS maintains about this assessment run. However, the operation leaves untouched all information about this assessment run that is stored in your Amazon S3 bucket.
 */
public suspend inline fun DatabaseMigrationClient.deleteReplicationTaskAssessmentRun(crossinline block: DeleteReplicationTaskAssessmentRunRequest.Builder.() -> Unit): DeleteReplicationTaskAssessmentRunResponse = deleteReplicationTaskAssessmentRun(DeleteReplicationTaskAssessmentRunRequest.Builder().apply(block).build())

/**
 * Lists all of the DMS attributes for a customer account. These attributes include DMS quotas for the account and a unique account identifier in a particular DMS region. DMS quotas include a list of resource quotas supported by the account, such as the number of replication instances allowed. The description for each resource quota, includes the quota name, current usage toward that quota, and the quota's maximum value. DMS uses the unique account identifier to name each artifact used by DMS in the given region.
 *
 * This command does not take any parameters.
 */
public suspend inline fun DatabaseMigrationClient.describeAccountAttributes(crossinline block: DescribeAccountAttributesRequest.Builder.() -> Unit): DescribeAccountAttributesResponse = describeAccountAttributes(DescribeAccountAttributesRequest.Builder().apply(block).build())

/**
 * Provides a list of individual assessments that you can specify for a new premigration assessment run, given one or more parameters.
 *
 * If you specify an existing migration task, this operation provides the default individual assessments you can specify for that task. Otherwise, the specified parameters model elements of a possible migration task on which to base a premigration assessment run.
 *
 * To use these migration task modeling parameters, you must specify an existing replication instance, a source database engine, a target database engine, and a migration type. This combination of parameters potentially limits the default individual assessments available for an assessment run created for a corresponding migration task.
 *
 * If you specify no parameters, this operation provides a list of all possible individual assessments that you can specify for an assessment run. If you specify any one of the task modeling parameters, you must specify all of them or the operation cannot provide a list of individual assessments. The only parameter that you can specify alone is for an existing migration task. The specified task definition then determines the default list of individual assessments that you can specify in an assessment run for the task.
 */
public suspend inline fun DatabaseMigrationClient.describeApplicableIndividualAssessments(crossinline block: DescribeApplicableIndividualAssessmentsRequest.Builder.() -> Unit): DescribeApplicableIndividualAssessmentsResponse = describeApplicableIndividualAssessments(DescribeApplicableIndividualAssessmentsRequest.Builder().apply(block).build())

/**
 * Provides a description of the certificate.
 */
public suspend inline fun DatabaseMigrationClient.describeCertificates(crossinline block: DescribeCertificatesRequest.Builder.() -> Unit): DescribeCertificatesResponse = describeCertificates(DescribeCertificatesRequest.Builder().apply(block).build())

/**
 * Describes the status of the connections that have been made between the replication instance and an endpoint. Connections are created when you test an endpoint.
 */
public suspend inline fun DatabaseMigrationClient.describeConnections(crossinline block: DescribeConnectionsRequest.Builder.() -> Unit): DescribeConnectionsResponse = describeConnections(DescribeConnectionsRequest.Builder().apply(block).build())

/**
 * Returns information about the possible endpoint settings available when you create an endpoint for a specific database engine.
 */
public suspend inline fun DatabaseMigrationClient.describeEndpointSettings(crossinline block: DescribeEndpointSettingsRequest.Builder.() -> Unit): DescribeEndpointSettingsResponse = describeEndpointSettings(DescribeEndpointSettingsRequest.Builder().apply(block).build())

/**
 * Returns information about the type of endpoints available.
 */
public suspend inline fun DatabaseMigrationClient.describeEndpointTypes(crossinline block: DescribeEndpointTypesRequest.Builder.() -> Unit): DescribeEndpointTypesResponse = describeEndpointTypes(DescribeEndpointTypesRequest.Builder().apply(block).build())

/**
 * Returns information about the endpoints for your account in the current region.
 */
public suspend inline fun DatabaseMigrationClient.describeEndpoints(crossinline block: DescribeEndpointsRequest.Builder.() -> Unit): DescribeEndpointsResponse = describeEndpoints(DescribeEndpointsRequest.Builder().apply(block).build())

/**
 * Lists categories for all event source types, or, if specified, for a specified source type. You can see a list of the event categories and source types in [Working with Events and Notifications](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html) in the *Database Migration Service User Guide.*
 */
public suspend inline fun DatabaseMigrationClient.describeEventCategories(crossinline block: DescribeEventCategoriesRequest.Builder.() -> Unit): DescribeEventCategoriesResponse = describeEventCategories(DescribeEventCategoriesRequest.Builder().apply(block).build())

/**
 * Lists all the event subscriptions for a customer account. The description of a subscription includes `SubscriptionName`, `SNSTopicARN`, `CustomerID`, `SourceType`, `SourceID`, `CreationTime`, and `Status`.
 *
 * If you specify `SubscriptionName`, this action lists the description for that subscription.
 */
public suspend inline fun DatabaseMigrationClient.describeEventSubscriptions(crossinline block: DescribeEventSubscriptionsRequest.Builder.() -> Unit): DescribeEventSubscriptionsResponse = describeEventSubscriptions(DescribeEventSubscriptionsRequest.Builder().apply(block).build())

/**
 * Lists events for a given source identifier and source type. You can also specify a start and end time. For more information on DMS events, see [Working with Events and Notifications](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html) in the *Database Migration Service User Guide.*
 */
public suspend inline fun DatabaseMigrationClient.describeEvents(crossinline block: DescribeEventsRequest.Builder.() -> Unit): DescribeEventsResponse = describeEvents(DescribeEventsRequest.Builder().apply(block).build())

/**
 * Returns a list of the Fleet Advisor collectors in your account.
 */
public suspend inline fun DatabaseMigrationClient.describeFleetAdvisorCollectors(crossinline block: DescribeFleetAdvisorCollectorsRequest.Builder.() -> Unit): DescribeFleetAdvisorCollectorsResponse = describeFleetAdvisorCollectors(DescribeFleetAdvisorCollectorsRequest.Builder().apply(block).build())

/**
 * Returns a list of Fleet Advisor databases in your account.
 */
public suspend inline fun DatabaseMigrationClient.describeFleetAdvisorDatabases(crossinline block: DescribeFleetAdvisorDatabasesRequest.Builder.() -> Unit): DescribeFleetAdvisorDatabasesResponse = describeFleetAdvisorDatabases(DescribeFleetAdvisorDatabasesRequest.Builder().apply(block).build())

/**
 * Provides descriptions of large-scale assessment (LSA) analyses produced by your Fleet Advisor collectors.
 */
public suspend inline fun DatabaseMigrationClient.describeFleetAdvisorLsaAnalysis(crossinline block: DescribeFleetAdvisorLsaAnalysisRequest.Builder.() -> Unit): DescribeFleetAdvisorLsaAnalysisResponse = describeFleetAdvisorLsaAnalysis(DescribeFleetAdvisorLsaAnalysisRequest.Builder().apply(block).build())

/**
 * Provides descriptions of the schemas discovered by your Fleet Advisor collectors.
 */
public suspend inline fun DatabaseMigrationClient.describeFleetAdvisorSchemaObjectSummary(crossinline block: DescribeFleetAdvisorSchemaObjectSummaryRequest.Builder.() -> Unit): DescribeFleetAdvisorSchemaObjectSummaryResponse = describeFleetAdvisorSchemaObjectSummary(DescribeFleetAdvisorSchemaObjectSummaryRequest.Builder().apply(block).build())

/**
 * Returns a list of schemas detected by Fleet Advisor Collectors in your account.
 */
public suspend inline fun DatabaseMigrationClient.describeFleetAdvisorSchemas(crossinline block: DescribeFleetAdvisorSchemasRequest.Builder.() -> Unit): DescribeFleetAdvisorSchemasResponse = describeFleetAdvisorSchemas(DescribeFleetAdvisorSchemasRequest.Builder().apply(block).build())

/**
 * Returns information about the replication instance types that can be created in the specified region.
 */
public suspend inline fun DatabaseMigrationClient.describeOrderableReplicationInstances(crossinline block: DescribeOrderableReplicationInstancesRequest.Builder.() -> Unit): DescribeOrderableReplicationInstancesResponse = describeOrderableReplicationInstances(DescribeOrderableReplicationInstancesRequest.Builder().apply(block).build())

/**
 * For internal use only
 */
public suspend inline fun DatabaseMigrationClient.describePendingMaintenanceActions(crossinline block: DescribePendingMaintenanceActionsRequest.Builder.() -> Unit): DescribePendingMaintenanceActionsResponse = describePendingMaintenanceActions(DescribePendingMaintenanceActionsRequest.Builder().apply(block).build())

/**
 * Returns a paginated list of limitations for recommendations of target Amazon Web Services engines.
 */
public suspend inline fun DatabaseMigrationClient.describeRecommendationLimitations(crossinline block: DescribeRecommendationLimitationsRequest.Builder.() -> Unit): DescribeRecommendationLimitationsResponse = describeRecommendationLimitations(DescribeRecommendationLimitationsRequest.Builder().apply(block).build())

/**
 * Returns a paginated list of target engine recommendations for your source databases.
 */
public suspend inline fun DatabaseMigrationClient.describeRecommendations(crossinline block: DescribeRecommendationsRequest.Builder.() -> Unit): DescribeRecommendationsResponse = describeRecommendations(DescribeRecommendationsRequest.Builder().apply(block).build())

/**
 * Returns the status of the RefreshSchemas operation.
 */
public suspend inline fun DatabaseMigrationClient.describeRefreshSchemasStatus(crossinline block: DescribeRefreshSchemasStatusRequest.Builder.() -> Unit): DescribeRefreshSchemasStatusResponse = describeRefreshSchemasStatus(DescribeRefreshSchemasStatusRequest.Builder().apply(block).build())

/**
 * Returns information about the task logs for the specified task.
 */
public suspend inline fun DatabaseMigrationClient.describeReplicationInstanceTaskLogs(crossinline block: DescribeReplicationInstanceTaskLogsRequest.Builder.() -> Unit): DescribeReplicationInstanceTaskLogsResponse = describeReplicationInstanceTaskLogs(DescribeReplicationInstanceTaskLogsRequest.Builder().apply(block).build())

/**
 * Returns information about replication instances for your account in the current region.
 */
public suspend inline fun DatabaseMigrationClient.describeReplicationInstances(crossinline block: DescribeReplicationInstancesRequest.Builder.() -> Unit): DescribeReplicationInstancesResponse = describeReplicationInstances(DescribeReplicationInstancesRequest.Builder().apply(block).build())

/**
 * Returns information about the replication subnet groups.
 */
public suspend inline fun DatabaseMigrationClient.describeReplicationSubnetGroups(crossinline block: DescribeReplicationSubnetGroupsRequest.Builder.() -> Unit): DescribeReplicationSubnetGroupsResponse = describeReplicationSubnetGroups(DescribeReplicationSubnetGroupsRequest.Builder().apply(block).build())

/**
 * Returns the task assessment results from the Amazon S3 bucket that DMS creates in your Amazon Web Services account. This action always returns the latest results.
 *
 * For more information about DMS task assessments, see [Creating a task assessment report](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html) in the *Database Migration Service User Guide*.
 */
public suspend inline fun DatabaseMigrationClient.describeReplicationTaskAssessmentResults(crossinline block: DescribeReplicationTaskAssessmentResultsRequest.Builder.() -> Unit): DescribeReplicationTaskAssessmentResultsResponse = describeReplicationTaskAssessmentResults(DescribeReplicationTaskAssessmentResultsRequest.Builder().apply(block).build())

/**
 * Returns a paginated list of premigration assessment runs based on filter settings.
 *
 * These filter settings can specify a combination of premigration assessment runs, migration tasks, replication instances, and assessment run status values.
 *
 * This operation doesn't return information about individual assessments. For this information, see the `DescribeReplicationTaskIndividualAssessments` operation.
 */
public suspend inline fun DatabaseMigrationClient.describeReplicationTaskAssessmentRuns(crossinline block: DescribeReplicationTaskAssessmentRunsRequest.Builder.() -> Unit): DescribeReplicationTaskAssessmentRunsResponse = describeReplicationTaskAssessmentRuns(DescribeReplicationTaskAssessmentRunsRequest.Builder().apply(block).build())

/**
 * Returns a paginated list of individual assessments based on filter settings.
 *
 * These filter settings can specify a combination of premigration assessment runs, migration tasks, and assessment status values.
 */
public suspend inline fun DatabaseMigrationClient.describeReplicationTaskIndividualAssessments(crossinline block: DescribeReplicationTaskIndividualAssessmentsRequest.Builder.() -> Unit): DescribeReplicationTaskIndividualAssessmentsResponse = describeReplicationTaskIndividualAssessments(DescribeReplicationTaskIndividualAssessmentsRequest.Builder().apply(block).build())

/**
 * Returns information about replication tasks for your account in the current region.
 */
public suspend inline fun DatabaseMigrationClient.describeReplicationTasks(crossinline block: DescribeReplicationTasksRequest.Builder.() -> Unit): DescribeReplicationTasksResponse = describeReplicationTasks(DescribeReplicationTasksRequest.Builder().apply(block).build())

/**
 * Returns information about the schema for the specified endpoint.
 */
public suspend inline fun DatabaseMigrationClient.describeSchemas(crossinline block: DescribeSchemasRequest.Builder.() -> Unit): DescribeSchemasResponse = describeSchemas(DescribeSchemasRequest.Builder().apply(block).build())

/**
 * Returns table statistics on the database migration task, including table name, rows inserted, rows updated, and rows deleted.
 *
 * Note that the "last updated" column the DMS console only indicates the time that DMS last updated the table statistics record for a table. It does not indicate the time of the last update to the table.
 */
public suspend inline fun DatabaseMigrationClient.describeTableStatistics(crossinline block: DescribeTableStatisticsRequest.Builder.() -> Unit): DescribeTableStatisticsResponse = describeTableStatistics(DescribeTableStatisticsRequest.Builder().apply(block).build())

/**
 * Uploads the specified certificate.
 */
public suspend inline fun DatabaseMigrationClient.importCertificate(crossinline block: ImportCertificateRequest.Builder.() -> Unit): ImportCertificateResponse = importCertificate(ImportCertificateRequest.Builder().apply(block).build())

/**
 * Lists all metadata tags attached to an DMS resource, including replication instance, endpoint, subnet group, and migration task. For more information, see `Tag`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html) data type description.
 */
public suspend inline fun DatabaseMigrationClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Modifies the specified endpoint.
 *
 * For a MySQL source or target endpoint, don't explicitly specify the database using the `DatabaseName` request parameter on the `ModifyEndpoint` API call. Specifying `DatabaseName` when you modify a MySQL endpoint replicates all the task tables to this single database. For MySQL endpoints, you specify the database only when you specify the schema in the table-mapping rules of the DMS task.
 */
public suspend inline fun DatabaseMigrationClient.modifyEndpoint(crossinline block: ModifyEndpointRequest.Builder.() -> Unit): ModifyEndpointResponse = modifyEndpoint(ModifyEndpointRequest.Builder().apply(block).build())

/**
 * Modifies an existing DMS event notification subscription.
 */
public suspend inline fun DatabaseMigrationClient.modifyEventSubscription(crossinline block: ModifyEventSubscriptionRequest.Builder.() -> Unit): ModifyEventSubscriptionResponse = modifyEventSubscription(ModifyEventSubscriptionRequest.Builder().apply(block).build())

/**
 * Modifies the replication instance to apply new settings. You can change one or more parameters by specifying these parameters and the new values in the request.
 *
 * Some settings are applied during the maintenance window.
 */
public suspend inline fun DatabaseMigrationClient.modifyReplicationInstance(crossinline block: ModifyReplicationInstanceRequest.Builder.() -> Unit): ModifyReplicationInstanceResponse = modifyReplicationInstance(ModifyReplicationInstanceRequest.Builder().apply(block).build())

/**
 * Modifies the settings for the specified replication subnet group.
 */
public suspend inline fun DatabaseMigrationClient.modifyReplicationSubnetGroup(crossinline block: ModifyReplicationSubnetGroupRequest.Builder.() -> Unit): ModifyReplicationSubnetGroupResponse = modifyReplicationSubnetGroup(ModifyReplicationSubnetGroupRequest.Builder().apply(block).build())

/**
 * Modifies the specified replication task.
 *
 * You can't modify the task endpoints. The task must be stopped before you can modify it.
 *
 * For more information about DMS tasks, see [Working with Migration Tasks](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html) in the *Database Migration Service User Guide*.
 */
public suspend inline fun DatabaseMigrationClient.modifyReplicationTask(crossinline block: ModifyReplicationTaskRequest.Builder.() -> Unit): ModifyReplicationTaskResponse = modifyReplicationTask(ModifyReplicationTaskRequest.Builder().apply(block).build())

/**
 * Moves a replication task from its current replication instance to a different target replication instance using the specified parameters. The target replication instance must be created with the same or later DMS version as the current replication instance.
 */
public suspend inline fun DatabaseMigrationClient.moveReplicationTask(crossinline block: MoveReplicationTaskRequest.Builder.() -> Unit): MoveReplicationTaskResponse = moveReplicationTask(MoveReplicationTaskRequest.Builder().apply(block).build())

/**
 * Reboots a replication instance. Rebooting results in a momentary outage, until the replication instance becomes available again.
 */
public suspend inline fun DatabaseMigrationClient.rebootReplicationInstance(crossinline block: RebootReplicationInstanceRequest.Builder.() -> Unit): RebootReplicationInstanceResponse = rebootReplicationInstance(RebootReplicationInstanceRequest.Builder().apply(block).build())

/**
 * Populates the schema for the specified endpoint. This is an asynchronous operation and can take several minutes. You can check the status of this operation by calling the DescribeRefreshSchemasStatus operation.
 */
public suspend inline fun DatabaseMigrationClient.refreshSchemas(crossinline block: RefreshSchemasRequest.Builder.() -> Unit): RefreshSchemasResponse = refreshSchemas(RefreshSchemasRequest.Builder().apply(block).build())

/**
 * Reloads the target database table with the source data.
 *
 * You can only use this operation with a task in the `RUNNING` state, otherwise the service will throw an `InvalidResourceStateFault` exception.
 */
public suspend inline fun DatabaseMigrationClient.reloadTables(crossinline block: ReloadTablesRequest.Builder.() -> Unit): ReloadTablesResponse = reloadTables(ReloadTablesRequest.Builder().apply(block).build())

/**
 * Removes metadata tags from an DMS resource, including replication instance, endpoint, subnet group, and migration task. For more information, see `Tag`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html) data type description.
 */
public suspend inline fun DatabaseMigrationClient.removeTagsFromResource(crossinline block: RemoveTagsFromResourceRequest.Builder.() -> Unit): RemoveTagsFromResourceResponse = removeTagsFromResource(RemoveTagsFromResourceRequest.Builder().apply(block).build())

/**
 * Runs large-scale assessment (LSA) analysis on every Fleet Advisor collector in your account.
 */
public suspend inline fun DatabaseMigrationClient.runFleetAdvisorLsaAnalysis(crossinline block: RunFleetAdvisorLsaAnalysisRequest.Builder.() -> Unit): RunFleetAdvisorLsaAnalysisResponse = runFleetAdvisorLsaAnalysis(RunFleetAdvisorLsaAnalysisRequest.Builder().apply(block).build())

/**
 * Starts the analysis of your source database to provide recommendations of target engines.
 *
 * You can create recommendations for multiple source databases using [BatchStartRecommendations](https://docs.aws.amazon.com/dms/latest/APIReference/API_BatchStartRecommendations.html).
 */
public suspend inline fun DatabaseMigrationClient.startRecommendations(crossinline block: StartRecommendationsRequest.Builder.() -> Unit): StartRecommendationsResponse = startRecommendations(StartRecommendationsRequest.Builder().apply(block).build())

/**
 * Starts the replication task.
 *
 * For more information about DMS tasks, see [Working with Migration Tasks ](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html) in the *Database Migration Service User Guide.*
 */
public suspend inline fun DatabaseMigrationClient.startReplicationTask(crossinline block: StartReplicationTaskRequest.Builder.() -> Unit): StartReplicationTaskResponse = startReplicationTask(StartReplicationTaskRequest.Builder().apply(block).build())

/**
 * Starts the replication task assessment for unsupported data types in the source database.
 *
 * You can only use this operation for a task if the following conditions are true:
 * + The task must be in the `stopped` state.
 * + The task must have successful connections to the source and target.
 *
 * If either of these conditions are not met, an `InvalidResourceStateFault` error will result.
 *
 * For information about DMS task assessments, see [Creating a task assessment report](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html) in the *Database Migration Service User Guide*.
 */
public suspend inline fun DatabaseMigrationClient.startReplicationTaskAssessment(crossinline block: StartReplicationTaskAssessmentRequest.Builder.() -> Unit): StartReplicationTaskAssessmentResponse = startReplicationTaskAssessment(StartReplicationTaskAssessmentRequest.Builder().apply(block).build())

/**
 * Starts a new premigration assessment run for one or more individual assessments of a migration task.
 *
 * The assessments that you can specify depend on the source and target database engine and the migration type defined for the given task. To run this operation, your migration task must already be created. After you run this operation, you can review the status of each individual assessment. You can also run the migration task manually after the assessment run and its individual assessments complete.
 */
public suspend inline fun DatabaseMigrationClient.startReplicationTaskAssessmentRun(crossinline block: StartReplicationTaskAssessmentRunRequest.Builder.() -> Unit): StartReplicationTaskAssessmentRunResponse = startReplicationTaskAssessmentRun(StartReplicationTaskAssessmentRunRequest.Builder().apply(block).build())

/**
 * Stops the replication task.
 */
public suspend inline fun DatabaseMigrationClient.stopReplicationTask(crossinline block: StopReplicationTaskRequest.Builder.() -> Unit): StopReplicationTaskResponse = stopReplicationTask(StopReplicationTaskRequest.Builder().apply(block).build())

/**
 * Tests the connection between the replication instance and the endpoint.
 */
public suspend inline fun DatabaseMigrationClient.testConnection(crossinline block: TestConnectionRequest.Builder.() -> Unit): TestConnectionResponse = testConnection(TestConnectionRequest.Builder().apply(block).build())

/**
 * Migrates 10 active and enabled Amazon SNS subscriptions at a time and converts them to corresponding Amazon EventBridge rules. By default, this operation migrates subscriptions only when all your replication instance versions are 3.4.6 or higher. If any replication instances are from versions earlier than 3.4.6, the operation raises an error and tells you to upgrade these instances to version 3.4.6 or higher. To enable migration regardless of version, set the `Force` option to true. However, if you don't upgrade instances earlier than version 3.4.6, some types of events might not be available when you use Amazon EventBridge.
 *
 * To call this operation, make sure that you have certain permissions added to your user account. For more information, see [Migrating event subscriptions to Amazon EventBridge](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html#CHAP_Events-migrate-to-eventbridge) in the *Amazon Web Services Database Migration Service User Guide*.
 */
public suspend inline fun DatabaseMigrationClient.updateSubscriptionsToEventBridge(crossinline block: UpdateSubscriptionsToEventBridgeRequest.Builder.() -> Unit): UpdateSubscriptionsToEventBridgeResponse = updateSubscriptionsToEventBridge(UpdateSubscriptionsToEventBridgeRequest.Builder().apply(block).build())
