// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.serde

import aws.sdk.kotlin.services.databasemigrationservice.model.DatabaseMigrationException
import aws.sdk.kotlin.services.databasemigrationservice.model.StartRecommendationsResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class StartRecommendationsOperationDeserializer: HttpDeserializer.NonStreaming<StartRecommendationsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): StartRecommendationsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwStartRecommendationsError(context, call, payload)
        }
        val builder = StartRecommendationsResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwStartRecommendationsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DatabaseMigrationException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidResourceStateFault" -> InvalidResourceStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundFault" -> ResourceNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedFault" -> AccessDeniedFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> DatabaseMigrationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
