// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides information that defines a SAP ASE endpoint.
 */
public class SybaseSettings private constructor(builder: Builder) {
    /**
     * Database name for the endpoint.
     */
    public val databaseName: kotlin.String? = builder.databaseName
    /**
     * Endpoint connection password.
     */
    public val password: kotlin.String? = builder.password
    /**
     * Endpoint TCP port. The default is 5000.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the trusted entity and grants the required permissions to access the value in `SecretsManagerSecret`. The role must allow the `iam:PassRole` action. `SecretsManagerSecret` has the value of the Amazon Web Services Secrets Manager secret that allows access to the SAP ASE endpoint.
     *
     * You can specify one of two sets of values for these permissions. You can specify the values for this setting and `SecretsManagerSecretId`. Or you can specify clear-text values for `UserName`, `Password`, `ServerName`, and `Port`. You can't specify both. For more information on creating this `SecretsManagerSecret` and the `SecretsManagerAccessRoleArn` and `SecretsManagerSecretId` required to access it, see [Using secrets to access Database Migration Service resources](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager) in the *Database Migration Service User Guide*.
     */
    public val secretsManagerAccessRoleArn: kotlin.String? = builder.secretsManagerAccessRoleArn
    /**
     * The full ARN, partial ARN, or friendly name of the `SecretsManagerSecret` that contains the SAP SAE endpoint connection details.
     */
    public val secretsManagerSecretId: kotlin.String? = builder.secretsManagerSecretId
    /**
     * Fully qualified domain name of the endpoint.
     */
    public val serverName: kotlin.String? = builder.serverName
    /**
     * Endpoint connection user name.
     */
    public val username: kotlin.String? = builder.username

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.SybaseSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SybaseSettings(")
        append("databaseName=$databaseName,")
        append("password=*** Sensitive Data Redacted ***,")
        append("port=$port,")
        append("secretsManagerAccessRoleArn=$secretsManagerAccessRoleArn,")
        append("secretsManagerSecretId=$secretsManagerSecretId,")
        append("serverName=$serverName,")
        append("username=$username")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = databaseName?.hashCode() ?: 0
        result = 31 * result + (password?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (secretsManagerAccessRoleArn?.hashCode() ?: 0)
        result = 31 * result + (secretsManagerSecretId?.hashCode() ?: 0)
        result = 31 * result + (serverName?.hashCode() ?: 0)
        result = 31 * result + (username?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SybaseSettings

        if (databaseName != other.databaseName) return false
        if (password != other.password) return false
        if (port != other.port) return false
        if (secretsManagerAccessRoleArn != other.secretsManagerAccessRoleArn) return false
        if (secretsManagerSecretId != other.secretsManagerSecretId) return false
        if (serverName != other.serverName) return false
        if (username != other.username) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.SybaseSettings = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Database name for the endpoint.
         */
        public var databaseName: kotlin.String? = null
        /**
         * Endpoint connection password.
         */
        public var password: kotlin.String? = null
        /**
         * Endpoint TCP port. The default is 5000.
         */
        public var port: kotlin.Int? = null
        /**
         * The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the trusted entity and grants the required permissions to access the value in `SecretsManagerSecret`. The role must allow the `iam:PassRole` action. `SecretsManagerSecret` has the value of the Amazon Web Services Secrets Manager secret that allows access to the SAP ASE endpoint.
         *
         * You can specify one of two sets of values for these permissions. You can specify the values for this setting and `SecretsManagerSecretId`. Or you can specify clear-text values for `UserName`, `Password`, `ServerName`, and `Port`. You can't specify both. For more information on creating this `SecretsManagerSecret` and the `SecretsManagerAccessRoleArn` and `SecretsManagerSecretId` required to access it, see [Using secrets to access Database Migration Service resources](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager) in the *Database Migration Service User Guide*.
         */
        public var secretsManagerAccessRoleArn: kotlin.String? = null
        /**
         * The full ARN, partial ARN, or friendly name of the `SecretsManagerSecret` that contains the SAP SAE endpoint connection details.
         */
        public var secretsManagerSecretId: kotlin.String? = null
        /**
         * Fully qualified domain name of the endpoint.
         */
        public var serverName: kotlin.String? = null
        /**
         * Endpoint connection user name.
         */
        public var username: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.SybaseSettings) : this() {
            this.databaseName = x.databaseName
            this.password = x.password
            this.port = x.port
            this.secretsManagerAccessRoleArn = x.secretsManagerAccessRoleArn
            this.secretsManagerSecretId = x.secretsManagerSecretId
            this.serverName = x.serverName
            this.username = x.username
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.SybaseSettings = SybaseSettings(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
