// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Settings for exporting data to Amazon S3.
 */
public class S3Settings private constructor(builder: Builder) {
    /**
     * An optional parameter that, when set to `true` or `y`, you can use to add column name information to the .csv output file.
     *
     * The default value is `false`. Valid values are `true`, `false`, `y`, and `n`.
     */
    public val addColumnName: kotlin.Boolean? = builder.addColumnName
    /**
     * Use the S3 target endpoint setting `AddTrailingPaddingCharacter` to add padding on string data. The default value is `false`.
     */
    public val addTrailingPaddingCharacter: kotlin.Boolean? = builder.addTrailingPaddingCharacter
    /**
     * An optional parameter to set a folder name in the S3 bucket. If provided, tables are created in the path ` <i>bucketFolder</i>/<i>schema_name</i>/<i>table_name</i>/`. If this parameter isn't specified, then the path used is ` <i>schema_name</i>/<i>table_name</i>/`.
     */
    public val bucketFolder: kotlin.String? = builder.bucketFolder
    /**
     * The name of the S3 bucket.
     */
    public val bucketName: kotlin.String? = builder.bucketName
    /**
     * A value that enables DMS to specify a predefined (canned) access control list for objects created in an Amazon S3 bucket as .csv or .parquet files. For more information about Amazon S3 canned ACLs, see [Canned ACL](http://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) in the *Amazon S3 Developer Guide.*
     *
     * The default value is NONE. Valid values include NONE, PRIVATE, PUBLIC_READ, PUBLIC_READ_WRITE, AUTHENTICATED_READ, AWS_EXEC_READ, BUCKET_OWNER_READ, and BUCKET_OWNER_FULL_CONTROL.
     */
    public val cannedAclForObjects: aws.sdk.kotlin.services.databasemigrationservice.model.CannedAclForObjectsValue? = builder.cannedAclForObjects
    /**
     * A value that enables a change data capture (CDC) load to write INSERT and UPDATE operations to .csv or .parquet (columnar storage) output files. The default setting is `false`, but when `CdcInsertsAndUpdates` is set to `true` or `y`, only INSERTs and UPDATEs from the source database are migrated to the .csv or .parquet file.
     *
     * DMS supports the use of the .parquet files in versions 3.4.7 and later.
     *
     * How these INSERTs and UPDATEs are recorded depends on the value of the `IncludeOpForFullLoad` parameter. If `IncludeOpForFullLoad` is set to `true`, the first field of every CDC record is set to either `I` or `U` to indicate INSERT and UPDATE operations at the source. But if `IncludeOpForFullLoad` is set to `false`, CDC records are written without an indication of INSERT or UPDATE operations at the source. For more information about how these settings work together, see [Indicating Source DB Operations in Migrated S3 Data](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps) in the *Database Migration Service User Guide.*.
     *
     * DMS supports the use of the `CdcInsertsAndUpdates` parameter in versions 3.3.1 and later.
     *
     * `CdcInsertsOnly` and `CdcInsertsAndUpdates` can't both be set to `true` for the same endpoint. Set either `CdcInsertsOnly` or `CdcInsertsAndUpdates` to `true` for the same endpoint, but not both.
     */
    public val cdcInsertsAndUpdates: kotlin.Boolean? = builder.cdcInsertsAndUpdates
    /**
     * A value that enables a change data capture (CDC) load to write only INSERT operations to .csv or columnar storage (.parquet) output files. By default (the `false` setting), the first field in a .csv or .parquet record contains the letter I (INSERT), U (UPDATE), or D (DELETE). These values indicate whether the row was inserted, updated, or deleted at the source database for a CDC load to the target.
     *
     * If `CdcInsertsOnly` is set to `true` or `y`, only INSERTs from the source database are migrated to the .csv or .parquet file. For .csv format only, how these INSERTs are recorded depends on the value of `IncludeOpForFullLoad`. If `IncludeOpForFullLoad` is set to `true`, the first field of every CDC record is set to I to indicate the INSERT operation at the source. If `IncludeOpForFullLoad` is set to `false`, every CDC record is written without a first field to indicate the INSERT operation at the source. For more information about how these settings work together, see [Indicating Source DB Operations in Migrated S3 Data](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps) in the *Database Migration Service User Guide.*.
     *
     * DMS supports the interaction described preceding between the `CdcInsertsOnly` and `IncludeOpForFullLoad` parameters in versions 3.1.4 and later.
     *
     * `CdcInsertsOnly` and `CdcInsertsAndUpdates` can't both be set to `true` for the same endpoint. Set either `CdcInsertsOnly` or `CdcInsertsAndUpdates` to `true` for the same endpoint, but not both.
     */
    public val cdcInsertsOnly: kotlin.Boolean? = builder.cdcInsertsOnly
    /**
     * Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3.
     *
     * When `CdcMaxBatchInterval` and `CdcMinFileSize` are both specified, the file write is triggered by whichever parameter condition is met first within an DMS CloudFormation template.
     *
     * The default value is 60 seconds.
     */
    public val cdcMaxBatchInterval: kotlin.Int? = builder.cdcMaxBatchInterval
    /**
     * Minimum file size, defined in kilobytes, to reach for a file output to Amazon S3.
     *
     * When `CdcMinFileSize` and `CdcMaxBatchInterval` are both specified, the file write is triggered by whichever parameter condition is met first within an DMS CloudFormation template.
     *
     * The default value is 32 MB.
     */
    public val cdcMinFileSize: kotlin.Int? = builder.cdcMinFileSize
    /**
     * Specifies the folder path of CDC files. For an S3 source, this setting is required if a task captures change data; otherwise, it's optional. If `CdcPath` is set, DMS reads CDC files from this path and replicates the data changes to the target endpoint. For an S3 target if you set `PreserveTransactions`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-PreserveTransactions) to `true`, DMS verifies that you have set this parameter to a folder path on your S3 target where DMS can save the transaction order for the CDC load. DMS creates this CDC folder path in either your S3 target working directory or the S3 target location specified by `BucketFolder`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-BucketFolder) and `BucketName`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-BucketName).
     *
     * For example, if you specify `CdcPath` as `MyChangedData`, and you specify `BucketName` as `MyTargetBucket` but do not specify `BucketFolder`, DMS creates the CDC folder path following: `MyTargetBucket/MyChangedData`.
     *
     * If you specify the same `CdcPath`, and you specify `BucketName` as `MyTargetBucket` and `BucketFolder` as `MyTargetData`, DMS creates the CDC folder path following: `MyTargetBucket/MyTargetData/MyChangedData`.
     *
     * For more information on CDC including transaction order on an S3 target, see [Capturing data changes (CDC) including transaction order on the S3 target](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.EndpointSettings.CdcPath).
     *
     * This setting is supported in DMS versions 3.4.2 and later.
     */
    public val cdcPath: kotlin.String? = builder.cdcPath
    /**
     * An optional parameter to use GZIP to compress the target files. Set to GZIP to compress the target files. Either set this parameter to NONE (the default) or don't use it to leave the files uncompressed. This parameter applies to both .csv and .parquet file formats.
     */
    public val compressionType: aws.sdk.kotlin.services.databasemigrationservice.model.CompressionTypeValue? = builder.compressionType
    /**
     * The delimiter used to separate columns in the .csv file for both source and target. The default is a comma.
     */
    public val csvDelimiter: kotlin.String? = builder.csvDelimiter
    /**
     * This setting only applies if your Amazon S3 output files during a change data capture (CDC) load are written in .csv format. If `UseCsvNoSupValue`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-UseCsvNoSupValue) is set to true, specify a string value that you want DMS to use for all columns not included in the supplemental log. If you do not specify a string value, DMS uses the null value for these columns regardless of the `UseCsvNoSupValue` setting.
     *
     * This setting is supported in DMS versions 3.4.1 and later.
     */
    public val csvNoSupValue: kotlin.String? = builder.csvNoSupValue
    /**
     * An optional parameter that specifies how DMS treats null values. While handling the null value, you can use this parameter to pass a user-defined string as null when writing to the target. For example, when target columns are nullable, you can use this option to differentiate between the empty string value and the null value. So, if you set this parameter value to the empty string ("" or ''), DMS treats the empty string as the null value instead of `NULL`.
     *
     * The default value is `NULL`. Valid values include any valid string.
     */
    public val csvNullValue: kotlin.String? = builder.csvNullValue
    /**
     * The delimiter used to separate rows in the .csv file for both source and target. The default is a carriage return (`\n`).
     */
    public val csvRowDelimiter: kotlin.String? = builder.csvRowDelimiter
    /**
     * The format of the data that you want to use for output. You can choose one of the following:
     * + `csv` : This is a row-based file format with comma-separated values (.csv).
     * + `parquet` : Apache Parquet (.parquet) is a columnar storage file format that features efficient compression and provides faster query response.
     */
    public val dataFormat: aws.sdk.kotlin.services.databasemigrationservice.model.DataFormatValue? = builder.dataFormat
    /**
     * The size of one data page in bytes. This parameter defaults to 1024 * 1024 bytes (1 MiB). This number is used for .parquet file format only.
     */
    public val dataPageSize: kotlin.Int? = builder.dataPageSize
    /**
     * Specifies a date separating delimiter to use during folder partitioning. The default value is `SLASH`. Use this parameter when `DatePartitionedEnabled` is set to `true`.
     */
    public val datePartitionDelimiter: aws.sdk.kotlin.services.databasemigrationservice.model.DatePartitionDelimiterValue? = builder.datePartitionDelimiter
    /**
     * When set to `true`, this parameter partitions S3 bucket folders based on transaction commit dates. The default value is `false`. For more information about date-based folder partitioning, see [Using date-based folder partitioning](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.DatePartitioning).
     */
    public val datePartitionEnabled: kotlin.Boolean? = builder.datePartitionEnabled
    /**
     * Identifies the sequence of the date format to use during folder partitioning. The default value is `YYYYMMDD`. Use this parameter when `DatePartitionedEnabled` is set to `true`.
     */
    public val datePartitionSequence: aws.sdk.kotlin.services.databasemigrationservice.model.DatePartitionSequenceValue? = builder.datePartitionSequence
    /**
     * When creating an S3 target endpoint, set `DatePartitionTimezone` to convert the current UTC time into a specified time zone. The conversion occurs when a date partition folder is created and a CDC filename is generated. The time zone format is Area/Location. Use this parameter when `DatePartitionedEnabled` is set to `true`, as shown in the following example.
     *
     * `s3-settings='{"DatePartitionEnabled": true, "DatePartitionSequence": "YYYYMMDDHH", "DatePartitionDelimiter": "SLASH", "DatePartitionTimezone":"<i>Asia/Seoul</i>", "BucketName": "dms-nattarat-test"}'`
     */
    public val datePartitionTimezone: kotlin.String? = builder.datePartitionTimezone
    /**
     * The maximum size of an encoded dictionary page of a column. If the dictionary page exceeds this, this column is stored using an encoding type of `PLAIN`. This parameter defaults to 1024 * 1024 bytes (1 MiB), the maximum size of a dictionary page before it reverts to `PLAIN` encoding. This size is used for .parquet file format only.
     */
    public val dictPageSizeLimit: kotlin.Int? = builder.dictPageSizeLimit
    /**
     * A value that enables statistics for Parquet pages and row groups. Choose `true` to enable statistics, `false` to disable. Statistics include `NULL`, `DISTINCT`, `MAX`, and `MIN` values. This parameter defaults to `true`. This value is used for .parquet file format only.
     */
    public val enableStatistics: kotlin.Boolean? = builder.enableStatistics
    /**
     * The type of encoding you are using:
     * + `RLE_DICTIONARY` uses a combination of bit-packing and run-length encoding to store repeated values more efficiently. This is the default.
     * + `PLAIN` doesn't use encoding at all. Values are stored as they are.
     * + `PLAIN_DICTIONARY` builds a dictionary of the values encountered in a given column. The dictionary is stored in a dictionary page for each column chunk.
     */
    public val encodingType: aws.sdk.kotlin.services.databasemigrationservice.model.EncodingTypeValue? = builder.encodingType
    /**
     * The type of server-side encryption that you want to use for your data. This encryption type is part of the endpoint settings or the extra connections attributes for Amazon S3. You can choose either `SSE_S3` (the default) or `SSE_KMS`.
     *
     * For the `ModifyEndpoint` operation, you can change the existing value of the `EncryptionMode` parameter from `SSE_KMS` to `SSE_S3`. But you can’t change the existing value from `SSE_S3` to `SSE_KMS`.
     *
     * To use `SSE_S3`, you need an Identity and Access Management (IAM) role with permission to allow `"arn:aws:s3:::dms-*"` to use the following actions:
     * + `s3:CreateBucket`
     * + `s3:ListBucket`
     * + `s3:DeleteBucket`
     * + `s3:GetBucketLocation`
     * + `s3:GetObject`
     * + `s3:PutObject`
     * + `s3:DeleteObject`
     * + `s3:GetObjectVersion`
     * + `s3:GetBucketPolicy`
     * + `s3:PutBucketPolicy`
     * + `s3:DeleteBucketPolicy`
     */
    public val encryptionMode: aws.sdk.kotlin.services.databasemigrationservice.model.EncryptionModeValue? = builder.encryptionMode
    /**
     * To specify a bucket owner and prevent sniping, you can use the `ExpectedBucketOwner` endpoint setting.
     *
     * Example: `--s3-settings='{"ExpectedBucketOwner": "<i>AWS_Account_ID</i>"}'`
     *
     * When you make a request to test a connection or perform a migration, S3 checks the account ID of the bucket owner against the specified parameter.
     */
    public val expectedBucketOwner: kotlin.String? = builder.expectedBucketOwner
    /**
     * Specifies how tables are defined in the S3 source files only.
     */
    public val externalTableDefinition: kotlin.String? = builder.externalTableDefinition
    /**
     * When true, allows Glue to catalog your S3 bucket. Creating an Glue catalog lets you use Athena to query your data.
     */
    public val glueCatalogGeneration: kotlin.Boolean? = builder.glueCatalogGeneration
    /**
     * When this value is set to 1, DMS ignores the first row header in a .csv file. A value of 1 turns on the feature; a value of 0 turns off the feature.
     *
     * The default is 0.
     */
    public val ignoreHeaderRows: kotlin.Int? = builder.ignoreHeaderRows
    /**
     * A value that enables a full load to write INSERT operations to the comma-separated value (.csv) or .parquet output files only to indicate how the rows were added to the source database.
     *
     * DMS supports the `IncludeOpForFullLoad` parameter in versions 3.1.4 and later.
     *
     * DMS supports the use of the .parquet files with the `IncludeOpForFullLoad` parameter in versions 3.4.7 and later.
     *
     * For full load, records can only be inserted. By default (the `false` setting), no information is recorded in these output files for a full load to indicate that the rows were inserted at the source database. If `IncludeOpForFullLoad` is set to `true` or `y`, the INSERT is recorded as an I annotation in the first field of the .csv file. This allows the format of your target records from a full load to be consistent with the target records from a CDC load.
     *
     * This setting works together with the `CdcInsertsOnly` and the `CdcInsertsAndUpdates` parameters for output to .csv files only. For more information about how these settings work together, see [Indicating Source DB Operations in Migrated S3 Data](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps) in the *Database Migration Service User Guide.*.
     */
    public val includeOpForFullLoad: kotlin.Boolean? = builder.includeOpForFullLoad
    /**
     * A value that specifies the maximum size (in KB) of any .csv file to be created while migrating to an S3 target during full load.
     *
     * The default value is 1,048,576 KB (1 GB). Valid values include 1 to 1,048,576.
     */
    public val maxFileSize: kotlin.Int? = builder.maxFileSize
    /**
     * A value that specifies the precision of any `TIMESTAMP` column values that are written to an Amazon S3 object file in .parquet format.
     *
     * DMS supports the `ParquetTimestampInMillisecond` parameter in versions 3.1.4 and later.
     *
     * When `ParquetTimestampInMillisecond` is set to `true` or `y`, DMS writes all `TIMESTAMP` columns in a .parquet formatted file with millisecond precision. Otherwise, DMS writes them with microsecond precision.
     *
     * Currently, Amazon Athena and Glue can handle only millisecond precision for `TIMESTAMP` values. Set this parameter to `true` for S3 endpoint object files that are .parquet formatted only if you plan to query or process the data with Athena or Glue.
     *
     * DMS writes any `TIMESTAMP` column values written to an S3 file in .csv format with microsecond precision.
     *
     * Setting `ParquetTimestampInMillisecond` has no effect on the string format of the timestamp column value that is inserted by setting the `TimestampColumnName` parameter.
     */
    public val parquetTimestampInMillisecond: kotlin.Boolean? = builder.parquetTimestampInMillisecond
    /**
     * The version of the Apache Parquet format that you want to use: `parquet_1_0` (the default) or `parquet_2_0`.
     */
    public val parquetVersion: aws.sdk.kotlin.services.databasemigrationservice.model.ParquetVersionValue? = builder.parquetVersion
    /**
     * If set to `true`, DMS saves the transaction order for a change data capture (CDC) load on the Amazon S3 target specified by `CdcPath`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-CdcPath). For more information, see [Capturing data changes (CDC) including transaction order on the S3 target](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.EndpointSettings.CdcPath).
     *
     * This setting is supported in DMS versions 3.4.2 and later.
     */
    public val preserveTransactions: kotlin.Boolean? = builder.preserveTransactions
    /**
     * For an S3 source, when this value is set to `true` or `y`, each leading double quotation mark has to be followed by an ending double quotation mark. This formatting complies with RFC 4180. When this value is set to `false` or `n`, string literals are copied to the target as is. In this case, a delimiter (row or column) signals the end of the field. Thus, you can't use a delimiter as part of the string, because it signals the end of the value.
     *
     * For an S3 target, an optional parameter used to set behavior to comply with RFC 4180 for data migrated to Amazon S3 using .csv file format only. When this value is set to `true` or `y` using Amazon S3 as a target, if the data has quotation marks or newline characters in it, DMS encloses the entire column with an additional pair of double quotation marks ("). Every quotation mark within the data is repeated twice.
     *
     * The default value is `true`. Valid values include `true`, `false`, `y`, and `n`.
     */
    public val rfc4180: kotlin.Boolean? = builder.rfc4180
    /**
     * The number of rows in a row group. A smaller row group size provides faster reads. But as the number of row groups grows, the slower writes become. This parameter defaults to 10,000 rows. This number is used for .parquet file format only.
     *
     * If you choose a value larger than the maximum, `RowGroupLength` is set to the max row group length in bytes (64 * 1024 * 1024).
     */
    public val rowGroupLength: kotlin.Int? = builder.rowGroupLength
    /**
     * If you are using `SSE_KMS` for the `EncryptionMode`, provide the KMS key ID. The key that you use needs an attached policy that enables Identity and Access Management (IAM) user permissions and allows use of the key.
     *
     * Here is a CLI example: `aws dms create-endpoint --endpoint-identifier <i>value</i> --endpoint-type target --engine-name s3 --s3-settings ServiceAccessRoleArn=<i>value</i>,BucketFolder=<i>value</i>,BucketName=<i>value</i>,EncryptionMode=SSE_KMS,ServerSideEncryptionKmsKeyId=<i>value</i> `
     */
    public val serverSideEncryptionKmsKeyId: kotlin.String? = builder.serverSideEncryptionKmsKeyId
    /**
     * The Amazon Resource Name (ARN) used by the service to access the IAM role. The role must allow the `iam:PassRole` action. It is a required parameter that enables DMS to write and read objects from an S3 bucket.
     */
    public val serviceAccessRoleArn: kotlin.String? = builder.serviceAccessRoleArn
    /**
     * A value that when nonblank causes DMS to add a column with timestamp information to the endpoint data for an Amazon S3 target.
     *
     * DMS supports the `TimestampColumnName` parameter in versions 3.1.4 and later.
     *
     * DMS includes an additional `STRING` column in the .csv or .parquet object files of your migrated data when you set `TimestampColumnName` to a nonblank value.
     *
     * For a full load, each row of this timestamp column contains a timestamp for when the data was transferred from the source to the target by DMS.
     *
     * For a change data capture (CDC) load, each row of the timestamp column contains the timestamp for the commit of that row in the source database.
     *
     * The string format for this timestamp column value is `yyyy-MM-dd HH:mm:ss.SSSSSS`. By default, the precision of this value is in microseconds. For a CDC load, the rounding of the precision depends on the commit timestamp supported by DMS for the source database.
     *
     * When the `AddColumnName` parameter is set to `true`, DMS also includes a name for the timestamp column that you set with `TimestampColumnName`.
     */
    public val timestampColumnName: kotlin.String? = builder.timestampColumnName
    /**
     * This setting applies if the S3 output files during a change data capture (CDC) load are written in .csv format. If set to `true` for columns not included in the supplemental log, DMS uses the value specified by `CsvNoSupValue`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-CsvNoSupValue). If not set or set to `false`, DMS uses the null value for these columns.
     *
     * This setting is supported in DMS versions 3.4.1 and later.
     */
    public val useCsvNoSupValue: kotlin.Boolean? = builder.useCsvNoSupValue
    /**
     * When set to true, this parameter uses the task start time as the timestamp column value instead of the time data is written to target. For full load, when `useTaskStartTimeForFullLoadTimestamp` is set to `true`, each row of the timestamp column contains the task start time. For CDC loads, each row of the timestamp column contains the transaction commit time.
     *
     * When `useTaskStartTimeForFullLoadTimestamp` is set to `false`, the full load timestamp in the timestamp column increments with the time data arrives at the target.
     */
    public val useTaskStartTimeForFullLoadTimestamp: kotlin.Boolean? = builder.useTaskStartTimeForFullLoadTimestamp

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.S3Settings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3Settings(")
        append("addColumnName=$addColumnName,")
        append("addTrailingPaddingCharacter=$addTrailingPaddingCharacter,")
        append("bucketFolder=$bucketFolder,")
        append("bucketName=$bucketName,")
        append("cannedAclForObjects=$cannedAclForObjects,")
        append("cdcInsertsAndUpdates=$cdcInsertsAndUpdates,")
        append("cdcInsertsOnly=$cdcInsertsOnly,")
        append("cdcMaxBatchInterval=$cdcMaxBatchInterval,")
        append("cdcMinFileSize=$cdcMinFileSize,")
        append("cdcPath=$cdcPath,")
        append("compressionType=$compressionType,")
        append("csvDelimiter=$csvDelimiter,")
        append("csvNoSupValue=$csvNoSupValue,")
        append("csvNullValue=$csvNullValue,")
        append("csvRowDelimiter=$csvRowDelimiter,")
        append("dataFormat=$dataFormat,")
        append("dataPageSize=$dataPageSize,")
        append("datePartitionDelimiter=$datePartitionDelimiter,")
        append("datePartitionEnabled=$datePartitionEnabled,")
        append("datePartitionSequence=$datePartitionSequence,")
        append("datePartitionTimezone=$datePartitionTimezone,")
        append("dictPageSizeLimit=$dictPageSizeLimit,")
        append("enableStatistics=$enableStatistics,")
        append("encodingType=$encodingType,")
        append("encryptionMode=$encryptionMode,")
        append("expectedBucketOwner=$expectedBucketOwner,")
        append("externalTableDefinition=$externalTableDefinition,")
        append("glueCatalogGeneration=$glueCatalogGeneration,")
        append("ignoreHeaderRows=$ignoreHeaderRows,")
        append("includeOpForFullLoad=$includeOpForFullLoad,")
        append("maxFileSize=$maxFileSize,")
        append("parquetTimestampInMillisecond=$parquetTimestampInMillisecond,")
        append("parquetVersion=$parquetVersion,")
        append("preserveTransactions=$preserveTransactions,")
        append("rfc4180=$rfc4180,")
        append("rowGroupLength=$rowGroupLength,")
        append("serverSideEncryptionKmsKeyId=$serverSideEncryptionKmsKeyId,")
        append("serviceAccessRoleArn=$serviceAccessRoleArn,")
        append("timestampColumnName=$timestampColumnName,")
        append("useCsvNoSupValue=$useCsvNoSupValue,")
        append("useTaskStartTimeForFullLoadTimestamp=$useTaskStartTimeForFullLoadTimestamp")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = addColumnName?.hashCode() ?: 0
        result = 31 * result + (addTrailingPaddingCharacter?.hashCode() ?: 0)
        result = 31 * result + (bucketFolder?.hashCode() ?: 0)
        result = 31 * result + (bucketName?.hashCode() ?: 0)
        result = 31 * result + (cannedAclForObjects?.hashCode() ?: 0)
        result = 31 * result + (cdcInsertsAndUpdates?.hashCode() ?: 0)
        result = 31 * result + (cdcInsertsOnly?.hashCode() ?: 0)
        result = 31 * result + (cdcMaxBatchInterval ?: 0)
        result = 31 * result + (cdcMinFileSize ?: 0)
        result = 31 * result + (cdcPath?.hashCode() ?: 0)
        result = 31 * result + (compressionType?.hashCode() ?: 0)
        result = 31 * result + (csvDelimiter?.hashCode() ?: 0)
        result = 31 * result + (csvNoSupValue?.hashCode() ?: 0)
        result = 31 * result + (csvNullValue?.hashCode() ?: 0)
        result = 31 * result + (csvRowDelimiter?.hashCode() ?: 0)
        result = 31 * result + (dataFormat?.hashCode() ?: 0)
        result = 31 * result + (dataPageSize ?: 0)
        result = 31 * result + (datePartitionDelimiter?.hashCode() ?: 0)
        result = 31 * result + (datePartitionEnabled?.hashCode() ?: 0)
        result = 31 * result + (datePartitionSequence?.hashCode() ?: 0)
        result = 31 * result + (datePartitionTimezone?.hashCode() ?: 0)
        result = 31 * result + (dictPageSizeLimit ?: 0)
        result = 31 * result + (enableStatistics?.hashCode() ?: 0)
        result = 31 * result + (encodingType?.hashCode() ?: 0)
        result = 31 * result + (encryptionMode?.hashCode() ?: 0)
        result = 31 * result + (expectedBucketOwner?.hashCode() ?: 0)
        result = 31 * result + (externalTableDefinition?.hashCode() ?: 0)
        result = 31 * result + (glueCatalogGeneration?.hashCode() ?: 0)
        result = 31 * result + (ignoreHeaderRows ?: 0)
        result = 31 * result + (includeOpForFullLoad?.hashCode() ?: 0)
        result = 31 * result + (maxFileSize ?: 0)
        result = 31 * result + (parquetTimestampInMillisecond?.hashCode() ?: 0)
        result = 31 * result + (parquetVersion?.hashCode() ?: 0)
        result = 31 * result + (preserveTransactions?.hashCode() ?: 0)
        result = 31 * result + (rfc4180?.hashCode() ?: 0)
        result = 31 * result + (rowGroupLength ?: 0)
        result = 31 * result + (serverSideEncryptionKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (serviceAccessRoleArn?.hashCode() ?: 0)
        result = 31 * result + (timestampColumnName?.hashCode() ?: 0)
        result = 31 * result + (useCsvNoSupValue?.hashCode() ?: 0)
        result = 31 * result + (useTaskStartTimeForFullLoadTimestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3Settings

        if (addColumnName != other.addColumnName) return false
        if (addTrailingPaddingCharacter != other.addTrailingPaddingCharacter) return false
        if (bucketFolder != other.bucketFolder) return false
        if (bucketName != other.bucketName) return false
        if (cannedAclForObjects != other.cannedAclForObjects) return false
        if (cdcInsertsAndUpdates != other.cdcInsertsAndUpdates) return false
        if (cdcInsertsOnly != other.cdcInsertsOnly) return false
        if (cdcMaxBatchInterval != other.cdcMaxBatchInterval) return false
        if (cdcMinFileSize != other.cdcMinFileSize) return false
        if (cdcPath != other.cdcPath) return false
        if (compressionType != other.compressionType) return false
        if (csvDelimiter != other.csvDelimiter) return false
        if (csvNoSupValue != other.csvNoSupValue) return false
        if (csvNullValue != other.csvNullValue) return false
        if (csvRowDelimiter != other.csvRowDelimiter) return false
        if (dataFormat != other.dataFormat) return false
        if (dataPageSize != other.dataPageSize) return false
        if (datePartitionDelimiter != other.datePartitionDelimiter) return false
        if (datePartitionEnabled != other.datePartitionEnabled) return false
        if (datePartitionSequence != other.datePartitionSequence) return false
        if (datePartitionTimezone != other.datePartitionTimezone) return false
        if (dictPageSizeLimit != other.dictPageSizeLimit) return false
        if (enableStatistics != other.enableStatistics) return false
        if (encodingType != other.encodingType) return false
        if (encryptionMode != other.encryptionMode) return false
        if (expectedBucketOwner != other.expectedBucketOwner) return false
        if (externalTableDefinition != other.externalTableDefinition) return false
        if (glueCatalogGeneration != other.glueCatalogGeneration) return false
        if (ignoreHeaderRows != other.ignoreHeaderRows) return false
        if (includeOpForFullLoad != other.includeOpForFullLoad) return false
        if (maxFileSize != other.maxFileSize) return false
        if (parquetTimestampInMillisecond != other.parquetTimestampInMillisecond) return false
        if (parquetVersion != other.parquetVersion) return false
        if (preserveTransactions != other.preserveTransactions) return false
        if (rfc4180 != other.rfc4180) return false
        if (rowGroupLength != other.rowGroupLength) return false
        if (serverSideEncryptionKmsKeyId != other.serverSideEncryptionKmsKeyId) return false
        if (serviceAccessRoleArn != other.serviceAccessRoleArn) return false
        if (timestampColumnName != other.timestampColumnName) return false
        if (useCsvNoSupValue != other.useCsvNoSupValue) return false
        if (useTaskStartTimeForFullLoadTimestamp != other.useTaskStartTimeForFullLoadTimestamp) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.S3Settings = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An optional parameter that, when set to `true` or `y`, you can use to add column name information to the .csv output file.
         *
         * The default value is `false`. Valid values are `true`, `false`, `y`, and `n`.
         */
        public var addColumnName: kotlin.Boolean? = null
        /**
         * Use the S3 target endpoint setting `AddTrailingPaddingCharacter` to add padding on string data. The default value is `false`.
         */
        public var addTrailingPaddingCharacter: kotlin.Boolean? = null
        /**
         * An optional parameter to set a folder name in the S3 bucket. If provided, tables are created in the path ` <i>bucketFolder</i>/<i>schema_name</i>/<i>table_name</i>/`. If this parameter isn't specified, then the path used is ` <i>schema_name</i>/<i>table_name</i>/`.
         */
        public var bucketFolder: kotlin.String? = null
        /**
         * The name of the S3 bucket.
         */
        public var bucketName: kotlin.String? = null
        /**
         * A value that enables DMS to specify a predefined (canned) access control list for objects created in an Amazon S3 bucket as .csv or .parquet files. For more information about Amazon S3 canned ACLs, see [Canned ACL](http://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) in the *Amazon S3 Developer Guide.*
         *
         * The default value is NONE. Valid values include NONE, PRIVATE, PUBLIC_READ, PUBLIC_READ_WRITE, AUTHENTICATED_READ, AWS_EXEC_READ, BUCKET_OWNER_READ, and BUCKET_OWNER_FULL_CONTROL.
         */
        public var cannedAclForObjects: aws.sdk.kotlin.services.databasemigrationservice.model.CannedAclForObjectsValue? = null
        /**
         * A value that enables a change data capture (CDC) load to write INSERT and UPDATE operations to .csv or .parquet (columnar storage) output files. The default setting is `false`, but when `CdcInsertsAndUpdates` is set to `true` or `y`, only INSERTs and UPDATEs from the source database are migrated to the .csv or .parquet file.
         *
         * DMS supports the use of the .parquet files in versions 3.4.7 and later.
         *
         * How these INSERTs and UPDATEs are recorded depends on the value of the `IncludeOpForFullLoad` parameter. If `IncludeOpForFullLoad` is set to `true`, the first field of every CDC record is set to either `I` or `U` to indicate INSERT and UPDATE operations at the source. But if `IncludeOpForFullLoad` is set to `false`, CDC records are written without an indication of INSERT or UPDATE operations at the source. For more information about how these settings work together, see [Indicating Source DB Operations in Migrated S3 Data](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps) in the *Database Migration Service User Guide.*.
         *
         * DMS supports the use of the `CdcInsertsAndUpdates` parameter in versions 3.3.1 and later.
         *
         * `CdcInsertsOnly` and `CdcInsertsAndUpdates` can't both be set to `true` for the same endpoint. Set either `CdcInsertsOnly` or `CdcInsertsAndUpdates` to `true` for the same endpoint, but not both.
         */
        public var cdcInsertsAndUpdates: kotlin.Boolean? = null
        /**
         * A value that enables a change data capture (CDC) load to write only INSERT operations to .csv or columnar storage (.parquet) output files. By default (the `false` setting), the first field in a .csv or .parquet record contains the letter I (INSERT), U (UPDATE), or D (DELETE). These values indicate whether the row was inserted, updated, or deleted at the source database for a CDC load to the target.
         *
         * If `CdcInsertsOnly` is set to `true` or `y`, only INSERTs from the source database are migrated to the .csv or .parquet file. For .csv format only, how these INSERTs are recorded depends on the value of `IncludeOpForFullLoad`. If `IncludeOpForFullLoad` is set to `true`, the first field of every CDC record is set to I to indicate the INSERT operation at the source. If `IncludeOpForFullLoad` is set to `false`, every CDC record is written without a first field to indicate the INSERT operation at the source. For more information about how these settings work together, see [Indicating Source DB Operations in Migrated S3 Data](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps) in the *Database Migration Service User Guide.*.
         *
         * DMS supports the interaction described preceding between the `CdcInsertsOnly` and `IncludeOpForFullLoad` parameters in versions 3.1.4 and later.
         *
         * `CdcInsertsOnly` and `CdcInsertsAndUpdates` can't both be set to `true` for the same endpoint. Set either `CdcInsertsOnly` or `CdcInsertsAndUpdates` to `true` for the same endpoint, but not both.
         */
        public var cdcInsertsOnly: kotlin.Boolean? = null
        /**
         * Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3.
         *
         * When `CdcMaxBatchInterval` and `CdcMinFileSize` are both specified, the file write is triggered by whichever parameter condition is met first within an DMS CloudFormation template.
         *
         * The default value is 60 seconds.
         */
        public var cdcMaxBatchInterval: kotlin.Int? = null
        /**
         * Minimum file size, defined in kilobytes, to reach for a file output to Amazon S3.
         *
         * When `CdcMinFileSize` and `CdcMaxBatchInterval` are both specified, the file write is triggered by whichever parameter condition is met first within an DMS CloudFormation template.
         *
         * The default value is 32 MB.
         */
        public var cdcMinFileSize: kotlin.Int? = null
        /**
         * Specifies the folder path of CDC files. For an S3 source, this setting is required if a task captures change data; otherwise, it's optional. If `CdcPath` is set, DMS reads CDC files from this path and replicates the data changes to the target endpoint. For an S3 target if you set `PreserveTransactions`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-PreserveTransactions) to `true`, DMS verifies that you have set this parameter to a folder path on your S3 target where DMS can save the transaction order for the CDC load. DMS creates this CDC folder path in either your S3 target working directory or the S3 target location specified by `BucketFolder`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-BucketFolder) and `BucketName`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-BucketName).
         *
         * For example, if you specify `CdcPath` as `MyChangedData`, and you specify `BucketName` as `MyTargetBucket` but do not specify `BucketFolder`, DMS creates the CDC folder path following: `MyTargetBucket/MyChangedData`.
         *
         * If you specify the same `CdcPath`, and you specify `BucketName` as `MyTargetBucket` and `BucketFolder` as `MyTargetData`, DMS creates the CDC folder path following: `MyTargetBucket/MyTargetData/MyChangedData`.
         *
         * For more information on CDC including transaction order on an S3 target, see [Capturing data changes (CDC) including transaction order on the S3 target](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.EndpointSettings.CdcPath).
         *
         * This setting is supported in DMS versions 3.4.2 and later.
         */
        public var cdcPath: kotlin.String? = null
        /**
         * An optional parameter to use GZIP to compress the target files. Set to GZIP to compress the target files. Either set this parameter to NONE (the default) or don't use it to leave the files uncompressed. This parameter applies to both .csv and .parquet file formats.
         */
        public var compressionType: aws.sdk.kotlin.services.databasemigrationservice.model.CompressionTypeValue? = null
        /**
         * The delimiter used to separate columns in the .csv file for both source and target. The default is a comma.
         */
        public var csvDelimiter: kotlin.String? = null
        /**
         * This setting only applies if your Amazon S3 output files during a change data capture (CDC) load are written in .csv format. If `UseCsvNoSupValue`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-UseCsvNoSupValue) is set to true, specify a string value that you want DMS to use for all columns not included in the supplemental log. If you do not specify a string value, DMS uses the null value for these columns regardless of the `UseCsvNoSupValue` setting.
         *
         * This setting is supported in DMS versions 3.4.1 and later.
         */
        public var csvNoSupValue: kotlin.String? = null
        /**
         * An optional parameter that specifies how DMS treats null values. While handling the null value, you can use this parameter to pass a user-defined string as null when writing to the target. For example, when target columns are nullable, you can use this option to differentiate between the empty string value and the null value. So, if you set this parameter value to the empty string ("" or ''), DMS treats the empty string as the null value instead of `NULL`.
         *
         * The default value is `NULL`. Valid values include any valid string.
         */
        public var csvNullValue: kotlin.String? = null
        /**
         * The delimiter used to separate rows in the .csv file for both source and target. The default is a carriage return (`\n`).
         */
        public var csvRowDelimiter: kotlin.String? = null
        /**
         * The format of the data that you want to use for output. You can choose one of the following:
         * + `csv` : This is a row-based file format with comma-separated values (.csv).
         * + `parquet` : Apache Parquet (.parquet) is a columnar storage file format that features efficient compression and provides faster query response.
         */
        public var dataFormat: aws.sdk.kotlin.services.databasemigrationservice.model.DataFormatValue? = null
        /**
         * The size of one data page in bytes. This parameter defaults to 1024 * 1024 bytes (1 MiB). This number is used for .parquet file format only.
         */
        public var dataPageSize: kotlin.Int? = null
        /**
         * Specifies a date separating delimiter to use during folder partitioning. The default value is `SLASH`. Use this parameter when `DatePartitionedEnabled` is set to `true`.
         */
        public var datePartitionDelimiter: aws.sdk.kotlin.services.databasemigrationservice.model.DatePartitionDelimiterValue? = null
        /**
         * When set to `true`, this parameter partitions S3 bucket folders based on transaction commit dates. The default value is `false`. For more information about date-based folder partitioning, see [Using date-based folder partitioning](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.DatePartitioning).
         */
        public var datePartitionEnabled: kotlin.Boolean? = null
        /**
         * Identifies the sequence of the date format to use during folder partitioning. The default value is `YYYYMMDD`. Use this parameter when `DatePartitionedEnabled` is set to `true`.
         */
        public var datePartitionSequence: aws.sdk.kotlin.services.databasemigrationservice.model.DatePartitionSequenceValue? = null
        /**
         * When creating an S3 target endpoint, set `DatePartitionTimezone` to convert the current UTC time into a specified time zone. The conversion occurs when a date partition folder is created and a CDC filename is generated. The time zone format is Area/Location. Use this parameter when `DatePartitionedEnabled` is set to `true`, as shown in the following example.
         *
         * `s3-settings='{"DatePartitionEnabled": true, "DatePartitionSequence": "YYYYMMDDHH", "DatePartitionDelimiter": "SLASH", "DatePartitionTimezone":"<i>Asia/Seoul</i>", "BucketName": "dms-nattarat-test"}'`
         */
        public var datePartitionTimezone: kotlin.String? = null
        /**
         * The maximum size of an encoded dictionary page of a column. If the dictionary page exceeds this, this column is stored using an encoding type of `PLAIN`. This parameter defaults to 1024 * 1024 bytes (1 MiB), the maximum size of a dictionary page before it reverts to `PLAIN` encoding. This size is used for .parquet file format only.
         */
        public var dictPageSizeLimit: kotlin.Int? = null
        /**
         * A value that enables statistics for Parquet pages and row groups. Choose `true` to enable statistics, `false` to disable. Statistics include `NULL`, `DISTINCT`, `MAX`, and `MIN` values. This parameter defaults to `true`. This value is used for .parquet file format only.
         */
        public var enableStatistics: kotlin.Boolean? = null
        /**
         * The type of encoding you are using:
         * + `RLE_DICTIONARY` uses a combination of bit-packing and run-length encoding to store repeated values more efficiently. This is the default.
         * + `PLAIN` doesn't use encoding at all. Values are stored as they are.
         * + `PLAIN_DICTIONARY` builds a dictionary of the values encountered in a given column. The dictionary is stored in a dictionary page for each column chunk.
         */
        public var encodingType: aws.sdk.kotlin.services.databasemigrationservice.model.EncodingTypeValue? = null
        /**
         * The type of server-side encryption that you want to use for your data. This encryption type is part of the endpoint settings or the extra connections attributes for Amazon S3. You can choose either `SSE_S3` (the default) or `SSE_KMS`.
         *
         * For the `ModifyEndpoint` operation, you can change the existing value of the `EncryptionMode` parameter from `SSE_KMS` to `SSE_S3`. But you can’t change the existing value from `SSE_S3` to `SSE_KMS`.
         *
         * To use `SSE_S3`, you need an Identity and Access Management (IAM) role with permission to allow `"arn:aws:s3:::dms-*"` to use the following actions:
         * + `s3:CreateBucket`
         * + `s3:ListBucket`
         * + `s3:DeleteBucket`
         * + `s3:GetBucketLocation`
         * + `s3:GetObject`
         * + `s3:PutObject`
         * + `s3:DeleteObject`
         * + `s3:GetObjectVersion`
         * + `s3:GetBucketPolicy`
         * + `s3:PutBucketPolicy`
         * + `s3:DeleteBucketPolicy`
         */
        public var encryptionMode: aws.sdk.kotlin.services.databasemigrationservice.model.EncryptionModeValue? = null
        /**
         * To specify a bucket owner and prevent sniping, you can use the `ExpectedBucketOwner` endpoint setting.
         *
         * Example: `--s3-settings='{"ExpectedBucketOwner": "<i>AWS_Account_ID</i>"}'`
         *
         * When you make a request to test a connection or perform a migration, S3 checks the account ID of the bucket owner against the specified parameter.
         */
        public var expectedBucketOwner: kotlin.String? = null
        /**
         * Specifies how tables are defined in the S3 source files only.
         */
        public var externalTableDefinition: kotlin.String? = null
        /**
         * When true, allows Glue to catalog your S3 bucket. Creating an Glue catalog lets you use Athena to query your data.
         */
        public var glueCatalogGeneration: kotlin.Boolean? = null
        /**
         * When this value is set to 1, DMS ignores the first row header in a .csv file. A value of 1 turns on the feature; a value of 0 turns off the feature.
         *
         * The default is 0.
         */
        public var ignoreHeaderRows: kotlin.Int? = null
        /**
         * A value that enables a full load to write INSERT operations to the comma-separated value (.csv) or .parquet output files only to indicate how the rows were added to the source database.
         *
         * DMS supports the `IncludeOpForFullLoad` parameter in versions 3.1.4 and later.
         *
         * DMS supports the use of the .parquet files with the `IncludeOpForFullLoad` parameter in versions 3.4.7 and later.
         *
         * For full load, records can only be inserted. By default (the `false` setting), no information is recorded in these output files for a full load to indicate that the rows were inserted at the source database. If `IncludeOpForFullLoad` is set to `true` or `y`, the INSERT is recorded as an I annotation in the first field of the .csv file. This allows the format of your target records from a full load to be consistent with the target records from a CDC load.
         *
         * This setting works together with the `CdcInsertsOnly` and the `CdcInsertsAndUpdates` parameters for output to .csv files only. For more information about how these settings work together, see [Indicating Source DB Operations in Migrated S3 Data](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps) in the *Database Migration Service User Guide.*.
         */
        public var includeOpForFullLoad: kotlin.Boolean? = null
        /**
         * A value that specifies the maximum size (in KB) of any .csv file to be created while migrating to an S3 target during full load.
         *
         * The default value is 1,048,576 KB (1 GB). Valid values include 1 to 1,048,576.
         */
        public var maxFileSize: kotlin.Int? = null
        /**
         * A value that specifies the precision of any `TIMESTAMP` column values that are written to an Amazon S3 object file in .parquet format.
         *
         * DMS supports the `ParquetTimestampInMillisecond` parameter in versions 3.1.4 and later.
         *
         * When `ParquetTimestampInMillisecond` is set to `true` or `y`, DMS writes all `TIMESTAMP` columns in a .parquet formatted file with millisecond precision. Otherwise, DMS writes them with microsecond precision.
         *
         * Currently, Amazon Athena and Glue can handle only millisecond precision for `TIMESTAMP` values. Set this parameter to `true` for S3 endpoint object files that are .parquet formatted only if you plan to query or process the data with Athena or Glue.
         *
         * DMS writes any `TIMESTAMP` column values written to an S3 file in .csv format with microsecond precision.
         *
         * Setting `ParquetTimestampInMillisecond` has no effect on the string format of the timestamp column value that is inserted by setting the `TimestampColumnName` parameter.
         */
        public var parquetTimestampInMillisecond: kotlin.Boolean? = null
        /**
         * The version of the Apache Parquet format that you want to use: `parquet_1_0` (the default) or `parquet_2_0`.
         */
        public var parquetVersion: aws.sdk.kotlin.services.databasemigrationservice.model.ParquetVersionValue? = null
        /**
         * If set to `true`, DMS saves the transaction order for a change data capture (CDC) load on the Amazon S3 target specified by `CdcPath`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-CdcPath). For more information, see [Capturing data changes (CDC) including transaction order on the S3 target](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.EndpointSettings.CdcPath).
         *
         * This setting is supported in DMS versions 3.4.2 and later.
         */
        public var preserveTransactions: kotlin.Boolean? = null
        /**
         * For an S3 source, when this value is set to `true` or `y`, each leading double quotation mark has to be followed by an ending double quotation mark. This formatting complies with RFC 4180. When this value is set to `false` or `n`, string literals are copied to the target as is. In this case, a delimiter (row or column) signals the end of the field. Thus, you can't use a delimiter as part of the string, because it signals the end of the value.
         *
         * For an S3 target, an optional parameter used to set behavior to comply with RFC 4180 for data migrated to Amazon S3 using .csv file format only. When this value is set to `true` or `y` using Amazon S3 as a target, if the data has quotation marks or newline characters in it, DMS encloses the entire column with an additional pair of double quotation marks ("). Every quotation mark within the data is repeated twice.
         *
         * The default value is `true`. Valid values include `true`, `false`, `y`, and `n`.
         */
        public var rfc4180: kotlin.Boolean? = null
        /**
         * The number of rows in a row group. A smaller row group size provides faster reads. But as the number of row groups grows, the slower writes become. This parameter defaults to 10,000 rows. This number is used for .parquet file format only.
         *
         * If you choose a value larger than the maximum, `RowGroupLength` is set to the max row group length in bytes (64 * 1024 * 1024).
         */
        public var rowGroupLength: kotlin.Int? = null
        /**
         * If you are using `SSE_KMS` for the `EncryptionMode`, provide the KMS key ID. The key that you use needs an attached policy that enables Identity and Access Management (IAM) user permissions and allows use of the key.
         *
         * Here is a CLI example: `aws dms create-endpoint --endpoint-identifier <i>value</i> --endpoint-type target --engine-name s3 --s3-settings ServiceAccessRoleArn=<i>value</i>,BucketFolder=<i>value</i>,BucketName=<i>value</i>,EncryptionMode=SSE_KMS,ServerSideEncryptionKmsKeyId=<i>value</i> `
         */
        public var serverSideEncryptionKmsKeyId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) used by the service to access the IAM role. The role must allow the `iam:PassRole` action. It is a required parameter that enables DMS to write and read objects from an S3 bucket.
         */
        public var serviceAccessRoleArn: kotlin.String? = null
        /**
         * A value that when nonblank causes DMS to add a column with timestamp information to the endpoint data for an Amazon S3 target.
         *
         * DMS supports the `TimestampColumnName` parameter in versions 3.1.4 and later.
         *
         * DMS includes an additional `STRING` column in the .csv or .parquet object files of your migrated data when you set `TimestampColumnName` to a nonblank value.
         *
         * For a full load, each row of this timestamp column contains a timestamp for when the data was transferred from the source to the target by DMS.
         *
         * For a change data capture (CDC) load, each row of the timestamp column contains the timestamp for the commit of that row in the source database.
         *
         * The string format for this timestamp column value is `yyyy-MM-dd HH:mm:ss.SSSSSS`. By default, the precision of this value is in microseconds. For a CDC load, the rounding of the precision depends on the commit timestamp supported by DMS for the source database.
         *
         * When the `AddColumnName` parameter is set to `true`, DMS also includes a name for the timestamp column that you set with `TimestampColumnName`.
         */
        public var timestampColumnName: kotlin.String? = null
        /**
         * This setting applies if the S3 output files during a change data capture (CDC) load are written in .csv format. If set to `true` for columns not included in the supplemental log, DMS uses the value specified by `CsvNoSupValue`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-CsvNoSupValue). If not set or set to `false`, DMS uses the null value for these columns.
         *
         * This setting is supported in DMS versions 3.4.1 and later.
         */
        public var useCsvNoSupValue: kotlin.Boolean? = null
        /**
         * When set to true, this parameter uses the task start time as the timestamp column value instead of the time data is written to target. For full load, when `useTaskStartTimeForFullLoadTimestamp` is set to `true`, each row of the timestamp column contains the task start time. For CDC loads, each row of the timestamp column contains the transaction commit time.
         *
         * When `useTaskStartTimeForFullLoadTimestamp` is set to `false`, the full load timestamp in the timestamp column increments with the time data arrives at the target.
         */
        public var useTaskStartTimeForFullLoadTimestamp: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.S3Settings) : this() {
            this.addColumnName = x.addColumnName
            this.addTrailingPaddingCharacter = x.addTrailingPaddingCharacter
            this.bucketFolder = x.bucketFolder
            this.bucketName = x.bucketName
            this.cannedAclForObjects = x.cannedAclForObjects
            this.cdcInsertsAndUpdates = x.cdcInsertsAndUpdates
            this.cdcInsertsOnly = x.cdcInsertsOnly
            this.cdcMaxBatchInterval = x.cdcMaxBatchInterval
            this.cdcMinFileSize = x.cdcMinFileSize
            this.cdcPath = x.cdcPath
            this.compressionType = x.compressionType
            this.csvDelimiter = x.csvDelimiter
            this.csvNoSupValue = x.csvNoSupValue
            this.csvNullValue = x.csvNullValue
            this.csvRowDelimiter = x.csvRowDelimiter
            this.dataFormat = x.dataFormat
            this.dataPageSize = x.dataPageSize
            this.datePartitionDelimiter = x.datePartitionDelimiter
            this.datePartitionEnabled = x.datePartitionEnabled
            this.datePartitionSequence = x.datePartitionSequence
            this.datePartitionTimezone = x.datePartitionTimezone
            this.dictPageSizeLimit = x.dictPageSizeLimit
            this.enableStatistics = x.enableStatistics
            this.encodingType = x.encodingType
            this.encryptionMode = x.encryptionMode
            this.expectedBucketOwner = x.expectedBucketOwner
            this.externalTableDefinition = x.externalTableDefinition
            this.glueCatalogGeneration = x.glueCatalogGeneration
            this.ignoreHeaderRows = x.ignoreHeaderRows
            this.includeOpForFullLoad = x.includeOpForFullLoad
            this.maxFileSize = x.maxFileSize
            this.parquetTimestampInMillisecond = x.parquetTimestampInMillisecond
            this.parquetVersion = x.parquetVersion
            this.preserveTransactions = x.preserveTransactions
            this.rfc4180 = x.rfc4180
            this.rowGroupLength = x.rowGroupLength
            this.serverSideEncryptionKmsKeyId = x.serverSideEncryptionKmsKeyId
            this.serviceAccessRoleArn = x.serviceAccessRoleArn
            this.timestampColumnName = x.timestampColumnName
            this.useCsvNoSupValue = x.useCsvNoSupValue
            this.useTaskStartTimeForFullLoadTimestamp = x.useTaskStartTimeForFullLoadTimestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.S3Settings = S3Settings(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
