// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information that describes a replication task created by the `CreateReplicationTask` operation.
 */
public class ReplicationTask private constructor(builder: Builder) {
    /**
     * Indicates when you want a change data capture (CDC) operation to start. Use either `CdcStartPosition` or `CdcStartTime` to specify when you want the CDC operation to start. Specifying both values results in an error.
     *
     * The value can be in date, checkpoint, or LSN/SCN format.
     *
     * Date Example: --cdc-start-position “2018-03-08T12:12:12”
     *
     * Checkpoint Example: --cdc-start-position "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"
     *
     * LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”
     */
    public val cdcStartPosition: kotlin.String? = builder.cdcStartPosition
    /**
     * Indicates when you want a change data capture (CDC) operation to stop. The value can be either server time or commit time.
     *
     * Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”
     *
     * Commit time example: --cdc-stop-position “commit_time:2018-02-09T12:12:12“
     */
    public val cdcStopPosition: kotlin.String? = builder.cdcStopPosition
    /**
     * The last error (failure) message generated for the replication task.
     */
    public val lastFailureMessage: kotlin.String? = builder.lastFailureMessage
    /**
     * The type of migration.
     */
    public val migrationType: aws.sdk.kotlin.services.databasemigrationservice.model.MigrationTypeValue? = builder.migrationType
    /**
     * Indicates the last checkpoint that occurred during a change data capture (CDC) operation. You can provide this value to the `CdcStartPosition` parameter to start a CDC operation that begins at that checkpoint.
     */
    public val recoveryCheckpoint: kotlin.String? = builder.recoveryCheckpoint
    /**
     * The ARN of the replication instance.
     */
    public val replicationInstanceArn: kotlin.String? = builder.replicationInstanceArn
    /**
     * The Amazon Resource Name (ARN) of the replication task.
     */
    public val replicationTaskArn: kotlin.String? = builder.replicationTaskArn
    /**
     * The date the replication task was created.
     */
    public val replicationTaskCreationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.replicationTaskCreationDate
    /**
     * The user-assigned replication task identifier or name.
     *
     * Constraints:
     * + Must contain 1-255 alphanumeric characters or hyphens.
     * + First character must be a letter.
     * + Cannot end with a hyphen or contain two consecutive hyphens.
     */
    public val replicationTaskIdentifier: kotlin.String? = builder.replicationTaskIdentifier
    /**
     * The settings for the replication task.
     */
    public val replicationTaskSettings: kotlin.String? = builder.replicationTaskSettings
    /**
     * The date the replication task is scheduled to start.
     */
    public val replicationTaskStartDate: aws.smithy.kotlin.runtime.time.Instant? = builder.replicationTaskStartDate
    /**
     * The statistics for the task, including elapsed time, tables loaded, and table errors.
     */
    public val replicationTaskStats: aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationTaskStats? = builder.replicationTaskStats
    /**
     * The Amazon Resource Name (ARN) that uniquely identifies the endpoint.
     */
    public val sourceEndpointArn: kotlin.String? = builder.sourceEndpointArn
    /**
     * The status of the replication task. This response parameter can return one of the following values:
     * + `"moving"` – The task is being moved in response to running the `MoveReplicationTask`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_MoveReplicationTask.html) operation.
     * + `"creating"` – The task is being created in response to running the `CreateReplicationTask`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_CreateReplicationTask.html) operation.
     * + `"deleting"` – The task is being deleted in response to running the `DeleteReplicationTask`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_DeleteReplicationTask.html) operation.
     * + `"failed"` – The task failed to successfully complete the database migration in response to running the `StartReplicationTask`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html) operation.
     * + `"failed-move"` – The task failed to move in response to running the `MoveReplicationTask`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_MoveReplicationTask.html) operation.
     * + `"modifying"` – The task definition is being modified in response to running the `ModifyReplicationTask`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_ModifyReplicationTask.html) operation.
     * + `"ready"` – The task is in a `ready` state where it can respond to other task operations, such as `StartReplicationTask`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html) or `DeleteReplicationTask`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_DeleteReplicationTask.html).
     * + `"running"` – The task is performing a database migration in response to running the `StartReplicationTask`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html) operation.
     * + `"starting"` – The task is preparing to perform a database migration in response to running the `StartReplicationTask`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html) operation.
     * + `"stopped"` – The task has stopped in response to running the `StopReplicationTask`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_StopReplicationTask.html) operation.
     * + `"stopping"` – The task is preparing to stop in response to running the `StopReplicationTask`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_StopReplicationTask.html) operation.
     * + `"testing"` – The database migration specified for this task is being tested in response to running either the `StartReplicationTaskAssessmentRun`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessmentRun.html) or the `StartReplicationTaskAssessment`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessment.html) operation.`StartReplicationTaskAssessmentRun`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessmentRun.html) is an improved premigration task assessment operation. The `StartReplicationTaskAssessment`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessment.html) operation assesses data type compatibility only between the source and target database of a given migration task. In contrast, `StartReplicationTaskAssessmentRun`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessmentRun.html) enables you to specify a variety of premigration task assessments in addition to data type compatibility. These assessments include ones for the validity of primary key definitions and likely issues with database migration performance, among others.
     */
    public val status: kotlin.String? = builder.status
    /**
     * The reason the replication task was stopped. This response parameter can return one of the following values:
     * + `"Stop Reason NORMAL"`
     * + `"Stop Reason RECOVERABLE_ERROR"`
     * + `"Stop Reason FATAL_ERROR"`
     * + `"Stop Reason FULL_LOAD_ONLY_FINISHED"`
     * + `"Stop Reason STOPPED_AFTER_FULL_LOAD"` – Full load completed, with cached changes not applied
     * + `"Stop Reason STOPPED_AFTER_CACHED_EVENTS"` – Full load completed, with cached changes applied
     * + `"Stop Reason EXPRESS_LICENSE_LIMITS_REACHED"`
     * + `"Stop Reason STOPPED_AFTER_DDL_APPLY"` – User-defined stop task after DDL applied
     * + `"Stop Reason STOPPED_DUE_TO_LOW_MEMORY"`
     * + `"Stop Reason STOPPED_DUE_TO_LOW_DISK"`
     * + `"Stop Reason STOPPED_AT_SERVER_TIME"` – User-defined server time for stopping task
     * + `"Stop Reason STOPPED_AT_COMMIT_TIME"` – User-defined commit time for stopping task
     * + `"Stop Reason RECONFIGURATION_RESTART"`
     * + `"Stop Reason RECYCLE_TASK"`
     */
    public val stopReason: kotlin.String? = builder.stopReason
    /**
     * Table mappings specified in the task.
     */
    public val tableMappings: kotlin.String? = builder.tableMappings
    /**
     * The ARN that uniquely identifies the endpoint.
     */
    public val targetEndpointArn: kotlin.String? = builder.targetEndpointArn
    /**
     * The ARN of the replication instance to which this task is moved in response to running the `MoveReplicationTask`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_MoveReplicationTask.html) operation. Otherwise, this response parameter isn't a member of the `ReplicationTask` object.
     */
    public val targetReplicationInstanceArn: kotlin.String? = builder.targetReplicationInstanceArn
    /**
     * Supplemental information that the task requires to migrate the data for certain source and target endpoints. For more information, see [Specifying Supplemental Data for Task Settings](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html) in the *Database Migration Service User Guide.*
     */
    public val taskData: kotlin.String? = builder.taskData

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationTask = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReplicationTask(")
        append("cdcStartPosition=$cdcStartPosition,")
        append("cdcStopPosition=$cdcStopPosition,")
        append("lastFailureMessage=$lastFailureMessage,")
        append("migrationType=$migrationType,")
        append("recoveryCheckpoint=$recoveryCheckpoint,")
        append("replicationInstanceArn=$replicationInstanceArn,")
        append("replicationTaskArn=$replicationTaskArn,")
        append("replicationTaskCreationDate=$replicationTaskCreationDate,")
        append("replicationTaskIdentifier=$replicationTaskIdentifier,")
        append("replicationTaskSettings=$replicationTaskSettings,")
        append("replicationTaskStartDate=$replicationTaskStartDate,")
        append("replicationTaskStats=$replicationTaskStats,")
        append("sourceEndpointArn=$sourceEndpointArn,")
        append("status=$status,")
        append("stopReason=$stopReason,")
        append("tableMappings=$tableMappings,")
        append("targetEndpointArn=$targetEndpointArn,")
        append("targetReplicationInstanceArn=$targetReplicationInstanceArn,")
        append("taskData=$taskData")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cdcStartPosition?.hashCode() ?: 0
        result = 31 * result + (cdcStopPosition?.hashCode() ?: 0)
        result = 31 * result + (lastFailureMessage?.hashCode() ?: 0)
        result = 31 * result + (migrationType?.hashCode() ?: 0)
        result = 31 * result + (recoveryCheckpoint?.hashCode() ?: 0)
        result = 31 * result + (replicationInstanceArn?.hashCode() ?: 0)
        result = 31 * result + (replicationTaskArn?.hashCode() ?: 0)
        result = 31 * result + (replicationTaskCreationDate?.hashCode() ?: 0)
        result = 31 * result + (replicationTaskIdentifier?.hashCode() ?: 0)
        result = 31 * result + (replicationTaskSettings?.hashCode() ?: 0)
        result = 31 * result + (replicationTaskStartDate?.hashCode() ?: 0)
        result = 31 * result + (replicationTaskStats?.hashCode() ?: 0)
        result = 31 * result + (sourceEndpointArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (stopReason?.hashCode() ?: 0)
        result = 31 * result + (tableMappings?.hashCode() ?: 0)
        result = 31 * result + (targetEndpointArn?.hashCode() ?: 0)
        result = 31 * result + (targetReplicationInstanceArn?.hashCode() ?: 0)
        result = 31 * result + (taskData?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReplicationTask

        if (cdcStartPosition != other.cdcStartPosition) return false
        if (cdcStopPosition != other.cdcStopPosition) return false
        if (lastFailureMessage != other.lastFailureMessage) return false
        if (migrationType != other.migrationType) return false
        if (recoveryCheckpoint != other.recoveryCheckpoint) return false
        if (replicationInstanceArn != other.replicationInstanceArn) return false
        if (replicationTaskArn != other.replicationTaskArn) return false
        if (replicationTaskCreationDate != other.replicationTaskCreationDate) return false
        if (replicationTaskIdentifier != other.replicationTaskIdentifier) return false
        if (replicationTaskSettings != other.replicationTaskSettings) return false
        if (replicationTaskStartDate != other.replicationTaskStartDate) return false
        if (replicationTaskStats != other.replicationTaskStats) return false
        if (sourceEndpointArn != other.sourceEndpointArn) return false
        if (status != other.status) return false
        if (stopReason != other.stopReason) return false
        if (tableMappings != other.tableMappings) return false
        if (targetEndpointArn != other.targetEndpointArn) return false
        if (targetReplicationInstanceArn != other.targetReplicationInstanceArn) return false
        if (taskData != other.taskData) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationTask = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates when you want a change data capture (CDC) operation to start. Use either `CdcStartPosition` or `CdcStartTime` to specify when you want the CDC operation to start. Specifying both values results in an error.
         *
         * The value can be in date, checkpoint, or LSN/SCN format.
         *
         * Date Example: --cdc-start-position “2018-03-08T12:12:12”
         *
         * Checkpoint Example: --cdc-start-position "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"
         *
         * LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”
         */
        public var cdcStartPosition: kotlin.String? = null
        /**
         * Indicates when you want a change data capture (CDC) operation to stop. The value can be either server time or commit time.
         *
         * Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”
         *
         * Commit time example: --cdc-stop-position “commit_time:2018-02-09T12:12:12“
         */
        public var cdcStopPosition: kotlin.String? = null
        /**
         * The last error (failure) message generated for the replication task.
         */
        public var lastFailureMessage: kotlin.String? = null
        /**
         * The type of migration.
         */
        public var migrationType: aws.sdk.kotlin.services.databasemigrationservice.model.MigrationTypeValue? = null
        /**
         * Indicates the last checkpoint that occurred during a change data capture (CDC) operation. You can provide this value to the `CdcStartPosition` parameter to start a CDC operation that begins at that checkpoint.
         */
        public var recoveryCheckpoint: kotlin.String? = null
        /**
         * The ARN of the replication instance.
         */
        public var replicationInstanceArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the replication task.
         */
        public var replicationTaskArn: kotlin.String? = null
        /**
         * The date the replication task was created.
         */
        public var replicationTaskCreationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The user-assigned replication task identifier or name.
         *
         * Constraints:
         * + Must contain 1-255 alphanumeric characters or hyphens.
         * + First character must be a letter.
         * + Cannot end with a hyphen or contain two consecutive hyphens.
         */
        public var replicationTaskIdentifier: kotlin.String? = null
        /**
         * The settings for the replication task.
         */
        public var replicationTaskSettings: kotlin.String? = null
        /**
         * The date the replication task is scheduled to start.
         */
        public var replicationTaskStartDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The statistics for the task, including elapsed time, tables loaded, and table errors.
         */
        public var replicationTaskStats: aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationTaskStats? = null
        /**
         * The Amazon Resource Name (ARN) that uniquely identifies the endpoint.
         */
        public var sourceEndpointArn: kotlin.String? = null
        /**
         * The status of the replication task. This response parameter can return one of the following values:
         * + `"moving"` – The task is being moved in response to running the `MoveReplicationTask`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_MoveReplicationTask.html) operation.
         * + `"creating"` – The task is being created in response to running the `CreateReplicationTask`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_CreateReplicationTask.html) operation.
         * + `"deleting"` – The task is being deleted in response to running the `DeleteReplicationTask`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_DeleteReplicationTask.html) operation.
         * + `"failed"` – The task failed to successfully complete the database migration in response to running the `StartReplicationTask`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html) operation.
         * + `"failed-move"` – The task failed to move in response to running the `MoveReplicationTask`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_MoveReplicationTask.html) operation.
         * + `"modifying"` – The task definition is being modified in response to running the `ModifyReplicationTask`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_ModifyReplicationTask.html) operation.
         * + `"ready"` – The task is in a `ready` state where it can respond to other task operations, such as `StartReplicationTask`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html) or `DeleteReplicationTask`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_DeleteReplicationTask.html).
         * + `"running"` – The task is performing a database migration in response to running the `StartReplicationTask`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html) operation.
         * + `"starting"` – The task is preparing to perform a database migration in response to running the `StartReplicationTask`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html) operation.
         * + `"stopped"` – The task has stopped in response to running the `StopReplicationTask`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_StopReplicationTask.html) operation.
         * + `"stopping"` – The task is preparing to stop in response to running the `StopReplicationTask`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_StopReplicationTask.html) operation.
         * + `"testing"` – The database migration specified for this task is being tested in response to running either the `StartReplicationTaskAssessmentRun`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessmentRun.html) or the `StartReplicationTaskAssessment`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessment.html) operation.`StartReplicationTaskAssessmentRun`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessmentRun.html) is an improved premigration task assessment operation. The `StartReplicationTaskAssessment`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessment.html) operation assesses data type compatibility only between the source and target database of a given migration task. In contrast, `StartReplicationTaskAssessmentRun`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessmentRun.html) enables you to specify a variety of premigration task assessments in addition to data type compatibility. These assessments include ones for the validity of primary key definitions and likely issues with database migration performance, among others.
         */
        public var status: kotlin.String? = null
        /**
         * The reason the replication task was stopped. This response parameter can return one of the following values:
         * + `"Stop Reason NORMAL"`
         * + `"Stop Reason RECOVERABLE_ERROR"`
         * + `"Stop Reason FATAL_ERROR"`
         * + `"Stop Reason FULL_LOAD_ONLY_FINISHED"`
         * + `"Stop Reason STOPPED_AFTER_FULL_LOAD"` – Full load completed, with cached changes not applied
         * + `"Stop Reason STOPPED_AFTER_CACHED_EVENTS"` – Full load completed, with cached changes applied
         * + `"Stop Reason EXPRESS_LICENSE_LIMITS_REACHED"`
         * + `"Stop Reason STOPPED_AFTER_DDL_APPLY"` – User-defined stop task after DDL applied
         * + `"Stop Reason STOPPED_DUE_TO_LOW_MEMORY"`
         * + `"Stop Reason STOPPED_DUE_TO_LOW_DISK"`
         * + `"Stop Reason STOPPED_AT_SERVER_TIME"` – User-defined server time for stopping task
         * + `"Stop Reason STOPPED_AT_COMMIT_TIME"` – User-defined commit time for stopping task
         * + `"Stop Reason RECONFIGURATION_RESTART"`
         * + `"Stop Reason RECYCLE_TASK"`
         */
        public var stopReason: kotlin.String? = null
        /**
         * Table mappings specified in the task.
         */
        public var tableMappings: kotlin.String? = null
        /**
         * The ARN that uniquely identifies the endpoint.
         */
        public var targetEndpointArn: kotlin.String? = null
        /**
         * The ARN of the replication instance to which this task is moved in response to running the `MoveReplicationTask`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_MoveReplicationTask.html) operation. Otherwise, this response parameter isn't a member of the `ReplicationTask` object.
         */
        public var targetReplicationInstanceArn: kotlin.String? = null
        /**
         * Supplemental information that the task requires to migrate the data for certain source and target endpoints. For more information, see [Specifying Supplemental Data for Task Settings](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html) in the *Database Migration Service User Guide.*
         */
        public var taskData: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationTask) : this() {
            this.cdcStartPosition = x.cdcStartPosition
            this.cdcStopPosition = x.cdcStopPosition
            this.lastFailureMessage = x.lastFailureMessage
            this.migrationType = x.migrationType
            this.recoveryCheckpoint = x.recoveryCheckpoint
            this.replicationInstanceArn = x.replicationInstanceArn
            this.replicationTaskArn = x.replicationTaskArn
            this.replicationTaskCreationDate = x.replicationTaskCreationDate
            this.replicationTaskIdentifier = x.replicationTaskIdentifier
            this.replicationTaskSettings = x.replicationTaskSettings
            this.replicationTaskStartDate = x.replicationTaskStartDate
            this.replicationTaskStats = x.replicationTaskStats
            this.sourceEndpointArn = x.sourceEndpointArn
            this.status = x.status
            this.stopReason = x.stopReason
            this.tableMappings = x.tableMappings
            this.targetEndpointArn = x.targetEndpointArn
            this.targetReplicationInstanceArn = x.targetReplicationInstanceArn
            this.taskData = x.taskData
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationTask = ReplicationTask(this)

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationTaskStats] inside the given [block]
         */
        public fun replicationTaskStats(block: aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationTaskStats.Builder.() -> kotlin.Unit) {
            this.replicationTaskStats = aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationTaskStats.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
