// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides information about the values of pending modifications to a replication instance. This data type is an object of the `ReplicationInstance`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_ReplicationInstance.html) user-defined data type.
 */
public class ReplicationPendingModifiedValues private constructor(builder: Builder) {
    /**
     * The amount of storage (in gigabytes) that is allocated for the replication instance.
     */
    public val allocatedStorage: kotlin.Int? = builder.allocatedStorage
    /**
     * The engine version number of the replication instance.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * Specifies whether the replication instance is a Multi-AZ deployment. You can't set the `AvailabilityZone` parameter if the Multi-AZ parameter is set to `true`.
     */
    public val multiAz: kotlin.Boolean? = builder.multiAz
    /**
     * The type of IP address protocol used by a replication instance, such as IPv4 only or Dual-stack that supports both IPv4 and IPv6 addressing. IPv6 only is not yet supported.
     */
    public val networkType: kotlin.String? = builder.networkType
    /**
     * The compute and memory capacity of the replication instance as defined for the specified replication instance class.
     *
     * For more information on the settings and capacities for the available replication instance classes, see [ Selecting the right DMS replication instance for your migration](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth).
     */
    public val replicationInstanceClass: kotlin.String? = builder.replicationInstanceClass

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationPendingModifiedValues = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReplicationPendingModifiedValues(")
        append("allocatedStorage=$allocatedStorage,")
        append("engineVersion=$engineVersion,")
        append("multiAz=$multiAz,")
        append("networkType=$networkType,")
        append("replicationInstanceClass=$replicationInstanceClass")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedStorage ?: 0
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (multiAz?.hashCode() ?: 0)
        result = 31 * result + (networkType?.hashCode() ?: 0)
        result = 31 * result + (replicationInstanceClass?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReplicationPendingModifiedValues

        if (allocatedStorage != other.allocatedStorage) return false
        if (engineVersion != other.engineVersion) return false
        if (multiAz != other.multiAz) return false
        if (networkType != other.networkType) return false
        if (replicationInstanceClass != other.replicationInstanceClass) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationPendingModifiedValues = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The amount of storage (in gigabytes) that is allocated for the replication instance.
         */
        public var allocatedStorage: kotlin.Int? = null
        /**
         * The engine version number of the replication instance.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * Specifies whether the replication instance is a Multi-AZ deployment. You can't set the `AvailabilityZone` parameter if the Multi-AZ parameter is set to `true`.
         */
        public var multiAz: kotlin.Boolean? = null
        /**
         * The type of IP address protocol used by a replication instance, such as IPv4 only or Dual-stack that supports both IPv4 and IPv6 addressing. IPv6 only is not yet supported.
         */
        public var networkType: kotlin.String? = null
        /**
         * The compute and memory capacity of the replication instance as defined for the specified replication instance class.
         *
         * For more information on the settings and capacities for the available replication instance classes, see [ Selecting the right DMS replication instance for your migration](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth).
         */
        public var replicationInstanceClass: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationPendingModifiedValues) : this() {
            this.allocatedStorage = x.allocatedStorage
            this.engineVersion = x.engineVersion
            this.multiAz = x.multiAz
            this.networkType = x.networkType
            this.replicationInstanceClass = x.replicationInstanceClass
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationPendingModifiedValues = ReplicationPendingModifiedValues(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
