// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides information about the required target engine settings.
 */
public class RecommendationSettings private constructor(builder: Builder) {
    /**
     * The size of your target instance. Fleet Advisor calculates this value based on your data collection type, such as total capacity and resource utilization. Valid values include `"total-capacity"` and `"utilization"`.
     */
    public val instanceSizingType: kotlin.String = requireNotNull(builder.instanceSizingType) { "A non-null value must be provided for instanceSizingType" }
    /**
     * The deployment option for your target engine. For production databases, Fleet Advisor chooses Multi-AZ deployment. For development or test databases, Fleet Advisor chooses Single-AZ deployment. Valid values include `"development"` and `"production"`.
     */
    public val workloadType: kotlin.String = requireNotNull(builder.workloadType) { "A non-null value must be provided for workloadType" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.RecommendationSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecommendationSettings(")
        append("instanceSizingType=$instanceSizingType,")
        append("workloadType=$workloadType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceSizingType.hashCode()
        result = 31 * result + (workloadType.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecommendationSettings

        if (instanceSizingType != other.instanceSizingType) return false
        if (workloadType != other.workloadType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.RecommendationSettings = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The size of your target instance. Fleet Advisor calculates this value based on your data collection type, such as total capacity and resource utilization. Valid values include `"total-capacity"` and `"utilization"`.
         */
        public var instanceSizingType: kotlin.String? = null
        /**
         * The deployment option for your target engine. For production databases, Fleet Advisor chooses Multi-AZ deployment. For development or test databases, Fleet Advisor chooses Single-AZ deployment. Valid values include `"development"` and `"production"`.
         */
        public var workloadType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.RecommendationSettings) : this() {
            this.instanceSizingType = x.instanceSizingType
            this.workloadType = x.workloadType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.RecommendationSettings = RecommendationSettings(this)

        internal fun correctErrors(): Builder {
            if (instanceSizingType == null) instanceSizingType = ""
            if (workloadType == null) workloadType = ""
            return this
        }
    }
}
