// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about provisioning resources for an DMS serverless replication.
 */
public class ProvisionData private constructor(builder: Builder) {
    /**
     * The timestamp when provisioning became available.
     */
    public val dateNewProvisioningDataAvailable: aws.smithy.kotlin.runtime.time.Instant? = builder.dateNewProvisioningDataAvailable
    /**
     * The timestamp when DMS provisioned replication resources.
     */
    public val dateProvisioned: aws.smithy.kotlin.runtime.time.Instant? = builder.dateProvisioned
    /**
     * Whether the new provisioning is available to the replication.
     */
    public val isNewProvisioningAvailable: kotlin.Boolean = builder.isNewProvisioningAvailable
    /**
     * The current provisioning state
     */
    public val provisionState: kotlin.String? = builder.provisionState
    /**
     * The number of capacity units the replication is using.
     */
    public val provisionedCapacityUnits: kotlin.Int = builder.provisionedCapacityUnits
    /**
     * A message describing the reason that DMS provisioned new resources for the serverless replication.
     */
    public val reasonForNewProvisioningData: kotlin.String? = builder.reasonForNewProvisioningData

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.ProvisionData = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProvisionData(")
        append("dateNewProvisioningDataAvailable=$dateNewProvisioningDataAvailable,")
        append("dateProvisioned=$dateProvisioned,")
        append("isNewProvisioningAvailable=$isNewProvisioningAvailable,")
        append("provisionState=$provisionState,")
        append("provisionedCapacityUnits=$provisionedCapacityUnits,")
        append("reasonForNewProvisioningData=$reasonForNewProvisioningData")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dateNewProvisioningDataAvailable?.hashCode() ?: 0
        result = 31 * result + (dateProvisioned?.hashCode() ?: 0)
        result = 31 * result + (isNewProvisioningAvailable.hashCode())
        result = 31 * result + (provisionState?.hashCode() ?: 0)
        result = 31 * result + (provisionedCapacityUnits)
        result = 31 * result + (reasonForNewProvisioningData?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProvisionData

        if (dateNewProvisioningDataAvailable != other.dateNewProvisioningDataAvailable) return false
        if (dateProvisioned != other.dateProvisioned) return false
        if (isNewProvisioningAvailable != other.isNewProvisioningAvailable) return false
        if (provisionState != other.provisionState) return false
        if (provisionedCapacityUnits != other.provisionedCapacityUnits) return false
        if (reasonForNewProvisioningData != other.reasonForNewProvisioningData) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.ProvisionData = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The timestamp when provisioning became available.
         */
        public var dateNewProvisioningDataAvailable: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The timestamp when DMS provisioned replication resources.
         */
        public var dateProvisioned: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Whether the new provisioning is available to the replication.
         */
        public var isNewProvisioningAvailable: kotlin.Boolean = false
        /**
         * The current provisioning state
         */
        public var provisionState: kotlin.String? = null
        /**
         * The number of capacity units the replication is using.
         */
        public var provisionedCapacityUnits: kotlin.Int = 0
        /**
         * A message describing the reason that DMS provisioned new resources for the serverless replication.
         */
        public var reasonForNewProvisioningData: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.ProvisionData) : this() {
            this.dateNewProvisioningDataAvailable = x.dateNewProvisioningDataAvailable
            this.dateProvisioned = x.dateProvisioned
            this.isNewProvisioningAvailable = x.isNewProvisioningAvailable
            this.provisionState = x.provisionState
            this.provisionedCapacityUnits = x.provisionedCapacityUnits
            this.reasonForNewProvisioningData = x.reasonForNewProvisioningData
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.ProvisionData = ProvisionData(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
