// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides information that defines a MongoDB data provider.
 */
public class MongoDbDataProviderSettings private constructor(builder: Builder) {
    /**
     * The authentication method for connecting to the data provider. Valid values are DEFAULT, MONGODB_CR, or SCRAM_SHA_1.
     */
    public val authMechanism: aws.sdk.kotlin.services.databasemigrationservice.model.AuthMechanismValue? = builder.authMechanism
    /**
     * The MongoDB database name. This setting isn't used when `AuthType` is set to `"no"`.
     *
     * The default is `"admin"`.
     */
    public val authSource: kotlin.String? = builder.authSource
    /**
     * The authentication type for the database connection. Valid values are PASSWORD or NO.
     */
    public val authType: aws.sdk.kotlin.services.databasemigrationservice.model.AuthTypeValue? = builder.authType
    /**
     * The Amazon Resource Name (ARN) of the certificate used for SSL connection.
     */
    public val certificateArn: kotlin.String? = builder.certificateArn
    /**
     * The database name on the MongoDB data provider.
     */
    public val databaseName: kotlin.String? = builder.databaseName
    /**
     * The port value for the MongoDB data provider.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The name of the MongoDB server.
     */
    public val serverName: kotlin.String? = builder.serverName
    /**
     * The SSL mode used to connect to the MongoDB data provider. The default value is `none`.
     */
    public val sslMode: aws.sdk.kotlin.services.databasemigrationservice.model.DmsSslModeValue? = builder.sslMode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.MongoDbDataProviderSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MongoDbDataProviderSettings(")
        append("authMechanism=$authMechanism,")
        append("authSource=$authSource,")
        append("authType=$authType,")
        append("certificateArn=$certificateArn,")
        append("databaseName=$databaseName,")
        append("port=$port,")
        append("serverName=$serverName,")
        append("sslMode=$sslMode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authMechanism?.hashCode() ?: 0
        result = 31 * result + (authSource?.hashCode() ?: 0)
        result = 31 * result + (authType?.hashCode() ?: 0)
        result = 31 * result + (certificateArn?.hashCode() ?: 0)
        result = 31 * result + (databaseName?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (serverName?.hashCode() ?: 0)
        result = 31 * result + (sslMode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MongoDbDataProviderSettings

        if (authMechanism != other.authMechanism) return false
        if (authSource != other.authSource) return false
        if (authType != other.authType) return false
        if (certificateArn != other.certificateArn) return false
        if (databaseName != other.databaseName) return false
        if (port != other.port) return false
        if (serverName != other.serverName) return false
        if (sslMode != other.sslMode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.MongoDbDataProviderSettings = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The authentication method for connecting to the data provider. Valid values are DEFAULT, MONGODB_CR, or SCRAM_SHA_1.
         */
        public var authMechanism: aws.sdk.kotlin.services.databasemigrationservice.model.AuthMechanismValue? = null
        /**
         * The MongoDB database name. This setting isn't used when `AuthType` is set to `"no"`.
         *
         * The default is `"admin"`.
         */
        public var authSource: kotlin.String? = null
        /**
         * The authentication type for the database connection. Valid values are PASSWORD or NO.
         */
        public var authType: aws.sdk.kotlin.services.databasemigrationservice.model.AuthTypeValue? = null
        /**
         * The Amazon Resource Name (ARN) of the certificate used for SSL connection.
         */
        public var certificateArn: kotlin.String? = null
        /**
         * The database name on the MongoDB data provider.
         */
        public var databaseName: kotlin.String? = null
        /**
         * The port value for the MongoDB data provider.
         */
        public var port: kotlin.Int? = null
        /**
         * The name of the MongoDB server.
         */
        public var serverName: kotlin.String? = null
        /**
         * The SSL mode used to connect to the MongoDB data provider. The default value is `none`.
         */
        public var sslMode: aws.sdk.kotlin.services.databasemigrationservice.model.DmsSslModeValue? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.MongoDbDataProviderSettings) : this() {
            this.authMechanism = x.authMechanism
            this.authSource = x.authSource
            this.authType = x.authType
            this.certificateArn = x.certificateArn
            this.databaseName = x.databaseName
            this.port = x.port
            this.serverName = x.serverName
            this.sslMode = x.sslMode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.MongoDbDataProviderSettings = MongoDbDataProviderSettings(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
