// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 *
 */
public class ModifyReplicationTaskRequest private constructor(builder: Builder) {
    /**
     * Indicates when you want a change data capture (CDC) operation to start. Use either CdcStartPosition or CdcStartTime to specify when you want a CDC operation to start. Specifying both values results in an error.
     *
     *  The value can be in date, checkpoint, or LSN/SCN format.
     *
     * Date Example: --cdc-start-position “2018-03-08T12:12:12”
     *
     * Checkpoint Example: --cdc-start-position "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"
     *
     * LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”
     *
     * When you use this task setting with a source PostgreSQL database, a logical replication slot should already be created and associated with the source endpoint. You can verify this by setting the `slotName` extra connection attribute to the name of this logical replication slot. For more information, see [Extra Connection Attributes When Using PostgreSQL as a Source for DMS](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib).
     */
    public val cdcStartPosition: kotlin.String? = builder.cdcStartPosition
    /**
     * Indicates the start time for a change data capture (CDC) operation. Use either CdcStartTime or CdcStartPosition to specify when you want a CDC operation to start. Specifying both values results in an error.
     *
     * Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”
     */
    public val cdcStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.cdcStartTime
    /**
     * Indicates when you want a change data capture (CDC) operation to stop. The value can be either server time or commit time.
     *
     * Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”
     *
     * Commit time example: --cdc-stop-position “commit_time:2018-02-09T12:12:12“
     */
    public val cdcStopPosition: kotlin.String? = builder.cdcStopPosition
    /**
     * The migration type. Valid values: `full-load` | `cdc` | `full-load-and-cdc`
     */
    public val migrationType: aws.sdk.kotlin.services.databasemigrationservice.model.MigrationTypeValue? = builder.migrationType
    /**
     * The Amazon Resource Name (ARN) of the replication task.
     */
    public val replicationTaskArn: kotlin.String? = builder.replicationTaskArn
    /**
     * The replication task identifier.
     *
     * Constraints:
     * + Must contain 1-255 alphanumeric characters or hyphens.
     * + First character must be a letter.
     * + Cannot end with a hyphen or contain two consecutive hyphens.
     */
    public val replicationTaskIdentifier: kotlin.String? = builder.replicationTaskIdentifier
    /**
     * JSON file that contains settings for the task, such as task metadata settings.
     */
    public val replicationTaskSettings: kotlin.String? = builder.replicationTaskSettings
    /**
     * When using the CLI or boto3, provide the path of the JSON file that contains the table mappings. Precede the path with `file://`. For example, `--table-mappings file://mappingfile.json`. When working with the DMS API, provide the JSON as the parameter value.
     */
    public val tableMappings: kotlin.String? = builder.tableMappings
    /**
     * Supplemental information that the task requires to migrate the data for certain source and target endpoints. For more information, see [Specifying Supplemental Data for Task Settings](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html) in the *Database Migration Service User Guide.*
     */
    public val taskData: kotlin.String? = builder.taskData

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.ModifyReplicationTaskRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyReplicationTaskRequest(")
        append("cdcStartPosition=$cdcStartPosition,")
        append("cdcStartTime=$cdcStartTime,")
        append("cdcStopPosition=$cdcStopPosition,")
        append("migrationType=$migrationType,")
        append("replicationTaskArn=$replicationTaskArn,")
        append("replicationTaskIdentifier=$replicationTaskIdentifier,")
        append("replicationTaskSettings=$replicationTaskSettings,")
        append("tableMappings=$tableMappings,")
        append("taskData=$taskData")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cdcStartPosition?.hashCode() ?: 0
        result = 31 * result + (cdcStartTime?.hashCode() ?: 0)
        result = 31 * result + (cdcStopPosition?.hashCode() ?: 0)
        result = 31 * result + (migrationType?.hashCode() ?: 0)
        result = 31 * result + (replicationTaskArn?.hashCode() ?: 0)
        result = 31 * result + (replicationTaskIdentifier?.hashCode() ?: 0)
        result = 31 * result + (replicationTaskSettings?.hashCode() ?: 0)
        result = 31 * result + (tableMappings?.hashCode() ?: 0)
        result = 31 * result + (taskData?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifyReplicationTaskRequest

        if (cdcStartPosition != other.cdcStartPosition) return false
        if (cdcStartTime != other.cdcStartTime) return false
        if (cdcStopPosition != other.cdcStopPosition) return false
        if (migrationType != other.migrationType) return false
        if (replicationTaskArn != other.replicationTaskArn) return false
        if (replicationTaskIdentifier != other.replicationTaskIdentifier) return false
        if (replicationTaskSettings != other.replicationTaskSettings) return false
        if (tableMappings != other.tableMappings) return false
        if (taskData != other.taskData) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.ModifyReplicationTaskRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates when you want a change data capture (CDC) operation to start. Use either CdcStartPosition or CdcStartTime to specify when you want a CDC operation to start. Specifying both values results in an error.
         *
         *  The value can be in date, checkpoint, or LSN/SCN format.
         *
         * Date Example: --cdc-start-position “2018-03-08T12:12:12”
         *
         * Checkpoint Example: --cdc-start-position "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"
         *
         * LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”
         *
         * When you use this task setting with a source PostgreSQL database, a logical replication slot should already be created and associated with the source endpoint. You can verify this by setting the `slotName` extra connection attribute to the name of this logical replication slot. For more information, see [Extra Connection Attributes When Using PostgreSQL as a Source for DMS](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib).
         */
        public var cdcStartPosition: kotlin.String? = null
        /**
         * Indicates the start time for a change data capture (CDC) operation. Use either CdcStartTime or CdcStartPosition to specify when you want a CDC operation to start. Specifying both values results in an error.
         *
         * Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”
         */
        public var cdcStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Indicates when you want a change data capture (CDC) operation to stop. The value can be either server time or commit time.
         *
         * Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”
         *
         * Commit time example: --cdc-stop-position “commit_time:2018-02-09T12:12:12“
         */
        public var cdcStopPosition: kotlin.String? = null
        /**
         * The migration type. Valid values: `full-load` | `cdc` | `full-load-and-cdc`
         */
        public var migrationType: aws.sdk.kotlin.services.databasemigrationservice.model.MigrationTypeValue? = null
        /**
         * The Amazon Resource Name (ARN) of the replication task.
         */
        public var replicationTaskArn: kotlin.String? = null
        /**
         * The replication task identifier.
         *
         * Constraints:
         * + Must contain 1-255 alphanumeric characters or hyphens.
         * + First character must be a letter.
         * + Cannot end with a hyphen or contain two consecutive hyphens.
         */
        public var replicationTaskIdentifier: kotlin.String? = null
        /**
         * JSON file that contains settings for the task, such as task metadata settings.
         */
        public var replicationTaskSettings: kotlin.String? = null
        /**
         * When using the CLI or boto3, provide the path of the JSON file that contains the table mappings. Precede the path with `file://`. For example, `--table-mappings file://mappingfile.json`. When working with the DMS API, provide the JSON as the parameter value.
         */
        public var tableMappings: kotlin.String? = null
        /**
         * Supplemental information that the task requires to migrate the data for certain source and target endpoints. For more information, see [Specifying Supplemental Data for Task Settings](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html) in the *Database Migration Service User Guide.*
         */
        public var taskData: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.ModifyReplicationTaskRequest) : this() {
            this.cdcStartPosition = x.cdcStartPosition
            this.cdcStartTime = x.cdcStartTime
            this.cdcStopPosition = x.cdcStopPosition
            this.migrationType = x.migrationType
            this.replicationTaskArn = x.replicationTaskArn
            this.replicationTaskIdentifier = x.replicationTaskIdentifier
            this.replicationTaskSettings = x.replicationTaskSettings
            this.tableMappings = x.tableMappings
            this.taskData = x.taskData
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.ModifyReplicationTaskRequest = ModifyReplicationTaskRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
