// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information that defines a migration project.
 */
public class MigrationProject private constructor(builder: Builder) {
    /**
     * A user-friendly description of the migration project.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The Amazon Resource Name (ARN) of the instance profile for your migration project.
     */
    public val instanceProfileArn: kotlin.String? = builder.instanceProfileArn
    /**
     * The name of the associated instance profile.
     */
    public val instanceProfileName: kotlin.String? = builder.instanceProfileName
    /**
     * The ARN string that uniquely identifies the migration project.
     */
    public val migrationProjectArn: kotlin.String? = builder.migrationProjectArn
    /**
     * The time when the migration project was created.
     */
    public val migrationProjectCreationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.migrationProjectCreationTime
    /**
     * The name of the migration project.
     */
    public val migrationProjectName: kotlin.String? = builder.migrationProjectName
    /**
     * The schema conversion application attributes, including the Amazon S3 bucket name and Amazon S3 role ARN.
     */
    public val schemaConversionApplicationAttributes: aws.sdk.kotlin.services.databasemigrationservice.model.ScApplicationAttributes? = builder.schemaConversionApplicationAttributes
    /**
     * Information about the source data provider, including the name or ARN, and Secrets Manager parameters.
     */
    public val sourceDataProviderDescriptors: List<DataProviderDescriptor>? = builder.sourceDataProviderDescriptors
    /**
     * Information about the target data provider, including the name or ARN, and Secrets Manager parameters.
     */
    public val targetDataProviderDescriptors: List<DataProviderDescriptor>? = builder.targetDataProviderDescriptors
    /**
     * The settings in JSON format for migration rules. Migration rules make it possible for you to change the object names according to the rules that you specify. For example, you can change an object name to lowercase or uppercase, add or remove a prefix or suffix, or rename objects.
     */
    public val transformationRules: kotlin.String? = builder.transformationRules

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.MigrationProject = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MigrationProject(")
        append("description=$description,")
        append("instanceProfileArn=$instanceProfileArn,")
        append("instanceProfileName=$instanceProfileName,")
        append("migrationProjectArn=$migrationProjectArn,")
        append("migrationProjectCreationTime=$migrationProjectCreationTime,")
        append("migrationProjectName=$migrationProjectName,")
        append("schemaConversionApplicationAttributes=$schemaConversionApplicationAttributes,")
        append("sourceDataProviderDescriptors=$sourceDataProviderDescriptors,")
        append("targetDataProviderDescriptors=$targetDataProviderDescriptors,")
        append("transformationRules=$transformationRules")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (instanceProfileArn?.hashCode() ?: 0)
        result = 31 * result + (instanceProfileName?.hashCode() ?: 0)
        result = 31 * result + (migrationProjectArn?.hashCode() ?: 0)
        result = 31 * result + (migrationProjectCreationTime?.hashCode() ?: 0)
        result = 31 * result + (migrationProjectName?.hashCode() ?: 0)
        result = 31 * result + (schemaConversionApplicationAttributes?.hashCode() ?: 0)
        result = 31 * result + (sourceDataProviderDescriptors?.hashCode() ?: 0)
        result = 31 * result + (targetDataProviderDescriptors?.hashCode() ?: 0)
        result = 31 * result + (transformationRules?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MigrationProject

        if (description != other.description) return false
        if (instanceProfileArn != other.instanceProfileArn) return false
        if (instanceProfileName != other.instanceProfileName) return false
        if (migrationProjectArn != other.migrationProjectArn) return false
        if (migrationProjectCreationTime != other.migrationProjectCreationTime) return false
        if (migrationProjectName != other.migrationProjectName) return false
        if (schemaConversionApplicationAttributes != other.schemaConversionApplicationAttributes) return false
        if (sourceDataProviderDescriptors != other.sourceDataProviderDescriptors) return false
        if (targetDataProviderDescriptors != other.targetDataProviderDescriptors) return false
        if (transformationRules != other.transformationRules) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.MigrationProject = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A user-friendly description of the migration project.
         */
        public var description: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the instance profile for your migration project.
         */
        public var instanceProfileArn: kotlin.String? = null
        /**
         * The name of the associated instance profile.
         */
        public var instanceProfileName: kotlin.String? = null
        /**
         * The ARN string that uniquely identifies the migration project.
         */
        public var migrationProjectArn: kotlin.String? = null
        /**
         * The time when the migration project was created.
         */
        public var migrationProjectCreationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the migration project.
         */
        public var migrationProjectName: kotlin.String? = null
        /**
         * The schema conversion application attributes, including the Amazon S3 bucket name and Amazon S3 role ARN.
         */
        public var schemaConversionApplicationAttributes: aws.sdk.kotlin.services.databasemigrationservice.model.ScApplicationAttributes? = null
        /**
         * Information about the source data provider, including the name or ARN, and Secrets Manager parameters.
         */
        public var sourceDataProviderDescriptors: List<DataProviderDescriptor>? = null
        /**
         * Information about the target data provider, including the name or ARN, and Secrets Manager parameters.
         */
        public var targetDataProviderDescriptors: List<DataProviderDescriptor>? = null
        /**
         * The settings in JSON format for migration rules. Migration rules make it possible for you to change the object names according to the rules that you specify. For example, you can change an object name to lowercase or uppercase, add or remove a prefix or suffix, or rename objects.
         */
        public var transformationRules: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.MigrationProject) : this() {
            this.description = x.description
            this.instanceProfileArn = x.instanceProfileArn
            this.instanceProfileName = x.instanceProfileName
            this.migrationProjectArn = x.migrationProjectArn
            this.migrationProjectCreationTime = x.migrationProjectCreationTime
            this.migrationProjectName = x.migrationProjectName
            this.schemaConversionApplicationAttributes = x.schemaConversionApplicationAttributes
            this.sourceDataProviderDescriptors = x.sourceDataProviderDescriptors
            this.targetDataProviderDescriptors = x.targetDataProviderDescriptors
            this.transformationRules = x.transformationRules
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.MigrationProject = MigrationProject(this)

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.ScApplicationAttributes] inside the given [block]
         */
        public fun schemaConversionApplicationAttributes(block: aws.sdk.kotlin.services.databasemigrationservice.model.ScApplicationAttributes.Builder.() -> kotlin.Unit) {
            this.schemaConversionApplicationAttributes = aws.sdk.kotlin.services.databasemigrationservice.model.ScApplicationAttributes.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
