// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes a schema object in a Fleet Advisor collector inventory.
 */
public class FleetAdvisorSchemaObjectResponse private constructor(builder: Builder) {
    /**
     * The number of lines of code in a schema object in a Fleet Advisor collector inventory.
     */
    public val codeLineCount: kotlin.Long? = builder.codeLineCount
    /**
     * The size level of the code in a schema object in a Fleet Advisor collector inventory.
     */
    public val codeSize: kotlin.Long? = builder.codeSize
    /**
     * The number of objects in a schema object in a Fleet Advisor collector inventory.
     */
    public val numberOfObjects: kotlin.Long? = builder.numberOfObjects
    /**
     * The type of the schema object, as reported by the database engine. Examples include the following:
     * + `function`
     * + `trigger`
     * + `SYSTEM_TABLE`
     * + `QUEUE`
     */
    public val objectType: kotlin.String? = builder.objectType
    /**
     * The ID of a schema object in a Fleet Advisor collector inventory.
     */
    public val schemaId: kotlin.String? = builder.schemaId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.FleetAdvisorSchemaObjectResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FleetAdvisorSchemaObjectResponse(")
        append("codeLineCount=$codeLineCount,")
        append("codeSize=$codeSize,")
        append("numberOfObjects=$numberOfObjects,")
        append("objectType=$objectType,")
        append("schemaId=$schemaId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = codeLineCount?.hashCode() ?: 0
        result = 31 * result + (codeSize?.hashCode() ?: 0)
        result = 31 * result + (numberOfObjects?.hashCode() ?: 0)
        result = 31 * result + (objectType?.hashCode() ?: 0)
        result = 31 * result + (schemaId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FleetAdvisorSchemaObjectResponse

        if (codeLineCount != other.codeLineCount) return false
        if (codeSize != other.codeSize) return false
        if (numberOfObjects != other.numberOfObjects) return false
        if (objectType != other.objectType) return false
        if (schemaId != other.schemaId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.FleetAdvisorSchemaObjectResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of lines of code in a schema object in a Fleet Advisor collector inventory.
         */
        public var codeLineCount: kotlin.Long? = null
        /**
         * The size level of the code in a schema object in a Fleet Advisor collector inventory.
         */
        public var codeSize: kotlin.Long? = null
        /**
         * The number of objects in a schema object in a Fleet Advisor collector inventory.
         */
        public var numberOfObjects: kotlin.Long? = null
        /**
         * The type of the schema object, as reported by the database engine. Examples include the following:
         * + `function`
         * + `trigger`
         * + `SYSTEM_TABLE`
         * + `QUEUE`
         */
        public var objectType: kotlin.String? = null
        /**
         * The ID of a schema object in a Fleet Advisor collector inventory.
         */
        public var schemaId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.FleetAdvisorSchemaObjectResponse) : this() {
            this.codeLineCount = x.codeLineCount
            this.codeSize = x.codeSize
            this.numberOfObjects = x.numberOfObjects
            this.objectType = x.objectType
            this.schemaId = x.schemaId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.FleetAdvisorSchemaObjectResponse = FleetAdvisorSchemaObjectResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
