// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides the Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role used to define an Amazon DynamoDB target endpoint.
 */
public class DynamoDbSettings private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) used by the service to access the IAM role. The role must allow the `iam:PassRole` action.
     */
    public val serviceAccessRoleArn: kotlin.String = requireNotNull(builder.serviceAccessRoleArn) { "A non-null value must be provided for serviceAccessRoleArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.DynamoDbSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DynamoDbSettings(")
        append("serviceAccessRoleArn=$serviceAccessRoleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = serviceAccessRoleArn.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DynamoDbSettings

        if (serviceAccessRoleArn != other.serviceAccessRoleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.DynamoDbSettings = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) used by the service to access the IAM role. The role must allow the `iam:PassRole` action.
         */
        public var serviceAccessRoleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.DynamoDbSettings) : this() {
            this.serviceAccessRoleArn = x.serviceAccessRoleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.DynamoDbSettings = DynamoDbSettings(this)

        internal fun correctErrors(): Builder {
            if (serviceAccessRoleArn == null) serviceAccessRoleArn = ""
            return this
        }
    }
}
