// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes a database in a Fleet Advisor collector inventory.
 */
public class DatabaseResponse private constructor(builder: Builder) {
    /**
     * A list of collectors associated with the database.
     */
    public val collectors: List<CollectorShortInfoResponse>? = builder.collectors
    /**
     * The ID of a database in a Fleet Advisor collector inventory.
     */
    public val databaseId: kotlin.String? = builder.databaseId
    /**
     * The name of a database in a Fleet Advisor collector inventory.
     */
    public val databaseName: kotlin.String? = builder.databaseName
    /**
     * The IP address of a database in a Fleet Advisor collector inventory.
     */
    public val ipAddress: kotlin.String? = builder.ipAddress
    /**
     * The number of schemas in a Fleet Advisor collector inventory database.
     */
    public val numberOfSchemas: kotlin.Long? = builder.numberOfSchemas
    /**
     * The server name of a database in a Fleet Advisor collector inventory.
     */
    public val server: aws.sdk.kotlin.services.databasemigrationservice.model.ServerShortInfoResponse? = builder.server
    /**
     * The software details of a database in a Fleet Advisor collector inventory, such as database engine and version.
     */
    public val softwareDetails: aws.sdk.kotlin.services.databasemigrationservice.model.DatabaseInstanceSoftwareDetailsResponse? = builder.softwareDetails

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.DatabaseResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DatabaseResponse(")
        append("collectors=$collectors,")
        append("databaseId=$databaseId,")
        append("databaseName=$databaseName,")
        append("ipAddress=$ipAddress,")
        append("numberOfSchemas=$numberOfSchemas,")
        append("server=$server,")
        append("softwareDetails=$softwareDetails")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = collectors?.hashCode() ?: 0
        result = 31 * result + (databaseId?.hashCode() ?: 0)
        result = 31 * result + (databaseName?.hashCode() ?: 0)
        result = 31 * result + (ipAddress?.hashCode() ?: 0)
        result = 31 * result + (numberOfSchemas?.hashCode() ?: 0)
        result = 31 * result + (server?.hashCode() ?: 0)
        result = 31 * result + (softwareDetails?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DatabaseResponse

        if (collectors != other.collectors) return false
        if (databaseId != other.databaseId) return false
        if (databaseName != other.databaseName) return false
        if (ipAddress != other.ipAddress) return false
        if (numberOfSchemas != other.numberOfSchemas) return false
        if (server != other.server) return false
        if (softwareDetails != other.softwareDetails) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.DatabaseResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of collectors associated with the database.
         */
        public var collectors: List<CollectorShortInfoResponse>? = null
        /**
         * The ID of a database in a Fleet Advisor collector inventory.
         */
        public var databaseId: kotlin.String? = null
        /**
         * The name of a database in a Fleet Advisor collector inventory.
         */
        public var databaseName: kotlin.String? = null
        /**
         * The IP address of a database in a Fleet Advisor collector inventory.
         */
        public var ipAddress: kotlin.String? = null
        /**
         * The number of schemas in a Fleet Advisor collector inventory database.
         */
        public var numberOfSchemas: kotlin.Long? = null
        /**
         * The server name of a database in a Fleet Advisor collector inventory.
         */
        public var server: aws.sdk.kotlin.services.databasemigrationservice.model.ServerShortInfoResponse? = null
        /**
         * The software details of a database in a Fleet Advisor collector inventory, such as database engine and version.
         */
        public var softwareDetails: aws.sdk.kotlin.services.databasemigrationservice.model.DatabaseInstanceSoftwareDetailsResponse? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.DatabaseResponse) : this() {
            this.collectors = x.collectors
            this.databaseId = x.databaseId
            this.databaseName = x.databaseName
            this.ipAddress = x.ipAddress
            this.numberOfSchemas = x.numberOfSchemas
            this.server = x.server
            this.softwareDetails = x.softwareDetails
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.DatabaseResponse = DatabaseResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.ServerShortInfoResponse] inside the given [block]
         */
        public fun server(block: aws.sdk.kotlin.services.databasemigrationservice.model.ServerShortInfoResponse.Builder.() -> kotlin.Unit) {
            this.server = aws.sdk.kotlin.services.databasemigrationservice.model.ServerShortInfoResponse.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.databasemigrationservice.model.DatabaseInstanceSoftwareDetailsResponse] inside the given [block]
         */
        public fun softwareDetails(block: aws.sdk.kotlin.services.databasemigrationservice.model.DatabaseInstanceSoftwareDetailsResponse.Builder.() -> kotlin.Unit) {
            this.softwareDetails = aws.sdk.kotlin.services.databasemigrationservice.model.DatabaseInstanceSoftwareDetailsResponse.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
