// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about a data provider.
 */
public class DataProviderDescriptorDefinition private constructor(builder: Builder) {
    /**
     * The name or Amazon Resource Name (ARN) of the data provider.
     */
    public val dataProviderIdentifier: kotlin.String = requireNotNull(builder.dataProviderIdentifier) { "A non-null value must be provided for dataProviderIdentifier" }
    /**
     * The ARN of the role used to access Amazon Web Services Secrets Manager.
     */
    public val secretsManagerAccessRoleArn: kotlin.String? = builder.secretsManagerAccessRoleArn
    /**
     * The identifier of the Amazon Web Services Secrets Manager Secret used to store access credentials for the data provider.
     */
    public val secretsManagerSecretId: kotlin.String? = builder.secretsManagerSecretId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.DataProviderDescriptorDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataProviderDescriptorDefinition(")
        append("dataProviderIdentifier=$dataProviderIdentifier,")
        append("secretsManagerAccessRoleArn=$secretsManagerAccessRoleArn,")
        append("secretsManagerSecretId=$secretsManagerSecretId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataProviderIdentifier.hashCode()
        result = 31 * result + (secretsManagerAccessRoleArn?.hashCode() ?: 0)
        result = 31 * result + (secretsManagerSecretId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataProviderDescriptorDefinition

        if (dataProviderIdentifier != other.dataProviderIdentifier) return false
        if (secretsManagerAccessRoleArn != other.secretsManagerAccessRoleArn) return false
        if (secretsManagerSecretId != other.secretsManagerSecretId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.DataProviderDescriptorDefinition = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name or Amazon Resource Name (ARN) of the data provider.
         */
        public var dataProviderIdentifier: kotlin.String? = null
        /**
         * The ARN of the role used to access Amazon Web Services Secrets Manager.
         */
        public var secretsManagerAccessRoleArn: kotlin.String? = null
        /**
         * The identifier of the Amazon Web Services Secrets Manager Secret used to store access credentials for the data provider.
         */
        public var secretsManagerSecretId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.DataProviderDescriptorDefinition) : this() {
            this.dataProviderIdentifier = x.dataProviderIdentifier
            this.secretsManagerAccessRoleArn = x.secretsManagerAccessRoleArn
            this.secretsManagerSecretId = x.secretsManagerSecretId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.DataProviderDescriptorDefinition = DataProviderDescriptorDefinition(this)

        internal fun correctErrors(): Builder {
            if (dataProviderIdentifier == null) dataProviderIdentifier = ""
            return this
        }
    }
}
