// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information that defines a data provider.
 */
public class DataProvider private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) string that uniquely identifies the data provider.
     */
    public val dataProviderArn: kotlin.String? = builder.dataProviderArn
    /**
     * The time the data provider was created.
     */
    public val dataProviderCreationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.dataProviderCreationTime
    /**
     * The name of the data provider.
     */
    public val dataProviderName: kotlin.String? = builder.dataProviderName
    /**
     * A description of the data provider. Descriptions can have up to 31 characters. A description can contain only ASCII letters, digits, and hyphens ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens, and can only begin with a letter.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The type of database engine for the data provider. Valid values include `"aurora"`, `"aurora-postgresql"`, `"mysql"`, `"oracle"`, `"postgres"`, `"sqlserver"`, `redshift`, `mariadb`, `mongodb`, and `docdb`. A value of `"aurora"` represents Amazon Aurora MySQL-Compatible Edition.
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The settings in JSON format for a data provider.
     */
    public val settings: aws.sdk.kotlin.services.databasemigrationservice.model.DataProviderSettings? = builder.settings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.DataProvider = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataProvider(")
        append("dataProviderArn=$dataProviderArn,")
        append("dataProviderCreationTime=$dataProviderCreationTime,")
        append("dataProviderName=$dataProviderName,")
        append("description=$description,")
        append("engine=$engine,")
        append("settings=$settings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataProviderArn?.hashCode() ?: 0
        result = 31 * result + (dataProviderCreationTime?.hashCode() ?: 0)
        result = 31 * result + (dataProviderName?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (settings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataProvider

        if (dataProviderArn != other.dataProviderArn) return false
        if (dataProviderCreationTime != other.dataProviderCreationTime) return false
        if (dataProviderName != other.dataProviderName) return false
        if (description != other.description) return false
        if (engine != other.engine) return false
        if (settings != other.settings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.DataProvider = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) string that uniquely identifies the data provider.
         */
        public var dataProviderArn: kotlin.String? = null
        /**
         * The time the data provider was created.
         */
        public var dataProviderCreationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the data provider.
         */
        public var dataProviderName: kotlin.String? = null
        /**
         * A description of the data provider. Descriptions can have up to 31 characters. A description can contain only ASCII letters, digits, and hyphens ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens, and can only begin with a letter.
         */
        public var description: kotlin.String? = null
        /**
         * The type of database engine for the data provider. Valid values include `"aurora"`, `"aurora-postgresql"`, `"mysql"`, `"oracle"`, `"postgres"`, `"sqlserver"`, `redshift`, `mariadb`, `mongodb`, and `docdb`. A value of `"aurora"` represents Amazon Aurora MySQL-Compatible Edition.
         */
        public var engine: kotlin.String? = null
        /**
         * The settings in JSON format for a data provider.
         */
        public var settings: aws.sdk.kotlin.services.databasemigrationservice.model.DataProviderSettings? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.DataProvider) : this() {
            this.dataProviderArn = x.dataProviderArn
            this.dataProviderCreationTime = x.dataProviderCreationTime
            this.dataProviderName = x.dataProviderName
            this.description = x.description
            this.engine = x.engine
            this.settings = x.settings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.DataProvider = DataProvider(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
