// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Configuration parameters for provisioning an DMS Serverless replication.
 */
public class ComputeConfig private constructor(builder: Builder) {
    /**
     * The Availability Zone where the DMS Serverless replication using this configuration will run. The default value is a random, system-chosen Availability Zone in the configuration's Amazon Web Services Region, for example, `"us-west-2"`. You can't set this parameter if the `MultiAZ` parameter is set to `true`.
     */
    public val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * A list of custom DNS name servers supported for the DMS Serverless replication to access your source or target database. This list overrides the default name servers supported by the DMS Serverless replication. You can specify a comma-separated list of internet addresses for up to four DNS name servers. For example: `"1.1.1.1,2.2.2.2,3.3.3.3,4.4.4.4"`
     */
    public val dnsNameServers: kotlin.String? = builder.dnsNameServers
    /**
     * An Key Management Service (KMS) key Amazon Resource Name (ARN) that is used to encrypt the data during DMS Serverless replication.
     *
     * If you don't specify a value for the `KmsKeyId` parameter, DMS uses your default encryption key.
     *
     * KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a different default encryption key for each Amazon Web Services Region.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Specifies the maximum value of the DMS capacity units (DCUs) for which a given DMS Serverless replication can be provisioned. A single DCU is 2GB of RAM, with 1 DCU as the minimum value allowed. The list of valid DCU values includes 1, 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384. So, the maximum value that you can specify for DMS Serverless is 384. The `MaxCapacityUnits` parameter is the only DCU parameter you are required to specify.
     */
    public val maxCapacityUnits: kotlin.Int? = builder.maxCapacityUnits
    /**
     * Specifies the minimum value of the DMS capacity units (DCUs) for which a given DMS Serverless replication can be provisioned. A single DCU is 2GB of RAM, with 1 DCU as the minimum value allowed. The list of valid DCU values includes 1, 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384. So, the minimum DCU value that you can specify for DMS Serverless is 1. You don't have to specify a value for the `MinCapacityUnits` parameter. If you don't set this value, DMS scans the current activity of available source tables to identify an optimum setting for this parameter. If there is no current source activity or DMS can't otherwise identify a more appropriate value, it sets this parameter to the minimum DCU value allowed, 1.
     */
    public val minCapacityUnits: kotlin.Int? = builder.minCapacityUnits
    /**
     * Specifies whether the DMS Serverless replication is a Multi-AZ deployment. You can't set the `AvailabilityZone` parameter if the `MultiAZ` parameter is set to `true`.
     */
    public val multiAz: kotlin.Boolean? = builder.multiAz
    /**
     * The weekly time range during which system maintenance can occur for the DMS Serverless replication, in Universal Coordinated Time (UTC). The format is `ddd:hh24:mi-ddd:hh24:mi`.
     *
     * The default is a 30-minute window selected at random from an 8-hour block of time per Amazon Web Services Region. This maintenance occurs on a random day of the week. Valid values for days of the week include `Mon`, `Tue`, `Wed`, `Thu`, `Fri`, `Sat`, and `Sun`.
     *
     * Constraints include a minimum 30-minute window.
     */
    public val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * Specifies a subnet group identifier to associate with the DMS Serverless replication.
     */
    public val replicationSubnetGroupId: kotlin.String? = builder.replicationSubnetGroupId
    /**
     * Specifies the virtual private cloud (VPC) security group to use with the DMS Serverless replication. The VPC security group must work with the VPC containing the replication.
     */
    public val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.ComputeConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ComputeConfig(")
        append("availabilityZone=$availabilityZone,")
        append("dnsNameServers=$dnsNameServers,")
        append("kmsKeyId=$kmsKeyId,")
        append("maxCapacityUnits=$maxCapacityUnits,")
        append("minCapacityUnits=$minCapacityUnits,")
        append("multiAz=$multiAz,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("replicationSubnetGroupId=$replicationSubnetGroupId,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (dnsNameServers?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (maxCapacityUnits ?: 0)
        result = 31 * result + (minCapacityUnits ?: 0)
        result = 31 * result + (multiAz?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (replicationSubnetGroupId?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ComputeConfig

        if (availabilityZone != other.availabilityZone) return false
        if (dnsNameServers != other.dnsNameServers) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (maxCapacityUnits != other.maxCapacityUnits) return false
        if (minCapacityUnits != other.minCapacityUnits) return false
        if (multiAz != other.multiAz) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (replicationSubnetGroupId != other.replicationSubnetGroupId) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.ComputeConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Availability Zone where the DMS Serverless replication using this configuration will run. The default value is a random, system-chosen Availability Zone in the configuration's Amazon Web Services Region, for example, `"us-west-2"`. You can't set this parameter if the `MultiAZ` parameter is set to `true`.
         */
        public var availabilityZone: kotlin.String? = null
        /**
         * A list of custom DNS name servers supported for the DMS Serverless replication to access your source or target database. This list overrides the default name servers supported by the DMS Serverless replication. You can specify a comma-separated list of internet addresses for up to four DNS name servers. For example: `"1.1.1.1,2.2.2.2,3.3.3.3,4.4.4.4"`
         */
        public var dnsNameServers: kotlin.String? = null
        /**
         * An Key Management Service (KMS) key Amazon Resource Name (ARN) that is used to encrypt the data during DMS Serverless replication.
         *
         * If you don't specify a value for the `KmsKeyId` parameter, DMS uses your default encryption key.
         *
         * KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a different default encryption key for each Amazon Web Services Region.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Specifies the maximum value of the DMS capacity units (DCUs) for which a given DMS Serverless replication can be provisioned. A single DCU is 2GB of RAM, with 1 DCU as the minimum value allowed. The list of valid DCU values includes 1, 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384. So, the maximum value that you can specify for DMS Serverless is 384. The `MaxCapacityUnits` parameter is the only DCU parameter you are required to specify.
         */
        public var maxCapacityUnits: kotlin.Int? = null
        /**
         * Specifies the minimum value of the DMS capacity units (DCUs) for which a given DMS Serverless replication can be provisioned. A single DCU is 2GB of RAM, with 1 DCU as the minimum value allowed. The list of valid DCU values includes 1, 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384. So, the minimum DCU value that you can specify for DMS Serverless is 1. You don't have to specify a value for the `MinCapacityUnits` parameter. If you don't set this value, DMS scans the current activity of available source tables to identify an optimum setting for this parameter. If there is no current source activity or DMS can't otherwise identify a more appropriate value, it sets this parameter to the minimum DCU value allowed, 1.
         */
        public var minCapacityUnits: kotlin.Int? = null
        /**
         * Specifies whether the DMS Serverless replication is a Multi-AZ deployment. You can't set the `AvailabilityZone` parameter if the `MultiAZ` parameter is set to `true`.
         */
        public var multiAz: kotlin.Boolean? = null
        /**
         * The weekly time range during which system maintenance can occur for the DMS Serverless replication, in Universal Coordinated Time (UTC). The format is `ddd:hh24:mi-ddd:hh24:mi`.
         *
         * The default is a 30-minute window selected at random from an 8-hour block of time per Amazon Web Services Region. This maintenance occurs on a random day of the week. Valid values for days of the week include `Mon`, `Tue`, `Wed`, `Thu`, `Fri`, `Sat`, and `Sun`.
         *
         * Constraints include a minimum 30-minute window.
         */
        public var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * Specifies a subnet group identifier to associate with the DMS Serverless replication.
         */
        public var replicationSubnetGroupId: kotlin.String? = null
        /**
         * Specifies the virtual private cloud (VPC) security group to use with the DMS Serverless replication. The VPC security group must work with the VPC containing the replication.
         */
        public var vpcSecurityGroupIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.ComputeConfig) : this() {
            this.availabilityZone = x.availabilityZone
            this.dnsNameServers = x.dnsNameServers
            this.kmsKeyId = x.kmsKeyId
            this.maxCapacityUnits = x.maxCapacityUnits
            this.minCapacityUnits = x.minCapacityUnits
            this.multiAz = x.multiAz
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.replicationSubnetGroupId = x.replicationSubnetGroupId
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.ComputeConfig = ComputeConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
