// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice

import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.databasemigrationservice.auth.DatabaseMigrationAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.databasemigrationservice.auth.DatabaseMigrationIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.databasemigrationservice.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.databasemigrationservice.model.*
import aws.sdk.kotlin.services.databasemigrationservice.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.AwsAttributes
import aws.smithy.kotlin.runtime.awsprotocol.json.AwsJsonProtocol
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext

internal class DefaultDatabaseMigrationClient(override val config: DatabaseMigrationClient.Config) : DatabaseMigrationClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = DatabaseMigrationIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "dms")
        }
        toMap()
    }
    private val authSchemeAdapter = DatabaseMigrationAuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.databasemigrationservice"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Adds metadata tags to an DMS resource, including replication instance, endpoint, subnet group, and migration task. These tags can also be used with cost allocation reporting to track cost associated with DMS resources, or used in a Condition statement in an IAM policy for DMS. For more information, see `Tag`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html) data type description.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.AddTagsToResource.sample
     */
    override suspend fun addTagsToResource(input: AddTagsToResourceRequest): AddTagsToResourceResponse {
        val op = SdkHttpOperation.build<AddTagsToResourceRequest, AddTagsToResourceResponse> {
            serializeWith = AddTagsToResourceOperationSerializer()
            deserializeWith = AddTagsToResourceOperationDeserializer()
            operationName = "AddTagsToResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Applies a pending maintenance action to a resource (for example, to a replication instance).
     */
    override suspend fun applyPendingMaintenanceAction(input: ApplyPendingMaintenanceActionRequest): ApplyPendingMaintenanceActionResponse {
        val op = SdkHttpOperation.build<ApplyPendingMaintenanceActionRequest, ApplyPendingMaintenanceActionResponse> {
            serializeWith = ApplyPendingMaintenanceActionOperationSerializer()
            deserializeWith = ApplyPendingMaintenanceActionOperationDeserializer()
            operationName = "ApplyPendingMaintenanceAction"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Starts the analysis of up to 20 source databases to recommend target engines for each source database. This is a batch version of [StartRecommendations](https://docs.aws.amazon.com/dms/latest/APIReference/API_StartRecommendations.html).
     *
     * The result of analysis of each source database is reported individually in the response. Because the batch request can result in a combination of successful and unsuccessful actions, you should check for batch errors even when the call returns an HTTP status code of `200`.
     */
    override suspend fun batchStartRecommendations(input: BatchStartRecommendationsRequest): BatchStartRecommendationsResponse {
        val op = SdkHttpOperation.build<BatchStartRecommendationsRequest, BatchStartRecommendationsResponse> {
            serializeWith = BatchStartRecommendationsOperationSerializer()
            deserializeWith = BatchStartRecommendationsOperationDeserializer()
            operationName = "BatchStartRecommendations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Cancels a single premigration assessment run.
     *
     * This operation prevents any individual assessments from running if they haven't started running. It also attempts to cancel any individual assessments that are currently running.
     */
    override suspend fun cancelReplicationTaskAssessmentRun(input: CancelReplicationTaskAssessmentRunRequest): CancelReplicationTaskAssessmentRunResponse {
        val op = SdkHttpOperation.build<CancelReplicationTaskAssessmentRunRequest, CancelReplicationTaskAssessmentRunResponse> {
            serializeWith = CancelReplicationTaskAssessmentRunOperationSerializer()
            deserializeWith = CancelReplicationTaskAssessmentRunOperationDeserializer()
            operationName = "CancelReplicationTaskAssessmentRun"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a data provider using the provided settings. A data provider stores a data store type and location information about your database.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.CreateDataProvider.sample
     */
    override suspend fun createDataProvider(input: CreateDataProviderRequest): CreateDataProviderResponse {
        val op = SdkHttpOperation.build<CreateDataProviderRequest, CreateDataProviderResponse> {
            serializeWith = CreateDataProviderOperationSerializer()
            deserializeWith = CreateDataProviderOperationDeserializer()
            operationName = "CreateDataProvider"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an endpoint using the provided settings.
     *
     * For a MySQL source or target endpoint, don't explicitly specify the database using the `DatabaseName` request parameter on the `CreateEndpoint` API call. Specifying `DatabaseName` when you create a MySQL endpoint replicates all the task tables to this single database. For MySQL endpoints, you specify the database only when you specify the schema in the table-mapping rules of the DMS task.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.CreateEndpoint.sample
     */
    override suspend fun createEndpoint(input: CreateEndpointRequest): CreateEndpointResponse {
        val op = SdkHttpOperation.build<CreateEndpointRequest, CreateEndpointResponse> {
            serializeWith = CreateEndpointOperationSerializer()
            deserializeWith = CreateEndpointOperationDeserializer()
            operationName = "CreateEndpoint"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an DMS event notification subscription.
     *
     * You can specify the type of source (`SourceType`) you want to be notified of, provide a list of DMS source IDs (`SourceIds`) that triggers the events, and provide a list of event categories (`EventCategories`) for events you want to be notified of. If you specify both the `SourceType` and `SourceIds`, such as `SourceType = replication-instance` and `SourceIdentifier = my-replinstance`, you will be notified of all the replication instance events for the specified source. If you specify a `SourceType` but don't specify a `SourceIdentifier`, you receive notice of the events for that source type for all your DMS sources. If you don't specify either `SourceType` nor `SourceIdentifier`, you will be notified of events generated from all DMS sources belonging to your customer account.
     *
     * For more information about DMS events, see [Working with Events and Notifications](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html) in the *Database Migration Service User Guide.*
     */
    override suspend fun createEventSubscription(input: CreateEventSubscriptionRequest): CreateEventSubscriptionResponse {
        val op = SdkHttpOperation.build<CreateEventSubscriptionRequest, CreateEventSubscriptionResponse> {
            serializeWith = CreateEventSubscriptionOperationSerializer()
            deserializeWith = CreateEventSubscriptionOperationDeserializer()
            operationName = "CreateEventSubscription"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a Fleet Advisor collector using the specified parameters.
     */
    override suspend fun createFleetAdvisorCollector(input: CreateFleetAdvisorCollectorRequest): CreateFleetAdvisorCollectorResponse {
        val op = SdkHttpOperation.build<CreateFleetAdvisorCollectorRequest, CreateFleetAdvisorCollectorResponse> {
            serializeWith = CreateFleetAdvisorCollectorOperationSerializer()
            deserializeWith = CreateFleetAdvisorCollectorOperationDeserializer()
            operationName = "CreateFleetAdvisorCollector"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates the instance profile using the specified parameters.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.CreateInstanceProfile.sample
     */
    override suspend fun createInstanceProfile(input: CreateInstanceProfileRequest): CreateInstanceProfileResponse {
        val op = SdkHttpOperation.build<CreateInstanceProfileRequest, CreateInstanceProfileResponse> {
            serializeWith = CreateInstanceProfileOperationSerializer()
            deserializeWith = CreateInstanceProfileOperationDeserializer()
            operationName = "CreateInstanceProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates the migration project using the specified parameters.
     *
     * You can run this action only after you create an instance profile and data providers using [CreateInstanceProfile](https://docs.aws.amazon.com/dms/latest/APIReference/API_CreateInstanceProfile.html) and [CreateDataProvider](https://docs.aws.amazon.com/dms/latest/APIReference/API_CreateDataProvider.html).
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.CreateMigrationProject.sample
     */
    override suspend fun createMigrationProject(input: CreateMigrationProjectRequest): CreateMigrationProjectResponse {
        val op = SdkHttpOperation.build<CreateMigrationProjectRequest, CreateMigrationProjectResponse> {
            serializeWith = CreateMigrationProjectOperationSerializer()
            deserializeWith = CreateMigrationProjectOperationDeserializer()
            operationName = "CreateMigrationProject"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a configuration that you can later provide to configure and start an DMS Serverless replication. You can also provide options to validate the configuration inputs before you start the replication.
     */
    override suspend fun createReplicationConfig(input: CreateReplicationConfigRequest): CreateReplicationConfigResponse {
        val op = SdkHttpOperation.build<CreateReplicationConfigRequest, CreateReplicationConfigResponse> {
            serializeWith = CreateReplicationConfigOperationSerializer()
            deserializeWith = CreateReplicationConfigOperationDeserializer()
            operationName = "CreateReplicationConfig"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates the replication instance using the specified parameters.
     *
     * DMS requires that your account have certain roles with appropriate permissions before you can create a replication instance. For information on the required roles, see [Creating the IAM Roles to Use With the CLI and DMS API](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.APIRole). For information on the required permissions, see [IAM Permissions Needed to Use DMS](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.IAMPermissions).
     *
     * If you don't specify a version when creating a replication instance, DMS will create the instance using the default engine version. For information about the default engine version, see [Release Notes](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReleaseNotes.html).
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.CreateReplicationInstance.sample
     */
    override suspend fun createReplicationInstance(input: CreateReplicationInstanceRequest): CreateReplicationInstanceResponse {
        val op = SdkHttpOperation.build<CreateReplicationInstanceRequest, CreateReplicationInstanceResponse> {
            serializeWith = CreateReplicationInstanceOperationSerializer()
            deserializeWith = CreateReplicationInstanceOperationDeserializer()
            operationName = "CreateReplicationInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a replication subnet group given a list of the subnet IDs in a VPC.
     *
     * The VPC needs to have at least one subnet in at least two availability zones in the Amazon Web Services Region, otherwise the service will throw a `ReplicationSubnetGroupDoesNotCoverEnoughAZs` exception.
     *
     * If a replication subnet group exists in your Amazon Web Services account, the CreateReplicationSubnetGroup action returns the following error message: The Replication Subnet Group already exists. In this case, delete the existing replication subnet group. To do so, use the [DeleteReplicationSubnetGroup](https://docs.aws.amazon.com/en_us/dms/latest/APIReference/API_DeleteReplicationSubnetGroup.html) action. Optionally, choose Subnet groups in the DMS console, then choose your subnet group. Next, choose Delete from Actions.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.CreateReplicationSubnetGroup.sample
     */
    override suspend fun createReplicationSubnetGroup(input: CreateReplicationSubnetGroupRequest): CreateReplicationSubnetGroupResponse {
        val op = SdkHttpOperation.build<CreateReplicationSubnetGroupRequest, CreateReplicationSubnetGroupResponse> {
            serializeWith = CreateReplicationSubnetGroupOperationSerializer()
            deserializeWith = CreateReplicationSubnetGroupOperationDeserializer()
            operationName = "CreateReplicationSubnetGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a replication task using the specified parameters.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.CreateReplicationTask.sample
     */
    override suspend fun createReplicationTask(input: CreateReplicationTaskRequest): CreateReplicationTaskResponse {
        val op = SdkHttpOperation.build<CreateReplicationTaskRequest, CreateReplicationTaskResponse> {
            serializeWith = CreateReplicationTaskOperationSerializer()
            deserializeWith = CreateReplicationTaskOperationDeserializer()
            operationName = "CreateReplicationTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified certificate.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.DeleteCertificate.sample
     */
    override suspend fun deleteCertificate(input: DeleteCertificateRequest): DeleteCertificateResponse {
        val op = SdkHttpOperation.build<DeleteCertificateRequest, DeleteCertificateResponse> {
            serializeWith = DeleteCertificateOperationSerializer()
            deserializeWith = DeleteCertificateOperationDeserializer()
            operationName = "DeleteCertificate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the connection between a replication instance and an endpoint.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.DeleteConnection.sample
     */
    override suspend fun deleteConnection(input: DeleteConnectionRequest): DeleteConnectionResponse {
        val op = SdkHttpOperation.build<DeleteConnectionRequest, DeleteConnectionResponse> {
            serializeWith = DeleteConnectionOperationSerializer()
            deserializeWith = DeleteConnectionOperationDeserializer()
            operationName = "DeleteConnection"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified data provider.
     *
     * All migration projects associated with the data provider must be deleted or modified before you can delete the data provider.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.DeleteDataProvider.sample
     */
    override suspend fun deleteDataProvider(input: DeleteDataProviderRequest): DeleteDataProviderResponse {
        val op = SdkHttpOperation.build<DeleteDataProviderRequest, DeleteDataProviderResponse> {
            serializeWith = DeleteDataProviderOperationSerializer()
            deserializeWith = DeleteDataProviderOperationDeserializer()
            operationName = "DeleteDataProvider"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified endpoint.
     *
     * All tasks associated with the endpoint must be deleted before you can delete the endpoint.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.DeleteEndpoint.sample
     */
    override suspend fun deleteEndpoint(input: DeleteEndpointRequest): DeleteEndpointResponse {
        val op = SdkHttpOperation.build<DeleteEndpointRequest, DeleteEndpointResponse> {
            serializeWith = DeleteEndpointOperationSerializer()
            deserializeWith = DeleteEndpointOperationDeserializer()
            operationName = "DeleteEndpoint"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an DMS event subscription.
     */
    override suspend fun deleteEventSubscription(input: DeleteEventSubscriptionRequest): DeleteEventSubscriptionResponse {
        val op = SdkHttpOperation.build<DeleteEventSubscriptionRequest, DeleteEventSubscriptionResponse> {
            serializeWith = DeleteEventSubscriptionOperationSerializer()
            deserializeWith = DeleteEventSubscriptionOperationDeserializer()
            operationName = "DeleteEventSubscription"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified Fleet Advisor collector.
     */
    override suspend fun deleteFleetAdvisorCollector(input: DeleteFleetAdvisorCollectorRequest): DeleteFleetAdvisorCollectorResponse {
        val op = SdkHttpOperation.build<DeleteFleetAdvisorCollectorRequest, DeleteFleetAdvisorCollectorResponse> {
            serializeWith = DeleteFleetAdvisorCollectorOperationSerializer()
            deserializeWith = DeleteFleetAdvisorCollectorOperationDeserializer()
            operationName = "DeleteFleetAdvisorCollector"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified Fleet Advisor collector databases.
     */
    override suspend fun deleteFleetAdvisorDatabases(input: DeleteFleetAdvisorDatabasesRequest): DeleteFleetAdvisorDatabasesResponse {
        val op = SdkHttpOperation.build<DeleteFleetAdvisorDatabasesRequest, DeleteFleetAdvisorDatabasesResponse> {
            serializeWith = DeleteFleetAdvisorDatabasesOperationSerializer()
            deserializeWith = DeleteFleetAdvisorDatabasesOperationDeserializer()
            operationName = "DeleteFleetAdvisorDatabases"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified instance profile.
     *
     * All migration projects associated with the instance profile must be deleted or modified before you can delete the instance profile.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.DeleteInstanceProfile.sample
     */
    override suspend fun deleteInstanceProfile(input: DeleteInstanceProfileRequest): DeleteInstanceProfileResponse {
        val op = SdkHttpOperation.build<DeleteInstanceProfileRequest, DeleteInstanceProfileResponse> {
            serializeWith = DeleteInstanceProfileOperationSerializer()
            deserializeWith = DeleteInstanceProfileOperationDeserializer()
            operationName = "DeleteInstanceProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified migration project.
     *
     * The migration project must be closed before you can delete it.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.DeleteMigrationProject.sample
     */
    override suspend fun deleteMigrationProject(input: DeleteMigrationProjectRequest): DeleteMigrationProjectResponse {
        val op = SdkHttpOperation.build<DeleteMigrationProjectRequest, DeleteMigrationProjectResponse> {
            serializeWith = DeleteMigrationProjectOperationSerializer()
            deserializeWith = DeleteMigrationProjectOperationDeserializer()
            operationName = "DeleteMigrationProject"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an DMS Serverless replication configuration. This effectively deprovisions any and all replications that use this configuration. You can't delete the configuration for an DMS Serverless replication that is ongoing. You can delete the configuration when the replication is in a non-RUNNING and non-STARTING state.
     */
    override suspend fun deleteReplicationConfig(input: DeleteReplicationConfigRequest): DeleteReplicationConfigResponse {
        val op = SdkHttpOperation.build<DeleteReplicationConfigRequest, DeleteReplicationConfigResponse> {
            serializeWith = DeleteReplicationConfigOperationSerializer()
            deserializeWith = DeleteReplicationConfigOperationDeserializer()
            operationName = "DeleteReplicationConfig"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified replication instance.
     *
     * You must delete any migration tasks that are associated with the replication instance before you can delete it.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.DeleteReplicationInstance.sample
     */
    override suspend fun deleteReplicationInstance(input: DeleteReplicationInstanceRequest): DeleteReplicationInstanceResponse {
        val op = SdkHttpOperation.build<DeleteReplicationInstanceRequest, DeleteReplicationInstanceResponse> {
            serializeWith = DeleteReplicationInstanceOperationSerializer()
            deserializeWith = DeleteReplicationInstanceOperationDeserializer()
            operationName = "DeleteReplicationInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a subnet group.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.DeleteReplicationSubnetGroup.sample
     */
    override suspend fun deleteReplicationSubnetGroup(input: DeleteReplicationSubnetGroupRequest): DeleteReplicationSubnetGroupResponse {
        val op = SdkHttpOperation.build<DeleteReplicationSubnetGroupRequest, DeleteReplicationSubnetGroupResponse> {
            serializeWith = DeleteReplicationSubnetGroupOperationSerializer()
            deserializeWith = DeleteReplicationSubnetGroupOperationDeserializer()
            operationName = "DeleteReplicationSubnetGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified replication task.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.DeleteReplicationTask.sample
     */
    override suspend fun deleteReplicationTask(input: DeleteReplicationTaskRequest): DeleteReplicationTaskResponse {
        val op = SdkHttpOperation.build<DeleteReplicationTaskRequest, DeleteReplicationTaskResponse> {
            serializeWith = DeleteReplicationTaskOperationSerializer()
            deserializeWith = DeleteReplicationTaskOperationDeserializer()
            operationName = "DeleteReplicationTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the record of a single premigration assessment run.
     *
     * This operation removes all metadata that DMS maintains about this assessment run. However, the operation leaves untouched all information about this assessment run that is stored in your Amazon S3 bucket.
     */
    override suspend fun deleteReplicationTaskAssessmentRun(input: DeleteReplicationTaskAssessmentRunRequest): DeleteReplicationTaskAssessmentRunResponse {
        val op = SdkHttpOperation.build<DeleteReplicationTaskAssessmentRunRequest, DeleteReplicationTaskAssessmentRunResponse> {
            serializeWith = DeleteReplicationTaskAssessmentRunOperationSerializer()
            deserializeWith = DeleteReplicationTaskAssessmentRunOperationDeserializer()
            operationName = "DeleteReplicationTaskAssessmentRun"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all of the DMS attributes for a customer account. These attributes include DMS quotas for the account and a unique account identifier in a particular DMS region. DMS quotas include a list of resource quotas supported by the account, such as the number of replication instances allowed. The description for each resource quota, includes the quota name, current usage toward that quota, and the quota's maximum value. DMS uses the unique account identifier to name each artifact used by DMS in the given region.
     *
     * This command does not take any parameters.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.DescribeAccountAttributes.sample
     */
    override suspend fun describeAccountAttributes(input: DescribeAccountAttributesRequest): DescribeAccountAttributesResponse {
        val op = SdkHttpOperation.build<DescribeAccountAttributesRequest, DescribeAccountAttributesResponse> {
            serializeWith = DescribeAccountAttributesOperationSerializer()
            deserializeWith = DescribeAccountAttributesOperationDeserializer()
            operationName = "DescribeAccountAttributes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Provides a list of individual assessments that you can specify for a new premigration assessment run, given one or more parameters.
     *
     * If you specify an existing migration task, this operation provides the default individual assessments you can specify for that task. Otherwise, the specified parameters model elements of a possible migration task on which to base a premigration assessment run.
     *
     * To use these migration task modeling parameters, you must specify an existing replication instance, a source database engine, a target database engine, and a migration type. This combination of parameters potentially limits the default individual assessments available for an assessment run created for a corresponding migration task.
     *
     * If you specify no parameters, this operation provides a list of all possible individual assessments that you can specify for an assessment run. If you specify any one of the task modeling parameters, you must specify all of them or the operation cannot provide a list of individual assessments. The only parameter that you can specify alone is for an existing migration task. The specified task definition then determines the default list of individual assessments that you can specify in an assessment run for the task.
     */
    override suspend fun describeApplicableIndividualAssessments(input: DescribeApplicableIndividualAssessmentsRequest): DescribeApplicableIndividualAssessmentsResponse {
        val op = SdkHttpOperation.build<DescribeApplicableIndividualAssessmentsRequest, DescribeApplicableIndividualAssessmentsResponse> {
            serializeWith = DescribeApplicableIndividualAssessmentsOperationSerializer()
            deserializeWith = DescribeApplicableIndividualAssessmentsOperationDeserializer()
            operationName = "DescribeApplicableIndividualAssessments"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Provides a description of the certificate.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.DescribeCertificates.sample
     */
    override suspend fun describeCertificates(input: DescribeCertificatesRequest): DescribeCertificatesResponse {
        val op = SdkHttpOperation.build<DescribeCertificatesRequest, DescribeCertificatesResponse> {
            serializeWith = DescribeCertificatesOperationSerializer()
            deserializeWith = DescribeCertificatesOperationDeserializer()
            operationName = "DescribeCertificates"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the status of the connections that have been made between the replication instance and an endpoint. Connections are created when you test an endpoint.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.DescribeConnections.sample
     */
    override suspend fun describeConnections(input: DescribeConnectionsRequest): DescribeConnectionsResponse {
        val op = SdkHttpOperation.build<DescribeConnectionsRequest, DescribeConnectionsResponse> {
            serializeWith = DescribeConnectionsOperationSerializer()
            deserializeWith = DescribeConnectionsOperationDeserializer()
            operationName = "DescribeConnections"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns configuration parameters for a schema conversion project.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.DescribeConversionConfiguration.sample
     */
    override suspend fun describeConversionConfiguration(input: DescribeConversionConfigurationRequest): DescribeConversionConfigurationResponse {
        val op = SdkHttpOperation.build<DescribeConversionConfigurationRequest, DescribeConversionConfigurationResponse> {
            serializeWith = DescribeConversionConfigurationOperationSerializer()
            deserializeWith = DescribeConversionConfigurationOperationDeserializer()
            operationName = "DescribeConversionConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a paginated list of data providers for your account in the current region.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.DescribeDataProviders.sample
     */
    override suspend fun describeDataProviders(input: DescribeDataProvidersRequest): DescribeDataProvidersResponse {
        val op = SdkHttpOperation.build<DescribeDataProvidersRequest, DescribeDataProvidersResponse> {
            serializeWith = DescribeDataProvidersOperationSerializer()
            deserializeWith = DescribeDataProvidersOperationDeserializer()
            operationName = "DescribeDataProviders"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the possible endpoint settings available when you create an endpoint for a specific database engine.
     */
    override suspend fun describeEndpointSettings(input: DescribeEndpointSettingsRequest): DescribeEndpointSettingsResponse {
        val op = SdkHttpOperation.build<DescribeEndpointSettingsRequest, DescribeEndpointSettingsResponse> {
            serializeWith = DescribeEndpointSettingsOperationSerializer()
            deserializeWith = DescribeEndpointSettingsOperationDeserializer()
            operationName = "DescribeEndpointSettings"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the type of endpoints available.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.DescribeEndpointTypes.sample
     */
    override suspend fun describeEndpointTypes(input: DescribeEndpointTypesRequest): DescribeEndpointTypesResponse {
        val op = SdkHttpOperation.build<DescribeEndpointTypesRequest, DescribeEndpointTypesResponse> {
            serializeWith = DescribeEndpointTypesOperationSerializer()
            deserializeWith = DescribeEndpointTypesOperationDeserializer()
            operationName = "DescribeEndpointTypes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the endpoints for your account in the current region.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.DescribeEndpoints.sample
     */
    override suspend fun describeEndpoints(input: DescribeEndpointsRequest): DescribeEndpointsResponse {
        val op = SdkHttpOperation.build<DescribeEndpointsRequest, DescribeEndpointsResponse> {
            serializeWith = DescribeEndpointsOperationSerializer()
            deserializeWith = DescribeEndpointsOperationDeserializer()
            operationName = "DescribeEndpoints"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the replication instance versions used in the project.
     */
    override suspend fun describeEngineVersions(input: DescribeEngineVersionsRequest): DescribeEngineVersionsResponse {
        val op = SdkHttpOperation.build<DescribeEngineVersionsRequest, DescribeEngineVersionsResponse> {
            serializeWith = DescribeEngineVersionsOperationSerializer()
            deserializeWith = DescribeEngineVersionsOperationDeserializer()
            operationName = "DescribeEngineVersions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists categories for all event source types, or, if specified, for a specified source type. You can see a list of the event categories and source types in [Working with Events and Notifications](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html) in the *Database Migration Service User Guide.*
     */
    override suspend fun describeEventCategories(input: DescribeEventCategoriesRequest): DescribeEventCategoriesResponse {
        val op = SdkHttpOperation.build<DescribeEventCategoriesRequest, DescribeEventCategoriesResponse> {
            serializeWith = DescribeEventCategoriesOperationSerializer()
            deserializeWith = DescribeEventCategoriesOperationDeserializer()
            operationName = "DescribeEventCategories"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the event subscriptions for a customer account. The description of a subscription includes `SubscriptionName`, `SNSTopicARN`, `CustomerID`, `SourceType`, `SourceID`, `CreationTime`, and `Status`.
     *
     * If you specify `SubscriptionName`, this action lists the description for that subscription.
     */
    override suspend fun describeEventSubscriptions(input: DescribeEventSubscriptionsRequest): DescribeEventSubscriptionsResponse {
        val op = SdkHttpOperation.build<DescribeEventSubscriptionsRequest, DescribeEventSubscriptionsResponse> {
            serializeWith = DescribeEventSubscriptionsOperationSerializer()
            deserializeWith = DescribeEventSubscriptionsOperationDeserializer()
            operationName = "DescribeEventSubscriptions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists events for a given source identifier and source type. You can also specify a start and end time. For more information on DMS events, see [Working with Events and Notifications](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html) in the *Database Migration Service User Guide.*
     */
    override suspend fun describeEvents(input: DescribeEventsRequest): DescribeEventsResponse {
        val op = SdkHttpOperation.build<DescribeEventsRequest, DescribeEventsResponse> {
            serializeWith = DescribeEventsOperationSerializer()
            deserializeWith = DescribeEventsOperationDeserializer()
            operationName = "DescribeEvents"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a paginated list of extension pack associations for the specified migration project. An extension pack is an add-on module that emulates functions present in a source database that are required when converting objects to the target database.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.DescribeExtensionPackAssociations.sample
     */
    override suspend fun describeExtensionPackAssociations(input: DescribeExtensionPackAssociationsRequest): DescribeExtensionPackAssociationsResponse {
        val op = SdkHttpOperation.build<DescribeExtensionPackAssociationsRequest, DescribeExtensionPackAssociationsResponse> {
            serializeWith = DescribeExtensionPackAssociationsOperationSerializer()
            deserializeWith = DescribeExtensionPackAssociationsOperationDeserializer()
            operationName = "DescribeExtensionPackAssociations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of the Fleet Advisor collectors in your account.
     */
    override suspend fun describeFleetAdvisorCollectors(input: DescribeFleetAdvisorCollectorsRequest): DescribeFleetAdvisorCollectorsResponse {
        val op = SdkHttpOperation.build<DescribeFleetAdvisorCollectorsRequest, DescribeFleetAdvisorCollectorsResponse> {
            serializeWith = DescribeFleetAdvisorCollectorsOperationSerializer()
            deserializeWith = DescribeFleetAdvisorCollectorsOperationDeserializer()
            operationName = "DescribeFleetAdvisorCollectors"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of Fleet Advisor databases in your account.
     */
    override suspend fun describeFleetAdvisorDatabases(input: DescribeFleetAdvisorDatabasesRequest): DescribeFleetAdvisorDatabasesResponse {
        val op = SdkHttpOperation.build<DescribeFleetAdvisorDatabasesRequest, DescribeFleetAdvisorDatabasesResponse> {
            serializeWith = DescribeFleetAdvisorDatabasesOperationSerializer()
            deserializeWith = DescribeFleetAdvisorDatabasesOperationDeserializer()
            operationName = "DescribeFleetAdvisorDatabases"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Provides descriptions of large-scale assessment (LSA) analyses produced by your Fleet Advisor collectors.
     */
    override suspend fun describeFleetAdvisorLsaAnalysis(input: DescribeFleetAdvisorLsaAnalysisRequest): DescribeFleetAdvisorLsaAnalysisResponse {
        val op = SdkHttpOperation.build<DescribeFleetAdvisorLsaAnalysisRequest, DescribeFleetAdvisorLsaAnalysisResponse> {
            serializeWith = DescribeFleetAdvisorLsaAnalysisOperationSerializer()
            deserializeWith = DescribeFleetAdvisorLsaAnalysisOperationDeserializer()
            operationName = "DescribeFleetAdvisorLsaAnalysis"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Provides descriptions of the schemas discovered by your Fleet Advisor collectors.
     */
    override suspend fun describeFleetAdvisorSchemaObjectSummary(input: DescribeFleetAdvisorSchemaObjectSummaryRequest): DescribeFleetAdvisorSchemaObjectSummaryResponse {
        val op = SdkHttpOperation.build<DescribeFleetAdvisorSchemaObjectSummaryRequest, DescribeFleetAdvisorSchemaObjectSummaryResponse> {
            serializeWith = DescribeFleetAdvisorSchemaObjectSummaryOperationSerializer()
            deserializeWith = DescribeFleetAdvisorSchemaObjectSummaryOperationDeserializer()
            operationName = "DescribeFleetAdvisorSchemaObjectSummary"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of schemas detected by Fleet Advisor Collectors in your account.
     */
    override suspend fun describeFleetAdvisorSchemas(input: DescribeFleetAdvisorSchemasRequest): DescribeFleetAdvisorSchemasResponse {
        val op = SdkHttpOperation.build<DescribeFleetAdvisorSchemasRequest, DescribeFleetAdvisorSchemasResponse> {
            serializeWith = DescribeFleetAdvisorSchemasOperationSerializer()
            deserializeWith = DescribeFleetAdvisorSchemasOperationDeserializer()
            operationName = "DescribeFleetAdvisorSchemas"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a paginated list of instance profiles for your account in the current region.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.DescribeInstanceProfiles.sample
     */
    override suspend fun describeInstanceProfiles(input: DescribeInstanceProfilesRequest): DescribeInstanceProfilesResponse {
        val op = SdkHttpOperation.build<DescribeInstanceProfilesRequest, DescribeInstanceProfilesResponse> {
            serializeWith = DescribeInstanceProfilesOperationSerializer()
            deserializeWith = DescribeInstanceProfilesOperationDeserializer()
            operationName = "DescribeInstanceProfiles"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a paginated list of metadata model assessments for your account in the current region.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.DescribeMetadataModelAssessments.sample
     */
    override suspend fun describeMetadataModelAssessments(input: DescribeMetadataModelAssessmentsRequest): DescribeMetadataModelAssessmentsResponse {
        val op = SdkHttpOperation.build<DescribeMetadataModelAssessmentsRequest, DescribeMetadataModelAssessmentsResponse> {
            serializeWith = DescribeMetadataModelAssessmentsOperationSerializer()
            deserializeWith = DescribeMetadataModelAssessmentsOperationDeserializer()
            operationName = "DescribeMetadataModelAssessments"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a paginated list of metadata model conversions for a migration project.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.DescribeMetadataModelConversions.sample
     */
    override suspend fun describeMetadataModelConversions(input: DescribeMetadataModelConversionsRequest): DescribeMetadataModelConversionsResponse {
        val op = SdkHttpOperation.build<DescribeMetadataModelConversionsRequest, DescribeMetadataModelConversionsResponse> {
            serializeWith = DescribeMetadataModelConversionsOperationSerializer()
            deserializeWith = DescribeMetadataModelConversionsOperationDeserializer()
            operationName = "DescribeMetadataModelConversions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a paginated list of metadata model exports.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.DescribeMetadataModelExportsAsScript.sample
     */
    override suspend fun describeMetadataModelExportsAsScript(input: DescribeMetadataModelExportsAsScriptRequest): DescribeMetadataModelExportsAsScriptResponse {
        val op = SdkHttpOperation.build<DescribeMetadataModelExportsAsScriptRequest, DescribeMetadataModelExportsAsScriptResponse> {
            serializeWith = DescribeMetadataModelExportsAsScriptOperationSerializer()
            deserializeWith = DescribeMetadataModelExportsAsScriptOperationDeserializer()
            operationName = "DescribeMetadataModelExportsAsScript"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a paginated list of metadata model exports.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.DescribeMetadataModelExportsToTarget.sample
     */
    override suspend fun describeMetadataModelExportsToTarget(input: DescribeMetadataModelExportsToTargetRequest): DescribeMetadataModelExportsToTargetResponse {
        val op = SdkHttpOperation.build<DescribeMetadataModelExportsToTargetRequest, DescribeMetadataModelExportsToTargetResponse> {
            serializeWith = DescribeMetadataModelExportsToTargetOperationSerializer()
            deserializeWith = DescribeMetadataModelExportsToTargetOperationDeserializer()
            operationName = "DescribeMetadataModelExportsToTarget"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a paginated list of metadata model imports.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.DescribeMetadataModelImports.sample
     */
    override suspend fun describeMetadataModelImports(input: DescribeMetadataModelImportsRequest): DescribeMetadataModelImportsResponse {
        val op = SdkHttpOperation.build<DescribeMetadataModelImportsRequest, DescribeMetadataModelImportsResponse> {
            serializeWith = DescribeMetadataModelImportsOperationSerializer()
            deserializeWith = DescribeMetadataModelImportsOperationDeserializer()
            operationName = "DescribeMetadataModelImports"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a paginated list of migration projects for your account in the current region.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.DescribeMigrationProjects.sample
     */
    override suspend fun describeMigrationProjects(input: DescribeMigrationProjectsRequest): DescribeMigrationProjectsResponse {
        val op = SdkHttpOperation.build<DescribeMigrationProjectsRequest, DescribeMigrationProjectsResponse> {
            serializeWith = DescribeMigrationProjectsOperationSerializer()
            deserializeWith = DescribeMigrationProjectsOperationDeserializer()
            operationName = "DescribeMigrationProjects"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the replication instance types that can be created in the specified region.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.DescribeOrderableReplicationInstances.sample
     */
    override suspend fun describeOrderableReplicationInstances(input: DescribeOrderableReplicationInstancesRequest): DescribeOrderableReplicationInstancesResponse {
        val op = SdkHttpOperation.build<DescribeOrderableReplicationInstancesRequest, DescribeOrderableReplicationInstancesResponse> {
            serializeWith = DescribeOrderableReplicationInstancesOperationSerializer()
            deserializeWith = DescribeOrderableReplicationInstancesOperationDeserializer()
            operationName = "DescribeOrderableReplicationInstances"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * For internal use only
     */
    override suspend fun describePendingMaintenanceActions(input: DescribePendingMaintenanceActionsRequest): DescribePendingMaintenanceActionsResponse {
        val op = SdkHttpOperation.build<DescribePendingMaintenanceActionsRequest, DescribePendingMaintenanceActionsResponse> {
            serializeWith = DescribePendingMaintenanceActionsOperationSerializer()
            deserializeWith = DescribePendingMaintenanceActionsOperationDeserializer()
            operationName = "DescribePendingMaintenanceActions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a paginated list of limitations for recommendations of target Amazon Web Services engines.
     */
    override suspend fun describeRecommendationLimitations(input: DescribeRecommendationLimitationsRequest): DescribeRecommendationLimitationsResponse {
        val op = SdkHttpOperation.build<DescribeRecommendationLimitationsRequest, DescribeRecommendationLimitationsResponse> {
            serializeWith = DescribeRecommendationLimitationsOperationSerializer()
            deserializeWith = DescribeRecommendationLimitationsOperationDeserializer()
            operationName = "DescribeRecommendationLimitations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a paginated list of target engine recommendations for your source databases.
     */
    override suspend fun describeRecommendations(input: DescribeRecommendationsRequest): DescribeRecommendationsResponse {
        val op = SdkHttpOperation.build<DescribeRecommendationsRequest, DescribeRecommendationsResponse> {
            serializeWith = DescribeRecommendationsOperationSerializer()
            deserializeWith = DescribeRecommendationsOperationDeserializer()
            operationName = "DescribeRecommendations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the status of the RefreshSchemas operation.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.DescribeRefreshSchemasStatus.sample
     */
    override suspend fun describeRefreshSchemasStatus(input: DescribeRefreshSchemasStatusRequest): DescribeRefreshSchemasStatusResponse {
        val op = SdkHttpOperation.build<DescribeRefreshSchemasStatusRequest, DescribeRefreshSchemasStatusResponse> {
            serializeWith = DescribeRefreshSchemasStatusOperationSerializer()
            deserializeWith = DescribeRefreshSchemasStatusOperationDeserializer()
            operationName = "DescribeRefreshSchemasStatus"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns one or more existing DMS Serverless replication configurations as a list of structures.
     */
    override suspend fun describeReplicationConfigs(input: DescribeReplicationConfigsRequest): DescribeReplicationConfigsResponse {
        val op = SdkHttpOperation.build<DescribeReplicationConfigsRequest, DescribeReplicationConfigsResponse> {
            serializeWith = DescribeReplicationConfigsOperationSerializer()
            deserializeWith = DescribeReplicationConfigsOperationDeserializer()
            operationName = "DescribeReplicationConfigs"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the task logs for the specified task.
     */
    override suspend fun describeReplicationInstanceTaskLogs(input: DescribeReplicationInstanceTaskLogsRequest): DescribeReplicationInstanceTaskLogsResponse {
        val op = SdkHttpOperation.build<DescribeReplicationInstanceTaskLogsRequest, DescribeReplicationInstanceTaskLogsResponse> {
            serializeWith = DescribeReplicationInstanceTaskLogsOperationSerializer()
            deserializeWith = DescribeReplicationInstanceTaskLogsOperationDeserializer()
            operationName = "DescribeReplicationInstanceTaskLogs"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about replication instances for your account in the current region.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.DescribeReplicationInstances.sample
     */
    override suspend fun describeReplicationInstances(input: DescribeReplicationInstancesRequest): DescribeReplicationInstancesResponse {
        val op = SdkHttpOperation.build<DescribeReplicationInstancesRequest, DescribeReplicationInstancesResponse> {
            serializeWith = DescribeReplicationInstancesOperationSerializer()
            deserializeWith = DescribeReplicationInstancesOperationDeserializer()
            operationName = "DescribeReplicationInstances"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the replication subnet groups.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.DescribeReplicationSubnetGroups.sample
     */
    override suspend fun describeReplicationSubnetGroups(input: DescribeReplicationSubnetGroupsRequest): DescribeReplicationSubnetGroupsResponse {
        val op = SdkHttpOperation.build<DescribeReplicationSubnetGroupsRequest, DescribeReplicationSubnetGroupsResponse> {
            serializeWith = DescribeReplicationSubnetGroupsOperationSerializer()
            deserializeWith = DescribeReplicationSubnetGroupsOperationDeserializer()
            operationName = "DescribeReplicationSubnetGroups"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns table and schema statistics for one or more provisioned replications that use a given DMS Serverless replication configuration.
     */
    override suspend fun describeReplicationTableStatistics(input: DescribeReplicationTableStatisticsRequest): DescribeReplicationTableStatisticsResponse {
        val op = SdkHttpOperation.build<DescribeReplicationTableStatisticsRequest, DescribeReplicationTableStatisticsResponse> {
            serializeWith = DescribeReplicationTableStatisticsOperationSerializer()
            deserializeWith = DescribeReplicationTableStatisticsOperationDeserializer()
            operationName = "DescribeReplicationTableStatistics"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the task assessment results from the Amazon S3 bucket that DMS creates in your Amazon Web Services account. This action always returns the latest results.
     *
     * For more information about DMS task assessments, see [Creating a task assessment report](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html) in the *Database Migration Service User Guide*.
     */
    override suspend fun describeReplicationTaskAssessmentResults(input: DescribeReplicationTaskAssessmentResultsRequest): DescribeReplicationTaskAssessmentResultsResponse {
        val op = SdkHttpOperation.build<DescribeReplicationTaskAssessmentResultsRequest, DescribeReplicationTaskAssessmentResultsResponse> {
            serializeWith = DescribeReplicationTaskAssessmentResultsOperationSerializer()
            deserializeWith = DescribeReplicationTaskAssessmentResultsOperationDeserializer()
            operationName = "DescribeReplicationTaskAssessmentResults"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a paginated list of premigration assessment runs based on filter settings.
     *
     * These filter settings can specify a combination of premigration assessment runs, migration tasks, replication instances, and assessment run status values.
     *
     * This operation doesn't return information about individual assessments. For this information, see the `DescribeReplicationTaskIndividualAssessments` operation.
     */
    override suspend fun describeReplicationTaskAssessmentRuns(input: DescribeReplicationTaskAssessmentRunsRequest): DescribeReplicationTaskAssessmentRunsResponse {
        val op = SdkHttpOperation.build<DescribeReplicationTaskAssessmentRunsRequest, DescribeReplicationTaskAssessmentRunsResponse> {
            serializeWith = DescribeReplicationTaskAssessmentRunsOperationSerializer()
            deserializeWith = DescribeReplicationTaskAssessmentRunsOperationDeserializer()
            operationName = "DescribeReplicationTaskAssessmentRuns"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a paginated list of individual assessments based on filter settings.
     *
     * These filter settings can specify a combination of premigration assessment runs, migration tasks, and assessment status values.
     */
    override suspend fun describeReplicationTaskIndividualAssessments(input: DescribeReplicationTaskIndividualAssessmentsRequest): DescribeReplicationTaskIndividualAssessmentsResponse {
        val op = SdkHttpOperation.build<DescribeReplicationTaskIndividualAssessmentsRequest, DescribeReplicationTaskIndividualAssessmentsResponse> {
            serializeWith = DescribeReplicationTaskIndividualAssessmentsOperationSerializer()
            deserializeWith = DescribeReplicationTaskIndividualAssessmentsOperationDeserializer()
            operationName = "DescribeReplicationTaskIndividualAssessments"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about replication tasks for your account in the current region.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.DescribeReplicationTasks.sample
     */
    override suspend fun describeReplicationTasks(input: DescribeReplicationTasksRequest): DescribeReplicationTasksResponse {
        val op = SdkHttpOperation.build<DescribeReplicationTasksRequest, DescribeReplicationTasksResponse> {
            serializeWith = DescribeReplicationTasksOperationSerializer()
            deserializeWith = DescribeReplicationTasksOperationDeserializer()
            operationName = "DescribeReplicationTasks"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Provides details on replication progress by returning status information for one or more provisioned DMS Serverless replications.
     */
    override suspend fun describeReplications(input: DescribeReplicationsRequest): DescribeReplicationsResponse {
        val op = SdkHttpOperation.build<DescribeReplicationsRequest, DescribeReplicationsResponse> {
            serializeWith = DescribeReplicationsOperationSerializer()
            deserializeWith = DescribeReplicationsOperationDeserializer()
            operationName = "DescribeReplications"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the schema for the specified endpoint.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.DescribeSchemas.sample
     */
    override suspend fun describeSchemas(input: DescribeSchemasRequest): DescribeSchemasResponse {
        val op = SdkHttpOperation.build<DescribeSchemasRequest, DescribeSchemasResponse> {
            serializeWith = DescribeSchemasOperationSerializer()
            deserializeWith = DescribeSchemasOperationDeserializer()
            operationName = "DescribeSchemas"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns table statistics on the database migration task, including table name, rows inserted, rows updated, and rows deleted.
     *
     * Note that the "last updated" column the DMS console only indicates the time that DMS last updated the table statistics record for a table. It does not indicate the time of the last update to the table.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.DescribeTableStatistics.sample
     */
    override suspend fun describeTableStatistics(input: DescribeTableStatisticsRequest): DescribeTableStatisticsResponse {
        val op = SdkHttpOperation.build<DescribeTableStatisticsRequest, DescribeTableStatisticsResponse> {
            serializeWith = DescribeTableStatisticsOperationSerializer()
            deserializeWith = DescribeTableStatisticsOperationDeserializer()
            operationName = "DescribeTableStatistics"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Saves a copy of a database migration assessment report to your Amazon S3 bucket. DMS can save your assessment report as a comma-separated value (CSV) or a PDF file.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.ExportMetadataModelAssessment.sample
     */
    override suspend fun exportMetadataModelAssessment(input: ExportMetadataModelAssessmentRequest): ExportMetadataModelAssessmentResponse {
        val op = SdkHttpOperation.build<ExportMetadataModelAssessmentRequest, ExportMetadataModelAssessmentResponse> {
            serializeWith = ExportMetadataModelAssessmentOperationSerializer()
            deserializeWith = ExportMetadataModelAssessmentOperationDeserializer()
            operationName = "ExportMetadataModelAssessment"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Uploads the specified certificate.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.ImportCertificate.sample
     */
    override suspend fun importCertificate(input: ImportCertificateRequest): ImportCertificateResponse {
        val op = SdkHttpOperation.build<ImportCertificateRequest, ImportCertificateResponse> {
            serializeWith = ImportCertificateOperationSerializer()
            deserializeWith = ImportCertificateOperationDeserializer()
            operationName = "ImportCertificate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all metadata tags attached to an DMS resource, including replication instance, endpoint, subnet group, and migration task. For more information, see `Tag`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html) data type description.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.ListTagsForResource.sample
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializeWith = ListTagsForResourceOperationSerializer()
            deserializeWith = ListTagsForResourceOperationDeserializer()
            operationName = "ListTagsForResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the specified schema conversion configuration using the provided parameters.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.ModifyConversionConfiguration.sample
     */
    override suspend fun modifyConversionConfiguration(input: ModifyConversionConfigurationRequest): ModifyConversionConfigurationResponse {
        val op = SdkHttpOperation.build<ModifyConversionConfigurationRequest, ModifyConversionConfigurationResponse> {
            serializeWith = ModifyConversionConfigurationOperationSerializer()
            deserializeWith = ModifyConversionConfigurationOperationDeserializer()
            operationName = "ModifyConversionConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the specified data provider using the provided settings.
     *
     * You must remove the data provider from all migration projects before you can modify it.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.ModifyDataProvider.sample
     */
    override suspend fun modifyDataProvider(input: ModifyDataProviderRequest): ModifyDataProviderResponse {
        val op = SdkHttpOperation.build<ModifyDataProviderRequest, ModifyDataProviderResponse> {
            serializeWith = ModifyDataProviderOperationSerializer()
            deserializeWith = ModifyDataProviderOperationDeserializer()
            operationName = "ModifyDataProvider"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the specified endpoint.
     *
     * For a MySQL source or target endpoint, don't explicitly specify the database using the `DatabaseName` request parameter on the `ModifyEndpoint` API call. Specifying `DatabaseName` when you modify a MySQL endpoint replicates all the task tables to this single database. For MySQL endpoints, you specify the database only when you specify the schema in the table-mapping rules of the DMS task.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.ModifyEndpoint.sample
     */
    override suspend fun modifyEndpoint(input: ModifyEndpointRequest): ModifyEndpointResponse {
        val op = SdkHttpOperation.build<ModifyEndpointRequest, ModifyEndpointResponse> {
            serializeWith = ModifyEndpointOperationSerializer()
            deserializeWith = ModifyEndpointOperationDeserializer()
            operationName = "ModifyEndpoint"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies an existing DMS event notification subscription.
     */
    override suspend fun modifyEventSubscription(input: ModifyEventSubscriptionRequest): ModifyEventSubscriptionResponse {
        val op = SdkHttpOperation.build<ModifyEventSubscriptionRequest, ModifyEventSubscriptionResponse> {
            serializeWith = ModifyEventSubscriptionOperationSerializer()
            deserializeWith = ModifyEventSubscriptionOperationDeserializer()
            operationName = "ModifyEventSubscription"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the specified instance profile using the provided parameters.
     *
     * All migration projects associated with the instance profile must be deleted or modified before you can modify the instance profile.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.ModifyInstanceProfile.sample
     */
    override suspend fun modifyInstanceProfile(input: ModifyInstanceProfileRequest): ModifyInstanceProfileResponse {
        val op = SdkHttpOperation.build<ModifyInstanceProfileRequest, ModifyInstanceProfileResponse> {
            serializeWith = ModifyInstanceProfileOperationSerializer()
            deserializeWith = ModifyInstanceProfileOperationDeserializer()
            operationName = "ModifyInstanceProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the specified migration project using the provided parameters.
     *
     * The migration project must be closed before you can modify it.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.ModifyMigrationProject.sample
     */
    override suspend fun modifyMigrationProject(input: ModifyMigrationProjectRequest): ModifyMigrationProjectResponse {
        val op = SdkHttpOperation.build<ModifyMigrationProjectRequest, ModifyMigrationProjectResponse> {
            serializeWith = ModifyMigrationProjectOperationSerializer()
            deserializeWith = ModifyMigrationProjectOperationDeserializer()
            operationName = "ModifyMigrationProject"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies an existing DMS Serverless replication configuration that you can use to start a replication. This command includes input validation and logic to check the state of any replication that uses this configuration. You can only modify a replication configuration before any replication that uses it has started. As soon as you have initially started a replication with a given configuiration, you can't modify that configuration, even if you stop it.
     *
     * Other run statuses that allow you to run this command include FAILED and CREATED. A provisioning state that allows you to run this command is FAILED_PROVISION.
     */
    override suspend fun modifyReplicationConfig(input: ModifyReplicationConfigRequest): ModifyReplicationConfigResponse {
        val op = SdkHttpOperation.build<ModifyReplicationConfigRequest, ModifyReplicationConfigResponse> {
            serializeWith = ModifyReplicationConfigOperationSerializer()
            deserializeWith = ModifyReplicationConfigOperationDeserializer()
            operationName = "ModifyReplicationConfig"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the replication instance to apply new settings. You can change one or more parameters by specifying these parameters and the new values in the request.
     *
     * Some settings are applied during the maintenance window.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.ModifyReplicationInstance.sample
     */
    override suspend fun modifyReplicationInstance(input: ModifyReplicationInstanceRequest): ModifyReplicationInstanceResponse {
        val op = SdkHttpOperation.build<ModifyReplicationInstanceRequest, ModifyReplicationInstanceResponse> {
            serializeWith = ModifyReplicationInstanceOperationSerializer()
            deserializeWith = ModifyReplicationInstanceOperationDeserializer()
            operationName = "ModifyReplicationInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the settings for the specified replication subnet group.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.ModifyReplicationSubnetGroup.sample
     */
    override suspend fun modifyReplicationSubnetGroup(input: ModifyReplicationSubnetGroupRequest): ModifyReplicationSubnetGroupResponse {
        val op = SdkHttpOperation.build<ModifyReplicationSubnetGroupRequest, ModifyReplicationSubnetGroupResponse> {
            serializeWith = ModifyReplicationSubnetGroupOperationSerializer()
            deserializeWith = ModifyReplicationSubnetGroupOperationDeserializer()
            operationName = "ModifyReplicationSubnetGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the specified replication task.
     *
     * You can't modify the task endpoints. The task must be stopped before you can modify it.
     *
     * For more information about DMS tasks, see [Working with Migration Tasks](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html) in the *Database Migration Service User Guide*.
     */
    override suspend fun modifyReplicationTask(input: ModifyReplicationTaskRequest): ModifyReplicationTaskResponse {
        val op = SdkHttpOperation.build<ModifyReplicationTaskRequest, ModifyReplicationTaskResponse> {
            serializeWith = ModifyReplicationTaskOperationSerializer()
            deserializeWith = ModifyReplicationTaskOperationDeserializer()
            operationName = "ModifyReplicationTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Moves a replication task from its current replication instance to a different target replication instance using the specified parameters. The target replication instance must be created with the same or later DMS version as the current replication instance.
     */
    override suspend fun moveReplicationTask(input: MoveReplicationTaskRequest): MoveReplicationTaskResponse {
        val op = SdkHttpOperation.build<MoveReplicationTaskRequest, MoveReplicationTaskResponse> {
            serializeWith = MoveReplicationTaskOperationSerializer()
            deserializeWith = MoveReplicationTaskOperationDeserializer()
            operationName = "MoveReplicationTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Reboots a replication instance. Rebooting results in a momentary outage, until the replication instance becomes available again.
     */
    override suspend fun rebootReplicationInstance(input: RebootReplicationInstanceRequest): RebootReplicationInstanceResponse {
        val op = SdkHttpOperation.build<RebootReplicationInstanceRequest, RebootReplicationInstanceResponse> {
            serializeWith = RebootReplicationInstanceOperationSerializer()
            deserializeWith = RebootReplicationInstanceOperationDeserializer()
            operationName = "RebootReplicationInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Populates the schema for the specified endpoint. This is an asynchronous operation and can take several minutes. You can check the status of this operation by calling the DescribeRefreshSchemasStatus operation.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.RefreshSchemas.sample
     */
    override suspend fun refreshSchemas(input: RefreshSchemasRequest): RefreshSchemasResponse {
        val op = SdkHttpOperation.build<RefreshSchemasRequest, RefreshSchemasResponse> {
            serializeWith = RefreshSchemasOperationSerializer()
            deserializeWith = RefreshSchemasOperationDeserializer()
            operationName = "RefreshSchemas"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Reloads the target database table with the source data for a given DMS Serverless replication configuration.
     *
     * You can only use this operation with a task in the RUNNING state, otherwise the service will throw an `InvalidResourceStateFault` exception.
     */
    override suspend fun reloadReplicationTables(input: ReloadReplicationTablesRequest): ReloadReplicationTablesResponse {
        val op = SdkHttpOperation.build<ReloadReplicationTablesRequest, ReloadReplicationTablesResponse> {
            serializeWith = ReloadReplicationTablesOperationSerializer()
            deserializeWith = ReloadReplicationTablesOperationDeserializer()
            operationName = "ReloadReplicationTables"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Reloads the target database table with the source data.
     *
     * You can only use this operation with a task in the `RUNNING` state, otherwise the service will throw an `InvalidResourceStateFault` exception.
     */
    override suspend fun reloadTables(input: ReloadTablesRequest): ReloadTablesResponse {
        val op = SdkHttpOperation.build<ReloadTablesRequest, ReloadTablesResponse> {
            serializeWith = ReloadTablesOperationSerializer()
            deserializeWith = ReloadTablesOperationDeserializer()
            operationName = "ReloadTables"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes metadata tags from an DMS resource, including replication instance, endpoint, subnet group, and migration task. For more information, see `Tag`[](https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html) data type description.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.RemoveTagsFromResource.sample
     */
    override suspend fun removeTagsFromResource(input: RemoveTagsFromResourceRequest): RemoveTagsFromResourceResponse {
        val op = SdkHttpOperation.build<RemoveTagsFromResourceRequest, RemoveTagsFromResourceResponse> {
            serializeWith = RemoveTagsFromResourceOperationSerializer()
            deserializeWith = RemoveTagsFromResourceOperationDeserializer()
            operationName = "RemoveTagsFromResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Runs large-scale assessment (LSA) analysis on every Fleet Advisor collector in your account.
     */
    override suspend fun runFleetAdvisorLsaAnalysis(input: RunFleetAdvisorLsaAnalysisRequest): RunFleetAdvisorLsaAnalysisResponse {
        val op = SdkHttpOperation.build<RunFleetAdvisorLsaAnalysisRequest, RunFleetAdvisorLsaAnalysisResponse> {
            serializeWith = RunFleetAdvisorLsaAnalysisOperationSerializer()
            deserializeWith = RunFleetAdvisorLsaAnalysisOperationDeserializer()
            operationName = "RunFleetAdvisorLsaAnalysis"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Applies the extension pack to your target database. An extension pack is an add-on module that emulates functions present in a source database that are required when converting objects to the target database.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.StartExtensionPackAssociation.sample
     */
    override suspend fun startExtensionPackAssociation(input: StartExtensionPackAssociationRequest): StartExtensionPackAssociationResponse {
        val op = SdkHttpOperation.build<StartExtensionPackAssociationRequest, StartExtensionPackAssociationResponse> {
            serializeWith = StartExtensionPackAssociationOperationSerializer()
            deserializeWith = StartExtensionPackAssociationOperationDeserializer()
            operationName = "StartExtensionPackAssociation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a database migration assessment report by assessing the migration complexity for your source database. A database migration assessment report summarizes all of the schema conversion tasks. It also details the action items for database objects that can't be converted to the database engine of your target database instance.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.StartMetadataModelAssessment.sample
     */
    override suspend fun startMetadataModelAssessment(input: StartMetadataModelAssessmentRequest): StartMetadataModelAssessmentResponse {
        val op = SdkHttpOperation.build<StartMetadataModelAssessmentRequest, StartMetadataModelAssessmentResponse> {
            serializeWith = StartMetadataModelAssessmentOperationSerializer()
            deserializeWith = StartMetadataModelAssessmentOperationDeserializer()
            operationName = "StartMetadataModelAssessment"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Converts your source database objects to a format compatible with the target database.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.StartMetadataModelConversion.sample
     */
    override suspend fun startMetadataModelConversion(input: StartMetadataModelConversionRequest): StartMetadataModelConversionResponse {
        val op = SdkHttpOperation.build<StartMetadataModelConversionRequest, StartMetadataModelConversionResponse> {
            serializeWith = StartMetadataModelConversionOperationSerializer()
            deserializeWith = StartMetadataModelConversionOperationDeserializer()
            operationName = "StartMetadataModelConversion"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Saves your converted code to a file as a SQL script, and stores this file on your Amazon S3 bucket.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.StartMetadataModelExportAsScript.sample
     */
    override suspend fun startMetadataModelExportAsScript(input: StartMetadataModelExportAsScriptRequest): StartMetadataModelExportAsScriptResponse {
        val op = SdkHttpOperation.build<StartMetadataModelExportAsScriptRequest, StartMetadataModelExportAsScriptResponse> {
            serializeWith = StartMetadataModelExportAsScriptOperationSerializer()
            deserializeWith = StartMetadataModelExportAsScriptOperationDeserializer()
            operationName = "StartMetadataModelExportAsScript"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Applies converted database objects to your target database.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.StartMetadataModelExportToTarget.sample
     */
    override suspend fun startMetadataModelExportToTarget(input: StartMetadataModelExportToTargetRequest): StartMetadataModelExportToTargetResponse {
        val op = SdkHttpOperation.build<StartMetadataModelExportToTargetRequest, StartMetadataModelExportToTargetResponse> {
            serializeWith = StartMetadataModelExportToTargetOperationSerializer()
            deserializeWith = StartMetadataModelExportToTargetOperationDeserializer()
            operationName = "StartMetadataModelExportToTarget"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Loads the metadata for all the dependent database objects of the parent object.
     *
     * This operation uses your project's Amazon S3 bucket as a metadata cache to improve performance.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.StartMetadataModelImport.sample
     */
    override suspend fun startMetadataModelImport(input: StartMetadataModelImportRequest): StartMetadataModelImportResponse {
        val op = SdkHttpOperation.build<StartMetadataModelImportRequest, StartMetadataModelImportResponse> {
            serializeWith = StartMetadataModelImportOperationSerializer()
            deserializeWith = StartMetadataModelImportOperationDeserializer()
            operationName = "StartMetadataModelImport"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Starts the analysis of your source database to provide recommendations of target engines.
     *
     * You can create recommendations for multiple source databases using [BatchStartRecommendations](https://docs.aws.amazon.com/dms/latest/APIReference/API_BatchStartRecommendations.html).
     */
    override suspend fun startRecommendations(input: StartRecommendationsRequest): StartRecommendationsResponse {
        val op = SdkHttpOperation.build<StartRecommendationsRequest, StartRecommendationsResponse> {
            serializeWith = StartRecommendationsOperationSerializer()
            deserializeWith = StartRecommendationsOperationDeserializer()
            operationName = "StartRecommendations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * For a given DMS Serverless replication configuration, DMS connects to the source endpoint and collects the metadata to analyze the replication workload. Using this metadata, DMS then computes and provisions the required capacity and starts replicating to the target endpoint using the server resources that DMS has provisioned for the DMS Serverless replication.
     */
    override suspend fun startReplication(input: StartReplicationRequest): StartReplicationResponse {
        val op = SdkHttpOperation.build<StartReplicationRequest, StartReplicationResponse> {
            serializeWith = StartReplicationOperationSerializer()
            deserializeWith = StartReplicationOperationDeserializer()
            operationName = "StartReplication"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Starts the replication task.
     *
     * For more information about DMS tasks, see [Working with Migration Tasks ](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html) in the *Database Migration Service User Guide.*
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.StartReplicationTask.sample
     */
    override suspend fun startReplicationTask(input: StartReplicationTaskRequest): StartReplicationTaskResponse {
        val op = SdkHttpOperation.build<StartReplicationTaskRequest, StartReplicationTaskResponse> {
            serializeWith = StartReplicationTaskOperationSerializer()
            deserializeWith = StartReplicationTaskOperationDeserializer()
            operationName = "StartReplicationTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Starts the replication task assessment for unsupported data types in the source database.
     *
     * You can only use this operation for a task if the following conditions are true:
     * + The task must be in the `stopped` state.
     * + The task must have successful connections to the source and target.
     *
     * If either of these conditions are not met, an `InvalidResourceStateFault` error will result.
     *
     * For information about DMS task assessments, see [Creating a task assessment report](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html) in the *Database Migration Service User Guide*.
     */
    override suspend fun startReplicationTaskAssessment(input: StartReplicationTaskAssessmentRequest): StartReplicationTaskAssessmentResponse {
        val op = SdkHttpOperation.build<StartReplicationTaskAssessmentRequest, StartReplicationTaskAssessmentResponse> {
            serializeWith = StartReplicationTaskAssessmentOperationSerializer()
            deserializeWith = StartReplicationTaskAssessmentOperationDeserializer()
            operationName = "StartReplicationTaskAssessment"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Starts a new premigration assessment run for one or more individual assessments of a migration task.
     *
     * The assessments that you can specify depend on the source and target database engine and the migration type defined for the given task. To run this operation, your migration task must already be created. After you run this operation, you can review the status of each individual assessment. You can also run the migration task manually after the assessment run and its individual assessments complete.
     */
    override suspend fun startReplicationTaskAssessmentRun(input: StartReplicationTaskAssessmentRunRequest): StartReplicationTaskAssessmentRunResponse {
        val op = SdkHttpOperation.build<StartReplicationTaskAssessmentRunRequest, StartReplicationTaskAssessmentRunResponse> {
            serializeWith = StartReplicationTaskAssessmentRunOperationSerializer()
            deserializeWith = StartReplicationTaskAssessmentRunOperationDeserializer()
            operationName = "StartReplicationTaskAssessmentRun"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * For a given DMS Serverless replication configuration, DMS stops any and all ongoing DMS Serverless replications. This command doesn't deprovision the stopped replications.
     */
    override suspend fun stopReplication(input: StopReplicationRequest): StopReplicationResponse {
        val op = SdkHttpOperation.build<StopReplicationRequest, StopReplicationResponse> {
            serializeWith = StopReplicationOperationSerializer()
            deserializeWith = StopReplicationOperationDeserializer()
            operationName = "StopReplication"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Stops the replication task.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.StopReplicationTask.sample
     */
    override suspend fun stopReplicationTask(input: StopReplicationTaskRequest): StopReplicationTaskResponse {
        val op = SdkHttpOperation.build<StopReplicationTaskRequest, StopReplicationTaskResponse> {
            serializeWith = StopReplicationTaskOperationSerializer()
            deserializeWith = StopReplicationTaskOperationDeserializer()
            operationName = "StopReplicationTask"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Tests the connection between the replication instance and the endpoint.
     *
     * @sample aws.sdk.kotlin.services.databasemigrationservice.samples.TestConnection.sample
     */
    override suspend fun testConnection(input: TestConnectionRequest): TestConnectionResponse {
        val op = SdkHttpOperation.build<TestConnectionRequest, TestConnectionResponse> {
            serializeWith = TestConnectionOperationSerializer()
            deserializeWith = TestConnectionOperationDeserializer()
            operationName = "TestConnection"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Migrates 10 active and enabled Amazon SNS subscriptions at a time and converts them to corresponding Amazon EventBridge rules. By default, this operation migrates subscriptions only when all your replication instance versions are 3.4.5 or higher. If any replication instances are from versions earlier than 3.4.5, the operation raises an error and tells you to upgrade these instances to version 3.4.5 or higher. To enable migration regardless of version, set the `Force` option to true. However, if you don't upgrade instances earlier than version 3.4.5, some types of events might not be available when you use Amazon EventBridge.
     *
     * To call this operation, make sure that you have certain permissions added to your user account. For more information, see [Migrating event subscriptions to Amazon EventBridge](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html#CHAP_Events-migrate-to-eventbridge) in the *Amazon Web Services Database Migration Service User Guide*.
     */
    override suspend fun updateSubscriptionsToEventBridge(input: UpdateSubscriptionsToEventBridgeRequest): UpdateSubscriptionsToEventBridgeResponse {
        val op = SdkHttpOperation.build<UpdateSubscriptionsToEventBridgeRequest, UpdateSubscriptionsToEventBridgeResponse> {
            serializeWith = UpdateSubscriptionsToEventBridgeOperationSerializer()
            deserializeWith = UpdateSubscriptionsToEventBridgeOperationDeserializer()
            operationName = "UpdateSubscriptionsToEventBridge"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AmazonDMSv20160101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsentNotNull(AwsAttributes.Region, config.region)
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "dms")
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }

}
