// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.serde

import aws.sdk.kotlin.services.databasemigrationservice.model.DatabaseMigrationException
import aws.sdk.kotlin.services.databasemigrationservice.model.StartMetadataModelConversionResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class StartMetadataModelConversionOperationDeserializer: HttpDeserialize<StartMetadataModelConversionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): StartMetadataModelConversionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwStartMetadataModelConversionError(context, call)
        }
        val builder = StartMetadataModelConversionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeStartMetadataModelConversionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwStartMetadataModelConversionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DatabaseMigrationException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidResourceStateFault" -> InvalidResourceStateFaultDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundFault" -> ResourceNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "ResourceAlreadyExistsFault" -> ResourceAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall)
        "S3AccessDeniedFault" -> S3AccessDeniedFaultDeserializer().deserialize(context, wrappedCall)
        "S3ResourceNotFoundFault" -> S3ResourceNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedFault" -> AccessDeniedFaultDeserializer().deserialize(context, wrappedCall)
        "KMSKeyNotAccessibleFault" -> KmsKeyNotAccessibleFaultDeserializer().deserialize(context, wrappedCall)
        "ResourceQuotaExceededFault" -> ResourceQuotaExceededFaultDeserializer().deserialize(context, wrappedCall)
        else -> DatabaseMigrationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeStartMetadataModelConversionOperationBody(builder: StartMetadataModelConversionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val REQUESTIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RequestIdentifier"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(REQUESTIDENTIFIER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                REQUESTIDENTIFIER_DESCRIPTOR.index -> builder.requestIdentifier = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
