// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model



/**
 * Provides information that describes the configuration of the recommended target engine on Amazon RDS.
 */
public class RdsConfiguration private constructor(builder: Builder) {
    /**
     * Describes the deployment option for the recommended Amazon RDS DB instance. The deployment options include Multi-AZ and Single-AZ deployments. Valid values include `"MULTI_AZ"` and `"SINGLE_AZ"`.
     */
    public val deploymentOption: kotlin.String? = builder.deploymentOption
    /**
     * Describes the recommended target Amazon RDS engine edition.
     */
    public val engineEdition: kotlin.String? = builder.engineEdition
    /**
     * Describes the recommended target Amazon RDS engine version.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * Describes the memory on the recommended Amazon RDS DB instance that meets your requirements.
     */
    public val instanceMemory: kotlin.Double? = builder.instanceMemory
    /**
     * Describes the recommended target Amazon RDS instance type.
     */
    public val instanceType: kotlin.String? = builder.instanceType
    /**
     * Describes the number of virtual CPUs (vCPU) on the recommended Amazon RDS DB instance that meets your requirements.
     */
    public val instanceVcpu: kotlin.Double? = builder.instanceVcpu
    /**
     * Describes the number of I/O operations completed each second (IOPS) on the recommended Amazon RDS DB instance that meets your requirements.
     */
    public val storageIops: kotlin.Int? = builder.storageIops
    /**
     * Describes the storage size of the recommended Amazon RDS DB instance that meets your requirements.
     */
    public val storageSize: kotlin.Int? = builder.storageSize
    /**
     * Describes the storage type of the recommended Amazon RDS DB instance that meets your requirements.
     *
     * Amazon RDS provides three storage types: General Purpose SSD (also known as gp2 and gp3), Provisioned IOPS SSD (also known as io1), and magnetic (also known as standard).
     */
    public val storageType: kotlin.String? = builder.storageType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.RdsConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RdsConfiguration(")
        append("deploymentOption=$deploymentOption,")
        append("engineEdition=$engineEdition,")
        append("engineVersion=$engineVersion,")
        append("instanceMemory=$instanceMemory,")
        append("instanceType=$instanceType,")
        append("instanceVcpu=$instanceVcpu,")
        append("storageIops=$storageIops,")
        append("storageSize=$storageSize,")
        append("storageType=$storageType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deploymentOption?.hashCode() ?: 0
        result = 31 * result + (engineEdition?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (instanceMemory?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (instanceVcpu?.hashCode() ?: 0)
        result = 31 * result + (storageIops ?: 0)
        result = 31 * result + (storageSize ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RdsConfiguration

        if (deploymentOption != other.deploymentOption) return false
        if (engineEdition != other.engineEdition) return false
        if (engineVersion != other.engineVersion) return false
        if (instanceMemory != other.instanceMemory) return false
        if (instanceType != other.instanceType) return false
        if (instanceVcpu != other.instanceVcpu) return false
        if (storageIops != other.storageIops) return false
        if (storageSize != other.storageSize) return false
        if (storageType != other.storageType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.RdsConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Describes the deployment option for the recommended Amazon RDS DB instance. The deployment options include Multi-AZ and Single-AZ deployments. Valid values include `"MULTI_AZ"` and `"SINGLE_AZ"`.
         */
        public var deploymentOption: kotlin.String? = null
        /**
         * Describes the recommended target Amazon RDS engine edition.
         */
        public var engineEdition: kotlin.String? = null
        /**
         * Describes the recommended target Amazon RDS engine version.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * Describes the memory on the recommended Amazon RDS DB instance that meets your requirements.
         */
        public var instanceMemory: kotlin.Double? = null
        /**
         * Describes the recommended target Amazon RDS instance type.
         */
        public var instanceType: kotlin.String? = null
        /**
         * Describes the number of virtual CPUs (vCPU) on the recommended Amazon RDS DB instance that meets your requirements.
         */
        public var instanceVcpu: kotlin.Double? = null
        /**
         * Describes the number of I/O operations completed each second (IOPS) on the recommended Amazon RDS DB instance that meets your requirements.
         */
        public var storageIops: kotlin.Int? = null
        /**
         * Describes the storage size of the recommended Amazon RDS DB instance that meets your requirements.
         */
        public var storageSize: kotlin.Int? = null
        /**
         * Describes the storage type of the recommended Amazon RDS DB instance that meets your requirements.
         *
         * Amazon RDS provides three storage types: General Purpose SSD (also known as gp2 and gp3), Provisioned IOPS SSD (also known as io1), and magnetic (also known as standard).
         */
        public var storageType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.RdsConfiguration) : this() {
            this.deploymentOption = x.deploymentOption
            this.engineEdition = x.engineEdition
            this.engineVersion = x.engineVersion
            this.instanceMemory = x.instanceMemory
            this.instanceType = x.instanceType
            this.instanceVcpu = x.instanceVcpu
            this.storageIops = x.storageIops
            this.storageSize = x.storageSize
            this.storageType = x.storageType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.RdsConfiguration = RdsConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
