// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model



/**
 * Provides information that defines an Oracle endpoint.
 */
public class OracleSettings private constructor(builder: Builder) {
    /**
     * Set this attribute to `false` in order to use the Binary Reader to capture change data for an Amazon RDS for Oracle as the source. This tells the DMS instance to not access redo logs through any specified path prefix replacement using direct file access.
     */
    public val accessAlternateDirectly: kotlin.Boolean? = builder.accessAlternateDirectly
    /**
     * Set this attribute to set up table-level supplemental logging for the Oracle database. This attribute enables PRIMARY KEY supplemental logging on all tables selected for a migration task.
     *
     * If you use this option, you still need to enable database-level supplemental logging.
     */
    public val addSupplementalLogging: kotlin.Boolean? = builder.addSupplementalLogging
    /**
     * Set this attribute with `ArchivedLogDestId` in a primary/ standby setup. This attribute is useful in the case of a switchover. In this case, DMS needs to know which destination to get archive redo logs from to read changes. This need arises because the previous primary instance is now a standby instance after switchover.
     *
     * Although DMS supports the use of the Oracle `RESETLOGS` option to open the database, never use `RESETLOGS` unless necessary. For additional information about `RESETLOGS`, see [RMAN Data Repair Concepts](https://docs.oracle.com/en/database/oracle/oracle-database/19/bradv/rman-data-repair-concepts.html#GUID-1805CCF7-4AF2-482D-B65A-998192F89C2B) in the *Oracle Database Backup and Recovery User's Guide*.
     */
    public val additionalArchivedLogDestId: kotlin.Int? = builder.additionalArchivedLogDestId
    /**
     * Set this attribute to `true` to enable replication of Oracle tables containing columns that are nested tables or defined types.
     */
    public val allowSelectNestedTables: kotlin.Boolean? = builder.allowSelectNestedTables
    /**
     * Specifies the ID of the destination for the archived redo logs. This value should be the same as a number in the dest_id column of the v$archived_log view. If you work with an additional redo log destination, use the `AdditionalArchivedLogDestId` option to specify the additional destination ID. Doing this improves performance by ensuring that the correct logs are accessed from the outset.
     */
    public val archivedLogDestId: kotlin.Int? = builder.archivedLogDestId
    /**
     * When this field is set to `Y`, DMS only accesses the archived redo logs. If the archived redo logs are stored on Automatic Storage Management (ASM) only, the DMS user account needs to be granted ASM privileges.
     */
    public val archivedLogsOnly: kotlin.Boolean? = builder.archivedLogsOnly
    /**
     * For an Oracle source endpoint, your Oracle Automatic Storage Management (ASM) password. You can set this value from the ` <i>asm_user_password</i> ` value. You set this value as part of the comma-separated value that you set to the `Password` request parameter when you create the endpoint to access transaction logs using Binary Reader. For more information, see [Configuration for change data capture (CDC) on an Oracle source database](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration).
     */
    public val asmPassword: kotlin.String? = builder.asmPassword
    /**
     * For an Oracle source endpoint, your ASM server address. You can set this value from the `asm_server` value. You set `asm_server` as part of the extra connection attribute string to access an Oracle server with Binary Reader that uses ASM. For more information, see [Configuration for change data capture (CDC) on an Oracle source database](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration).
     */
    public val asmServer: kotlin.String? = builder.asmServer
    /**
     * For an Oracle source endpoint, your ASM user name. You can set this value from the `asm_user` value. You set `asm_user` as part of the extra connection attribute string to access an Oracle server with Binary Reader that uses ASM. For more information, see [Configuration for change data capture (CDC) on an Oracle source database](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration).
     */
    public val asmUser: kotlin.String? = builder.asmUser
    /**
     * Specifies whether the length of a character column is in bytes or in characters. To indicate that the character column length is in characters, set this attribute to `CHAR`. Otherwise, the character column length is in bytes.
     *
     * Example: `charLengthSemantics=CHAR;`
     */
    public val charLengthSemantics: aws.sdk.kotlin.services.databasemigrationservice.model.CharLengthSemantics? = builder.charLengthSemantics
    /**
     * When true, converts timestamps with the `timezone` datatype to their UTC value.
     */
    public val convertTimestampWithZoneToUtc: kotlin.Boolean? = builder.convertTimestampWithZoneToUtc
    /**
     * Database name for the endpoint.
     */
    public val databaseName: kotlin.String? = builder.databaseName
    /**
     * When set to `true`, this attribute helps to increase the commit rate on the Oracle target database by writing directly to tables and not writing a trail to database logs.
     */
    public val directPathNoLog: kotlin.Boolean? = builder.directPathNoLog
    /**
     * When set to `true`, this attribute specifies a parallel load when `useDirectPathFullLoad` is set to `Y`. This attribute also only applies when you use the DMS parallel load feature. Note that the target table cannot have any constraints or indexes.
     */
    public val directPathParallelLoad: kotlin.Boolean? = builder.directPathParallelLoad
    /**
     * Set this attribute to enable homogenous tablespace replication and create existing tables or indexes under the same tablespace on the target.
     */
    public val enableHomogenousTablespace: kotlin.Boolean? = builder.enableHomogenousTablespace
    /**
     * Specifies the IDs of one more destinations for one or more archived redo logs. These IDs are the values of the `dest_id` column in the `v$archived_log` view. Use this setting with the `archivedLogDestId` extra connection attribute in a primary-to-single setup or a primary-to-multiple-standby setup.
     *
     * This setting is useful in a switchover when you use an Oracle Data Guard database as a source. In this case, DMS needs information about what destination to get archive redo logs from to read changes. DMS needs this because after the switchover the previous primary is a standby instance. For example, in a primary-to-single standby setup you might apply the following settings.
     *
     * `archivedLogDestId=1; ExtraArchivedLogDestIds=[2]`
     *
     * In a primary-to-multiple-standby setup, you might apply the following settings.
     *
     * `archivedLogDestId=1; ExtraArchivedLogDestIds=[2,3,4]`
     *
     * Although DMS supports the use of the Oracle `RESETLOGS` option to open the database, never use `RESETLOGS` unless it's necessary. For more information about `RESETLOGS`, see [ RMAN Data Repair Concepts](https://docs.oracle.com/en/database/oracle/oracle-database/19/bradv/rman-data-repair-concepts.html#GUID-1805CCF7-4AF2-482D-B65A-998192F89C2B) in the *Oracle Database Backup and Recovery User's Guide*.
     */
    public val extraArchivedLogDestIds: List<Int>? = builder.extraArchivedLogDestIds
    /**
     * When set to `true`, this attribute causes a task to fail if the actual size of an LOB column is greater than the specified `LobMaxSize`.
     *
     * If a task is set to limited LOB mode and this option is set to `true`, the task fails instead of truncating the LOB data.
     */
    public val failTasksOnLobTruncation: kotlin.Boolean? = builder.failTasksOnLobTruncation
    /**
     * Specifies the number scale. You can select a scale up to 38, or you can select FLOAT. By default, the NUMBER data type is converted to precision 38, scale 10.
     *
     * Example: `numberDataTypeScale=12`
     */
    public val numberDatatypeScale: kotlin.Int? = builder.numberDatatypeScale
    /**
     * The timeframe in minutes to check for open transactions for a CDC-only task.
     *
     * You can specify an integer value between 0 (the default) and 240 (the maximum).
     *
     * This parameter is only valid in DMS version 3.5.0 and later. DMS supports a window of up to 9.5 hours including the value for `OpenTransactionWindow`.
     */
    public val openTransactionWindow: kotlin.Int? = builder.openTransactionWindow
    /**
     * Set this string attribute to the required value in order to use the Binary Reader to capture change data for an Amazon RDS for Oracle as the source. This value specifies the default Oracle root used to access the redo logs.
     */
    public val oraclePathPrefix: kotlin.String? = builder.oraclePathPrefix
    /**
     * Set this attribute to change the number of threads that DMS configures to perform a change data capture (CDC) load using Oracle Automatic Storage Management (ASM). You can specify an integer value between 2 (the default) and 8 (the maximum). Use this attribute together with the `readAheadBlocks` attribute.
     */
    public val parallelAsmReadThreads: kotlin.Int? = builder.parallelAsmReadThreads
    /**
     * Endpoint connection password.
     */
    public val password: kotlin.String? = builder.password
    /**
     * Endpoint TCP port.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * Set this attribute to change the number of read-ahead blocks that DMS configures to perform a change data capture (CDC) load using Oracle Automatic Storage Management (ASM). You can specify an integer value between 1000 (the default) and 200,000 (the maximum).
     */
    public val readAheadBlocks: kotlin.Int? = builder.readAheadBlocks
    /**
     * When set to `true`, this attribute supports tablespace replication.
     */
    public val readTableSpaceName: kotlin.Boolean? = builder.readTableSpaceName
    /**
     * Set this attribute to true in order to use the Binary Reader to capture change data for an Amazon RDS for Oracle as the source. This setting tells DMS instance to replace the default Oracle root with the specified `usePathPrefix` setting to access the redo logs.
     */
    public val replacePathPrefix: kotlin.Boolean? = builder.replacePathPrefix
    /**
     * Specifies the number of seconds that the system waits before resending a query.
     *
     * Example: `retryInterval=6;`
     */
    public val retryInterval: kotlin.Int? = builder.retryInterval
    /**
     * The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the trusted entity and grants the required permissions to access the value in `SecretsManagerSecret`. The role must allow the `iam:PassRole` action. `SecretsManagerSecret` has the value of the Amazon Web Services Secrets Manager secret that allows access to the Oracle endpoint.
     *
     * You can specify one of two sets of values for these permissions. You can specify the values for this setting and `SecretsManagerSecretId`. Or you can specify clear-text values for `UserName`, `Password`, `ServerName`, and `Port`. You can't specify both. For more information on creating this `SecretsManagerSecret` and the `SecretsManagerAccessRoleArn` and `SecretsManagerSecretId` required to access it, see [Using secrets to access Database Migration Service resources](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager) in the *Database Migration Service User Guide*.
     */
    public val secretsManagerAccessRoleArn: kotlin.String? = builder.secretsManagerAccessRoleArn
    /**
     * Required only if your Oracle endpoint uses Automatic Storage Management (ASM). The full ARN of the IAM role that specifies DMS as the trusted entity and grants the required permissions to access the `SecretsManagerOracleAsmSecret`. This `SecretsManagerOracleAsmSecret` has the secret value that allows access to the Oracle ASM of the endpoint.
     *
     * You can specify one of two sets of values for these permissions. You can specify the values for this setting and `SecretsManagerOracleAsmSecretId`. Or you can specify clear-text values for `AsmUser`, `AsmPassword`, and `AsmServerName`. You can't specify both. For more information on creating this `SecretsManagerOracleAsmSecret` and the `SecretsManagerOracleAsmAccessRoleArn` and `SecretsManagerOracleAsmSecretId` required to access it, see [Using secrets to access Database Migration Service resources](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager) in the *Database Migration Service User Guide*.
     */
    public val secretsManagerOracleAsmAccessRoleArn: kotlin.String? = builder.secretsManagerOracleAsmAccessRoleArn
    /**
     * Required only if your Oracle endpoint uses Automatic Storage Management (ASM). The full ARN, partial ARN, or friendly name of the `SecretsManagerOracleAsmSecret` that contains the Oracle ASM connection details for the Oracle endpoint.
     */
    public val secretsManagerOracleAsmSecretId: kotlin.String? = builder.secretsManagerOracleAsmSecretId
    /**
     * The full ARN, partial ARN, or friendly name of the `SecretsManagerSecret` that contains the Oracle endpoint connection details.
     */
    public val secretsManagerSecretId: kotlin.String? = builder.secretsManagerSecretId
    /**
     * For an Oracle source endpoint, the transparent data encryption (TDE) password required by AWM DMS to access Oracle redo logs encrypted by TDE using Binary Reader. It is also the ` <i>TDE_Password</i> ` part of the comma-separated value you set to the `Password` request parameter when you create the endpoint. The `SecurityDbEncryptian` setting is related to this `SecurityDbEncryptionName` setting. For more information, see [ Supported encryption methods for using Oracle as a source for DMS ](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.Encryption) in the *Database Migration Service User Guide*.
     */
    public val securityDbEncryption: kotlin.String? = builder.securityDbEncryption
    /**
     * For an Oracle source endpoint, the name of a key used for the transparent data encryption (TDE) of the columns and tablespaces in an Oracle source database that is encrypted using TDE. The key value is the value of the `SecurityDbEncryption` setting. For more information on setting the key name value of `SecurityDbEncryptionName`, see the information and example for setting the `securityDbEncryptionName` extra connection attribute in [ Supported encryption methods for using Oracle as a source for DMS ](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.Encryption) in the *Database Migration Service User Guide*.
     */
    public val securityDbEncryptionName: kotlin.String? = builder.securityDbEncryptionName
    /**
     * Fully qualified domain name of the endpoint.
     *
     * For an Amazon RDS Oracle instance, this is the output of [DescribeDBInstances](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBInstances.html), in the ` <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_Endpoint.html">Endpoint</a>.Address` field.
     */
    public val serverName: kotlin.String? = builder.serverName
    /**
     * Use this attribute to convert `SDO_GEOMETRY` to `GEOJSON` format. By default, DMS calls the `SDO2GEOJSON` custom function if present and accessible. Or you can create your own custom function that mimics the operation of `SDOGEOJSON` and set `SpatialDataOptionToGeoJsonFunctionName` to call it instead.
     */
    public val spatialDataOptionToGeoJsonFunctionName: kotlin.String? = builder.spatialDataOptionToGeoJsonFunctionName
    /**
     * Use this attribute to specify a time in minutes for the delay in standby sync. If the source is an Oracle Active Data Guard standby database, use this attribute to specify the time lag between primary and standby databases.
     *
     * In DMS, you can create an Oracle CDC task that uses an Active Data Guard standby instance as a source for replicating ongoing changes. Doing this eliminates the need to connect to an active database that might be in production.
     */
    public val standbyDelayTime: kotlin.Int? = builder.standbyDelayTime
    /**
     * Use the `TrimSpaceInChar` source endpoint setting to trim data on CHAR and NCHAR data types during migration. The default value is `true`.
     */
    public val trimSpaceInChar: kotlin.Boolean? = builder.trimSpaceInChar
    /**
     * Set this attribute to `true` in order to use the Binary Reader to capture change data for an Amazon RDS for Oracle as the source. This tells the DMS instance to use any specified prefix replacement to access all online redo logs.
     */
    public val useAlternateFolderForOnline: kotlin.Boolean? = builder.useAlternateFolderForOnline
    /**
     * Set this attribute to Y to capture change data using the Binary Reader utility. Set `UseLogminerReader` to N to set this attribute to Y. To use Binary Reader with Amazon RDS for Oracle as the source, you set additional attributes. For more information about using this setting with Oracle Automatic Storage Management (ASM), see [ Using Oracle LogMiner or DMS Binary Reader for CDC](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC).
     */
    public val useBFile: kotlin.Boolean? = builder.useBFile
    /**
     * Set this attribute to Y to have DMS use a direct path full load. Specify this value to use the direct path protocol in the Oracle Call Interface (OCI). By using this OCI protocol, you can bulk-load Oracle target tables during a full load.
     */
    public val useDirectPathFullLoad: kotlin.Boolean? = builder.useDirectPathFullLoad
    /**
     * Set this attribute to Y to capture change data using the Oracle LogMiner utility (the default). Set this attribute to N if you want to access the redo logs as a binary file. When you set `UseLogminerReader` to N, also set `UseBfile` to Y. For more information on this setting and using Oracle ASM, see [ Using Oracle LogMiner or DMS Binary Reader for CDC](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC) in the *DMS User Guide*.
     */
    public val useLogminerReader: kotlin.Boolean? = builder.useLogminerReader
    /**
     * Set this string attribute to the required value in order to use the Binary Reader to capture change data for an Amazon RDS for Oracle as the source. This value specifies the path prefix used to replace the default Oracle root to access the redo logs.
     */
    public val usePathPrefix: kotlin.String? = builder.usePathPrefix
    /**
     * Endpoint connection user name.
     */
    public val username: kotlin.String? = builder.username

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.OracleSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OracleSettings(")
        append("accessAlternateDirectly=$accessAlternateDirectly,")
        append("addSupplementalLogging=$addSupplementalLogging,")
        append("additionalArchivedLogDestId=$additionalArchivedLogDestId,")
        append("allowSelectNestedTables=$allowSelectNestedTables,")
        append("archivedLogDestId=$archivedLogDestId,")
        append("archivedLogsOnly=$archivedLogsOnly,")
        append("asmPassword=*** Sensitive Data Redacted ***,")
        append("asmServer=$asmServer,")
        append("asmUser=$asmUser,")
        append("charLengthSemantics=$charLengthSemantics,")
        append("convertTimestampWithZoneToUtc=$convertTimestampWithZoneToUtc,")
        append("databaseName=$databaseName,")
        append("directPathNoLog=$directPathNoLog,")
        append("directPathParallelLoad=$directPathParallelLoad,")
        append("enableHomogenousTablespace=$enableHomogenousTablespace,")
        append("extraArchivedLogDestIds=$extraArchivedLogDestIds,")
        append("failTasksOnLobTruncation=$failTasksOnLobTruncation,")
        append("numberDatatypeScale=$numberDatatypeScale,")
        append("openTransactionWindow=$openTransactionWindow,")
        append("oraclePathPrefix=$oraclePathPrefix,")
        append("parallelAsmReadThreads=$parallelAsmReadThreads,")
        append("password=*** Sensitive Data Redacted ***,")
        append("port=$port,")
        append("readAheadBlocks=$readAheadBlocks,")
        append("readTableSpaceName=$readTableSpaceName,")
        append("replacePathPrefix=$replacePathPrefix,")
        append("retryInterval=$retryInterval,")
        append("secretsManagerAccessRoleArn=$secretsManagerAccessRoleArn,")
        append("secretsManagerOracleAsmAccessRoleArn=$secretsManagerOracleAsmAccessRoleArn,")
        append("secretsManagerOracleAsmSecretId=$secretsManagerOracleAsmSecretId,")
        append("secretsManagerSecretId=$secretsManagerSecretId,")
        append("securityDbEncryption=*** Sensitive Data Redacted ***,")
        append("securityDbEncryptionName=$securityDbEncryptionName,")
        append("serverName=$serverName,")
        append("spatialDataOptionToGeoJsonFunctionName=$spatialDataOptionToGeoJsonFunctionName,")
        append("standbyDelayTime=$standbyDelayTime,")
        append("trimSpaceInChar=$trimSpaceInChar,")
        append("useAlternateFolderForOnline=$useAlternateFolderForOnline,")
        append("useBFile=$useBFile,")
        append("useDirectPathFullLoad=$useDirectPathFullLoad,")
        append("useLogminerReader=$useLogminerReader,")
        append("usePathPrefix=$usePathPrefix,")
        append("username=$username")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessAlternateDirectly?.hashCode() ?: 0
        result = 31 * result + (addSupplementalLogging?.hashCode() ?: 0)
        result = 31 * result + (additionalArchivedLogDestId ?: 0)
        result = 31 * result + (allowSelectNestedTables?.hashCode() ?: 0)
        result = 31 * result + (archivedLogDestId ?: 0)
        result = 31 * result + (archivedLogsOnly?.hashCode() ?: 0)
        result = 31 * result + (asmPassword?.hashCode() ?: 0)
        result = 31 * result + (asmServer?.hashCode() ?: 0)
        result = 31 * result + (asmUser?.hashCode() ?: 0)
        result = 31 * result + (charLengthSemantics?.hashCode() ?: 0)
        result = 31 * result + (convertTimestampWithZoneToUtc?.hashCode() ?: 0)
        result = 31 * result + (databaseName?.hashCode() ?: 0)
        result = 31 * result + (directPathNoLog?.hashCode() ?: 0)
        result = 31 * result + (directPathParallelLoad?.hashCode() ?: 0)
        result = 31 * result + (enableHomogenousTablespace?.hashCode() ?: 0)
        result = 31 * result + (extraArchivedLogDestIds?.hashCode() ?: 0)
        result = 31 * result + (failTasksOnLobTruncation?.hashCode() ?: 0)
        result = 31 * result + (numberDatatypeScale ?: 0)
        result = 31 * result + (openTransactionWindow ?: 0)
        result = 31 * result + (oraclePathPrefix?.hashCode() ?: 0)
        result = 31 * result + (parallelAsmReadThreads ?: 0)
        result = 31 * result + (password?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (readAheadBlocks ?: 0)
        result = 31 * result + (readTableSpaceName?.hashCode() ?: 0)
        result = 31 * result + (replacePathPrefix?.hashCode() ?: 0)
        result = 31 * result + (retryInterval ?: 0)
        result = 31 * result + (secretsManagerAccessRoleArn?.hashCode() ?: 0)
        result = 31 * result + (secretsManagerOracleAsmAccessRoleArn?.hashCode() ?: 0)
        result = 31 * result + (secretsManagerOracleAsmSecretId?.hashCode() ?: 0)
        result = 31 * result + (secretsManagerSecretId?.hashCode() ?: 0)
        result = 31 * result + (securityDbEncryption?.hashCode() ?: 0)
        result = 31 * result + (securityDbEncryptionName?.hashCode() ?: 0)
        result = 31 * result + (serverName?.hashCode() ?: 0)
        result = 31 * result + (spatialDataOptionToGeoJsonFunctionName?.hashCode() ?: 0)
        result = 31 * result + (standbyDelayTime ?: 0)
        result = 31 * result + (trimSpaceInChar?.hashCode() ?: 0)
        result = 31 * result + (useAlternateFolderForOnline?.hashCode() ?: 0)
        result = 31 * result + (useBFile?.hashCode() ?: 0)
        result = 31 * result + (useDirectPathFullLoad?.hashCode() ?: 0)
        result = 31 * result + (useLogminerReader?.hashCode() ?: 0)
        result = 31 * result + (usePathPrefix?.hashCode() ?: 0)
        result = 31 * result + (username?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OracleSettings

        if (accessAlternateDirectly != other.accessAlternateDirectly) return false
        if (addSupplementalLogging != other.addSupplementalLogging) return false
        if (additionalArchivedLogDestId != other.additionalArchivedLogDestId) return false
        if (allowSelectNestedTables != other.allowSelectNestedTables) return false
        if (archivedLogDestId != other.archivedLogDestId) return false
        if (archivedLogsOnly != other.archivedLogsOnly) return false
        if (asmPassword != other.asmPassword) return false
        if (asmServer != other.asmServer) return false
        if (asmUser != other.asmUser) return false
        if (charLengthSemantics != other.charLengthSemantics) return false
        if (convertTimestampWithZoneToUtc != other.convertTimestampWithZoneToUtc) return false
        if (databaseName != other.databaseName) return false
        if (directPathNoLog != other.directPathNoLog) return false
        if (directPathParallelLoad != other.directPathParallelLoad) return false
        if (enableHomogenousTablespace != other.enableHomogenousTablespace) return false
        if (extraArchivedLogDestIds != other.extraArchivedLogDestIds) return false
        if (failTasksOnLobTruncation != other.failTasksOnLobTruncation) return false
        if (numberDatatypeScale != other.numberDatatypeScale) return false
        if (openTransactionWindow != other.openTransactionWindow) return false
        if (oraclePathPrefix != other.oraclePathPrefix) return false
        if (parallelAsmReadThreads != other.parallelAsmReadThreads) return false
        if (password != other.password) return false
        if (port != other.port) return false
        if (readAheadBlocks != other.readAheadBlocks) return false
        if (readTableSpaceName != other.readTableSpaceName) return false
        if (replacePathPrefix != other.replacePathPrefix) return false
        if (retryInterval != other.retryInterval) return false
        if (secretsManagerAccessRoleArn != other.secretsManagerAccessRoleArn) return false
        if (secretsManagerOracleAsmAccessRoleArn != other.secretsManagerOracleAsmAccessRoleArn) return false
        if (secretsManagerOracleAsmSecretId != other.secretsManagerOracleAsmSecretId) return false
        if (secretsManagerSecretId != other.secretsManagerSecretId) return false
        if (securityDbEncryption != other.securityDbEncryption) return false
        if (securityDbEncryptionName != other.securityDbEncryptionName) return false
        if (serverName != other.serverName) return false
        if (spatialDataOptionToGeoJsonFunctionName != other.spatialDataOptionToGeoJsonFunctionName) return false
        if (standbyDelayTime != other.standbyDelayTime) return false
        if (trimSpaceInChar != other.trimSpaceInChar) return false
        if (useAlternateFolderForOnline != other.useAlternateFolderForOnline) return false
        if (useBFile != other.useBFile) return false
        if (useDirectPathFullLoad != other.useDirectPathFullLoad) return false
        if (useLogminerReader != other.useLogminerReader) return false
        if (usePathPrefix != other.usePathPrefix) return false
        if (username != other.username) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.OracleSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Set this attribute to `false` in order to use the Binary Reader to capture change data for an Amazon RDS for Oracle as the source. This tells the DMS instance to not access redo logs through any specified path prefix replacement using direct file access.
         */
        public var accessAlternateDirectly: kotlin.Boolean? = null
        /**
         * Set this attribute to set up table-level supplemental logging for the Oracle database. This attribute enables PRIMARY KEY supplemental logging on all tables selected for a migration task.
         *
         * If you use this option, you still need to enable database-level supplemental logging.
         */
        public var addSupplementalLogging: kotlin.Boolean? = null
        /**
         * Set this attribute with `ArchivedLogDestId` in a primary/ standby setup. This attribute is useful in the case of a switchover. In this case, DMS needs to know which destination to get archive redo logs from to read changes. This need arises because the previous primary instance is now a standby instance after switchover.
         *
         * Although DMS supports the use of the Oracle `RESETLOGS` option to open the database, never use `RESETLOGS` unless necessary. For additional information about `RESETLOGS`, see [RMAN Data Repair Concepts](https://docs.oracle.com/en/database/oracle/oracle-database/19/bradv/rman-data-repair-concepts.html#GUID-1805CCF7-4AF2-482D-B65A-998192F89C2B) in the *Oracle Database Backup and Recovery User's Guide*.
         */
        public var additionalArchivedLogDestId: kotlin.Int? = null
        /**
         * Set this attribute to `true` to enable replication of Oracle tables containing columns that are nested tables or defined types.
         */
        public var allowSelectNestedTables: kotlin.Boolean? = null
        /**
         * Specifies the ID of the destination for the archived redo logs. This value should be the same as a number in the dest_id column of the v$archived_log view. If you work with an additional redo log destination, use the `AdditionalArchivedLogDestId` option to specify the additional destination ID. Doing this improves performance by ensuring that the correct logs are accessed from the outset.
         */
        public var archivedLogDestId: kotlin.Int? = null
        /**
         * When this field is set to `Y`, DMS only accesses the archived redo logs. If the archived redo logs are stored on Automatic Storage Management (ASM) only, the DMS user account needs to be granted ASM privileges.
         */
        public var archivedLogsOnly: kotlin.Boolean? = null
        /**
         * For an Oracle source endpoint, your Oracle Automatic Storage Management (ASM) password. You can set this value from the ` <i>asm_user_password</i> ` value. You set this value as part of the comma-separated value that you set to the `Password` request parameter when you create the endpoint to access transaction logs using Binary Reader. For more information, see [Configuration for change data capture (CDC) on an Oracle source database](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration).
         */
        public var asmPassword: kotlin.String? = null
        /**
         * For an Oracle source endpoint, your ASM server address. You can set this value from the `asm_server` value. You set `asm_server` as part of the extra connection attribute string to access an Oracle server with Binary Reader that uses ASM. For more information, see [Configuration for change data capture (CDC) on an Oracle source database](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration).
         */
        public var asmServer: kotlin.String? = null
        /**
         * For an Oracle source endpoint, your ASM user name. You can set this value from the `asm_user` value. You set `asm_user` as part of the extra connection attribute string to access an Oracle server with Binary Reader that uses ASM. For more information, see [Configuration for change data capture (CDC) on an Oracle source database](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration).
         */
        public var asmUser: kotlin.String? = null
        /**
         * Specifies whether the length of a character column is in bytes or in characters. To indicate that the character column length is in characters, set this attribute to `CHAR`. Otherwise, the character column length is in bytes.
         *
         * Example: `charLengthSemantics=CHAR;`
         */
        public var charLengthSemantics: aws.sdk.kotlin.services.databasemigrationservice.model.CharLengthSemantics? = null
        /**
         * When true, converts timestamps with the `timezone` datatype to their UTC value.
         */
        public var convertTimestampWithZoneToUtc: kotlin.Boolean? = null
        /**
         * Database name for the endpoint.
         */
        public var databaseName: kotlin.String? = null
        /**
         * When set to `true`, this attribute helps to increase the commit rate on the Oracle target database by writing directly to tables and not writing a trail to database logs.
         */
        public var directPathNoLog: kotlin.Boolean? = null
        /**
         * When set to `true`, this attribute specifies a parallel load when `useDirectPathFullLoad` is set to `Y`. This attribute also only applies when you use the DMS parallel load feature. Note that the target table cannot have any constraints or indexes.
         */
        public var directPathParallelLoad: kotlin.Boolean? = null
        /**
         * Set this attribute to enable homogenous tablespace replication and create existing tables or indexes under the same tablespace on the target.
         */
        public var enableHomogenousTablespace: kotlin.Boolean? = null
        /**
         * Specifies the IDs of one more destinations for one or more archived redo logs. These IDs are the values of the `dest_id` column in the `v$archived_log` view. Use this setting with the `archivedLogDestId` extra connection attribute in a primary-to-single setup or a primary-to-multiple-standby setup.
         *
         * This setting is useful in a switchover when you use an Oracle Data Guard database as a source. In this case, DMS needs information about what destination to get archive redo logs from to read changes. DMS needs this because after the switchover the previous primary is a standby instance. For example, in a primary-to-single standby setup you might apply the following settings.
         *
         * `archivedLogDestId=1; ExtraArchivedLogDestIds=[2]`
         *
         * In a primary-to-multiple-standby setup, you might apply the following settings.
         *
         * `archivedLogDestId=1; ExtraArchivedLogDestIds=[2,3,4]`
         *
         * Although DMS supports the use of the Oracle `RESETLOGS` option to open the database, never use `RESETLOGS` unless it's necessary. For more information about `RESETLOGS`, see [ RMAN Data Repair Concepts](https://docs.oracle.com/en/database/oracle/oracle-database/19/bradv/rman-data-repair-concepts.html#GUID-1805CCF7-4AF2-482D-B65A-998192F89C2B) in the *Oracle Database Backup and Recovery User's Guide*.
         */
        public var extraArchivedLogDestIds: List<Int>? = null
        /**
         * When set to `true`, this attribute causes a task to fail if the actual size of an LOB column is greater than the specified `LobMaxSize`.
         *
         * If a task is set to limited LOB mode and this option is set to `true`, the task fails instead of truncating the LOB data.
         */
        public var failTasksOnLobTruncation: kotlin.Boolean? = null
        /**
         * Specifies the number scale. You can select a scale up to 38, or you can select FLOAT. By default, the NUMBER data type is converted to precision 38, scale 10.
         *
         * Example: `numberDataTypeScale=12`
         */
        public var numberDatatypeScale: kotlin.Int? = null
        /**
         * The timeframe in minutes to check for open transactions for a CDC-only task.
         *
         * You can specify an integer value between 0 (the default) and 240 (the maximum).
         *
         * This parameter is only valid in DMS version 3.5.0 and later. DMS supports a window of up to 9.5 hours including the value for `OpenTransactionWindow`.
         */
        public var openTransactionWindow: kotlin.Int? = null
        /**
         * Set this string attribute to the required value in order to use the Binary Reader to capture change data for an Amazon RDS for Oracle as the source. This value specifies the default Oracle root used to access the redo logs.
         */
        public var oraclePathPrefix: kotlin.String? = null
        /**
         * Set this attribute to change the number of threads that DMS configures to perform a change data capture (CDC) load using Oracle Automatic Storage Management (ASM). You can specify an integer value between 2 (the default) and 8 (the maximum). Use this attribute together with the `readAheadBlocks` attribute.
         */
        public var parallelAsmReadThreads: kotlin.Int? = null
        /**
         * Endpoint connection password.
         */
        public var password: kotlin.String? = null
        /**
         * Endpoint TCP port.
         */
        public var port: kotlin.Int? = null
        /**
         * Set this attribute to change the number of read-ahead blocks that DMS configures to perform a change data capture (CDC) load using Oracle Automatic Storage Management (ASM). You can specify an integer value between 1000 (the default) and 200,000 (the maximum).
         */
        public var readAheadBlocks: kotlin.Int? = null
        /**
         * When set to `true`, this attribute supports tablespace replication.
         */
        public var readTableSpaceName: kotlin.Boolean? = null
        /**
         * Set this attribute to true in order to use the Binary Reader to capture change data for an Amazon RDS for Oracle as the source. This setting tells DMS instance to replace the default Oracle root with the specified `usePathPrefix` setting to access the redo logs.
         */
        public var replacePathPrefix: kotlin.Boolean? = null
        /**
         * Specifies the number of seconds that the system waits before resending a query.
         *
         * Example: `retryInterval=6;`
         */
        public var retryInterval: kotlin.Int? = null
        /**
         * The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the trusted entity and grants the required permissions to access the value in `SecretsManagerSecret`. The role must allow the `iam:PassRole` action. `SecretsManagerSecret` has the value of the Amazon Web Services Secrets Manager secret that allows access to the Oracle endpoint.
         *
         * You can specify one of two sets of values for these permissions. You can specify the values for this setting and `SecretsManagerSecretId`. Or you can specify clear-text values for `UserName`, `Password`, `ServerName`, and `Port`. You can't specify both. For more information on creating this `SecretsManagerSecret` and the `SecretsManagerAccessRoleArn` and `SecretsManagerSecretId` required to access it, see [Using secrets to access Database Migration Service resources](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager) in the *Database Migration Service User Guide*.
         */
        public var secretsManagerAccessRoleArn: kotlin.String? = null
        /**
         * Required only if your Oracle endpoint uses Automatic Storage Management (ASM). The full ARN of the IAM role that specifies DMS as the trusted entity and grants the required permissions to access the `SecretsManagerOracleAsmSecret`. This `SecretsManagerOracleAsmSecret` has the secret value that allows access to the Oracle ASM of the endpoint.
         *
         * You can specify one of two sets of values for these permissions. You can specify the values for this setting and `SecretsManagerOracleAsmSecretId`. Or you can specify clear-text values for `AsmUser`, `AsmPassword`, and `AsmServerName`. You can't specify both. For more information on creating this `SecretsManagerOracleAsmSecret` and the `SecretsManagerOracleAsmAccessRoleArn` and `SecretsManagerOracleAsmSecretId` required to access it, see [Using secrets to access Database Migration Service resources](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager) in the *Database Migration Service User Guide*.
         */
        public var secretsManagerOracleAsmAccessRoleArn: kotlin.String? = null
        /**
         * Required only if your Oracle endpoint uses Automatic Storage Management (ASM). The full ARN, partial ARN, or friendly name of the `SecretsManagerOracleAsmSecret` that contains the Oracle ASM connection details for the Oracle endpoint.
         */
        public var secretsManagerOracleAsmSecretId: kotlin.String? = null
        /**
         * The full ARN, partial ARN, or friendly name of the `SecretsManagerSecret` that contains the Oracle endpoint connection details.
         */
        public var secretsManagerSecretId: kotlin.String? = null
        /**
         * For an Oracle source endpoint, the transparent data encryption (TDE) password required by AWM DMS to access Oracle redo logs encrypted by TDE using Binary Reader. It is also the ` <i>TDE_Password</i> ` part of the comma-separated value you set to the `Password` request parameter when you create the endpoint. The `SecurityDbEncryptian` setting is related to this `SecurityDbEncryptionName` setting. For more information, see [ Supported encryption methods for using Oracle as a source for DMS ](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.Encryption) in the *Database Migration Service User Guide*.
         */
        public var securityDbEncryption: kotlin.String? = null
        /**
         * For an Oracle source endpoint, the name of a key used for the transparent data encryption (TDE) of the columns and tablespaces in an Oracle source database that is encrypted using TDE. The key value is the value of the `SecurityDbEncryption` setting. For more information on setting the key name value of `SecurityDbEncryptionName`, see the information and example for setting the `securityDbEncryptionName` extra connection attribute in [ Supported encryption methods for using Oracle as a source for DMS ](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.Encryption) in the *Database Migration Service User Guide*.
         */
        public var securityDbEncryptionName: kotlin.String? = null
        /**
         * Fully qualified domain name of the endpoint.
         *
         * For an Amazon RDS Oracle instance, this is the output of [DescribeDBInstances](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBInstances.html), in the ` <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_Endpoint.html">Endpoint</a>.Address` field.
         */
        public var serverName: kotlin.String? = null
        /**
         * Use this attribute to convert `SDO_GEOMETRY` to `GEOJSON` format. By default, DMS calls the `SDO2GEOJSON` custom function if present and accessible. Or you can create your own custom function that mimics the operation of `SDOGEOJSON` and set `SpatialDataOptionToGeoJsonFunctionName` to call it instead.
         */
        public var spatialDataOptionToGeoJsonFunctionName: kotlin.String? = null
        /**
         * Use this attribute to specify a time in minutes for the delay in standby sync. If the source is an Oracle Active Data Guard standby database, use this attribute to specify the time lag between primary and standby databases.
         *
         * In DMS, you can create an Oracle CDC task that uses an Active Data Guard standby instance as a source for replicating ongoing changes. Doing this eliminates the need to connect to an active database that might be in production.
         */
        public var standbyDelayTime: kotlin.Int? = null
        /**
         * Use the `TrimSpaceInChar` source endpoint setting to trim data on CHAR and NCHAR data types during migration. The default value is `true`.
         */
        public var trimSpaceInChar: kotlin.Boolean? = null
        /**
         * Set this attribute to `true` in order to use the Binary Reader to capture change data for an Amazon RDS for Oracle as the source. This tells the DMS instance to use any specified prefix replacement to access all online redo logs.
         */
        public var useAlternateFolderForOnline: kotlin.Boolean? = null
        /**
         * Set this attribute to Y to capture change data using the Binary Reader utility. Set `UseLogminerReader` to N to set this attribute to Y. To use Binary Reader with Amazon RDS for Oracle as the source, you set additional attributes. For more information about using this setting with Oracle Automatic Storage Management (ASM), see [ Using Oracle LogMiner or DMS Binary Reader for CDC](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC).
         */
        public var useBFile: kotlin.Boolean? = null
        /**
         * Set this attribute to Y to have DMS use a direct path full load. Specify this value to use the direct path protocol in the Oracle Call Interface (OCI). By using this OCI protocol, you can bulk-load Oracle target tables during a full load.
         */
        public var useDirectPathFullLoad: kotlin.Boolean? = null
        /**
         * Set this attribute to Y to capture change data using the Oracle LogMiner utility (the default). Set this attribute to N if you want to access the redo logs as a binary file. When you set `UseLogminerReader` to N, also set `UseBfile` to Y. For more information on this setting and using Oracle ASM, see [ Using Oracle LogMiner or DMS Binary Reader for CDC](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC) in the *DMS User Guide*.
         */
        public var useLogminerReader: kotlin.Boolean? = null
        /**
         * Set this string attribute to the required value in order to use the Binary Reader to capture change data for an Amazon RDS for Oracle as the source. This value specifies the path prefix used to replace the default Oracle root to access the redo logs.
         */
        public var usePathPrefix: kotlin.String? = null
        /**
         * Endpoint connection user name.
         */
        public var username: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.OracleSettings) : this() {
            this.accessAlternateDirectly = x.accessAlternateDirectly
            this.addSupplementalLogging = x.addSupplementalLogging
            this.additionalArchivedLogDestId = x.additionalArchivedLogDestId
            this.allowSelectNestedTables = x.allowSelectNestedTables
            this.archivedLogDestId = x.archivedLogDestId
            this.archivedLogsOnly = x.archivedLogsOnly
            this.asmPassword = x.asmPassword
            this.asmServer = x.asmServer
            this.asmUser = x.asmUser
            this.charLengthSemantics = x.charLengthSemantics
            this.convertTimestampWithZoneToUtc = x.convertTimestampWithZoneToUtc
            this.databaseName = x.databaseName
            this.directPathNoLog = x.directPathNoLog
            this.directPathParallelLoad = x.directPathParallelLoad
            this.enableHomogenousTablespace = x.enableHomogenousTablespace
            this.extraArchivedLogDestIds = x.extraArchivedLogDestIds
            this.failTasksOnLobTruncation = x.failTasksOnLobTruncation
            this.numberDatatypeScale = x.numberDatatypeScale
            this.openTransactionWindow = x.openTransactionWindow
            this.oraclePathPrefix = x.oraclePathPrefix
            this.parallelAsmReadThreads = x.parallelAsmReadThreads
            this.password = x.password
            this.port = x.port
            this.readAheadBlocks = x.readAheadBlocks
            this.readTableSpaceName = x.readTableSpaceName
            this.replacePathPrefix = x.replacePathPrefix
            this.retryInterval = x.retryInterval
            this.secretsManagerAccessRoleArn = x.secretsManagerAccessRoleArn
            this.secretsManagerOracleAsmAccessRoleArn = x.secretsManagerOracleAsmAccessRoleArn
            this.secretsManagerOracleAsmSecretId = x.secretsManagerOracleAsmSecretId
            this.secretsManagerSecretId = x.secretsManagerSecretId
            this.securityDbEncryption = x.securityDbEncryption
            this.securityDbEncryptionName = x.securityDbEncryptionName
            this.serverName = x.serverName
            this.spatialDataOptionToGeoJsonFunctionName = x.spatialDataOptionToGeoJsonFunctionName
            this.standbyDelayTime = x.standbyDelayTime
            this.trimSpaceInChar = x.trimSpaceInChar
            this.useAlternateFolderForOnline = x.useAlternateFolderForOnline
            this.useBFile = x.useBFile
            this.useDirectPathFullLoad = x.useDirectPathFullLoad
            this.useLogminerReader = x.useLogminerReader
            this.usePathPrefix = x.usePathPrefix
            this.username = x.username
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.OracleSettings = OracleSettings(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
