// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information that defines an instance profile.
 */
public class InstanceProfile private constructor(builder: Builder) {
    /**
     * The Availability Zone where the instance profile runs.
     */
    public val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * A description of the instance profile. Descriptions can have up to 31 characters. A description can contain only ASCII letters, digits, and hyphens ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens, and can only begin with a letter.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The Amazon Resource Name (ARN) string that uniquely identifies the instance profile.
     */
    public val instanceProfileArn: kotlin.String? = builder.instanceProfileArn
    /**
     * The time the instance profile was created.
     */
    public val instanceProfileCreationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.instanceProfileCreationTime
    /**
     * The user-friendly name for the instance profile.
     */
    public val instanceProfileName: kotlin.String? = builder.instanceProfileName
    /**
     * The Amazon Resource Name (ARN) of the KMS key that is used to encrypt the connection parameters for the instance profile.
     *
     * If you don't specify a value for the `KmsKeyArn` parameter, then DMS uses your default encryption key.
     *
     * KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a different default encryption key for each Amazon Web Services Region.
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * Specifies the network type for the instance profile. A value of `IPV4` represents an instance profile with IPv4 network type and only supports IPv4 addressing. A value of `IPV6` represents an instance profile with IPv6 network type and only supports IPv6 addressing. A value of `DUAL` represents an instance profile with dual network type that supports IPv4 and IPv6 addressing.
     */
    public val networkType: kotlin.String? = builder.networkType
    /**
     * Specifies the accessibility options for the instance profile. A value of `true` represents an instance profile with a public IP address. A value of `false` represents an instance profile with a private IP address. The default value is `true`.
     */
    public val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * The identifier of the subnet group that is associated with the instance profile.
     */
    public val subnetGroupIdentifier: kotlin.String? = builder.subnetGroupIdentifier
    /**
     * The VPC security groups that are used with the instance profile. The VPC security group must work with the VPC containing the instance profile.
     */
    public val vpcSecurityGroups: List<String>? = builder.vpcSecurityGroups

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.InstanceProfile = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceProfile(")
        append("availabilityZone=$availabilityZone,")
        append("description=$description,")
        append("instanceProfileArn=$instanceProfileArn,")
        append("instanceProfileCreationTime=$instanceProfileCreationTime,")
        append("instanceProfileName=$instanceProfileName,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("networkType=$networkType,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("subnetGroupIdentifier=$subnetGroupIdentifier,")
        append("vpcSecurityGroups=$vpcSecurityGroups")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (instanceProfileArn?.hashCode() ?: 0)
        result = 31 * result + (instanceProfileCreationTime?.hashCode() ?: 0)
        result = 31 * result + (instanceProfileName?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (networkType?.hashCode() ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (subnetGroupIdentifier?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroups?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceProfile

        if (availabilityZone != other.availabilityZone) return false
        if (description != other.description) return false
        if (instanceProfileArn != other.instanceProfileArn) return false
        if (instanceProfileCreationTime != other.instanceProfileCreationTime) return false
        if (instanceProfileName != other.instanceProfileName) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (networkType != other.networkType) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (subnetGroupIdentifier != other.subnetGroupIdentifier) return false
        if (vpcSecurityGroups != other.vpcSecurityGroups) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.InstanceProfile = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Availability Zone where the instance profile runs.
         */
        public var availabilityZone: kotlin.String? = null
        /**
         * A description of the instance profile. Descriptions can have up to 31 characters. A description can contain only ASCII letters, digits, and hyphens ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens, and can only begin with a letter.
         */
        public var description: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) string that uniquely identifies the instance profile.
         */
        public var instanceProfileArn: kotlin.String? = null
        /**
         * The time the instance profile was created.
         */
        public var instanceProfileCreationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The user-friendly name for the instance profile.
         */
        public var instanceProfileName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the KMS key that is used to encrypt the connection parameters for the instance profile.
         *
         * If you don't specify a value for the `KmsKeyArn` parameter, then DMS uses your default encryption key.
         *
         * KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a different default encryption key for each Amazon Web Services Region.
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * Specifies the network type for the instance profile. A value of `IPV4` represents an instance profile with IPv4 network type and only supports IPv4 addressing. A value of `IPV6` represents an instance profile with IPv6 network type and only supports IPv6 addressing. A value of `DUAL` represents an instance profile with dual network type that supports IPv4 and IPv6 addressing.
         */
        public var networkType: kotlin.String? = null
        /**
         * Specifies the accessibility options for the instance profile. A value of `true` represents an instance profile with a public IP address. A value of `false` represents an instance profile with a private IP address. The default value is `true`.
         */
        public var publiclyAccessible: kotlin.Boolean? = null
        /**
         * The identifier of the subnet group that is associated with the instance profile.
         */
        public var subnetGroupIdentifier: kotlin.String? = null
        /**
         * The VPC security groups that are used with the instance profile. The VPC security group must work with the VPC containing the instance profile.
         */
        public var vpcSecurityGroups: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.InstanceProfile) : this() {
            this.availabilityZone = x.availabilityZone
            this.description = x.description
            this.instanceProfileArn = x.instanceProfileArn
            this.instanceProfileCreationTime = x.instanceProfileCreationTime
            this.instanceProfileName = x.instanceProfileName
            this.kmsKeyArn = x.kmsKeyArn
            this.networkType = x.networkType
            this.publiclyAccessible = x.publiclyAccessible
            this.subnetGroupIdentifier = x.subnetGroupIdentifier
            this.vpcSecurityGroups = x.vpcSecurityGroups
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.InstanceProfile = InstanceProfile(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
