// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.serde

import aws.sdk.kotlin.services.databasemigrationservice.model.DatabaseMigrationException
import aws.sdk.kotlin.services.databasemigrationservice.model.MigrationProject
import aws.sdk.kotlin.services.databasemigrationservice.model.ModifyMigrationProjectResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ModifyMigrationProjectOperationDeserializer: HttpDeserialize<ModifyMigrationProjectResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ModifyMigrationProjectResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwModifyMigrationProjectError(context, call)
        }
        val builder = ModifyMigrationProjectResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeModifyMigrationProjectOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwModifyMigrationProjectError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DatabaseMigrationException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidResourceStateFault" -> InvalidResourceStateFaultDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundFault" -> ResourceNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "S3AccessDeniedFault" -> S3AccessDeniedFaultDeserializer().deserialize(context, wrappedCall)
        "S3ResourceNotFoundFault" -> S3ResourceNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedFault" -> AccessDeniedFaultDeserializer().deserialize(context, wrappedCall)
        else -> DatabaseMigrationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeModifyMigrationProjectOperationBody(builder: ModifyMigrationProjectResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val MIGRATIONPROJECT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("MigrationProject"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MIGRATIONPROJECT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MIGRATIONPROJECT_DESCRIPTOR.index -> builder.migrationProject = deserializeMigrationProjectDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
