// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.serde

import aws.sdk.kotlin.services.databasemigrationservice.model.DatabaseMigrationException
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeReplicationInstanceTaskLogsResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationInstanceTaskLog
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeReplicationInstanceTaskLogsOperationDeserializer: HttpDeserialize<DescribeReplicationInstanceTaskLogsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeReplicationInstanceTaskLogsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeReplicationInstanceTaskLogsError(context, call)
        }
        val builder = DescribeReplicationInstanceTaskLogsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeReplicationInstanceTaskLogsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeReplicationInstanceTaskLogsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DatabaseMigrationException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidResourceStateFault" -> InvalidResourceStateFaultDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundFault" -> ResourceNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        else -> DatabaseMigrationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeReplicationInstanceTaskLogsOperationBody(builder: DescribeReplicationInstanceTaskLogsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val MARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Marker"))
    val REPLICATIONINSTANCEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ReplicationInstanceArn"))
    val REPLICATIONINSTANCETASKLOGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ReplicationInstanceTaskLogs"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MARKER_DESCRIPTOR)
        field(REPLICATIONINSTANCEARN_DESCRIPTOR)
        field(REPLICATIONINSTANCETASKLOGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MARKER_DESCRIPTOR.index -> builder.marker = deserializeString()
                REPLICATIONINSTANCEARN_DESCRIPTOR.index -> builder.replicationInstanceArn = deserializeString()
                REPLICATIONINSTANCETASKLOGS_DESCRIPTOR.index -> builder.replicationInstanceTaskLogs =
                    deserializer.deserializeList(REPLICATIONINSTANCETASKLOGS_DESCRIPTOR) {
                        val col0 = mutableListOf<ReplicationInstanceTaskLog>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeReplicationInstanceTaskLogDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
