// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.serde

import aws.sdk.kotlin.services.databasemigrationservice.model.DatabaseMigrationException
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeEndpointTypesResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.SupportedEndpointType
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeEndpointTypesOperationDeserializer: HttpDeserialize<DescribeEndpointTypesResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeEndpointTypesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeEndpointTypesError(context, call)
        }
        val builder = DescribeEndpointTypesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeEndpointTypesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeEndpointTypesError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DatabaseMigrationException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> DatabaseMigrationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeEndpointTypesOperationBody(builder: DescribeEndpointTypesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val MARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Marker"))
    val SUPPORTEDENDPOINTTYPES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SupportedEndpointTypes"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MARKER_DESCRIPTOR)
        field(SUPPORTEDENDPOINTTYPES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MARKER_DESCRIPTOR.index -> builder.marker = deserializeString()
                SUPPORTEDENDPOINTTYPES_DESCRIPTOR.index -> builder.supportedEndpointTypes =
                    deserializer.deserializeList(SUPPORTEDENDPOINTTYPES_DESCRIPTOR) {
                        val col0 = mutableListOf<SupportedEndpointType>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSupportedEndpointTypeDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
