// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model



/**
 * Provides information about types of supported endpoints in response to a request by the `DescribeEndpointTypes` operation. This information includes the type of endpoint, the database engine name, and whether change data capture (CDC) is supported.
 */
public class SupportedEndpointType private constructor(builder: Builder) {
    /**
     * The type of endpoint. Valid values are `source` and `target`.
     */
    public val endpointType: aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationEndpointTypeValue? = builder.endpointType
    /**
     * The expanded name for the engine name. For example, if the `EngineName` parameter is "aurora", this value would be "Amazon Aurora MySQL".
     */
    public val engineDisplayName: kotlin.String? = builder.engineDisplayName
    /**
     * The database engine name. Valid values, depending on the EndpointType, include `"mysql"`, `"oracle"`, `"postgres"`, `"mariadb"`, `"aurora"`, `"aurora-postgresql"`, `"redshift"`, `"s3"`, `"db2"`, `"db2-zos"`, `"azuredb"`, `"sybase"`, `"dynamodb"`, `"mongodb"`, `"kinesis"`, `"kafka"`, `"elasticsearch"`, `"documentdb"`, `"sqlserver"`, `"neptune"`, and `"babelfish"`.
     */
    public val engineName: kotlin.String? = builder.engineName
    /**
     * The earliest DMS engine version that supports this endpoint engine. Note that endpoint engines released with DMS versions earlier than 3.1.1 do not return a value for this parameter.
     */
    public val replicationInstanceEngineMinimumVersion: kotlin.String? = builder.replicationInstanceEngineMinimumVersion
    /**
     * Indicates if change data capture (CDC) is supported.
     */
    public val supportsCdc: kotlin.Boolean = builder.supportsCdc

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.SupportedEndpointType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SupportedEndpointType(")
        append("endpointType=$endpointType,")
        append("engineDisplayName=$engineDisplayName,")
        append("engineName=$engineName,")
        append("replicationInstanceEngineMinimumVersion=$replicationInstanceEngineMinimumVersion,")
        append("supportsCdc=$supportsCdc")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endpointType?.hashCode() ?: 0
        result = 31 * result + (engineDisplayName?.hashCode() ?: 0)
        result = 31 * result + (engineName?.hashCode() ?: 0)
        result = 31 * result + (replicationInstanceEngineMinimumVersion?.hashCode() ?: 0)
        result = 31 * result + (supportsCdc.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SupportedEndpointType

        if (endpointType != other.endpointType) return false
        if (engineDisplayName != other.engineDisplayName) return false
        if (engineName != other.engineName) return false
        if (replicationInstanceEngineMinimumVersion != other.replicationInstanceEngineMinimumVersion) return false
        if (supportsCdc != other.supportsCdc) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.SupportedEndpointType = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The type of endpoint. Valid values are `source` and `target`.
         */
        public var endpointType: aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationEndpointTypeValue? = null
        /**
         * The expanded name for the engine name. For example, if the `EngineName` parameter is "aurora", this value would be "Amazon Aurora MySQL".
         */
        public var engineDisplayName: kotlin.String? = null
        /**
         * The database engine name. Valid values, depending on the EndpointType, include `"mysql"`, `"oracle"`, `"postgres"`, `"mariadb"`, `"aurora"`, `"aurora-postgresql"`, `"redshift"`, `"s3"`, `"db2"`, `"db2-zos"`, `"azuredb"`, `"sybase"`, `"dynamodb"`, `"mongodb"`, `"kinesis"`, `"kafka"`, `"elasticsearch"`, `"documentdb"`, `"sqlserver"`, `"neptune"`, and `"babelfish"`.
         */
        public var engineName: kotlin.String? = null
        /**
         * The earliest DMS engine version that supports this endpoint engine. Note that endpoint engines released with DMS versions earlier than 3.1.1 do not return a value for this parameter.
         */
        public var replicationInstanceEngineMinimumVersion: kotlin.String? = null
        /**
         * Indicates if change data capture (CDC) is supported.
         */
        public var supportsCdc: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.SupportedEndpointType) : this() {
            this.endpointType = x.endpointType
            this.engineDisplayName = x.engineDisplayName
            this.engineName = x.engineName
            this.replicationInstanceEngineMinimumVersion = x.replicationInstanceEngineMinimumVersion
            this.supportsCdc = x.supportsCdc
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.SupportedEndpointType = SupportedEndpointType(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
