// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model



/**
 * Provides information that describes the requirements to the target engine on Amazon RDS.
 */
public class RdsRequirements private constructor(builder: Builder) {
    /**
     * The required deployment option for the Amazon RDS DB instance. Valid values include `"MULTI_AZ"` for Multi-AZ deployments and `"SINGLE_AZ"` for Single-AZ deployments.
     */
    public val deploymentOption: kotlin.String? = builder.deploymentOption
    /**
     * The required target Amazon RDS engine edition.
     */
    public val engineEdition: kotlin.String? = builder.engineEdition
    /**
     * The required target Amazon RDS engine version.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The required memory on the Amazon RDS DB instance.
     */
    public val instanceMemory: kotlin.Double? = builder.instanceMemory
    /**
     * The required number of virtual CPUs (vCPU) on the Amazon RDS DB instance.
     */
    public val instanceVcpu: kotlin.Double? = builder.instanceVcpu
    /**
     * The required number of I/O operations completed each second (IOPS) on your Amazon RDS DB instance.
     */
    public val storageIops: kotlin.Int? = builder.storageIops
    /**
     * The required Amazon RDS DB instance storage size.
     */
    public val storageSize: kotlin.Int? = builder.storageSize

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.RdsRequirements = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RdsRequirements(")
        append("deploymentOption=$deploymentOption,")
        append("engineEdition=$engineEdition,")
        append("engineVersion=$engineVersion,")
        append("instanceMemory=$instanceMemory,")
        append("instanceVcpu=$instanceVcpu,")
        append("storageIops=$storageIops,")
        append("storageSize=$storageSize")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deploymentOption?.hashCode() ?: 0
        result = 31 * result + (engineEdition?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (instanceMemory?.hashCode() ?: 0)
        result = 31 * result + (instanceVcpu?.hashCode() ?: 0)
        result = 31 * result + (storageIops ?: 0)
        result = 31 * result + (storageSize ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RdsRequirements

        if (deploymentOption != other.deploymentOption) return false
        if (engineEdition != other.engineEdition) return false
        if (engineVersion != other.engineVersion) return false
        if (instanceMemory != other.instanceMemory) return false
        if (instanceVcpu != other.instanceVcpu) return false
        if (storageIops != other.storageIops) return false
        if (storageSize != other.storageSize) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.RdsRequirements = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The required deployment option for the Amazon RDS DB instance. Valid values include `"MULTI_AZ"` for Multi-AZ deployments and `"SINGLE_AZ"` for Single-AZ deployments.
         */
        public var deploymentOption: kotlin.String? = null
        /**
         * The required target Amazon RDS engine edition.
         */
        public var engineEdition: kotlin.String? = null
        /**
         * The required target Amazon RDS engine version.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The required memory on the Amazon RDS DB instance.
         */
        public var instanceMemory: kotlin.Double? = null
        /**
         * The required number of virtual CPUs (vCPU) on the Amazon RDS DB instance.
         */
        public var instanceVcpu: kotlin.Double? = null
        /**
         * The required number of I/O operations completed each second (IOPS) on your Amazon RDS DB instance.
         */
        public var storageIops: kotlin.Int? = null
        /**
         * The required Amazon RDS DB instance storage size.
         */
        public var storageSize: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.RdsRequirements) : this() {
            this.deploymentOption = x.deploymentOption
            this.engineEdition = x.engineEdition
            this.engineVersion = x.engineVersion
            this.instanceMemory = x.instanceMemory
            this.instanceVcpu = x.instanceVcpu
            this.storageIops = x.storageIops
            this.storageSize = x.storageSize
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.RdsRequirements = RdsRequirements(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
