// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.serde

import aws.sdk.kotlin.services.databasemigrationservice.model.DatabaseMigrationException
import aws.sdk.kotlin.services.databasemigrationservice.model.ModifyReplicationConfigResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.ReplicationConfig
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ModifyReplicationConfigOperationDeserializer: HttpDeserialize<ModifyReplicationConfigResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ModifyReplicationConfigResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwModifyReplicationConfigError(context, call)
        }
        val builder = ModifyReplicationConfigResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeModifyReplicationConfigOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwModifyReplicationConfigError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DatabaseMigrationException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidResourceStateFault" -> InvalidResourceStateFaultDeserializer().deserialize(context, wrappedCall)
        "ReplicationSubnetGroupDoesNotCoverEnoughAZs" -> ReplicationSubnetGroupDoesNotCoverEnoughAzsDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundFault" -> ResourceNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedFault" -> AccessDeniedFaultDeserializer().deserialize(context, wrappedCall)
        "KMSKeyNotAccessibleFault" -> KmsKeyNotAccessibleFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidSubnet" -> InvalidSubnetDeserializer().deserialize(context, wrappedCall)
        else -> DatabaseMigrationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeModifyReplicationConfigOperationBody(builder: ModifyReplicationConfigResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val REPLICATIONCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ReplicationConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(REPLICATIONCONFIG_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                REPLICATIONCONFIG_DESCRIPTOR.index -> builder.replicationConfig = deserializeReplicationConfigDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
