// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model



/**
 * Status of the connection between an endpoint and a replication instance, including Amazon Resource Names (ARNs) and the last error message issued.
 */
public class Connection private constructor(builder: Builder) {
    /**
     * The ARN string that uniquely identifies the endpoint.
     */
    public val endpointArn: kotlin.String? = builder.endpointArn
    /**
     * The identifier of the endpoint. Identifiers must begin with a letter and must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen or contain two consecutive hyphens.
     */
    public val endpointIdentifier: kotlin.String? = builder.endpointIdentifier
    /**
     * The error message when the connection last failed.
     */
    public val lastFailureMessage: kotlin.String? = builder.lastFailureMessage
    /**
     * The ARN of the replication instance.
     */
    public val replicationInstanceArn: kotlin.String? = builder.replicationInstanceArn
    /**
     * The replication instance identifier. This parameter is stored as a lowercase string.
     */
    public val replicationInstanceIdentifier: kotlin.String? = builder.replicationInstanceIdentifier
    /**
     * The connection status. This parameter can return one of the following values:
     * + `"successful"`
     * + `"testing"`
     * + `"failed"`
     * + `"deleting"`
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.Connection = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Connection(")
        append("endpointArn=$endpointArn,")
        append("endpointIdentifier=$endpointIdentifier,")
        append("lastFailureMessage=$lastFailureMessage,")
        append("replicationInstanceArn=$replicationInstanceArn,")
        append("replicationInstanceIdentifier=$replicationInstanceIdentifier,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endpointArn?.hashCode() ?: 0
        result = 31 * result + (endpointIdentifier?.hashCode() ?: 0)
        result = 31 * result + (lastFailureMessage?.hashCode() ?: 0)
        result = 31 * result + (replicationInstanceArn?.hashCode() ?: 0)
        result = 31 * result + (replicationInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Connection

        if (endpointArn != other.endpointArn) return false
        if (endpointIdentifier != other.endpointIdentifier) return false
        if (lastFailureMessage != other.lastFailureMessage) return false
        if (replicationInstanceArn != other.replicationInstanceArn) return false
        if (replicationInstanceIdentifier != other.replicationInstanceIdentifier) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.Connection = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN string that uniquely identifies the endpoint.
         */
        public var endpointArn: kotlin.String? = null
        /**
         * The identifier of the endpoint. Identifiers must begin with a letter and must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen or contain two consecutive hyphens.
         */
        public var endpointIdentifier: kotlin.String? = null
        /**
         * The error message when the connection last failed.
         */
        public var lastFailureMessage: kotlin.String? = null
        /**
         * The ARN of the replication instance.
         */
        public var replicationInstanceArn: kotlin.String? = null
        /**
         * The replication instance identifier. This parameter is stored as a lowercase string.
         */
        public var replicationInstanceIdentifier: kotlin.String? = null
        /**
         * The connection status. This parameter can return one of the following values:
         * + `"successful"`
         * + `"testing"`
         * + `"failed"`
         * + `"deleting"`
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.Connection) : this() {
            this.endpointArn = x.endpointArn
            this.endpointIdentifier = x.endpointIdentifier
            this.lastFailureMessage = x.lastFailureMessage
            this.replicationInstanceArn = x.replicationInstanceArn
            this.replicationInstanceIdentifier = x.replicationInstanceIdentifier
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.Connection = Connection(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
