// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model



public class ModifyDataProviderRequest private constructor(builder: Builder) {
    /**
     * The identifier of the data provider. Identifiers must begin with a letter and must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen, or contain two consecutive hyphens.
     */
    public val dataProviderIdentifier: kotlin.String? = builder.dataProviderIdentifier
    /**
     * The name of the data provider.
     */
    public val dataProviderName: kotlin.String? = builder.dataProviderName
    /**
     * A user-friendly description of the data provider.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The type of database engine for the data provider. Valid values include `"aurora"`, `"aurora-postgresql"`, `"mysql"`, `"oracle"`, `"postgres"`, `"sqlserver"`, `redshift`, `mariadb`, `mongodb`, and `docdb`. A value of `"aurora"` represents Amazon Aurora MySQL-Compatible Edition.
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * If this attribute is Y, the current call to `ModifyDataProvider` replaces all existing data provider settings with the exact settings that you specify in this call. If this attribute is N, the current call to `ModifyDataProvider` does two things:
     * + It replaces any data provider settings that already exist with new values, for settings with the same names.
     * + It creates new data provider settings that you specify in the call, for settings with different names.
     */
    public val exactSettings: kotlin.Boolean? = builder.exactSettings
    /**
     * The settings in JSON format for a data provider.
     */
    public val settings: aws.sdk.kotlin.services.databasemigrationservice.model.DataProviderSettings? = builder.settings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.ModifyDataProviderRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyDataProviderRequest(")
        append("dataProviderIdentifier=$dataProviderIdentifier,")
        append("dataProviderName=$dataProviderName,")
        append("description=$description,")
        append("engine=$engine,")
        append("exactSettings=$exactSettings,")
        append("settings=$settings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataProviderIdentifier?.hashCode() ?: 0
        result = 31 * result + (dataProviderName?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (exactSettings?.hashCode() ?: 0)
        result = 31 * result + (settings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifyDataProviderRequest

        if (dataProviderIdentifier != other.dataProviderIdentifier) return false
        if (dataProviderName != other.dataProviderName) return false
        if (description != other.description) return false
        if (engine != other.engine) return false
        if (exactSettings != other.exactSettings) return false
        if (settings != other.settings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.ModifyDataProviderRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the data provider. Identifiers must begin with a letter and must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen, or contain two consecutive hyphens.
         */
        public var dataProviderIdentifier: kotlin.String? = null
        /**
         * The name of the data provider.
         */
        public var dataProviderName: kotlin.String? = null
        /**
         * A user-friendly description of the data provider.
         */
        public var description: kotlin.String? = null
        /**
         * The type of database engine for the data provider. Valid values include `"aurora"`, `"aurora-postgresql"`, `"mysql"`, `"oracle"`, `"postgres"`, `"sqlserver"`, `redshift`, `mariadb`, `mongodb`, and `docdb`. A value of `"aurora"` represents Amazon Aurora MySQL-Compatible Edition.
         */
        public var engine: kotlin.String? = null
        /**
         * If this attribute is Y, the current call to `ModifyDataProvider` replaces all existing data provider settings with the exact settings that you specify in this call. If this attribute is N, the current call to `ModifyDataProvider` does two things:
         * + It replaces any data provider settings that already exist with new values, for settings with the same names.
         * + It creates new data provider settings that you specify in the call, for settings with different names.
         */
        public var exactSettings: kotlin.Boolean? = null
        /**
         * The settings in JSON format for a data provider.
         */
        public var settings: aws.sdk.kotlin.services.databasemigrationservice.model.DataProviderSettings? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.ModifyDataProviderRequest) : this() {
            this.dataProviderIdentifier = x.dataProviderIdentifier
            this.dataProviderName = x.dataProviderName
            this.description = x.description
            this.engine = x.engine
            this.exactSettings = x.exactSettings
            this.settings = x.settings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.ModifyDataProviderRequest = ModifyDataProviderRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
