// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.databasemigrationservice.model.CollectorResponse
import aws.sdk.kotlin.services.databasemigrationservice.model.DatabaseMigrationException
import aws.sdk.kotlin.services.databasemigrationservice.model.DescribeFleetAdvisorCollectorsResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeFleetAdvisorCollectorsOperationDeserializer: HttpDeserialize<DescribeFleetAdvisorCollectorsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeFleetAdvisorCollectorsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeFleetAdvisorCollectorsError(context, response)
        }
        val builder = DescribeFleetAdvisorCollectorsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeFleetAdvisorCollectorsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeFleetAdvisorCollectorsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DatabaseMigrationException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidResourceStateFault" -> InvalidResourceStateFaultDeserializer().deserialize(context, wrappedResponse)
        else -> DatabaseMigrationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeFleetAdvisorCollectorsOperationBody(builder: DescribeFleetAdvisorCollectorsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COLLECTORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Collectors"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COLLECTORS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COLLECTORS_DESCRIPTOR.index -> builder.collectors =
                    deserializer.deserializeList(COLLECTORS_DESCRIPTOR) {
                        val col0 = mutableListOf<CollectorResponse>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeCollectorResponseDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
