// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.databasemigrationservice.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a maintenance action pending for an DMS resource, including when and how it will be applied. This data type is a response element to the `DescribePendingMaintenanceActions` operation.
 */
public class PendingMaintenanceAction private constructor(builder: Builder) {
    /**
     * The type of pending maintenance action that is available for the resource.
     */
    public val action: kotlin.String? = builder.action
    /**
     * The date of the maintenance window when the action is to be applied. The maintenance action is applied to the resource during its first maintenance window after this date. If this date is specified, any `next-maintenance` opt-in requests are ignored.
     */
    public val autoAppliedAfterDate: aws.smithy.kotlin.runtime.time.Instant? = builder.autoAppliedAfterDate
    /**
     * The effective date when the pending maintenance action will be applied to the resource. This date takes into account opt-in requests received from the `ApplyPendingMaintenanceAction` API operation, and also the `AutoAppliedAfterDate` and `ForcedApplyDate` parameter values. This value is blank if an opt-in request has not been received and nothing has been specified for `AutoAppliedAfterDate` or `ForcedApplyDate`.
     */
    public val currentApplyDate: aws.smithy.kotlin.runtime.time.Instant? = builder.currentApplyDate
    /**
     * A description providing more detail about the maintenance action.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The date when the maintenance action will be automatically applied. The maintenance action is applied to the resource on this date regardless of the maintenance window for the resource. If this date is specified, any `immediate` opt-in requests are ignored.
     */
    public val forcedApplyDate: aws.smithy.kotlin.runtime.time.Instant? = builder.forcedApplyDate
    /**
     * The type of opt-in request that has been received for the resource.
     */
    public val optInStatus: kotlin.String? = builder.optInStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.databasemigrationservice.model.PendingMaintenanceAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PendingMaintenanceAction(")
        append("action=$action,")
        append("autoAppliedAfterDate=$autoAppliedAfterDate,")
        append("currentApplyDate=$currentApplyDate,")
        append("description=$description,")
        append("forcedApplyDate=$forcedApplyDate,")
        append("optInStatus=$optInStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (autoAppliedAfterDate?.hashCode() ?: 0)
        result = 31 * result + (currentApplyDate?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (forcedApplyDate?.hashCode() ?: 0)
        result = 31 * result + (optInStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PendingMaintenanceAction

        if (action != other.action) return false
        if (autoAppliedAfterDate != other.autoAppliedAfterDate) return false
        if (currentApplyDate != other.currentApplyDate) return false
        if (description != other.description) return false
        if (forcedApplyDate != other.forcedApplyDate) return false
        if (optInStatus != other.optInStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.databasemigrationservice.model.PendingMaintenanceAction = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The type of pending maintenance action that is available for the resource.
         */
        public var action: kotlin.String? = null
        /**
         * The date of the maintenance window when the action is to be applied. The maintenance action is applied to the resource during its first maintenance window after this date. If this date is specified, any `next-maintenance` opt-in requests are ignored.
         */
        public var autoAppliedAfterDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The effective date when the pending maintenance action will be applied to the resource. This date takes into account opt-in requests received from the `ApplyPendingMaintenanceAction` API operation, and also the `AutoAppliedAfterDate` and `ForcedApplyDate` parameter values. This value is blank if an opt-in request has not been received and nothing has been specified for `AutoAppliedAfterDate` or `ForcedApplyDate`.
         */
        public var currentApplyDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A description providing more detail about the maintenance action.
         */
        public var description: kotlin.String? = null
        /**
         * The date when the maintenance action will be automatically applied. The maintenance action is applied to the resource on this date regardless of the maintenance window for the resource. If this date is specified, any `immediate` opt-in requests are ignored.
         */
        public var forcedApplyDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The type of opt-in request that has been received for the resource.
         */
        public var optInStatus: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.databasemigrationservice.model.PendingMaintenanceAction) : this() {
            this.action = x.action
            this.autoAppliedAfterDate = x.autoAppliedAfterDate
            this.currentApplyDate = x.currentApplyDate
            this.description = x.description
            this.forcedApplyDate = x.forcedApplyDate
            this.optInStatus = x.optInStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.databasemigrationservice.model.PendingMaintenanceAction = PendingMaintenanceAction(this)
    }
}
