// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.customerprofiles.serde

import aws.sdk.kotlin.services.customerprofiles.model.AdditionalSearchKey
import aws.sdk.kotlin.services.customerprofiles.model.LogicalOperator
import aws.sdk.kotlin.services.customerprofiles.model.SearchProfilesRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class SearchProfilesOperationSerializer: HttpSerializer.NonStreaming<SearchProfilesRequest> {
    override fun serialize(context: ExecutionContext, input: SearchProfilesRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.domainName) { "domainName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("domains"))
                add(PercentEncoding.SmithyLabel.encode(input.domainName))
                add(PercentEncoding.Path.encode("profiles"))
                add(PercentEncoding.Path.encode("search"))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.maxResults != null) add("max-results", input.maxResults.toString())
                if (input.nextToken != null) add("next-token", input.nextToken)
            }
        }

        val payload = serializeSearchProfilesOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeSearchProfilesOperationBody(context: ExecutionContext, input: SearchProfilesRequest): ByteArray {
    val serializer = JsonSerializer()
    val ADDITIONALSEARCHKEYS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AdditionalSearchKeys"))
    val KEYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KeyName"))
    val LOGICALOPERATOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("LogicalOperator"))
    val VALUES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Values"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADDITIONALSEARCHKEYS_DESCRIPTOR)
        field(KEYNAME_DESCRIPTOR)
        field(LOGICALOPERATOR_DESCRIPTOR)
        field(VALUES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.additionalSearchKeys != null) {
            listField(ADDITIONALSEARCHKEYS_DESCRIPTOR) {
                for (el0 in input.additionalSearchKeys) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeAdditionalSearchKeyDocument))
                }
            }
        }
        input.keyName?.let { field(KEYNAME_DESCRIPTOR, it) }
        input.logicalOperator?.let { field(LOGICALOPERATOR_DESCRIPTOR, it.value) }
        if (input.values != null) {
            listField(VALUES_DESCRIPTOR) {
                for (el0 in input.values) {
                    serializeString(el0)
                }
            }
        }
    }
    return serializer.toByteArray()
}
